/*
 * Decompiled with CFR 0.152.
 */
package org.misaka.api.common.network.packet;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;
import org.misaka.MisakaNetwork;
import org.misaka.MisakaNetworkClient;
import org.misaka.api.common.network.NetworkSystem;
import org.misaka.api.common.network.ThreadType;
import org.misaka.api.common.network.event.S2CPacketEvent;
import org.misaka.api.common.network.packet.Packet;
import org.misaka.api.common.network.packet.PacketType;
import org.slf4j.Logger;

public final class S2CPacket
implements net.minecraft.network.protocol.Packet<ClientPacketListener> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final net.minecraft.network.protocol.PacketType<S2CPacket> TYPE = new net.minecraft.network.protocol.PacketType(PacketFlow.CLIENTBOUND, MisakaNetwork.location("s2c_packet"));
    public static final StreamCodec<ByteBuf, S2CPacket> STREAM_CODEC = net.minecraft.network.protocol.Packet.codec(S2CPacket::write, S2CPacket::new);
    private final int id;
    private final ByteBuf byteBuf;

    public <T extends Packet<ClientPacketListener, T>> S2CPacket(T packet) {
        this.id = packet.getPacketType().getPacketId();
        this.byteBuf = Unpooled.buffer();
        long startTime = NetworkSystem.isDebugInfo() ? System.nanoTime() : 0L;
        packet.getPacketType().codec().encode((Object)this.byteBuf, packet);
        if (NetworkSystem.isDebugInfo()) {
            long endTime = System.nanoTime();
            int packetSize = this.byteBuf.readableBytes();
            LOGGER.debug("[SEND][S2C] Packet: {}(ID: {}), Size: {} bytes, Encode Time: {} ns", new Object[]{packet.getClass().getSimpleName(), this.id, packetSize, endTime - startTime});
        }
    }

    @ApiStatus.Internal
    public S2CPacket(ByteBuf byteBuf) {
        this.id = VarInt.read((ByteBuf)byteBuf);
        this.byteBuf = byteBuf.readBytes(byteBuf.readableBytes());
    }

    public void write(ByteBuf byteBuf) {
        VarInt.write((ByteBuf)byteBuf, (int)this.id);
        byteBuf.writeBytes(this.byteBuf.copy());
    }

    public net.minecraft.network.protocol.PacketType<? extends net.minecraft.network.protocol.Packet<ClientPacketListener>> type() {
        return TYPE;
    }

    public void handle(ClientPacketListener handler) {
        Minecraft.getInstance().execute(() -> {
            S2CPacketEvent event = new S2CPacketEvent(this);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            Object packetType = NetworkSystem.getPacketTypeById(this.id);
            Class packetClass = ((PacketType)packetType).packetClass();
            if (NetworkSystem.isDebugInfo()) {
                int packetSize = this.byteBuf.readableBytes();
                LOGGER.info("[RECEIVE][S2C] Packet: {}(ID: {}), Size: {} bytes", new Object[]{packetClass.getSimpleName(), this.id, packetSize});
            }
            if (!NetworkSystem.shouldReceive(packetClass, ThreadType.CLIENT)) {
                return;
            }
            try {
                StreamCodec codec = ((PacketType)packetType).codec();
                Packet instance = (Packet)codec.decode((Object)this.byteBuf);
                instance.setPacketListener(handler);
                MisakaNetworkClient.NETWORK_MANAGER.dispatchPacket(instance);
            }
            catch (Throwable e) {
                LOGGER.error("Exception processing S2C packet. Class: {}, ID: {}. Listener: {}. Error: {}", new Object[]{packetClass.getSimpleName(), this.id, handler.getClass().getSimpleName(), e.getMessage(), e});
            }
        });
    }
}

