/*
 * Decompiled with CFR 0.152.
 */
package org.misaka.api.server.network.future;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.misaka.api.common.network.annotation.SubscribePacket;
import org.misaka.api.common.network.future.AbstractFutureManager;
import org.misaka.api.common.network.future.packet.FutureRequestPacket;
import org.misaka.api.common.network.future.packet.FutureResponsePacket;
import org.misaka.api.common.network.future.packet.RequestPacket;
import org.misaka.api.common.network.future.packet.ResponsePacket;
import org.misaka.api.common.network.packet.S2CPacket;

public class FutureManagerServer
extends AbstractFutureManager {
    public <RES_L extends ClientboundPacketListener, RES_P extends ResponsePacket<RES_L, RES_P>, REQ_L extends ServerboundPacketListener, REQ_P extends RequestPacket<REQ_L, REQ_P, RES_L, RES_P>> void sendRequestToClient(ServerPlayer player, REQ_P requestPacket, Consumer<RES_P> callback, long timeoutMillis) {
        int futureId = this.createPendingFuture(requestPacket.getResponsePacketType(), callback, timeoutMillis);
        if (futureId == -1) {
            return;
        }
        int requestTypeId = requestPacket.getPacketType().getPacketId();
        ByteBuf buffer = Unpooled.buffer();
        requestPacket.getPacketType().codec().encode((Object)buffer, requestPacket);
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        FutureRequestPacket packet = new FutureRequestPacket(futureId, requestTypeId, bytes);
        player.connection.send((Packet)new S2CPacket(packet));
    }

    public <RES_L extends ClientboundPacketListener, RES_P extends ResponsePacket<RES_L, RES_P>, REQ_L extends ServerboundPacketListener, REQ_P extends RequestPacket<REQ_L, REQ_P, RES_L, RES_P>> void sendRequestToClient(ServerPlayer player, REQ_P requestPacket, Consumer<RES_P> callback) {
        this.sendRequestToClient(player, requestPacket, callback, 60000L);
    }

    @SubscribePacket
    public void handleFutureRequestFromClient(FutureRequestPacket<ServerGamePacketListenerImpl> futureRequestPacket) {
        ServerGamePacketListenerImpl packetListener = (ServerGamePacketListenerImpl)futureRequestPacket.getPacketListener();
        ServerPlayer player = packetListener.getPlayer();
        this.handleRequest(futureRequestPacket, (ServerGamePacketListenerImpl)futureRequestPacket.getPacketListener(), response -> {
            int responseTypeId = response.getPacketType().getPacketId();
            ByteBuf responseBuffer = Unpooled.buffer();
            response.getPacketType().codec().encode((Object)responseBuffer, response);
            byte[] bytes = new byte[responseBuffer.readableBytes()];
            responseBuffer.readBytes(bytes);
            FutureResponsePacket responsePkt = new FutureResponsePacket(futureRequestPacket.getFutureId(), responseTypeId, bytes);
            player.connection.send((Packet)new S2CPacket(responsePkt));
        });
    }

    @SubscribePacket
    public void handleFutureResponseFromClient(FutureResponsePacket<ServerGamePacketListenerImpl> responsePacket) {
        this.handleResponse(responsePacket, resPacket -> ((ServerGamePacketListenerImpl)responsePacket.getPacketListener()).server.execute(() -> this.executeCallback(responsePacket.getFutureId(), (ResponsePacket<?, ?>)resPacket)));
    }
}

