/*
 * Decompiled with CFR 0.152.
 */
package org.misaka.processor;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.misaka.processor.spec.HandlerInfo;

@SupportedAnnotationTypes(value={"org.misaka.api.common.network.annotation.SubscribePacket", "org.misaka.api.common.network.future.annotation.HandleFuture"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
@AutoService(value={Processor.class})
public final class MisakaPacketProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private Elements elementUtils;
    private Types typeUtils;
    private String customProviderFqcn;
    private final Map<TypeElement, List<HandlerInfo>> handlerInfoMap = new HashMap<TypeElement, List<HandlerInfo>>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.customProviderFqcn = processingEnv.getOptions().get("misaka.provider.fqcn");
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Set.of("misaka.project.id", "misaka.provider.fqcn");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "MisakaProcessor: Running processing round.");
        }
        try {
            this.processSubscribePacket(roundEnv);
            this.processHandleFuture(roundEnv);
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Unhandled error in MisakaPacketProcessor: " + String.valueOf(e));
            return false;
        }
        if (roundEnv.processingOver()) {
            if (!this.handlerInfoMap.isEmpty()) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "MisakaProcessor: Final round, generating provider...");
                try {
                    this.generateProviderImplementation();
                }
                catch (IOException e) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to generate MisakaHandlersProvider: " + String.valueOf(e));
                }
            } else {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "MisakaProcessor: Final round, but no handlers were collected.");
            }
        }
        return true;
    }

    private void processSubscribePacket(RoundEnvironment roundEnv) throws IOException {
        TypeElement annotationElement = this.elementUtils.getTypeElement("org.misaka.api.common.network.annotation.SubscribePacket");
        if (annotationElement == null) {
            return;
        }
        TypeElement packetElement = this.elementUtils.getTypeElement("org.misaka.api.common.network.packet.Packet");
        if (packetElement == null) {
            return;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            if (!this.validateSubscribePacketMethod(element, packetElement.asType())) continue;
            this.generateListenerClass((ExecutableElement)element);
        }
    }

    private boolean validateSubscribePacketMethod(Element element, TypeMirror packetType) {
        if (element.getKind() != ElementKind.METHOD) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@SubscribePacket can only be applied to methods.", element);
            return false;
        }
        ExecutableElement method = (ExecutableElement)element;
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Method annotated with @SubscribePacket must be public.", method);
            return false;
        }
        if (method.getParameters().size() != 1) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Method must have exactly one parameter.", method);
            return false;
        }
        VariableElement parameter = method.getParameters().getFirst();
        if (!this.typeUtils.isSubtype(this.typeUtils.erasure(parameter.asType()), this.typeUtils.erasure(packetType))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Parameter must be a subtype of Packet.", parameter);
            return false;
        }
        return true;
    }

    private void generateListenerClass(ExecutableElement method) throws IOException {
        boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
        TypeElement enclosingClass = (TypeElement)method.getEnclosingElement();
        VariableElement parameter = method.getParameters().getFirst();
        String packageName = this.elementUtils.getPackageOf(enclosingClass).getQualifiedName().toString();
        String generatedSimpleClassName = this.buildGeneratedClassName(enclosingClass, method, parameter, "_MNListener");
        ClassName generatedClassName = ClassName.get(packageName, generatedSimpleClassName, new String[0]);
        ClassName superclass = ClassName.get("org.misaka.api.common.network.listener", isStatic ? "StaticPacketListener" : "InstancePacketListener", new String[0]);
        ClassName packetSuperclassName = ClassName.get("org.misaka.api.common.network.packet", "Packet", new String[0]);
        TypeName enclosingClassName = TypeName.get(enclosingClass.asType());
        TypeName packetClassName = TypeName.get(parameter.asType());
        TypeName rawPacketClassName = packetClassName;
        if (rawPacketClassName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)rawPacketClassName;
            rawPacketClassName = parameterizedTypeName.rawType;
        }
        MethodSpec getPacketClassMethod = MethodSpec.methodBuilder("getPacketClass").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(ClassName.get(Class.class), WildcardTypeName.subtypeOf(packetSuperclassName))).addStatement("return $T.class", rawPacketClassName).build();
        MethodSpec.Builder handlePacketMethod = MethodSpec.methodBuilder("handlePacket").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter(packetSuperclassName, "packet", new Modifier[0]);
        if (isStatic) {
            handlePacketMethod.addStatement("$T.$L(($T) packet)", enclosingClassName, method.getSimpleName(), packetClassName);
        } else {
            handlePacketMethod.addStatement("(($T) this.instance).$L(($T) packet)", enclosingClassName, method.getSimpleName(), packetClassName);
        }
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(generatedClassName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).superclass(superclass).addMethod(getPacketClassMethod).addMethod(handlePacketMethod.build());
        if (!isStatic) {
            classBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)Object.class), "instance", new Modifier[0]).addStatement("super(instance)", new Object[0]).build());
        }
        JavaFile.builder(packageName, classBuilder.build()).indent("    ").build().writeTo(this.filer);
        HandlerInfo.Scope scope = isStatic ? HandlerInfo.Scope.STATIC : HandlerInfo.Scope.INSTANCE;
        HandlerInfo info = new HandlerInfo(generatedClassName.canonicalName(), HandlerInfo.HandlerType.LISTENER, scope, enclosingClass, method);
        this.handlerInfoMap.computeIfAbsent(enclosingClass, k -> new ArrayList()).add(info);
    }

    private void processHandleFuture(RoundEnvironment roundEnv) throws IOException {
        TypeElement annotationElement = this.elementUtils.getTypeElement("org.misaka.api.common.network.future.annotation.HandleFuture");
        if (annotationElement == null) {
            return;
        }
        TypeElement requestElement = this.elementUtils.getTypeElement("org.misaka.api.common.network.future.packet.RequestPacket");
        TypeElement responseElement = this.elementUtils.getTypeElement("org.misaka.api.common.network.future.packet.ResponsePacket");
        if (requestElement == null || responseElement == null) {
            return;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            if (!this.validateHandleFutureMethod(element, requestElement.asType(), responseElement.asType())) continue;
            this.generateInvokerClass((ExecutableElement)element);
        }
    }

    private boolean validateHandleFutureMethod(Element element, TypeMirror requestType, TypeMirror responseType) {
        if (element.getKind() != ElementKind.METHOD) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@HandleFuture can only be applied to methods.", element);
            return false;
        }
        ExecutableElement method = (ExecutableElement)element;
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Method annotated with @HandleFuture must be public.", method);
            return false;
        }
        if (method.getParameters().size() != 1) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Method must have exactly one parameter.", method);
            return false;
        }
        VariableElement parameter = method.getParameters().getFirst();
        if (!this.typeUtils.isSubtype(this.typeUtils.erasure(parameter.asType()), this.typeUtils.erasure(requestType))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Parameter must be a subtype of RequestPacket.", parameter);
            return false;
        }
        if (this.typeUtils.isSameType(method.getReturnType(), this.typeUtils.getNoType(TypeKind.VOID))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Method must have a return value.", method);
            return false;
        }
        if (!this.typeUtils.isSubtype(this.typeUtils.erasure(method.getReturnType()), this.typeUtils.erasure(responseType))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Return type must be a subtype of ResponsePacket.", method);
            return false;
        }
        return true;
    }

    private void generateInvokerClass(ExecutableElement method) throws IOException {
        boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
        TypeElement enclosingClass = (TypeElement)method.getEnclosingElement();
        VariableElement parameter = method.getParameters().getFirst();
        String packageName = this.elementUtils.getPackageOf(enclosingClass).getQualifiedName().toString();
        String generatedSimpleClassName = this.buildGeneratedClassName(enclosingClass, method, parameter, "_MNInvoker");
        ClassName generatedClassName = ClassName.get(packageName, generatedSimpleClassName, new String[0]);
        ClassName superclass = ClassName.get("org.misaka.api.common.network.future.invoker", isStatic ? "StaticFutureHandlerInvoker" : "InstanceFutureHandlerInvoker", new String[0]);
        ClassName requestPacketName = ClassName.get("org.misaka.api.common.network.future.packet", "RequestPacket", new String[0]);
        ClassName responsePacketName = ClassName.get("org.misaka.api.common.network.future.packet", "ResponsePacket", new String[0]);
        TypeName enclosingClassName = TypeName.get(enclosingClass.asType());
        TypeName requestClassName = TypeName.get(parameter.asType());
        MethodSpec getRequestPacketClassMethod = MethodSpec.methodBuilder("getRequestPacketClass").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(ClassName.get(Class.class), WildcardTypeName.subtypeOf(requestPacketName))).addStatement("return $T.class", requestClassName).build();
        MethodSpec.Builder invokeMethod = MethodSpec.methodBuilder("invoke").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter(requestPacketName, "requestPacket", new Modifier[0]).returns(responsePacketName);
        if (isStatic) {
            invokeMethod.addStatement("return $T.$L(($T) requestPacket)", enclosingClassName, method.getSimpleName(), requestClassName);
        } else {
            invokeMethod.addStatement("return (($T) this.instance).$L(($T) requestPacket)", enclosingClassName, method.getSimpleName(), requestClassName);
        }
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(generatedClassName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).superclass(superclass).addMethod(getRequestPacketClassMethod).addMethod(invokeMethod.build());
        if (!isStatic) {
            classBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)Object.class), "newInstance", new Modifier[0]).addStatement("super(newInstance)", new Object[0]).build());
        }
        JavaFile.builder(packageName, classBuilder.build()).indent("    ").build().writeTo(this.filer);
        HandlerInfo.Scope scope = isStatic ? HandlerInfo.Scope.STATIC : HandlerInfo.Scope.INSTANCE;
        HandlerInfo info = new HandlerInfo(generatedClassName.canonicalName(), HandlerInfo.HandlerType.INVOKER, scope, enclosingClass, method);
        this.handlerInfoMap.computeIfAbsent(enclosingClass, k -> new ArrayList()).add(info);
    }

    private void generateProviderImplementation() throws IOException {
        Object simpleClassName;
        Object providerPackageName;
        ClassName providerInterface = ClassName.get("org.misaka.internal", "MisakaHandlersProvider", new String[0]);
        if (this.customProviderFqcn != null && !this.customProviderFqcn.isEmpty()) {
            int lastDot = this.customProviderFqcn.lastIndexOf(46);
            if (lastDot > 0) {
                providerPackageName = this.customProviderFqcn.substring(0, lastDot);
                simpleClassName = this.customProviderFqcn.substring(lastDot + 1);
            } else {
                providerPackageName = "";
                simpleClassName = this.customProviderFqcn;
            }
        } else {
            String randomId = Long.toHexString(System.currentTimeMillis());
            providerPackageName = randomId + ".misaka.generated";
            simpleClassName = randomId + "_MisakaHandlersProviderImpl";
        }
        ClassName generatedProviderClassName = ClassName.get((String)providerPackageName, (String)simpleClassName, new String[0]);
        ClassName ipacketListener = ClassName.get("org.misaka.api.common.network.listener", "IPacketListener", new String[0]);
        ClassName ifutureInvoker = ClassName.get("org.misaka.api.common.network.future.invoker", "IFutureHandlerInvoker", new String[0]);
        ParameterizedTypeName classWildcard = ParameterizedTypeName.get(ClassName.get(Class.class), WildcardTypeName.subtypeOf(TypeName.OBJECT));
        ParameterizedTypeName staticListenersMapType = ParameterizedTypeName.get(ClassName.get(Map.class), classWildcard, ParameterizedTypeName.get(ClassName.get(List.class), ipacketListener));
        ParameterizedTypeName instanceListenerFactoriesMapType = ParameterizedTypeName.get(ClassName.get(Map.class), classWildcard, ParameterizedTypeName.get(ClassName.get(List.class), ParameterizedTypeName.get(ClassName.get(Function.class), TypeName.OBJECT, ipacketListener)));
        ParameterizedTypeName staticInvokersMapType = ParameterizedTypeName.get(ClassName.get(Map.class), classWildcard, ParameterizedTypeName.get(ClassName.get(List.class), ifutureInvoker));
        ParameterizedTypeName instanceInvokerFactoriesMapType = ParameterizedTypeName.get(ClassName.get(Map.class), classWildcard, ParameterizedTypeName.get(ClassName.get(List.class), ParameterizedTypeName.get(ClassName.get(Function.class), TypeName.OBJECT, ifutureInvoker)));
        FieldSpec staticListenersField = FieldSpec.builder(staticListenersMapType, "STATIC_LISTENERS", Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).build();
        FieldSpec instanceListenerFactoriesField = FieldSpec.builder(instanceListenerFactoriesMapType, "INSTANCE_LISTENER_FACTORIES", Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).build();
        FieldSpec staticInvokersField = FieldSpec.builder(staticInvokersMapType, "STATIC_INVOKERS", Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).build();
        FieldSpec instanceInvokerFactoriesField = FieldSpec.builder(instanceInvokerFactoriesMapType, "INSTANCE_INVOKER_FACTORIES", Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).build();
        CodeBlock.Builder staticInitializer = CodeBlock.builder().addStatement("var staticListeners = new $T()", ParameterizedTypeName.get(ClassName.get(HashMap.class), classWildcard, ParameterizedTypeName.get(ClassName.get(List.class), ipacketListener))).addStatement("var instanceListenerFactories = new $T()", ParameterizedTypeName.get(ClassName.get(HashMap.class), classWildcard, ParameterizedTypeName.get(ClassName.get(List.class), ParameterizedTypeName.get(ClassName.get(Function.class), TypeName.OBJECT, ipacketListener)))).addStatement("var staticInvokers = new $T()", ParameterizedTypeName.get(ClassName.get(HashMap.class), classWildcard, ParameterizedTypeName.get(ClassName.get(List.class), ifutureInvoker))).addStatement("var instanceInvokerFactories = new $T()", ParameterizedTypeName.get(ClassName.get(HashMap.class), classWildcard, ParameterizedTypeName.get(ClassName.get(List.class), ParameterizedTypeName.get(ClassName.get(Function.class), TypeName.OBJECT, ifutureInvoker))));
        this.handlerInfoMap.forEach((sourceClass, infos) -> {
            CodeBlock lambdas;
            CodeBlock newInstances;
            List<HandlerInfo> staticListeners = infos.stream().filter(i -> i.scope() == HandlerInfo.Scope.STATIC && i.handlerType() == HandlerInfo.HandlerType.LISTENER).toList();
            List<HandlerInfo> instanceListeners = infos.stream().filter(i -> i.scope() == HandlerInfo.Scope.INSTANCE && i.handlerType() == HandlerInfo.HandlerType.LISTENER).toList();
            List<HandlerInfo> staticInvokers = infos.stream().filter(i -> i.scope() == HandlerInfo.Scope.STATIC && i.handlerType() == HandlerInfo.HandlerType.INVOKER).toList();
            List<HandlerInfo> instanceInvokers = infos.stream().filter(i -> i.scope() == HandlerInfo.Scope.INSTANCE && i.handlerType() == HandlerInfo.HandlerType.INVOKER).toList();
            if (!staticListeners.isEmpty()) {
                newInstances = staticListeners.stream().map(info -> CodeBlock.of("new $L()", info.generatedClassName())).collect(CodeBlock.joining(", "));
                staticInitializer.addStatement("staticListeners.put($T.class, $T.of($L))", sourceClass.asType(), List.class, newInstances);
            }
            if (!instanceListeners.isEmpty()) {
                lambdas = instanceListeners.stream().map(info -> CodeBlock.of("instance -> new $L(instance)", info.generatedClassName())).collect(CodeBlock.joining(", "));
                staticInitializer.addStatement("instanceListenerFactories.put($T.class, $T.of($L))", sourceClass.asType(), List.class, lambdas);
            }
            if (!staticInvokers.isEmpty()) {
                newInstances = staticInvokers.stream().map(info -> CodeBlock.of("new $L()", info.generatedClassName())).collect(CodeBlock.joining(", "));
                staticInitializer.addStatement("staticInvokers.put($T.class, $T.of($L))", sourceClass.asType(), List.class, newInstances);
            }
            if (!instanceInvokers.isEmpty()) {
                lambdas = instanceInvokers.stream().map(info -> CodeBlock.of("instance -> new $L(instance)", info.generatedClassName())).collect(CodeBlock.joining(", "));
                staticInitializer.addStatement("instanceInvokerFactories.put($T.class, $T.of($L))", sourceClass.asType(), List.class, lambdas);
            }
        });
        staticInitializer.addStatement("$N = $T.unmodifiableMap(staticListeners)", staticListenersField, Collections.class).addStatement("$N = $T.unmodifiableMap(instanceListenerFactories)", instanceListenerFactoriesField, Collections.class).addStatement("$N = $T.unmodifiableMap(staticInvokers)", staticInvokersField, Collections.class).addStatement("$N = $T.unmodifiableMap(instanceInvokerFactories)", instanceInvokerFactoriesField, Collections.class);
        MethodSpec getStaticListeners = MethodSpec.methodBuilder("getStaticListeners").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(staticListenersMapType).addStatement("return $N", staticListenersField).build();
        MethodSpec getInstanceFactories = MethodSpec.methodBuilder("getInstanceListenerFactories").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(instanceListenerFactoriesMapType).addStatement("return $N", instanceListenerFactoriesField).build();
        MethodSpec getStaticInvokers = MethodSpec.methodBuilder("getStaticInvokers").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(staticInvokersMapType).addStatement("return $N", staticInvokersField).build();
        MethodSpec getInstanceInvokerFactories = MethodSpec.methodBuilder("getInstanceInvokerFactories").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(instanceInvokerFactoriesMapType).addStatement("return $N", instanceInvokerFactoriesField).build();
        TypeSpec providerClass = TypeSpec.classBuilder(generatedProviderClassName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addSuperinterface(providerInterface).addField(staticListenersField).addField(instanceListenerFactoriesField).addField(staticInvokersField).addField(instanceInvokerFactoriesField).addStaticBlock(staticInitializer.build()).addMethod(getStaticListeners).addMethod(getInstanceFactories).addMethod(getStaticInvokers).addMethod(getInstanceInvokerFactories).build();
        JavaFile.builder((String)providerPackageName, providerClass).indent("    ").build().writeTo(this.filer);
        FileObject serviceFile = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + providerInterface.canonicalName(), new Element[0]);
        try (Writer writer = serviceFile.openWriter();){
            writer.write(generatedProviderClassName.canonicalName());
        }
    }

    private String buildGeneratedClassName(TypeElement enclosingClass, ExecutableElement method, VariableElement parameter, String suffix) {
        String shortHash;
        StringBuilder className = new StringBuilder();
        ArrayDeque<TypeElement> classStack = new ArrayDeque<TypeElement>();
        Element current = enclosingClass;
        while (current.getKind().isClass() || current.getKind().isInterface()) {
            classStack.addFirst((TypeElement)current);
            current = current.getEnclosingElement();
        }
        while (!classStack.isEmpty()) {
            className.append(((Element)classStack.pollFirst()).getSimpleName());
            if (classStack.isEmpty()) continue;
            className.append("_");
        }
        TypeElement paramTypeElement = (TypeElement)this.typeUtils.asElement(parameter.asType());
        String paramSimpleName = paramTypeElement.getSimpleName().toString();
        String paramQualifiedName = paramTypeElement.getQualifiedName().toString();
        int hash = paramQualifiedName.hashCode();
        if (hash == Integer.MIN_VALUE) {
            hash = 0;
        }
        if ((shortHash = Integer.toHexString(hash = Math.abs(hash))).length() > 6) {
            shortHash = shortHash.substring(0, 6);
        }
        className.append("_").append(method.getSimpleName()).append("_").append(paramSimpleName).append("_").append(shortHash).append(suffix);
        return className.toString();
    }
}

