/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.prism.registry;

import com.adonis.prism.CreatePrism;
import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.CTType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class CPSpriteShifts {
    private static final Map<String, Map<Boolean, CTSpriteShiftEntry>> GLASS_CASING_SHIFTS = new HashMap<String, Map<Boolean, CTSpriteShiftEntry>>();
    private static final Map<String, CTSpriteShiftEntry> ILLUMINATION_CASING_SHIFTS = new HashMap<String, CTSpriteShiftEntry>();
    private static final Map<String, CTSpriteShiftEntry> SPRITE_SHIFTS = new HashMap<String, CTSpriteShiftEntry>();

    public static void init() {
        CPSpriteShifts.registerCasingShift("andesite");
        CPSpriteShifts.registerCasingShift("brass");
        CPSpriteShifts.registerCasingShift("copper");
        CPSpriteShifts.registerCasingShift("train");
        CPSpriteShifts.registerIlluminationCasingShift("andesite");
        CPSpriteShifts.registerIlluminationCasingShift("brass");
        CPSpriteShifts.registerIlluminationCasingShift("copper");
        CPSpriteShifts.registerIlluminationCasingShift("train");
    }

    private static void registerIlluminationCasingShift(String name) {
        ILLUMINATION_CASING_SHIFTS.put(name, CPSpriteShifts.createOmniShift(name + "_illumination_casing"));
    }

    public static CTSpriteShiftEntry getIlluminationCasingShift(String casing) {
        return ILLUMINATION_CASING_SHIFTS.get(casing);
    }

    private static void registerCasingShift(String name) {
        HashMap<Boolean, CTSpriteShiftEntry> shifts = new HashMap<Boolean, CTSpriteShiftEntry>();
        shifts.put(false, CPSpriteShifts.createOmniShift(name + "_glass_casing"));
        shifts.put(true, CPSpriteShifts.createOmniShift(name + "_clear_glass_casing"));
        GLASS_CASING_SHIFTS.put(name, shifts);
    }

    public static CTSpriteShiftEntry getCasingShift(String casing, boolean clear) {
        Map<Boolean, CTSpriteShiftEntry> shifts = GLASS_CASING_SHIFTS.get(casing);
        if (shifts != null) {
            return shifts.get(clear);
        }
        return null;
    }

    public static CTSpriteShiftEntry omni(String name) {
        return SPRITE_SHIFTS.computeIfAbsent(name + "_omni", key -> CPSpriteShifts.getCT((CTType)AllCTTypes.OMNIDIRECTIONAL, name));
    }

    public static CTSpriteShiftEntry horizontal(String name) {
        return SPRITE_SHIFTS.computeIfAbsent(name + "_horizontal", key -> CPSpriteShifts.getCT((CTType)AllCTTypes.HORIZONTAL, name));
    }

    public static CTSpriteShiftEntry vertical(String name) {
        return SPRITE_SHIFTS.computeIfAbsent(name + "_vertical", key -> CPSpriteShifts.getCT((CTType)AllCTTypes.VERTICAL, name));
    }

    private static CTSpriteShiftEntry createOmniShift(String name) {
        return CPSpriteShifts.getCT((CTType)AllCTTypes.OMNIDIRECTIONAL, name);
    }

    private static CTSpriteShiftEntry getCT(CTType type, String blockTextureName) {
        return CPSpriteShifts.getCT(type, blockTextureName, blockTextureName);
    }

    private static CTSpriteShiftEntry getCT(CTType type, String blockTextureName, String connectedTextureName) {
        return CTSpriteShifter.getCT((CTType)type, (ResourceLocation)CreatePrism.asResource("block/" + blockTextureName), (ResourceLocation)CreatePrism.asResource("block/" + connectedTextureName + "_connected"));
    }
}

