/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.prism.registry.builders;

import com.adonis.prism.CreatePrism;
import com.adonis.prism.block.glass.GlassCasing;
import com.adonis.prism.block.glass.GlassEncasedCTBehaviour;
import com.adonis.prism.block.glass.GlassEncasedCogCTBehaviour;
import com.adonis.prism.block.glass.GlassEncasedCogwheel;
import com.adonis.prism.block.glass.GlassEncasedShaft;
import com.adonis.prism.block.illumination.IlluminationCasing;
import com.adonis.prism.block.illumination.IlluminationEncasedCTBehaviour;
import com.adonis.prism.block.illumination.IlluminationEncasedCogCTBehaviour;
import com.adonis.prism.block.illumination.IlluminationEncasedCogwheel;
import com.adonis.prism.block.illumination.IlluminationEncasedShaft;
import com.adonis.prism.registry.CPSpriteShifts;
import com.adonis.prism.util.CasingHolder;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.MetalScaffoldingBlock;
import com.simibubi.create.content.decoration.MetalScaffoldingBlockItem;
import com.simibubi.create.content.decoration.MetalScaffoldingCTBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.decoration.palettes.AllPaletteBlocks;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import net.createmod.catnip.data.Couple;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class GlassBlockBuilders {
    public static <T extends AbstractRegistrate<?>> BlockEntry<GlassCasing> glassCasing(T reg, CasingHolder holder, boolean clear) {
        String name = holder.name();
        String newName = name + (clear ? "_clear_glass_casing" : "_glass_casing");
        CTSpriteShiftEntry ctEntry = CPSpriteShifts.getCasingShift(name, clear);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(newName, GlassCasing::new).initialProperties(() -> Blocks.GLASS).properties(p -> p.sound(SoundType.GLASS).noOcclusion()).properties(GlassBlockBuilders::glassProperties).addLayer(() -> RenderType::cutout).blockstate((c, p) -> p.simpleBlock((Block)c.get())).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(ctEntry)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.makeCasing((Block)block, ctEntry)))).tag(new TagKey[]{AllTags.AllBlockTags.CASING.tag}).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)c.get())).requires((ItemLike)holder.casing().get()).requires((ItemLike)AllPaletteBlocks.FRAMED_GLASS.get()).unlockedBy("has_casing", RegistrateRecipeProvider.has((TagKey)AllTags.AllItemTags.CASING.tag)).save((RecipeOutput)p, CreatePrism.asResource("crafting/glass_casing/" + c.getName()))).item().tag(new TagKey[]{AllTags.AllItemTags.CASING.tag}).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<IlluminationCasing> illuminationCasing(T reg, CasingHolder holder) {
        String name = holder.name();
        String newName = name + "_illumination_casing";
        CTSpriteShiftEntry ctEntry = CPSpriteShifts.getIlluminationCasingShift(name);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(newName, IlluminationCasing::new).initialProperties(() -> Blocks.GLOWSTONE).properties(p -> p.sound(SoundType.GLASS).noOcclusion().lightLevel(s -> 15)).addLayer(() -> RenderType::translucent).blockstate((c, p) -> p.simpleBlock((Block)c.get())).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(ctEntry)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.makeCasing((Block)block, ctEntry)))).tag(new TagKey[]{AllTags.AllBlockTags.CASING.tag}).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)c.get())).requires((ItemLike)holder.casing().get()).requires((ItemLike)Items.GLOWSTONE_DUST, 4).unlockedBy("has_casing", RegistrateRecipeProvider.has((TagKey)AllTags.AllItemTags.CASING.tag)).save((RecipeOutput)p, CreatePrism.asResource("crafting/illumination_casing/" + c.getName()))).item().tag(new TagKey[]{AllTags.AllItemTags.CASING.tag}).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<GlassEncasedShaft> glassEncasedShaft(T reg, String casing, boolean clear, NonNullFunction<BlockBehaviour.Properties, GlassEncasedShaft> factory) {
        String newName = casing + (clear ? "_clear_glass_encased_shaft" : "_glass_encased_shaft");
        CTSpriteShiftEntry ctEntry = CPSpriteShifts.getCasingShift(casing, clear);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(newName, factory).initialProperties(() -> Blocks.GLASS).properties(BlockBehaviour.Properties::noOcclusion).properties(GlassBlockBuilders::glassProperties).loot((p, lb) -> p.dropOther((Block)lb, (ItemLike)AllBlocks.SHAFT.get())).addLayer(() -> RenderType::cutout).onRegister(CreateRegistrate.connectedTextures(() -> new GlassEncasedCTBehaviour(ctEntry)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, ctEntry, (state, face) -> true)))).transform(TagGen.pickaxeOnly())).blockstate((ctx, prov) -> BlockStateGen.axisBlock((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, state -> ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), CreatePrism.asResource("block/glass_encased_shaft/block"))).texture("casing", CreatePrism.asResource("block/" + casing + (clear ? "_clear_glass" : "_glass") + "_casing"))).texture("opening", GlassBlockBuilders.getOpening(casing)), (boolean)true)).item().model((ctx, prov) -> ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), CreatePrism.asResource("block/glass_encased_shaft/block"))).texture("casing", CreatePrism.asResource("block/" + casing + (clear ? "_clear_glass" : "_glass") + "_casing"))).texture("opening", GlassBlockBuilders.getOpening(casing))).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<IlluminationEncasedShaft> illuminationEncasedShaft(T reg, String casing, NonNullFunction<BlockBehaviour.Properties, IlluminationEncasedShaft> factory) {
        String newName = casing + "_illumination_encased_shaft";
        CTSpriteShiftEntry ctEntry = CPSpriteShifts.getIlluminationCasingShift(casing);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(newName, factory).initialProperties(() -> Blocks.GLOWSTONE).properties(BlockBehaviour.Properties::noOcclusion).properties(p -> p.lightLevel(s -> 15)).properties(GlassBlockBuilders::glassProperties).loot((p, lb) -> p.dropOther((Block)lb, (ItemLike)AllBlocks.SHAFT.get())).addLayer(() -> RenderType::translucent).onRegister(CreateRegistrate.connectedTextures(() -> new IlluminationEncasedCTBehaviour(ctEntry)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, ctEntry, (state, face) -> true)))).transform(TagGen.pickaxeOnly())).blockstate((ctx, prov) -> BlockStateGen.axisBlock((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, state -> ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), CreatePrism.asResource("block/illumination_encased_shaft/block"))).texture("casing", CreatePrism.asResource("block/" + casing + "_illumination_casing"))).texture("opening", GlassBlockBuilders.getOpening(casing)), (boolean)true)).item().model((ctx, prov) -> ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), CreatePrism.asResource("block/illumination_encased_shaft/block"))).texture("casing", CreatePrism.asResource("block/" + casing + "_illumination_casing"))).texture("opening", GlassBlockBuilders.getOpening(casing))).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<GlassEncasedCogwheel> glassEncasedCogwheel(T reg, String casingType, boolean large, boolean clear, NonNullFunction<BlockBehaviour.Properties, GlassEncasedCogwheel> factory) {
        CTSpriteShiftEntry mainShift = CPSpriteShifts.getCasingShift(casingType, clear);
        String name = casingType + (clear ? "_clear" : "");
        String blockName = name + (large ? "_glass_encased_large_cogwheel" : "_glass_encased_cogwheel");
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(blockName, factory).initialProperties(() -> Blocks.GLASS).properties(BlockBehaviour.Properties::noOcclusion).properties(GlassBlockBuilders::glassProperties).loot((p, lb) -> {
            if (large) {
                p.dropOther((Block)lb, (ItemLike)AllBlocks.LARGE_COGWHEEL.get());
            } else {
                p.dropOther((Block)lb, (ItemLike)AllBlocks.COGWHEEL.get());
            }
        }).addLayer(() -> RenderType::cutout).onRegister(CreateRegistrate.connectedTextures(() -> GlassBlockBuilders.getCogCTBehaviour(mainShift, casingType, large)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, mainShift, (state, f) -> state.getBlock() instanceof GlassEncasedCogwheel && f.getAxis() == state.getValue((Property)GlassEncasedCogwheel.AXIS) && (Boolean)state.getValue((Property)(f.getAxisDirection() == Direction.AxisDirection.POSITIVE ? GlassEncasedCogwheel.TOP_SHAFT : GlassEncasedCogwheel.BOTTOM_SHAFT)) == false)))).transform(TagGen.pickaxeOnly())).blockstate((ctx, prov) -> BlockStateGen.axisBlock((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, blockState -> {
            String suffix = ((Boolean)blockState.getValue((Property)GlassEncasedCogwheel.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.getValue((Property)GlassEncasedCogwheel.BOTTOM_SHAFT) != false ? "_bottom" : "");
            String modelName = ctx.getName() + suffix;
            String blockFolder = large ? "encased_large_cogwheel" : "encased_cogwheel";
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, CreatePrism.asResource("block/" + blockFolder + "/block" + suffix))).texture("particle", CreatePrism.asResource("block/" + name + "_glass_casing"))).texture("casing", CreatePrism.asResource("block/" + name + "_glass_casing"))).texture("backing", GlassBlockBuilders.getBacking(casingType))).texture("opening", GlassBlockBuilders.getOpening(casingType))).texture("siding", GlassBlockBuilders.getSiding(casingType, large));
        }, (boolean)false)).item().model((ctx, prov) -> {
            String blockFolder = large ? "encased_large_cogwheel" : "encased_cogwheel";
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), CreatePrism.asResource("block/" + blockFolder + "/item"))).texture("casing", CreatePrism.asResource("block/" + name + "_glass_casing"))).texture("backing", GlassBlockBuilders.getBacking(casingType))).texture("opening", GlassBlockBuilders.getOpening(casingType))).texture("siding", GlassBlockBuilders.getSiding(casingType, large));
        }).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<IlluminationEncasedCogwheel> illuminationEncasedCogwheel(T reg, String casingType, boolean large, NonNullFunction<BlockBehaviour.Properties, IlluminationEncasedCogwheel> factory) {
        CTSpriteShiftEntry mainShift = CPSpriteShifts.getIlluminationCasingShift(casingType);
        String name = casingType + "_illumination";
        String blockName = name + (large ? "_encased_large_cogwheel" : "_encased_cogwheel");
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(blockName, factory).initialProperties(() -> Blocks.GLOWSTONE).properties(BlockBehaviour.Properties::noOcclusion).properties(p -> p.lightLevel(s -> 15)).properties(GlassBlockBuilders::glassProperties).loot((p, lb) -> {
            if (large) {
                p.dropOther((Block)lb, (ItemLike)AllBlocks.LARGE_COGWHEEL.get());
            } else {
                p.dropOther((Block)lb, (ItemLike)AllBlocks.COGWHEEL.get());
            }
        }).addLayer(() -> RenderType::translucent).onRegister(CreateRegistrate.connectedTextures(() -> GlassBlockBuilders.getIlluminationCogCTBehaviour(mainShift, casingType, large)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, mainShift, (state, f) -> state.getBlock() instanceof IlluminationEncasedCogwheel && f.getAxis() == state.getValue((Property)GlassEncasedCogwheel.AXIS) && (Boolean)state.getValue((Property)(f.getAxisDirection() == Direction.AxisDirection.POSITIVE ? GlassEncasedCogwheel.TOP_SHAFT : GlassEncasedCogwheel.BOTTOM_SHAFT)) == false)))).transform(TagGen.pickaxeOnly())).blockstate((ctx, prov) -> BlockStateGen.axisBlock((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, blockState -> {
            String suffix = ((Boolean)blockState.getValue((Property)GlassEncasedCogwheel.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.getValue((Property)GlassEncasedCogwheel.BOTTOM_SHAFT) != false ? "_bottom" : "");
            String modelName = ctx.getName() + suffix;
            String blockFolder = large ? "encased_large_cogwheel" : "encased_cogwheel";
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, CreatePrism.asResource("block/" + blockFolder + "/block" + suffix))).texture("particle", CreatePrism.asResource("block/" + casingType + "_illumination_casing"))).texture("casing", CreatePrism.asResource("block/" + casingType + "_illumination_casing"))).texture("backing", GlassBlockBuilders.getBacking(casingType))).texture("opening", GlassBlockBuilders.getOpening(casingType))).texture("siding", GlassBlockBuilders.getIlluminationSiding(casingType, large));
        }, (boolean)false)).item().model((ctx, prov) -> {
            String blockFolder = large ? "encased_large_cogwheel" : "encased_cogwheel";
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), CreatePrism.asResource("block/" + blockFolder + "/item"))).texture("casing", CreatePrism.asResource("block/" + casingType + "_illumination_casing"))).texture("backing", GlassBlockBuilders.getBacking(casingType))).texture("opening", GlassBlockBuilders.getOpening(casingType))).texture("siding", GlassBlockBuilders.getIlluminationSiding(casingType, large));
        }).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<MetalScaffoldingBlock> glassScaffolding(T reg, String casing, boolean clear, NonNullFunction<BlockBehaviour.Properties, MetalScaffoldingBlock> factory) {
        String name = casing + (clear ? "_clear" : "") + "_glass_scaffolding";
        CTSpriteShiftEntry mainShift = CPSpriteShifts.getCasingShift(casing, clear);
        CTSpriteShiftEntry side = GlassBlockBuilders.getSideShift(casing);
        CTSpriteShiftEntry innerSide = GlassBlockBuilders.getInnerSideShift(casing);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(name, factory).initialProperties(() -> Blocks.SCAFFOLDING).properties(p -> p.sound(SoundType.COPPER).noOcclusion()).addLayer(() -> RenderType::cutout).onRegister(CreateRegistrate.connectedTextures(() -> new MetalScaffoldingCTBehaviour(side, innerSide, mainShift)))).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{BlockTags.CLIMBABLE}).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(s -> {
            String suffix = (Boolean)s.getValue((Property)MetalScaffoldingBlock.BOTTOM) != false ? "_horizontal" : "";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + suffix, CreatePrism.asResource("block/scaffold/block" + suffix))).texture("top", GlassBlockBuilders.getTopTexture(casing))).texture("inside", GlassBlockBuilders.getInsideTexture(casing))).texture("side", GlassBlockBuilders.getSideTexture(casing))).texture("casing", CreatePrism.asResource("block/" + casing + (clear ? "_clear" : "") + "_glass_casing"))).texture("particle", GlassBlockBuilders.getSideTexture(casing))).build();
        }, new Property[]{MetalScaffoldingBlock.WATERLOGGED, MetalScaffoldingBlock.DISTANCE})).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)c.get())).requires(GlassBlockBuilders.getScaffoldingBase(casing)).requires((ItemLike)AllPaletteBlocks.FRAMED_GLASS.get()).unlockedBy("has_scaffolding", RegistrateRecipeProvider.has(GlassBlockBuilders.getScaffoldingBase(casing))).save((RecipeOutput)p, CreatePrism.asResource("crafting/glass_scaffolding/" + c.getName()))).item(MetalScaffoldingBlockItem::new).model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), CreatePrism.asResource("block/scaffold/item"))).texture("top", GlassBlockBuilders.getTopTexture(casing))).texture("inside", GlassBlockBuilders.getInsideTexture(casing))).texture("side", GlassBlockBuilders.getSideTexture(casing))).texture("casing", CreatePrism.asResource("block/" + casing + (clear ? "_clear" : "") + "_glass_casing"))).texture("particle", GlassBlockBuilders.getSideTexture(casing))).build()).register();
    }

    private static GlassEncasedCogCTBehaviour getCogCTBehaviour(CTSpriteShiftEntry mainShift, String casingType, boolean large) {
        if (!large) {
            CTSpriteShiftEntry side = CPSpriteShifts.vertical("encased_cogwheels/" + casingType + "_encased_cogwheel_side");
            CTSpriteShiftEntry otherSide = CPSpriteShifts.horizontal("encased_cogwheels/" + casingType + "_encased_cogwheel_side");
            Couple sideShifts = Couple.create((Object)side, (Object)otherSide);
            return new GlassEncasedCogCTBehaviour(mainShift, (Couple<CTSpriteShiftEntry>)sideShifts);
        }
        return new GlassEncasedCogCTBehaviour(mainShift);
    }

    private static IlluminationEncasedCogCTBehaviour getIlluminationCogCTBehaviour(CTSpriteShiftEntry mainShift, String casingType, boolean large) {
        if (!large) {
            CTSpriteShiftEntry side = CPSpriteShifts.vertical("encased_cogwheels/" + casingType + "_illumination_encased_cogwheel_side");
            CTSpriteShiftEntry otherSide = CPSpriteShifts.horizontal("encased_cogwheels/" + casingType + "_illumination_encased_cogwheel_side");
            Couple sideShifts = Couple.create((Object)side, (Object)otherSide);
            return new IlluminationEncasedCogCTBehaviour(mainShift, (Couple<CTSpriteShiftEntry>)sideShifts);
        }
        return new IlluminationEncasedCogCTBehaviour(mainShift);
    }

    private static BlockBehaviour.Properties glassProperties(BlockBehaviour.Properties p) {
        return p.isValidSpawn(($, $$, $$$, $$$$) -> false).isRedstoneConductor(($, $$, $$$) -> false).isSuffocating(($, $$, $$$) -> false).isViewBlocking(($, $$, $$$) -> false);
    }

    private static ResourceLocation getOpening(String casing) {
        if (casing.equals("andesite")) {
            return ResourceLocation.parse((String)"create:block/gearbox");
        }
        if (casing.equals("brass")) {
            return ResourceLocation.parse((String)"create:block/brass_gearbox");
        }
        return CreatePrism.asResource("block/" + casing + "_gearbox");
    }

    private static ResourceLocation getBacking(String casing) {
        if (casing.equals("andesite")) {
            return ResourceLocation.withDefaultNamespace((String)"block/stripped_spruce_log_top");
        }
        if (casing.equals("brass")) {
            return ResourceLocation.withDefaultNamespace((String)"block/stripped_dark_oak_log_top");
        }
        return CreatePrism.asResource("block/" + casing + "_backing");
    }

    private static ResourceLocation getSiding(String casing, boolean large) {
        return CreatePrism.asResource("block/encased_cogwheels/" + (large ? "large_" : "") + casing + "_encased_cogwheel_side");
    }

    private static ResourceLocation getIlluminationSiding(String casing, boolean large) {
        return CreatePrism.asResource("block/encased_cogwheels/" + (large ? "large_" : "") + casing + "_illumination_encased_cogwheel_side");
    }

    private static CTSpriteShiftEntry getSideShift(String casing) {
        if (casing.equals("andesite")) {
            return AllSpriteShifts.ANDESITE_SCAFFOLD;
        }
        if (casing.equals("brass")) {
            return AllSpriteShifts.BRASS_SCAFFOLD;
        }
        if (casing.equals("copper")) {
            return AllSpriteShifts.COPPER_SCAFFOLD;
        }
        return CPSpriteShifts.horizontal("scaffold/" + casing + "_scaffold");
    }

    private static CTSpriteShiftEntry getInnerSideShift(String casing) {
        if (casing.equals("andesite")) {
            return AllSpriteShifts.ANDESITE_SCAFFOLD_INSIDE;
        }
        if (casing.equals("brass")) {
            return AllSpriteShifts.BRASS_SCAFFOLD_INSIDE;
        }
        if (casing.equals("copper")) {
            return AllSpriteShifts.COPPER_SCAFFOLD_INSIDE;
        }
        return CPSpriteShifts.horizontal("scaffold/" + casing + "_scaffold_inside");
    }

    private static ResourceLocation getTopTexture(String casing) {
        if (casing.equals("andesite") || casing.equals("brass") || casing.equals("copper")) {
            return ResourceLocation.parse((String)("create:block/funnel/" + casing + "_funnel_frame"));
        }
        return CreatePrism.asResource("block/scaffold/" + casing + "_frame");
    }

    private static ResourceLocation getInsideTexture(String casing) {
        if (casing.equals("andesite") || casing.equals("brass") || casing.equals("copper")) {
            return ResourceLocation.parse((String)("create:block/scaffold/" + casing + "_scaffold_inside"));
        }
        return CreatePrism.asResource("block/scaffold/" + casing + "_scaffold_inside");
    }

    private static ResourceLocation getSideTexture(String casing) {
        if (casing.equals("andesite") || casing.equals("brass") || casing.equals("copper")) {
            return ResourceLocation.parse((String)("create:block/scaffold/" + casing + "_scaffold"));
        }
        return CreatePrism.asResource("block/scaffold/" + casing + "_scaffold");
    }

    private static BlockEntry<?> getScaffoldingBase(String casing) {
        if (casing.equals("andesite")) {
            return AllBlocks.ANDESITE_SCAFFOLD;
        }
        if (casing.equals("brass")) {
            return AllBlocks.BRASS_SCAFFOLD;
        }
        if (casing.equals("copper")) {
            return AllBlocks.COPPER_SCAFFOLD;
        }
        return AllBlocks.ANDESITE_SCAFFOLD;
    }
}

