/*
 * Decompiled with CFR 0.152.
 */
package ru.infikot.shelfwits;

import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4590;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_8113;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.infikot.shelfwits.DebugCommand;
import ru.infikot.shelfwits.ShelfUtils;

public class ShelfWitsClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"shelf-wits");
    private static int managedDisplayEntityId = -1;
    private static class_2338 currentTargetBlockPos = null;

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null && client.field_1687 != null && client.field_1724.field_6012 % 2 == 0) {
                this.tick(client);
            }
        });
        DebugCommand.register();
        LOGGER.info("WITS (shelf-wits) initialized using Display Entity approach!");
    }

    private void tick(class_310 client) {
        TargetInfo currentTarget = this.getCurrentTargetInfo(client);
        this.manageDisplayEntity(client, currentTarget);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void manageDisplayEntity(class_310 client, TargetInfo target) {
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        class_1297 existingEntity = world.method_8469(managedDisplayEntityId);
        if (target == null) {
            if (existingEntity != null) {
                existingEntity.method_31472();
                managedDisplayEntityId = -1;
            }
            currentTargetBlockPos = null;
            return;
        }
        if (target.pos().equals((Object)currentTargetBlockPos) && existingEntity instanceof class_8113.class_8123) {
            class_8113.class_8123 display = (class_8113.class_8123)existingEntity;
            if (!existingEntity.method_31481()) {
                display.method_48911(target.text());
                return;
            }
        }
        if (existingEntity != null) {
            existingEntity.method_31472();
        }
        class_8113.class_8123 newDisplay = new class_8113.class_8123(class_1299.field_42457, (class_1937)world);
        newDisplay.method_48911(target.text());
        newDisplay.method_33574(this.getDisplayPosition(target.pos(), target.state()));
        class_2350 facing = (class_2350)target.state().method_11654((class_2769)class_2741.field_12481);
        switch (facing) {
            case field_11043: {
                newDisplay.method_36456(180.0f);
                break;
            }
            case field_11035: {
                newDisplay.method_36456(0.0f);
                break;
            }
            case field_11039: {
                newDisplay.method_36456(90.0f);
                break;
            }
            case field_11034: {
                newDisplay.method_36456(-90.0f);
                break;
            }
        }
        newDisplay.method_48847(class_8113.class_8114.field_42406);
        newDisplay.method_48912((byte)1);
        newDisplay.method_48910(0);
        newDisplay.method_48909((byte)-1);
        float scale = 0.37f;
        Vector3f scaleVector = new Vector3f(scale, scale, scale);
        class_4590 transformation = new class_4590(null, null, scaleVector, null);
        newDisplay.method_48849(transformation);
        world.method_53875((class_1297)newDisplay);
        managedDisplayEntityId = newDisplay.method_5628();
        currentTargetBlockPos = target.pos();
    }

    private TargetInfo getCurrentTargetInfo(class_310 client) {
        class_5250 namePart;
        if (client.field_1687 == null || client.field_1724 == null) {
            return null;
        }
        class_239 hit = client.field_1765;
        if (!(hit instanceof class_3965)) {
            return null;
        }
        class_3965 blockHit = (class_3965)hit;
        class_2338 pos = blockHit.method_17777();
        if (client.field_1724.method_73189().method_1025(pos.method_46558()) > 36.0) {
            return null;
        }
        class_2680 state = client.field_1687.method_8320(pos);
        class_2960 blockId = class_7923.field_41175.method_10221((Object)state.method_26204());
        if (!blockId.method_12832().endsWith("_shelf") || !state.method_28498((class_2769)class_2741.field_12481)) {
            return null;
        }
        class_2586 blockEntity = client.field_1687.method_8321(pos);
        if (blockEntity == null) {
            return null;
        }
        int slot = ShelfUtils.getTargetedSlot(blockHit, state);
        if (slot < 0 || slot > 2) {
            return null;
        }
        Map<Integer, ShelfUtils.ItemStackWithColor> items = ShelfUtils.getItemsFromBlockEntity(blockEntity);
        ShelfUtils.ItemStackWithColor stackData = items.get(slot);
        int count = 0;
        if (stackData != null && !stackData.stack().method_7960()) {
            String rawName = stackData.stack().method_7964().getString();
            String displayName = rawName.length() > 15 ? rawName.substring(0, 12) + "..." : rawName;
            namePart = class_2561.method_43470((String)displayName);
            class_124 rarityFormatting = stackData.stack().method_7932().method_58413();
            class_5251 color = class_5251.method_27718((class_124)rarityFormatting);
            if (color != null) {
                namePart.method_10862(class_2583.field_24360.method_27703(color));
            }
            count = stackData.stack().method_7947();
        } else {
            namePart = class_2561.method_43471((String)"text.shelf-wits.empty_slot").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xAAAAAA)));
        }
        class_5250 countPart = class_2561.method_43470((String)(" (" + count + ")")).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0x888888)));
        class_5250 displayText = namePart.method_10852((class_2561)countPart);
        return new TargetInfo(pos, (class_2561)displayText, state);
    }

    private class_243 getDisplayPosition(class_2338 shelfPos, class_2680 shelfState) {
        class_2350 facing = (class_2350)shelfState.method_11654((class_2769)class_2741.field_12481);
        class_243 pos = shelfPos.method_46558();
        pos = pos.method_1019(class_243.method_24954((class_2382)facing.method_62675()).method_1021(-0.18000000000000005));
        pos = pos.method_1031(0.0, 0.35, 0.0);
        return pos;
    }

    private record TargetInfo(class_2338 pos, class_2561 text, class_2680 state) {
    }
}

