/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.BlastFurnace;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Directional;

public class PetroleumEngine
extends Device {
    private static final long serialVersionUID = -3929409797254451315L;
    private transient BlockFace faceDir;
    public static int petrolNeeded = 10;

    public PetroleumEngine(Location loc) {
        super(loc);
        this.setMaterial("BLAST_FURNACE");
        this.deviceName = "Petroleum Engine";
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setStoreForm(false);
        this.addLiquidType(Device.LiquidType.PETROL, 100);
        this.setPowerGen(60);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        slots.add(0);
        slots.add(1);
        this.setClickableSlots(slots);
        this.setPollutionGen(20);
        this.updateDeviceHeadItem();
        this.displayRotationOffset = 180;
        if (loc != null) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    PetroleumEngine.this.updateUIIcon();
                }
            }, 1L);
        }
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.RED) + "- " + petrolNeeded + "\ud83d\udca7");
        lore.add("- Convert petroleum into energy.");
        lore.add("- Requires petroleum piping connection.");
        lore.add("- Placing grindstones on the left and right");
        lore.add("- Will increase power efficiency");
        return lore;
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance);
            boolean playerReallyClose = TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance);
            Block block = this.getLocation().getBlock();
            BlastFurnace state = null;
            this.setProducingPower(false);
            if (this.getStoredLiquid(Device.LiquidType.PETROL) >= petrolNeeded) {
                BlastFurnace smoker;
                if (playerNear) {
                    smoker = state = (BlastFurnace)block.getState();
                    smoker.setBurnTime((short)30);
                    smoker.update();
                }
                if (this.faceDir == null) {
                    BlockFace facing;
                    smoker = (BlastFurnace)block.getState();
                    Directional directionalData = (Directional)smoker.getBlockData();
                    this.faceDir = facing = directionalData.getFacing();
                }
                this.removeLiquid(Device.LiquidType.PETROL, petrolNeeded);
                this.getGrid().logLiquid(Device.LiquidType.PETROL, -petrolNeeded);
                double eff = 0.34;
                if (playerReallyClose) {
                    block.getWorld().playSound(block.getLocation(), Sound.BLOCK_SMOKER_SMOKE, 1.0f, 1.0f);
                }
                if (block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 90)).getType().equals((Object)Material.GRINDSTONE)) {
                    eff += 0.33;
                    this.steamSmoke(block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 90)).getLocation(), playerNear);
                }
                if (block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 270)).getType().equals((Object)Material.GRINDSTONE)) {
                    eff += 0.33;
                    this.steamSmoke(block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 270)).getLocation(), playerNear);
                }
                this.getGrid().addPower(this, (int)((double)this.getPowerGen() * eff));
                this.setProducingPower(true);
            }
            if (playerReallyClose) {
                BlastFurnace smoker = state;
                if (smoker == null) {
                    smoker = (BlastFurnace)block.getState();
                }
                if (smoker.getInventory().getViewers().size() > 0) {
                    this.updateUIIcon();
                }
            }
        }
    }

    private void updateUIIcon() {
        Block block = this.getLocationREADONLY().getBlock();
        BlockState blockState = block.getState();
        if (blockState instanceof BlastFurnace) {
            BlastFurnace smoker = (BlastFurnace)blockState;
            ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Petroleum", String.valueOf(this.getStoredLiquid(Device.LiquidType.PETROL)) + "/" + this.getMaxLiquid(Device.LiquidType.PETROL)));
            smoker.getInventory().setResult(TUItems.setModelData(TUItems.createItem(Material.GLASS, String.valueOf(MineItems.goldBold()) + "Stored Petroleum", lore), 9529));
        }
    }

    private void steamSmoke(final Location loc, boolean nearby) {
        if (!nearby) {
            return;
        }
        loc.add(0.5, 1.0, 0.5);
        int i = 0;
        while (i < 3) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    loc.add(0.0, 0.33, 0.0);
                    if (!loc.getBlock().getType().isSolid()) {
                        loc.getWorld().spawnParticle(Particle.CAMPFIRE_COSY_SMOKE, loc, 1, 0.0, 0.0, 0.0, 1.0E-11);
                    }
                }
            }, 10L * (long)i);
            ++i;
        }
    }

    @Override
    public int getGridScore() {
        return 2;
    }
}

