/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Liquids;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Liquids.PipeLine;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.block.data.type.Wall;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Transformation;

public class Pipe {
    private static HashSet<Pipe> allPipes = new HashSet();
    private PipeLine line;
    private Display pipeDisplay;
    private Display liquidDisplay;
    private ArrayList<Display> cube = new ArrayList();
    private Block block;
    private Location loc;
    private Device.LiquidType type;

    public Pipe(Location loc) {
        allPipes.add(this);
        this.block = loc.getBlock();
        this.setLoc(loc);
        this.block.setMetadata("MT-Pipe", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)this));
    }

    public void removePipe() {
        this.block.removeMetadata("MT-Pipe", MineMain.getPlugin());
        allPipes.remove(this);
        this.line = null;
        this.removeDecor();
    }

    public void spawnDecor() {
        if (this.pipeDisplay == null) {
            if (this.block.getType().toString().contains("POLISHED")) {
                if (this.cube.size() == 0) {
                    this.cube.addAll(Pipe.addCopperDoors(this.block.getLocation()));
                }
                return;
            }
            Wall wall = (Wall)this.block.getBlockData();
            int wallCount = 0;
            if (!wall.getHeight(BlockFace.NORTH).equals((Object)Wall.Height.NONE)) {
                ++wallCount;
            }
            if (!wall.getHeight(BlockFace.EAST).equals((Object)Wall.Height.NONE)) {
                ++wallCount;
            }
            if (!wall.getHeight(BlockFace.SOUTH).equals((Object)Wall.Height.NONE)) {
                ++wallCount;
            }
            if (!wall.getHeight(BlockFace.WEST).equals((Object)Wall.Height.NONE)) {
                ++wallCount;
            }
            if (wallCount == 0) {
                this.pipeDisplay = Pipe.verticalPipe(this.block);
            }
            if (wallCount == 1) {
                this.pipeDisplay = Pipe.pipeCube(this.block);
            }
            if (wallCount == 2) {
                this.pipeDisplay = Pipe.horizonalPipe(this.block);
            }
            if (wallCount > 3) {
                this.pipeDisplay = Pipe.pipeCube(this.block);
            }
        }
        if (this.pipeDisplay != null && this.liquidDisplay == null && this.type != null) {
            this.liquidDisplay = Pipe.spawnLiquid(this.pipeDisplay.getLocation(), this.pipeDisplay.getTransformation(), this.type);
        }
        if (this.liquidDisplay != null && this.type != null) {
            ((BlockDisplay)this.liquidDisplay).setBlock(Pipe.getLiquidMaterial(this.type).createBlockData());
        }
    }

    public void removeDecor() {
        if (this.pipeDisplay != null) {
            this.pipeDisplay.remove();
            this.pipeDisplay = null;
        }
        this.removeLiquidDisplay();
        if (this.cube.size() > 0) {
            for (Display display : new ArrayList<Display>(this.cube)) {
                display.remove();
            }
            this.cube.clear();
        }
    }

    public void removeLiquidDisplay() {
        if (this.liquidDisplay != null) {
            this.liquidDisplay.remove();
            this.liquidDisplay = null;
        }
    }

    public static boolean isPipe(Block block) {
        return block.hasMetadata("MT-Pipe");
    }

    private static Display horizonalPipe(Block pipeBlock) {
        BlockFace dir = Pipe.getConnectedFace(pipeBlock);
        Location dirMod = pipeBlock.getLocation().add(0.0, 0.04, 0.15);
        if (dir.equals((Object)BlockFace.NORTH) || dir.equals((Object)BlockFace.SOUTH)) {
            dirMod = pipeBlock.getLocation().add(0.15, 0.04, 0.0);
        }
        BlockDisplay display = (BlockDisplay)pipeBlock.getWorld().spawn(dirMod, BlockDisplay.class);
        MineUtil.setDisposableEntity((Entity)display);
        display.setBlock(Material.COPPER_GRATE.createBlockData());
        Transformation transform = display.getTransformation();
        if (dir.equals((Object)BlockFace.NORTH) || dir.equals((Object)BlockFace.SOUTH)) {
            transform.getScale().set(0.7, 0.8, 1.0);
        } else {
            transform.getScale().set(1.0, 0.8, 0.7);
        }
        display.setTransformation(transform);
        return display;
    }

    private static Display verticalPipe(Block pipeBlock) {
        Location spawnLoc = pipeBlock.getLocation().add(0.2, 0.0, 0.2);
        BlockDisplay display = (BlockDisplay)pipeBlock.getWorld().spawn(spawnLoc, BlockDisplay.class);
        MineUtil.setDisposableEntity((Entity)display);
        display.setBlock(Material.COPPER_GRATE.createBlockData());
        Transformation transform = display.getTransformation();
        transform.getScale().set(0.6, 1.001, 0.6);
        display.setTransformation(transform);
        display.setBrightness(new Display.Brightness(15, 15));
        return display;
    }

    private static Display pipeCube(Block pipeBlock) {
        Location spawnLoc = pipeBlock.getLocation().add(0.0, 0.0, 0.0);
        BlockDisplay display = (BlockDisplay)pipeBlock.getWorld().spawn(spawnLoc, BlockDisplay.class);
        MineUtil.setDisposableEntity((Entity)display);
        display.setBlock(Material.COPPER_GRATE.createBlockData());
        Transformation transform = display.getTransformation();
        transform.getScale().set(1.0, 1.001, 1.0);
        display.setTransformation(transform);
        return display;
    }

    private static Display spawnLiquid(Location loc, Transformation transform, Device.LiquidType type) {
        if (type == null) {
            return null;
        }
        loc.add(0.001, 0.001, 0.001);
        BlockDisplay display2 = (BlockDisplay)loc.getWorld().spawn(loc, BlockDisplay.class);
        MineUtil.setDisposableEntity((Entity)display2);
        display2.setBlock(Pipe.getLiquidMaterial(type).createBlockData());
        Transformation transform2 = transform;
        transform2.getScale().set(transform2.getScale().x * 0.98f, transform2.getScale().y * 0.98f, transform2.getScale().z * 0.98f);
        display2.setTransformation(transform2);
        return display2;
    }

    private static Material getLiquidMaterial(Device.LiquidType type) {
        Material liquidMat = Material.LAPIS_BLOCK;
        if (type.equals((Object)Device.LiquidType.OIL)) {
            liquidMat = Material.COAL_BLOCK;
        }
        if (type.equals((Object)Device.LiquidType.HEAVYOIL)) {
            liquidMat = Material.ORANGE_CONCRETE;
        }
        if (type.equals((Object)Device.LiquidType.LIGHTOIL)) {
            liquidMat = Material.YELLOW_CONCRETE;
        }
        if (type.equals((Object)Device.LiquidType.PETROL)) {
            liquidMat = Material.LIGHT_GRAY_CONCRETE;
        }
        if (type.equals((Object)Device.LiquidType.LUBRICANT)) {
            liquidMat = Material.LIME_CONCRETE;
        }
        if (type.equals((Object)Device.LiquidType.STEAM)) {
            liquidMat = Material.LIGHT_GRAY_WOOL;
        }
        if (type.equals((Object)Device.LiquidType.SULFURIC_ACID)) {
            liquidMat = Material.WET_SPONGE;
        }
        return liquidMat;
    }

    public static BlockFace getConnectedFace(Block block) {
        String blockType = block.getType().toString().replace("POLISHED_", "").replace("_WALL", "");
        for (Block near : TUMaths.getNearbyBlocks6Sided(block)) {
            String nearType = near.getType().toString().replace("POLISHED_", "").replace("_WALL", "");
            if (!nearType.equals(blockType)) continue;
            return Pipe.getCardinalDirection(block, near);
        }
        return BlockFace.NORTH;
    }

    public static BlockFace getCardinalDirection(Block a, Block b) {
        if (a.getY() > b.getY()) {
            return BlockFace.UP;
        }
        if (a.getY() < b.getY()) {
            return BlockFace.DOWN;
        }
        int dx = b.getX() - a.getX();
        int dz = b.getZ() - a.getZ();
        if (Math.abs(dx) > Math.abs(dz)) {
            return dx > 0 ? BlockFace.EAST : BlockFace.WEST;
        }
        if (Math.abs(dz) > 0) {
            return dz > 0 ? BlockFace.SOUTH : BlockFace.NORTH;
        }
        return BlockFace.SELF;
    }

    private static ArrayList<Display> addCopperDoors(Location loc) {
        Transformation transform;
        BlockDisplay display;
        Transformation transform2;
        BlockDisplay display2;
        ArrayList<Display> doors = new ArrayList<Display>();
        if (loc.getBlock().getRelative(BlockFace.UP).getType().isAir()) {
            display2 = (BlockDisplay)loc.getWorld().spawn(loc.clone().add(0.05, 0.85, 0.05), BlockDisplay.class);
            display2.setBrightness(new Display.Brightness(15, 15));
            MineUtil.setDisposableEntity((Entity)display2);
            display2.setBlock(Material.COPPER_TRAPDOOR.createBlockData());
            transform2 = display2.getTransformation();
            transform2.getScale().set(0.9);
            display2.setTransformation(transform2);
            doors.add((Display)display2);
        }
        if (loc.getBlock().getRelative(BlockFace.DOWN).getType().isAir()) {
            display2 = (BlockDisplay)loc.getWorld().spawn(loc.clone().add(0.05, -0.015, 0.05), BlockDisplay.class);
            display2.setBrightness(new Display.Brightness(15, 15));
            MineUtil.setDisposableEntity((Entity)display2);
            display2.setBlock(Material.COPPER_TRAPDOOR.createBlockData());
            transform2 = display2.getTransformation();
            transform2.getScale().set(0.9);
            display2.setTransformation(transform2);
            doors.add((Display)display2);
        }
        BlockData upDoor = Material.COPPER_TRAPDOOR.createBlockData();
        TrapDoor trapdoor = (TrapDoor)upDoor;
        trapdoor.setOpen(true);
        if (loc.getBlock().getRelative(BlockFace.NORTH).getType().isAir()) {
            display = (BlockDisplay)loc.getWorld().spawn(loc.clone().add(0.05, 0.05, -0.75), BlockDisplay.class);
            display.setBrightness(new Display.Brightness(15, 15));
            MineUtil.setDisposableEntity((Entity)display);
            display.setBlock((BlockData)trapdoor);
            transform = display.getTransformation();
            transform.getScale().set(0.9);
            display.setTransformation(transform);
            doors.add((Display)display);
        }
        if (loc.getBlock().getRelative(BlockFace.NORTH).getType().isAir()) {
            display = (BlockDisplay)loc.getWorld().spawn(loc.clone().add(0.05, 0.05, 0.12), BlockDisplay.class);
            display.setBrightness(new Display.Brightness(15, 15));
            MineUtil.setDisposableEntity((Entity)display);
            display.setBlock((BlockData)trapdoor);
            transform = display.getTransformation();
            transform.getScale().set(0.9);
            display.setTransformation(transform);
            doors.add((Display)display);
        }
        trapdoor.setFacing(BlockFace.EAST);
        if (loc.getBlock().getRelative(BlockFace.EAST).getType().isAir()) {
            display = (BlockDisplay)loc.getWorld().spawn(loc.clone().add(0.85, 0.05, 0.05), BlockDisplay.class);
            display.setBrightness(new Display.Brightness(15, 15));
            MineUtil.setDisposableEntity((Entity)display);
            display.setBlock((BlockData)trapdoor);
            transform = display.getTransformation();
            transform.getScale().set(0.9);
            display.setTransformation(transform);
            doors.add((Display)display);
        }
        trapdoor.setFacing(BlockFace.WEST);
        if (loc.getBlock().getRelative(BlockFace.WEST).getType().isAir()) {
            display = (BlockDisplay)loc.getWorld().spawn(loc.clone().add(-0.75, 0.05, 0.05), BlockDisplay.class);
            display.setBrightness(new Display.Brightness(15, 15));
            MineUtil.setDisposableEntity((Entity)display);
            display.setBlock((BlockData)trapdoor);
            transform = display.getTransformation();
            transform.getScale().set(0.9);
            display.setTransformation(transform);
            doors.add((Display)display);
        }
        return doors;
    }

    public PipeLine getLine() {
        return this.line;
    }

    public void setLine(PipeLine line) {
        this.line = line;
    }

    public static void tickPipes() {
        for (Pipe pipe : allPipes) {
            pipe.decorTick();
        }
    }

    public void decorTick() {
        if (TUMaths.isPlayerNearby(this.getLoc(), 64.0)) {
            this.spawnDecor();
        } else {
            this.removeDecor();
        }
    }

    public static void removeAll() {
        for (Pipe pipe : new ArrayList<Pipe>(allPipes)) {
            pipe.removePipe();
        }
    }

    public Location getLoc() {
        return this.loc;
    }

    public void setLoc(Location loc) {
        this.loc = loc;
    }

    public void setType(Device.LiquidType type) {
        this.type = type;
    }
}

