/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Manufactoring;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class Incinerator
extends Device {
    private static final long serialVersionUID = 7571974070728037014L;
    private transient Item item = null;

    public Incinerator(Location loc) {
        super(loc);
        this.setMaterial("RED_NETHER_BRICK_SLAB");
        this.deviceName = "Incinerator";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(3);
        this.useAutoSlots();
        this.setPollutionGen(2);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Deletes anything in the input slot.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.FLINT_AND_STEEL, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            boolean playSound = false;
            Sound sound = Sound.BLOCK_FIRE_AMBIENT;
            if (this.getGrid().hasPower(this.getActionPower())) {
                boolean ran = false;
                Iterator<ItemStack> iterator = this.getInputItems().iterator();
                if (iterator.hasNext()) {
                    ItemStack stack = iterator.next();
                    ran = true;
                    playSound = true;
                    this.logItem(stack, -1);
                    stack.setAmount(stack.getAmount() - 1);
                    this.setConsumingPower(true);
                }
                if (!ran) {
                    this.setFailReason("Nothing to incinerate");
                    this.spawnInactiveParticles();
                }
            } else {
                this.setFailReason("Not Enough Power");
            }
            if (playSound && TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance)) {
                this.getLocation().getWorld().playSound(this.getLocation(), sound, 1.0f, 1.0f);
            }
        }
    }
}

