/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class AutoButcher
extends Device {
    private static final long serialVersionUID = 7571974070728037018L;
    private transient Item item = null;

    public AutoButcher(Location loc) {
        super(loc);
        this.setMaterial("NETHER_BRICK_SLAB");
        this.deviceName = "Auto Butcher";
        this.setActionTimer(5);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.useAutoSlots();
        this.setPollutionGen(5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will kill nearby animals.");
        lore.add("- This requires swords in the input slots to operate.");
        lore.add("- This only works while animals are loaded nearby.");
        lore.add("- Only kills animals if there is 8 nearby.");
        lore.add("- Range is limited to a 10x10x10 area.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GOLDEN_SWORD, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance);
            if (!playerNear) {
                return;
            }
            ArrayList<ItemStack> axes = new ArrayList<ItemStack>();
            for (ItemStack stack : this.getInventory()) {
                if (!TUItems.isValid(stack) || !stack.getType().toString().contains("SWORD")) continue;
                axes.add(stack);
            }
            if (axes.size() <= 0) {
                this.spawnInactiveParticles();
                this.setFailReason("Missing sword");
                return;
            }
            boolean playerVeryNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance);
            HashMap<EntityType, Integer> byTypes = new HashMap<EntityType, Integer>();
            boolean killed = false;
            for (Entity entity : MineUtil.getEntitiesInCubeRange(this.getLocation(), 5.0)) {
                Ageable ageable;
                if (!(entity instanceof Ageable) || !(ageable = (Ageable)entity).isAdult() || !(entity instanceof Animals)) continue;
                if (!byTypes.containsKey(entity.getType())) {
                    byTypes.put(entity.getType(), 1);
                } else {
                    byTypes.put(entity.getType(), (Integer)byTypes.get(entity.getType()) + 1);
                }
                if ((Integer)byTypes.get(entity.getType()) < 8) continue;
                ageable.damage(100.0);
                MineUtil.damageItemStack((ItemStack)axes.get(0), this.getLocation(), this.getInventory());
                killed = true;
                playSound = true;
                if (!playerVeryNear) break;
                MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), ageable.getEyeLocation(), MineMain.version.getDrippingLavaParticle(), 1, 0.5);
                break;
            }
            if (byTypes.size() == 0) {
                this.setFailReason("No killable animals");
            }
            if (byTypes.size() > 0 && !killed) {
                this.setFailReason("Need 8 adults nearby");
            }
            if (playSound && playerVeryNear) {
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, 1.0f);
            }
        }
    }
}

