/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class AutoLogger
extends Device {
    private static final long serialVersionUID = 7571974070728037021L;
    private transient Item item = null;
    private transient Location logCorner1 = null;
    private transient Location logCorner2 = null;
    private transient HashSet<Location> scanLoctions = new HashSet();
    private int logScanCooldown = 0;
    private transient ArrayList<Location> logSpots = new ArrayList();

    public AutoLogger(Location loc) {
        super(loc);
        this.setMaterial("OAK_SLAB");
        this.deviceName = "Auto Logger";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(3);
        this.useAutoSlots();
        this.setPollutionGen(5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will break nearby logs!");
        lore.add("- This requires any axe to be in the input slots to operate.");
        lore.add("- Input slots are the top row of slots.");
        lore.add("- Each item collected is placed into its own output slot.");
        lore.add("- A mover will only extract items from the output slots.");
        lore.add("- Output slots are the bottom row of slots.");
        lore.add("- Will break any log in a 21x21x21 area.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GOLDEN_AXE, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    public void resetCooldown() {
        this.logScanCooldown = 0;
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            boolean chunkLoaded = TUMaths.isPlayerNearby(this.getLocation(), MineMain.chunkViewDistance);
            if (!chunkLoaded) {
                return;
            }
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            if (this.logScanCooldown > 0) {
                this.setFailReason("Log Scan in " + this.logScanCooldown + "s");
                --this.logScanCooldown;
                return;
            }
            boolean playSound = false;
            boolean leafSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance);
            if (this.getGrid().hasPower(this.getActionPower())) {
                ArrayList<ItemStack> axes = new ArrayList<ItemStack>();
                for (ItemStack stack : this.getInputItems()) {
                    if (!TUItems.isValid(stack) || !stack.getType().toString().contains("_AXE")) continue;
                    axes.add(stack);
                }
                if (axes.size() == 0) {
                    if (playerNear) {
                        this.spawnInactiveParticles();
                    }
                    this.setFailReason("Missing axes");
                    return;
                }
                if (this.logCorner1 == null) {
                    this.logCorner1 = this.getLocation();
                    this.logCorner1.setX(this.logCorner1.getX() - 10.0);
                    this.logCorner1.setZ(this.logCorner1.getZ() - 10.0);
                    this.logCorner1.setY(this.logCorner1.getY() - 10.0);
                    this.logCorner2 = this.getLocation();
                    this.logCorner2.setX(this.logCorner2.getX() + 10.0);
                    this.logCorner2.setZ(this.logCorner2.getZ() + 10.0);
                    this.logCorner2.setY(this.logCorner2.getY() + 15.0);
                    this.scanLoctions = new HashSet<Location>(MineUtil.generateLocationsInArea(this.logCorner1, this.logCorner2));
                }
                if (this.logSpots == null) {
                    this.logSpots = new ArrayList();
                }
                if (this.logSpots.size() == 0) {
                    HashSet<Location> logLocations = new HashSet<Location>();
                    HashSet<Location> leaveLocations = new HashSet<Location>();
                    for (Location location : this.scanLoctions) {
                        if (location.getBlock().getType().toString().contains("_LOG") || location.getBlock().getType().toString().contains("_ROOTS") || location.getBlock().getType().toString().contains("_WOOD")) {
                            logLocations.add(location);
                            continue;
                        }
                        if (!MineMain.autoLoggerBreaksLeaves || !location.getBlock().getType().toString().contains("_LEAVES")) continue;
                        leaveLocations.add(location);
                    }
                    this.logSpots.addAll(logLocations);
                    this.logSpots.addAll(leaveLocations);
                }
                if (this.logSpots.size() == 0) {
                    this.logScanCooldown = 60;
                } else {
                    Location brokenSpot = null;
                    ArrayList<Location> noLongerLogs = new ArrayList<Location>();
                    for (Location spot : this.logSpots) {
                        if (axes.size() <= 0 || !this.getGrid().hasPower(this.getActionPower()) || this.getOutputSlot() == -1) break;
                        if (MinetorioListener.canBuild(this, spot)) {
                            boolean isLeafBreak;
                            boolean bl = isLeafBreak = MineMain.autoLoggerBreaksLeaves && spot.getBlock().getType().toString().contains("_LEAVES");
                            if (spot.getBlock().getType().toString().contains("_LOG") || spot.getBlock().getType().toString().contains("_ROOTS") || isLeafBreak) {
                                brokenSpot = spot;
                                this.getGrid().consumePower(this, this.getActionPower());
                                this.setConsumingPower(true);
                                ItemStack stack2 = (ItemStack)axes.get(0);
                                if (isLeafBreak) {
                                    if (TUMaths.rollRange(0, 9) == 0) {
                                        MineUtil.damageItemStack(stack2, spot, this.getInventory());
                                    }
                                } else {
                                    MineUtil.damageItemStack(stack2, spot, this.getInventory());
                                }
                                if (!isLeafBreak) {
                                    ItemStack logStack = new ItemStack(spot.getBlock().getType());
                                    this.getInventory().setItem(this.getOutputSlot(), logStack);
                                    this.logItem(logStack);
                                } else {
                                    Material leaveMaterial;
                                    leafSound = true;
                                    ItemStack drop = null;
                                    if (drop == null && TUMaths.rollRange(0, 99) <= 1) {
                                        drop = new ItemStack(Material.STICK, TUMaths.rollRange(1, 2));
                                    }
                                    if (drop == null && TUMaths.rollRange(0, 99) <= 1 && (leaveMaterial = Material.matchMaterial((String)spot.getBlock().getType().toString().replace("_LEAVES", "_SAPLING"))) != null) {
                                        drop = new ItemStack(leaveMaterial, TUMaths.rollRange(1, 2));
                                    }
                                    if (drop == null && TUMaths.rollRange(0, 199) <= 0 && (spot.getBlock().getType().equals((Object)Material.OAK_LEAVES) || spot.getBlock().getType().equals((Object)Material.DARK_OAK_LEAVES))) {
                                        drop = new ItemStack(Material.APPLE);
                                    }
                                    if (drop != null) {
                                        spot.getWorld().dropItem(TUMaths.centerLocation(spot.getBlock().getLocation(), 0.5), drop);
                                    }
                                }
                                spot.getBlock().setType(Material.AIR);
                                brokenSpot = spot;
                                if (!playerNear) break;
                                playSound = true;
                                MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), spot.getBlock().getRelative(BlockFace.UP).getLocation(), Particle.ASH, 1, 0.25);
                                break;
                            }
                            noLongerLogs.add(spot);
                            continue;
                        }
                        noLongerLogs.add(spot);
                    }
                    for (Location spot : noLongerLogs) {
                        this.logSpots.remove(spot);
                    }
                    if (brokenSpot != null) {
                        this.logSpots.remove(brokenSpot);
                    }
                }
            }
            if (playSound) {
                Sound sound = Sound.BLOCK_WOOD_BREAK;
                if (leafSound) {
                    sound = Sound.BLOCK_AZALEA_LEAVES_BREAK;
                }
                this.getLocation().getWorld().playSound(this.getLocation(), sound, 1.0f, 1.0f);
            }
        }
    }
}

