/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AutoMiner
extends Device {
    private static final long serialVersionUID = 7571974070728037023L;
    private int drillYLevel = 0;
    public int mined = 0;
    private int drillRadius = 7;
    private transient Item item = null;
    private int virtualDigs = 0;
    private boolean isPhysicalMining = false;
    private transient ArrayList<Location> cachedLayer = new ArrayList();
    private transient boolean firstCache = true;
    private boolean m2PhysicalMining = true;
    private static HashMap<Material, Collection<ItemStack>> cachedDrops = new HashMap();

    public AutoMiner(Location loc) {
        super(loc);
        this.setMaterial("GRANITE_SLAB");
        this.deviceName = "Auto Miner";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(8);
        this.useAutoSlots();
        if (loc != null) {
            if (!MineMain.virtualMiningWarmpUp && MineMain.miningMode != 1) {
            }
            this.drillYLevel = loc.getBlockY() - 2;
        }
        this.setPollutionGen(30);
        this.displayLockedHorizontal = true;
        this.updateDeviceHeadItem();
        this.displayYScaleShift = -0.75f;
    }

    @Override
    public int getGridScore() {
        return 3;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will mine blocks underneath it in a 15x15 area.");
        lore.add("- This requires any pickaxe to be in the input slots to operate.");
        lore.add("- Input slots are the top row of slots.");
        lore.add("- Each resource collected is placed into its own output slot.");
        lore.add("- A mover will only extract items from the output slots.");
        lore.add("- Output slots are the bottom row of slots.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GOLDEN_PICKAXE, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        this.miningAction();
    }

    public void miningAction() {
        if (this.isPowered()) {
            boolean playSound = false;
            int configMaxDepth = MineMain.miningMaxDepth;
            int mode = MineMain.miningMode;
            if (this.getDrillDistance() >= this.getMaxDrillDistance()) {
                if (mode == 2) {
                    if (this.drillYLevel <= -64) {
                        this.m2PhysicalMining = false;
                    }
                } else {
                    this.setFailReason("Max depth reached");
                    return;
                }
            }
            if (this.getGrid().hasPower(this.getActionPower())) {
                if (this.getOutputSlot() == -1) {
                    this.setFailReason("No output space");
                    return;
                }
                Location readLocation = this.getLocation();
                boolean playerNear = TUMaths.isPlayerNearby(readLocation, MineMain.farDistance);
                if (mode == 0 || mode == 2 && !this.m2PhysicalMining) {
                    this.isPhysicalMining = false;
                    playSound = this.virtualMining(playerNear);
                }
                if (mode == 1 || mode == 2 && this.m2PhysicalMining) {
                    this.isPhysicalMining = true;
                    playSound = this.physicalMining(playerNear, mode, configMaxDepth);
                }
            }
            if (playSound && TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance)) {
                Location loc = this.getLocation();
                loc.getWorld().playSound(loc, Sound.BLOCK_CALCITE_BREAK, 1.0f, 1.0f);
                ++this.mined;
            }
        }
    }

    private int getDrillDistance() {
        return (int)Math.abs(this.getLocation().getY() - (double)this.drillYLevel) - 2;
    }

    private int getMaxDrillDistance() {
        return MineMain.miningMaxDepth;
    }

    private void rebuildCache() {
        if (this.drillRadius <= 0) {
            this.drillRadius = 1;
        }
        int radius = this.drillRadius;
        Location corner1 = this.getLocation();
        corner1.setY((double)this.drillYLevel);
        corner1.setX(corner1.getX() - (double)radius);
        corner1.setZ(corner1.getZ() - (double)radius);
        Location corner2 = this.getLocation();
        corner2.setX(corner2.getX() + (double)radius);
        corner2.setZ(corner2.getZ() + (double)radius);
        corner2.setY((double)this.drillYLevel);
        this.cachedLayer = AutoMiner.generateLocationsInArea(corner1, corner2);
    }

    private boolean physicalMining(boolean playerNear, int mode, int configMaxDepth) {
        if (this.cachedLayer == null) {
            this.cachedLayer = new ArrayList();
            this.firstCache = true;
        }
        if (this.cachedLayer.size() == 0) {
            if (this.firstCache) {
                this.firstCache = false;
            } else {
                --this.drillYLevel;
            }
            this.rebuildCache();
            for (Location location : new ArrayList<Location>(this.cachedLayer)) {
                Material type = location.getBlock().getType();
                if (!(type.equals((Object)Material.AIR) || type.equals((Object)Material.WATER) || type.equals((Object)Material.LAVA) || type.equals((Object)Material.BEDROCK) || type.equals((Object)Material.CHEST) || type.equals((Object)Material.FURNACE) || type.equals((Object)Material.BEDROCK) || type.toString().contains("CARPET") || Device.getDevice(location) != null || Mover.isMover(location))) {
                    Location topLoc = location.getBlock().getRelative(BlockFace.UP).getLocation();
                    if (Device.getDevice(topLoc) == null && !topLoc.getBlock().getType().toString().contains("CARPET") && !Mover.isMover(topLoc)) continue;
                    this.cachedLayer.remove(location);
                    continue;
                }
                this.cachedLayer.remove(location);
            }
        } else {
            ItemStack pickaxe2 = this.getBestPickaxe();
            ItemStack stonePickaxe = this.getStonePickaxe();
            Location mined = null;
            ArrayList<Location> skipped = new ArrayList<Location>();
            for (Location spot : this.cachedLayer) {
                if (pickaxe2 == null) {
                    if (playerNear) {
                        this.spawnInactiveParticles();
                    }
                    this.setFailReason("Missing pickaxes");
                    break;
                }
                Material spotType = spot.getBlock().getType();
                boolean canBreak = this.canPickaxeBreak(pickaxe2.getType(), spotType);
                if (stonePickaxe != null && this.canPickaxeBreak(stonePickaxe.getType(), spotType)) {
                    pickaxe2 = stonePickaxe;
                }
                if (canBreak) {
                    canBreak = MinetorioListener.canBuild(this, spot);
                }
                if (canBreak) {
                    mined = spot;
                    MineUtil.damageItemStack(pickaxe2, this.getLocation(), this.getInventory(), MineMain.pickaxeDMG);
                    Collection<Object> blockDrops = new HashSet();
                    if (!cachedDrops.containsKey(spotType)) {
                        cachedDrops.put(spotType, spot.getBlock().getDrops());
                    }
                    blockDrops = cachedDrops.get(spotType);
                    for (ItemStack itemStack : blockDrops) {
                        if (itemStack.getType().equals((Object)Material.LAPIS_LAZULI)) {
                            itemStack.setAmount(TUMaths.rollRange(4, 9));
                        }
                        if (itemStack.getType().equals((Object)Material.RAW_COPPER)) {
                            itemStack.setAmount(TUMaths.rollRange(2, 5));
                        }
                        if (itemStack.getType().equals((Object)Material.REDSTONE)) {
                            itemStack.setAmount(TUMaths.rollRange(4, 5));
                        }
                        ItemStack itemStack2 = this.fortuneDrop(pickaxe2, itemStack);
                        this.getInventory().setItem(this.getOutputSlot(), itemStack2);
                        this.logItem(itemStack2);
                    }
                    spot.getBlock().setType(Material.AIR);
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    break;
                }
                skipped.add(spot);
            }
            if (skipped.size() > 0) {
                for (Location loc : skipped) {
                    this.cachedLayer.remove(loc);
                }
            }
            if (mined != null) {
                this.cachedLayer.remove(mined);
                return true;
            }
        }
        return false;
    }

    private boolean virtualMining(boolean playerNear) {
        ItemStack pickaxe = this.getBestPickaxe();
        if (pickaxe != null) {
            MineUtil.damageItemStack(pickaxe, this.getLocation(), this.getInventory());
            ++this.virtualDigs;
            if (this.virtualDigs >= 225) {
                --this.drillYLevel;
                this.virtualDigs = 0;
            }
            ItemStack drop = new ItemStack(Material.DIRT);
            HashMap<Material, Integer> chances = new HashMap<Material, Integer>();
            chances.put(Material.COAL, 135);
            double scaling = MineMain.vmDropScaling;
            chances.put(Material.RAW_COPPER, (int)(80.0 * scaling));
            chances.put(Material.RAW_IRON, (int)(107.0 * scaling));
            if (this.drillYLevel <= 32) {
                chances.put(Material.RAW_GOLD, (int)(256.0 * scaling));
                chances.put(Material.LAPIS_LAZULI, (int)(360.0 * scaling));
            }
            if (this.drillYLevel <= 16) {
                chances.put(Material.REDSTONE, (int)(60.0 * scaling));
            }
            if (this.drillYLevel <= 16) {
                chances.put(Material.DIAMOND, (int)(200.0 * scaling));
            }
            if (pickaxe.getType().equals((Object)Material.WOODEN_PICKAXE)) {
                chances.remove(Material.RAW_IRON);
                chances.remove(Material.RAW_GOLD);
                chances.remove(Material.REDSTONE);
                chances.remove(Material.DIAMOND);
                chances.remove(Material.LAPIS_LAZULI);
            }
            if (pickaxe.getType().equals((Object)Material.STONE_PICKAXE)) {
                chances.remove(Material.RAW_GOLD);
                chances.remove(Material.REDSTONE);
                chances.remove(Material.DIAMOND);
                chances.remove(Material.LAPIS_LAZULI);
            }
            ArrayList possibleResources = new ArrayList(chances.keySet());
            Collections.reverse(possibleResources);
            boolean isStone = true;
            for (Material spawnType : possibleResources) {
                if (TUMaths.rollRange(1, (Integer)chances.get(spawnType)) > 1) continue;
                drop.setType(spawnType);
                if (spawnType.equals((Object)Material.REDSTONE)) {
                    drop.setAmount(TUMaths.rollRange(4, 5));
                }
                if (spawnType.equals((Object)Material.RAW_COPPER)) {
                    drop.setAmount(TUMaths.rollRange(2, 5));
                }
                if (spawnType.equals((Object)Material.LAPIS_LAZULI)) {
                    drop.setAmount(TUMaths.rollRange(4, 9));
                }
                isStone = false;
                break;
            }
            if (isStone) {
                Material stoneType = Material.COBBLESTONE;
                switch (TUMaths.rollRange(0, 5)) {
                    case 0: {
                        stoneType = Material.DIORITE;
                        break;
                    }
                    case 1: {
                        stoneType = Material.ANDESITE;
                        break;
                    }
                    case 2: {
                        stoneType = Material.GRANITE;
                        break;
                    }
                    case 3: {
                        stoneType = Material.DIRT;
                        break;
                    }
                    case 4: {
                        stoneType = Material.COBBLESTONE;
                        break;
                    }
                    case 5: {
                        stoneType = Material.DEEPSLATE;
                    }
                }
                drop.setType(stoneType);
            }
            this.getInventory().setItem(this.getOutputSlot(), drop);
            this.logItem(drop);
            this.getGrid().consumePower(this, this.getActionPower());
            this.setConsumingPower(true);
            return true;
        }
        if (playerNear) {
            this.spawnInactiveParticles();
        }
        this.setFailReason("Missing pickaxes");
        return false;
    }

    private boolean canPickaxeBreak(Material pickType, Material mat) {
        if (mat.equals((Object)Material.AIR) || mat.equals((Object)Material.BEDROCK)) {
            return false;
        }
        if (pickType.equals((Object)Material.DIAMOND_PICKAXE) || pickType.equals((Object)Material.NETHERITE_PICKAXE)) {
            return true;
        }
        if (pickType.equals((Object)Material.IRON_PICKAXE) && mat.equals((Object)Material.OBSIDIAN)) {
            return false;
        }
        if (pickType.equals((Object)Material.STONE_PICKAXE)) {
            if (mat.equals((Object)Material.DIAMOND_ORE) || mat.equals((Object)Material.DEEPSLATE_DIAMOND_ORE)) {
                return false;
            }
            if (mat.equals((Object)Material.EMERALD_ORE) || mat.equals((Object)Material.DEEPSLATE_EMERALD_ORE)) {
                return false;
            }
            if (mat.equals((Object)Material.REDSTONE_ORE) || mat.equals((Object)Material.DEEPSLATE_REDSTONE_ORE)) {
                return false;
            }
            if (mat.equals((Object)Material.GOLD_ORE) || mat.equals((Object)Material.DEEPSLATE_GOLD_ORE)) {
                return false;
            }
            if (mat.equals((Object)Material.OBSIDIAN)) {
                return false;
            }
        }
        if (pickType.equals((Object)Material.WOODEN_PICKAXE) || pickType.equals((Object)Material.GOLDEN_PICKAXE)) {
            String mString = mat.toString();
            if (mString.contains("ORE") && !mString.contains("COAL")) {
                return false;
            }
            if (mat.equals((Object)Material.OBSIDIAN)) {
                return false;
            }
        }
        return true;
    }

    private ArrayList<ItemStack> getPicks() {
        ArrayList<ItemStack> picks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.getInputItems()) {
            if (!TUItems.isValid(stack) || !stack.getType().toString().contains("PICKAXE")) continue;
            picks.add(stack);
        }
        return picks;
    }

    private ItemStack getBestPickaxe() {
        ItemStack best = null;
        for (ItemStack pickaxe : this.getPicks()) {
            if (best == null) {
                best = pickaxe;
            } else {
                if (best.getType().equals((Object)Material.WOODEN_PICKAXE) && !pickaxe.getType().equals((Object)Material.WOODEN_PICKAXE)) {
                    best = pickaxe;
                }
                if (best.getType().equals((Object)Material.STONE_PICKAXE) && pickaxe.getType().equals((Object)Material.IRON_PICKAXE)) {
                    best = pickaxe;
                }
                if (best.getType().equals((Object)Material.IRON_PICKAXE) && pickaxe.getType().equals((Object)Material.DIAMOND_PICKAXE)) {
                    best = pickaxe;
                }
            }
            if (best == null || !best.getType().equals((Object)Material.NETHERITE_PICKAXE)) continue;
            return best;
        }
        return best;
    }

    private ItemStack getStonePickaxe() {
        for (ItemStack stack : this.getInputItems()) {
            if (!stack.getType().equals((Object)Material.STONE_PICKAXE)) continue;
            return stack;
        }
        return null;
    }

    public static ArrayList<Location> generateLocationsInArea(Location corner1, Location corner2) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int minX = Math.min(corner1.getBlockX(), corner2.getBlockX());
        int minY = Math.min(corner1.getBlockY(), corner2.getBlockY());
        int minZ = Math.min(corner1.getBlockZ(), corner2.getBlockZ());
        int maxX = Math.max(corner1.getBlockX(), corner2.getBlockX());
        int maxY = Math.max(corner1.getBlockY(), corner2.getBlockY());
        int maxZ = Math.max(corner1.getBlockZ(), corner2.getBlockZ());
        int x = minX;
        while (x <= maxX) {
            int y = minY;
            while (y <= maxY) {
                int z = minZ;
                while (z <= maxZ) {
                    locations.add(new Location(corner1.getWorld(), (double)x, (double)y, (double)z));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return locations;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 13) {
            ++this.drillRadius;
            if (this.drillRadius > 7) {
                this.drillRadius = 1;
            }
            this.rebuildCache();
            player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.updateUI();
        }
    }

    @Override
    public ItemStack createInfoIcon() {
        ArrayList<String> lore = new ArrayList<String>();
        if (MineMain.usingPowerSystem()) {
            lore.add(String.valueOf(ChatColor.GOLD) + " Action Time: " + String.valueOf(ChatColor.WHITE) + this.getCurrentTimer() + "s/" + this.getActionTimer() + "s");
            if (this.isConsumingPower()) {
                lore.add(String.valueOf(ChatColor.GOLD) + " Power Usage: " + String.valueOf(ChatColor.WHITE) + this.getActionPower() + " (Active)");
            } else {
                lore.add(String.valueOf(ChatColor.GOLD) + " Power Usage: " + String.valueOf(ChatColor.WHITE) + this.getIdlePower() + " (Idle)");
            }
            if (this.getGrid() != null) {
                int connections = this.getGrid().deviceConnections.size();
                lore.add(String.valueOf(ChatColor.GOLD) + " Grid Connections: " + String.valueOf(ChatColor.WHITE) + connections);
            } else {
                lore.add(String.valueOf(ChatColor.GOLD) + " Grid Connected: " + String.valueOf(ChatColor.WHITE) + "false");
            }
        }
        for (String string : this.extraInfoLore()) {
            lore.add(string);
        }
        if (!this.getFailReason().equals("None")) {
            lore.add(String.valueOf(ChatColor.RED) + " - " + this.getFailReason());
        }
        ItemStack stack = TUItems.setModelData(TUItems.createItem(Material.REDSTONE_LAMP, ChatColor.WHITE + ChatColor.BOLD + "Device Information", lore), 9523);
        return stack;
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = new ArrayList<String>();
        boolean maxDepth = this.getDrillDistance() >= this.getMaxDrillDistance();
        boolean m2VirtualMining = this.m2PhysicalMining && MineMain.miningMode == 2;
        int amount = 0;
        if (!maxDepth) {
            if (this.isPhysicalMining) {
                if (this.cachedLayer != null) {
                    amount = this.cachedLayer.size();
                }
            } else {
                amount = 255 - this.virtualDigs;
            }
        }
        String layerAmount = String.valueOf(ChatColor.GRAY) + " (" + amount + ")";
        if (!m2VirtualMining) {
            if (!maxDepth) {
                lore.add(String.valueOf(ChatColor.GOLD) + " Drill Depth: " + String.valueOf(ChatColor.WHITE) + this.getDrillDistance() + "/" + this.getMaxDrillDistance() + layerAmount);
            } else {
                lore.add(String.valueOf(ChatColor.GOLD) + " Drill Depth: " + String.valueOf(ChatColor.WHITE) + this.getDrillDistance() + "/" + this.getMaxDrillDistance() + String.valueOf(ChatColor.RED) + " (Max Depth)");
            }
        } else {
            lore.add(String.valueOf(ChatColor.GOLD) + " Drill Depth: " + String.valueOf(ChatColor.WHITE) + this.getDrillDistance() + "/\u221e");
        }
        lore.add(String.valueOf(ChatColor.GOLD) + " Drill Y Level: " + String.valueOf(ChatColor.WHITE) + this.drillYLevel);
        lore.add(String.valueOf(ChatColor.GOLD) + " Drill Radius: " + String.valueOf(ChatColor.WHITE) + this.drillRadius);
        if (m2VirtualMining) {
            lore.add(" ");
            lore.add(String.valueOf(ChatColor.WHITE) + " Bedrock Mining Mode");
        }
        return lore;
    }
}

