/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Spaceship;

import com.MT.triggersUtility.Events.TUEvents;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.ShipCore;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.PlanetHandler;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PhaseRelay
extends Device {
    private static final long serialVersionUID = 4730775097323296120L;
    private static String classSpacedNamed = "Phase Relay";
    private boolean trickleCharging = false;
    public int charge = 0;

    public PhaseRelay(Location loc) {
        super(loc);
        this.setMaterial("TARGET");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(0);
        this.setActionPower(10);
        this.setUseUI(true);
        this.setupUI();
        this.updateDeviceHeadItem();
    }

    public void setupUI() {
        int i = 0;
        while (i <= 8) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            this.getInventory().setItem(18 + i, MainMenu.createGoldPane());
            ++i;
        }
        this.getInventory().setItem(13, this.createInfoIcon());
    }

    @Override
    public void onDeviceRemove() {
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Used with a Phase Beacon.");
        lore.add("- Which returns the player");
        lore.add("- to the Phase Relay.");
        return lore;
    }

    @Override
    public void updateUI() {
        ItemStack stack = this.createInfoIcon();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Charge", this.charge + "%"));
        if (this.trickleCharging) {
            lore.add(MineItems.yellowBold() + " Trickle Charging");
        }
        lore.add(" ");
        lore.addAll(MineUtil.wrapText("This can teleport a player to the planet the ship is orbiting. It can also return a player to this device's location from any location by using a Phase Beacon. The phase relay will slowly generate charge, however it will generate its charge must faster when supplied with power. The relay needs to be at 100% charge in order to teleport the player.", 45, ChatColor.WHITE, 1));
        lore.add(" ");
        lore.add(String.valueOf(ChatColor.YELLOW) + "  -> Click to teleport to planet surface.");
        TUItems.addLore(stack, lore);
        this.getInventory().setItem(13, stack);
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.ENDER_PEARL, 1.0);
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, PhaseRelay.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new PhaseRelay(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 2));
        ings.add(new ItemStack(Material.ENDER_PEARL, 2));
        RecipeUtils.addDefaultRecipe(new PhaseRelay(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player;
        if (event.getSlot() == 13 && (player = (Player)event.getWhoClicked()).getWorld().getName().equals("MT_world_space")) {
            ArrayList<ShipCore> nearby = ShipCore.getCores(player.getLocation());
            for (ShipCore core : nearby) {
                if (TUMaths.get2DManhattanDistance(core.getLocationREADONLY(), player.getLocation()) > 100) continue;
                if (core.closestPlanet() != null && core.inOrbit()) {
                    Location loc = core.getVirtualLocation().clone();
                    if (core.closestWorld() != null) {
                        loc.setWorld(core.closestWorld());
                        player.teleport(PlanetHandler.clampToWorldBorder(loc.getWorld().getHighestBlockAt(loc).getLocation().add(0.5, 1.0, 0.5)));
                        this.getLocation().getWorld().playSound(this.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                        player.playSound((Entity)player, Sound.ITEM_CHORUS_FRUIT_TELEPORT, 1.0f, 0.5f);
                        continue;
                    }
                    MineUtil.sendWarning(player, "There isn't anyway to land on this planet!");
                    continue;
                }
                MineUtil.sendWarning(player, "You must be orbiting a planet to do this.");
            }
        }
    }

    @Override
    public void action() {
        this.trickleCharging = false;
        this.checkNearby();
        if (this.charge >= 100) {
            return;
        }
        if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
            this.getGrid().consumePower(this, this.getActionPower());
            this.setConsumingPower(true);
            this.charge += 5;
        } else {
            this.trickleCharging = true;
            if (TUMaths.isMultipleOf(TUEvents.serverTimeSeconds, 5)) {
                ++this.charge;
            }
        }
        if (this.charge > 100) {
            this.charge = 100;
        }
    }

    public void checkNearby() {
        if (!MinetorioListener.isPlayerNearby2DOPT(this.getLocation(), 10.0)) {
            return;
        }
        for (Entity entity : this.getLocationREADONLY().getWorld().getNearbyEntities(this.getLocation(), 10.0, 10.0, 10.0)) {
            if (!entity.getType().equals((Object)EntityType.PLAYER)) continue;
            this.linkPhaseBeacon((Player)entity);
        }
    }

    public void linkPhaseBeacon(Player player) {
        PlayerInventory inv = player.getInventory();
        boolean linked = false;
        int i = 0;
        while (i < inv.getSize()) {
            PhaseRelay relayLink;
            ItemStack stack = inv.getItem(i);
            if (MineItems.isPhaseBeacon(stack) && ((relayLink = MineItems.getPhaseRelay(stack)) == null || !relayLink.equals(this))) {
                ItemStack newStack = MineItems.getLinkedPhaseBeacon(this);
                newStack.setAmount(stack.getAmount());
                inv.setItem(i, newStack);
                linked = true;
            }
            ++i;
        }
        if (linked) {
            MineUtil.sendMessage(player, LocaleUtil.messageText("Phase_Relay_Connection"));
        }
    }
}

