/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Guide;

import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterface;
import com.MT.triggersUtility.TUInterface.TUInterfaceScrolling;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Guide.ExampleFactorys;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.PlayerData;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuideMenu {
    public static HashMap<UUID, String> lastGuide = new HashMap();
    public static HashMap<UUID, String> lastFactory = new HashMap();
    private static HashMap<String, ArrayList<ItemStack>> guideCatSets = new HashMap();

    public static void openGuideMenu(Player player, boolean openLastExample) {
        MainMenu.lastMenu.put(player.getUniqueId(), "Guide");
        if (openLastExample) {
            if (lastFactory.containsKey(player.getUniqueId())) {
                ExampleFactorys.openExampleFactory(player, lastFactory.get(player.getUniqueId()));
                return;
            }
        } else {
            lastFactory.remove(player.getUniqueId());
        }
        TUInterfaceScrolling face = GuideMenu.getScrollingFace(player);
        face.openInterface(player);
    }

    private static TUInterfaceScrolling getScrollingFace(final Player player) {
        final PlayerData pd = PlayerData.getPlayerData(player.getUniqueId().toString());
        TUInterfaceScrolling face = new TUInterfaceScrolling(MineItems.uiTitle() + LocaleUtil.uiText("GM_Title"), 6){

            @Override
            public ItemStack defineScrolling(int i) {
                String tag = this.getTag("CAT:");
                if (tag == null) {
                    tag = lastGuide.containsKey(player.getUniqueId()) ? lastGuide.get(player.getUniqueId()) : "CAT:PAPER";
                    this.addTag(tag);
                    if (this.hasTag("CAT:PAPER")) {
                        TUMaths.addGlow(this.getComponent(1).getLinkedStack());
                    }
                    this.getComponent(1).createItemStack();
                    if (this.hasTag("CAT:BOOK")) {
                        TUMaths.addGlow(this.getComponent(3).getLinkedStack());
                    }
                    this.getComponent(3).createItemStack();
                    if (this.hasTag("CAT:KNOWLEDGE_BOOK")) {
                        TUMaths.addGlow(this.getComponent(5).getLinkedStack());
                    }
                    this.getComponent(5).createItemStack();
                    if (this.hasTag("CAT:DROPPER")) {
                        TUMaths.addGlow(this.getComponent(7).getLinkedStack());
                    }
                    this.getComponent(7).createItemStack();
                }
                return GuideMenu.getCategoryStack(pd, tag.split(":")[1], i);
            }

            @Override
            public void scrollingActionClick(Player player2, ItemStack item, InventoryClickEvent event) {
                if (this.hasTag("CAT:DROPPER")) {
                    String example = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
                    ExampleFactorys.openExampleFactory(player2, example);
                    lastFactory.put(player2.getUniqueId(), example);
                } else {
                    String guideName = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
                    if (pd.isCheckedOff(guideName)) {
                        pd.removeCheckedOff(guideName);
                    } else {
                        pd.addCheckedOff(guideName);
                    }
                }
                this.updateScrolling();
                player2.playSound(player2.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        };
        TUIComponent leftScroll = GuideMenu.createLeftScroll();
        TUIComponent rightScroll = GuideMenu.createRightScroll();
        face.addComponent(leftScroll);
        face.addComponent(rightScroll);
        face.setLeftComp(leftScroll);
        face.setRightComp(rightScroll);
        int i = 9;
        while (i < 18) {
            face.addComponent(GuideMenu.pane(Material.WHITE_STAINED_GLASS_PANE, i));
            ++i;
        }
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 45));
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 46));
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 48));
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 50));
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 52));
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 53));
        face.addComponent(GuideMenu.createReturnArrow());
        face.addComponent(GuideMenu.createCategoryButton(Material.PAPER, LocaleUtil.uiText("GM_Button_Starting"), 1, " " + LocaleUtil.uiText("GM_Button_Starting_Desc")));
        face.addComponent(GuideMenu.createCategoryButton(Material.BOOK, LocaleUtil.uiText("GM_Button_Basics"), 3, " " + LocaleUtil.uiText("GM_Button_Basics_Desc")));
        face.addComponent(GuideMenu.createCategoryButton(Material.KNOWLEDGE_BOOK, LocaleUtil.uiText("GM_Button_Advanced"), 5, " " + LocaleUtil.uiText("GM_Button_Advanced_Desc")));
        face.addComponent(GuideMenu.createCategoryButton(Material.DROPPER, LocaleUtil.uiText("GM_Button_Examples"), 7, " " + LocaleUtil.uiText("GM_Button_Examples_Desc")));
        face.removeComponent(13);
        face.addComponent(MineUtil.createInfoComponent(13, LocaleUtil.uiText("GM_Info_Desc")));
        face.setScrollingSlots(GuideMenu.getScrollingSlots());
        face.updateScrolling();
        return face;
    }

    private static void deselectAll(TUInterface face) {
        int i = 0;
        while (i < 9) {
            TUIComponent comp = face.getComponent(i);
            if (comp != null) {
                ItemStack stack = comp.getLinkedStack();
                stack.removeEnchantment(Enchantment.KNOCKBACK);
                comp.setLinkedStack(stack);
                comp.createItemStack();
            }
            ++i;
        }
    }

    public static TUIComponent pane(Material mat, int slot) {
        ItemStack itemStack = TUItems.createItem(mat, " ");
        if (mat.equals((Object)Material.ORANGE_STAINED_GLASS_PANE)) {
            itemStack = TUItems.setModelData(itemStack, 9500);
        }
        if (mat.equals((Object)Material.WHITE_STAINED_GLASS_PANE)) {
            itemStack = TUItems.setModelData(itemStack, 9501);
        }
        if (mat.equals((Object)Material.YELLOW_STAINED_GLASS_PANE)) {
            itemStack = TUItems.setModelData(itemStack, 9521);
        }
        return new TUIComponent(slot, itemStack);
    }

    private static TUIComponent createLeftScroll() {
        return MineUtil.createLeftScroll(47);
    }

    private static TUIComponent createRightScroll() {
        return MineUtil.createRightScroll(51);
    }

    private static TUIComponent createReturnArrow() {
        ItemStack itemStack = MainMenu.createReturnArrow();
        return new TUIComponent(49, itemStack){

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                MainMenu.openGuideMenu(player, null);
            }
        };
    }

    private static TUIComponent createCategoryButton(final Material mat, String name, int slot, String desc) {
        ItemStack itemStack = TUItems.createItem(mat, MineItems.goldBold() + name);
        ArrayList<String> lore = new ArrayList<String>();
        for (String str : MineUtil.wrapText(desc, 45, ChatColor.WHITE, 1)) {
            lore.add(String.valueOf(ChatColor.WHITE) + str);
        }
        TUItems.addLore(itemStack, lore);
        if (name.equals("Getting Started")) {
            itemStack = TUItems.setModelData(itemStack, 9516);
        }
        if (name.equals("Basic Concepts")) {
            itemStack = TUItems.setModelData(itemStack, 9517);
        }
        if (name.equals("Advanced Mechanics")) {
            itemStack = TUItems.setModelData(itemStack, 9518);
        }
        if (name.equals("Factory Examples")) {
            itemStack = TUItems.setModelData(itemStack, 9519);
        }
        final ItemStack fStack = itemStack;
        return new TUIComponent(slot, itemStack){

            @Override
            public void onLeftClick(Player player) {
                if (MineMain.debugMode) {
                    TUMaths.dm("Factory Exmaple Button CLICKED");
                }
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.getTuface().removeTag("CAT:");
                this.getTuface().addTag("CAT:" + mat.toString());
                lastGuide.put(player.getUniqueId(), "CAT:" + mat.toString());
                ((TUInterfaceScrolling)this.getTuface()).updateScrolling();
                GuideMenu.deselectAll(this.getTuface());
                this.setLinkedStack(fStack);
                TUMaths.addGlow(this.getLinkedStack());
                this.createItemStack();
            }
        };
    }

    private static ArrayList<Integer> getScrollingSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int i = 18;
        while (i <= 26) {
            slots.add(i);
            ++i;
        }
        i = 18;
        while (i <= 26) {
            slots.add(i + 9);
            ++i;
        }
        i = 18;
        while (i <= 26) {
            slots.add(i + 18);
            ++i;
        }
        return slots;
    }

    private static ItemStack getCategoryStack(PlayerData pd, String category, int slot) {
        if (guideCatSets.get(category).size() - 1 >= slot) {
            ItemStack catStack = guideCatSets.get(category).get(slot);
            if (pd.isCheckedOff(ChatColor.stripColor((String)catStack.getItemMeta().getDisplayName()))) {
                catStack = catStack.clone();
                catStack.setType(Material.GREEN_CONCRETE);
                ItemStack newStack = MineUtil.getCheckMarkStack();
                ItemMeta im = newStack.getItemMeta();
                im.setDisplayName(catStack.getItemMeta().getDisplayName());
                im.setLore(catStack.getItemMeta().getLore());
                newStack.setItemMeta(im);
                catStack = newStack;
            }
            return catStack;
        }
        return null;
    }

    public static void populateGuideCategorys() {
        GuideMenu.populateGuideCategory("PAPER");
        GuideMenu.populateGuideCategory("BOOK");
        GuideMenu.populateGuideCategory("KNOWLEDGE_BOOK");
        GuideMenu.populateGuideCategory("DROPPER");
    }

    private static ArrayList<ItemStack> populateGuideFromConfig(String category2) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        File file = new File(MineMain.getPlugin().getDataFolder(), "guide.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection entriesSection = config.getConfigurationSection("Entries");
        if (entriesSection == null) {
            return stacks;
        }
        for (String entryKey : entriesSection.getKeys(false)) {
            String category;
            ConfigurationSection entry = entriesSection.getConfigurationSection(entryKey);
            if (entry == null || entry.getBoolean("Premium Entry Only") && MineMain.isFree || !(category = entry.getString("Category")).equals(category2)) continue;
            String name = entryKey;
            String desc = entry.getString("Description", "No description provided.");
            String materialName = entry.getString("Material", "BOOK");
            Material mat = Material.matchMaterial((String)materialName);
            if (mat == null) {
                Bukkit.getLogger().warning("Invalid material: " + materialName + " for entry: " + name);
                mat = Material.PAPER;
            }
            stacks.add(GuideMenu.createGuideItemStack(mat, name, desc));
        }
        return stacks;
    }

    public static void populateGuideCategory(String category) {
        String converted = "Getting Started";
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        category.equals("PAPER");
        if (category.equals("BOOK")) {
            converted = "Basic Concepts";
        }
        if (category.equals("KNOWLEDGE_BOOK")) {
            converted = "Advanced Mechanics";
        }
        if (category.equals("DROPPER")) {
            stacks.add(GuideMenu.createGuideItemStack(Material.CHEST, "Chest Sorting", "This example shows a simple chest sorting system!"));
            stacks.add(GuideMenu.createGuideItemStack(Material.FURNACE, "Auto Smelting", "This example shows a simple  auto smelting system!"));
        }
        if (!category.equals("DROPPER")) {
            stacks.addAll(GuideMenu.populateGuideFromConfig(converted));
        }
        guideCatSets.put(category, stacks);
    }

    private static ItemStack createGuideItemStack(Material mat, String name, String desc) {
        ItemStack stack = TUItems.createItem(mat, MineItems.goldBold() + name);
        ArrayList<String> lore = new ArrayList<String>();
        for (String str : MineUtil.wrapText(desc, 45, ChatColor.WHITE, 1)) {
            lore.add(String.valueOf(ChatColor.WHITE) + str);
        }
        TUItems.addLore(stack, lore);
        return stack;
    }
}

