/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Planets;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class LightningManager {
    private final Map<World, Integer> secondsUntilNext = new HashMap<World, Integer>();
    private final Random random = new Random();
    private static LightningManager manager;

    public void tick(World world, double meteorIntensity) {
        if (meteorIntensity <= 0.0 || world.getPlayers().isEmpty()) {
            return;
        }
        int secondsLeft = this.secondsUntilNext.getOrDefault(world, -1);
        if (secondsLeft < 0) {
            int intervalSeconds = (int)(3600.0 / meteorIntensity);
            this.secondsUntilNext.put(world, intervalSeconds);
            return;
        }
        if (secondsLeft <= 0) {
            List players = world.getPlayers();
            if (!players.isEmpty()) {
                Player target = (Player)players.get(this.random.nextInt(players.size()));
                int amount = TUMaths.rollRange(20, 40);
                LightningManager.spawnLightningStrikesAround(target.getLocation(), amount, amount * 20, (double)MineMain.chunkViewDistance * 0.5, 40);
            }
            int intervalSeconds = (int)(3600.0 / meteorIntensity);
            this.secondsUntilNext.put(world, intervalSeconds);
        } else {
            this.secondsUntilNext.put(world, secondsLeft - 1);
        }
    }

    public static void spawnLightningStrikesAround(final Location center, int strikeCount, int totalTicks, final double range, int tickRNG) {
        final World world = center.getWorld();
        if (world == null || strikeCount <= 0 || totalTicks < 0 || range <= 0.0) {
            return;
        }
        final Random random = new Random();
        int interval = totalTicks / Math.max(1, strikeCount);
        int i = 0;
        while (i < strikeCount) {
            int delay = i * interval;
            new BukkitRunnable(){

                public void run() {
                    double dx = (random.nextDouble() * 2.0 - 1.0) * range;
                    double dz = (random.nextDouble() * 2.0 - 1.0) * range;
                    Location strikeLocation = center.clone().add(dx, 0.0, dz);
                    strikeLocation.setY((double)(strikeLocation.getWorld().getHighestBlockYAt(strikeLocation) + 1));
                    world.strikeLightning(strikeLocation);
                }
            }.runTaskLater(MineMain.getPlugin(), (long)(delay += TUMaths.rollRange(0, tickRNG)));
            ++i;
        }
    }

    public static LightningManager getManager() {
        if (manager == null) {
            manager = new LightningManager();
        }
        return manager;
    }
}

