/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.MineMain;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public abstract class Saveable
implements Serializable {
    private String type = this.getClass().getName();
    private String dataFolder;
    private String fileName;
    private boolean save;
    private boolean delete;
    private boolean loadOnStart;
    private static final long serialVersionUID = -4312014567094463973L;
    private static HashMap<String, ArrayList<Saveable>> savedTypes = new HashMap();
    public static Plugin plugin;
    private static long mbSize;
    private static ArrayList<String> deleteAfterLoaded;

    static {
        mbSize = 0L;
        deleteAfterLoaded = new ArrayList();
    }

    public Saveable(String dataFolderName, String fileName) {
        this.register(true);
        this.dataFolder = dataFolderName;
        this.fileName = fileName == null ? UUID.randomUUID().toString() : fileName;
        this.save = true;
        this.delete = false;
        this.setLoadOnStart(true);
    }

    public void save() {
        this.onSave();
        String fileName = this.getFileName() + ".yml";
        String fileLocation = "Server Data/Saved/" + this.dataFolder + "/" + fileName;
        File file = new File(String.valueOf(plugin.getDataFolder()) + File.separator + fileLocation);
        file.getParentFile().mkdirs();
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(file));
            os.writeObject(this);
            os.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onSave() {
    }

    public void onDisable() {
    }

    public void register(boolean isFirstTime) {
        if (!savedTypes.containsKey(this.type)) {
            savedTypes.put(this.type, new ArrayList());
        }
        savedTypes.get(this.type).add(this);
        this.onCreate(isFirstTime);
    }

    public void remove() {
        if (!savedTypes.containsKey(this.type)) {
            savedTypes.put(this.type, new ArrayList());
        }
        savedTypes.get(this.type).remove(this);
    }

    public boolean isSave() {
        return this.save;
    }

    public void setSave(boolean save) {
        this.save = save;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public File getFile() {
        String fileName = this.getFileName() + ".yml";
        String fileLocation = "Server Data/Saved/" + this.dataFolder + "/" + fileName;
        return new File(String.valueOf(plugin.getDataFolder()) + File.separator + fileLocation);
    }

    public boolean isLoadOnStart() {
        return this.loadOnStart;
    }

    public void setLoadOnStart(boolean loadOnStart) {
        this.loadOnStart = loadOnStart;
    }

    public abstract void onCreate(boolean var1);

    public static Saveable load(File file, boolean isStartup) {
        long mb = (long)Math.floor((double)file.length() / 1024.0 / 1024.0);
        mbSize += mb;
        if (mb > 1L) {
            TUMaths.dm("FileSize is: " + mb + "mb for" + file.getName() + " All Saveables Total Size: " + mbSize);
        }
        Saveable saveable = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream is = new ObjectInputStream(fis);
            Object object = is.readObject();
            is.close();
            fis.close();
            saveable = (Saveable)object;
            if (isStartup) {
                if (saveable.isLoadOnStart()) {
                    saveable.register(false);
                }
            } else {
                saveable.register(false);
            }
        }
        catch (EOFException e) {
            TUMaths.dm("Critical Error loading 0, removing this file. " + file.getPath(), ChatColor.RED);
            Saveable.removePlacedDevice(file.getPath());
            file.delete();
            return null;
        }
        catch (FileNotFoundException e) {
            TUMaths.dm("Critical Error loading 1, removing this file. " + file.getPath(), ChatColor.RED);
            Saveable.removePlacedDevice(file.getPath());
            file.delete();
            return null;
        }
        catch (IOException e) {
            deleteAfterLoaded.add(file.getPath());
            TUMaths.dm("Critical Error loading 2, removing this file. " + file.getPath(), ChatColor.RED);
            Saveable.removePlacedDevice(file.getPath());
            file.delete();
            return null;
        }
        catch (ClassNotFoundException e) {
            deleteAfterLoaded.add(file.getPath());
            TUMaths.dm("Critical Error loading 3, removing this file. " + file.getPath(), ChatColor.RED);
            Saveable.removePlacedDevice(file.getPath());
            file.delete();
            return null;
        }
        return saveable;
    }

    private static void removePlacedDevice(String path) {
        if (!path.contains("Device Data\\")) {
            return;
        }
        String[] parts = path.split("Device Data")[1].replace("\\", "").split("==");
        World world = Bukkit.getWorld((String)parts[0]);
        if (world != null) {
            Location loc = new Location(world, (double)Integer.valueOf(parts[1]).intValue(), (double)Integer.valueOf(parts[2]).intValue(), (double)Integer.valueOf(parts[3]).intValue());
            loc.getBlock().setType(Material.AIR);
        }
    }

    public static void loadAll() {
        File file = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Server Data/Saved");
        if (!file.exists()) {
            file.mkdirs();
        }
        File[] files = file.listFiles();
        ArrayList<String> folders = new ArrayList<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getPath().contains(Saveable.getPlugin().getName())) {
                folders.add(f.getName());
            }
            ++n2;
        }
        for (String folderName : new ArrayList(folders)) {
            File folderFile = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Server Data/Saved/" + folderName);
            files = folderFile.listFiles();
            if (files == null) continue;
            int loaded = 0;
            int skipped = 0;
            String duoInt = Saveable.scanDirectory(files);
            TUMaths.dm(String.valueOf(ChatColor.GOLD) + "[Minetorio] " + String.valueOf(ChatColor.WHITE) + (loaded += Integer.valueOf(duoInt.split("::")[0]).intValue()) + " saved objects from " + folderName + " loaded successfully & " + (skipped += Integer.valueOf(duoInt.split("::")[1]).intValue()) + " were skipped!");
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                for (String filePath : deleteAfterLoaded) {
                    File file2 = new File(filePath);
                    if (file2.delete()) continue;
                    TUMaths.dm("Failed to delete!");
                }
            }
        }, 20L);
    }

    private static String scanDirectory(File[] files) {
        int loaded = 0;
        int skipped = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.isDirectory()) {
                if (Saveable.load(f, true) != null) {
                    ++loaded;
                } else {
                    ++skipped;
                }
            } else {
                String duo = Saveable.scanDirectory(f.listFiles());
                loaded += Integer.valueOf(duo.split("::")[0]).intValue();
                skipped += Integer.valueOf(duo.split("::")[1]).intValue();
            }
            ++n2;
        }
        return loaded + "::" + skipped;
    }

    public static void saveAll() {
        for (String type : new ArrayList<String>(savedTypes.keySet())) {
            for (Saveable saveable : new ArrayList(savedTypes.get(type))) {
                if (saveable.save) {
                    saveable.save();
                }
                if (!saveable.isDelete()) continue;
                saveable.getFile().delete();
            }
        }
    }

    public static void disableAll() {
        for (String type : new ArrayList<String>(savedTypes.keySet())) {
            for (Saveable saveable : new ArrayList(savedTypes.get(type))) {
                saveable.onDisable();
            }
        }
    }

    public static void delayedSaveAll() {
        long delay = 0L;
        for (String type : new ArrayList<String>(savedTypes.keySet())) {
            if (type.contains("Shop") || type.contains("Achievement") || type.contains("Dailys") || type.contains("Wild") || type.contains("SLLogger") || type.contains("DataGenFile") || type.contains("TUItem") || type.contains("ZoneMessage")) continue;
            for (final Saveable saveable : new ArrayList(savedTypes.get(type))) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        if (saveable.save) {
                            saveable.save();
                        }
                        if (saveable.isDelete()) {
                            saveable.getFile().delete();
                        }
                    }
                }, ++delay);
            }
        }
        double seconds = TUMaths.roundDouble((double)delay / 20.0, 2);
        TUMaths.dm("All saveables will be saved in " + seconds + " seconds!");
    }

    public static Saveable getSaveable(String type, String fileName) {
        if (savedTypes.containsKey(type)) {
            for (Saveable saveable : new ArrayList(savedTypes.get(type))) {
                if (!saveable.getFileName().equals(fileName)) continue;
                return saveable;
            }
        }
        return null;
    }

    public static File findFile(String directory, String fileName) {
        return new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Server Data/Saved/" + directory + "/" + fileName + ".yml");
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static void enable(Plugin p) {
        plugin = p;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileNameIKnowWhatImDoing(String fileName) {
        this.fileName = fileName;
    }

    public void delete() {
        this.remove();
        this.getFile().delete();
    }
}

