/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Defense;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class ArtilleryDevice
extends Device {
    private static final long serialVersionUID = -3922409112253171315L;
    private static String classSpacedNamed = "Artillery Device";
    private transient Location strikeLoc;

    public ArtilleryDevice(Location loc) {
        super(loc);
        this.setMaterial("DEEPSLATE_TILE_SLAB");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(3);
        this.setActionPower(10);
        this.setUseUI(true);
        this.useAutoSlots();
        this.useAutoUI();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Can shoot artillery shells up to 500");
        lore.add("- blocks away using artillery beacons.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.TNT, 1.0);
    }

    @Override
    public void action() {
        if (this.getGrid() == null) {
            return;
        }
        if (this.strikeLoc != null) {
            int strikes = 0;
            for (ItemStack stack : this.getInputItems()) {
                if (!MineItems.isIndustrialItem(stack, "Artillery Shell")) continue;
                while (stack.getAmount() > 0) {
                    if (strikes >= 3) break;
                    stack.setAmount(stack.getAmount() - 1);
                    ++strikes;
                }
                if (strikes >= 3) break;
            }
            final Location target = this.strikeLoc.clone();
            long travelTime = 20 * (TUMaths.getManhattanDistance(target, this.getLocation()) / 50);
            final double accuracy = TUMaths.getManhattanDistance(target, this.getLocation()) / 50;
            while (strikes > 0) {
                --strikes;
                if (!this.getGrid().hasPower(this.getActionPower())) continue;
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        ArtilleryDevice.spawnArtilleryProjectile(target.clone().add(TUMaths.rollRange(-accuracy, accuracy), 0.0, TUMaths.rollRange(-accuracy, accuracy)), ArtilleryDevice.this.getLocation());
                    }
                }, travelTime);
                travelTime += 20L;
                this.getGrid().consumePower(this, this.getActionPower());
                this.setConsumingPower(true);
            }
            this.strikeLoc = null;
        }
    }

    public static void spawnArtilleryProjectile(Location impactLocation, Location deviceLocation) {
        double spawnRadius = 64.0;
        Vector direction = impactLocation.toVector().subtract(deviceLocation.toVector()).normalize();
        Location spawnLocation = impactLocation.clone().subtract(direction.multiply(spawnRadius)).add(0.0, 32.0, 0.0);
        spawnLocation.setY((double)(spawnLocation.getWorld().getHighestBlockYAt(spawnLocation) + 32));
        Fireball fireball = (Fireball)impactLocation.getWorld().spawnEntity(spawnLocation, EntityType.FIREBALL);
        fireball.setYield(0.0f);
        fireball.setIsIncendiary(true);
        Vector velocity = impactLocation.toVector().subtract(spawnLocation.toVector()).normalize().multiply(2);
        fireball.setVelocity(velocity);
        fireball.setMetadata("MT-GRENADE", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)true));
        fireball.setMetadata("MT-Artilley", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)true));
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, ArtilleryDevice.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.DEFENSE, new ArtilleryDevice(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Processing Unit"));
        ings.add(MineItems.getIndustrialItem("Low Density Structure", 5));
        ings.add(MineItems.getIndustrialItem("Electric Engine Unit", 3));
        RecipeUtils.addDefaultRecipe(new ArtilleryDevice(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    public void setTarget(Location loc) {
        this.strikeLoc = loc;
    }

    public boolean isStriking() {
        return this.strikeLoc != null;
    }

    public void setStriking(Location loc) {
        this.strikeLoc = loc;
    }

    @Override
    public int getGridScore() {
        return 2;
    }
}

