/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Smoker;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Levelled;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GeothermalGenerator
extends Device {
    private static final long serialVersionUID = -39294092254451315L;
    private transient BlockFace faceDir;
    private int lavaSize = 0;
    private int lastPower = 0;
    private static String classSpacedNamed = "Geothermal Generator";
    private static int requiredLaved = 25;
    private double lastEff = 0.0;
    private double copperDebuff = 0.0;
    private boolean missingCopper = false;
    private boolean missingLava = false;
    private int rescan = 0;
    private String worldType = null;

    public GeothermalGenerator(Location loc) {
        super(loc);
        this.setMaterial("SMOKER");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setStoreForm(false);
        this.setPowerGen(5);
        this.setUseUI(true);
        this.setDeviceCrowding(true);
        this.crowdingDistance = 5;
        this.lavaSize = (int)this.calculateLavaScore(loc, requiredLaved, 5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Needs lava on left and right side");
        lore.add("- Needs copper slab above it to work");
        lore.add("- Waxed copper is best!");
        lore.add("- This increases power efficiency");
        lore.add("- Works best in large bodies of lava.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = TUItems.basicLore(String.valueOf(MineItems.whiteBold()) + " " + this.lastPower + "/" + this.getPowerGen());
        if (this.worldType != null && this.worldType.equals("NETHER")) {
            lore.add(String.valueOf(ChatColor.GREEN) + " + Nether Heat " + String.valueOf(ChatColor.BOLD) + "2\u26a1");
        }
        if (this.worldType != null && this.worldType.equals("NORMAL") && this.getLocationREADONLY().getBlockY() <= 0) {
            lore.add(String.valueOf(ChatColor.GREEN) + " + Core Heat " + String.valueOf(ChatColor.BOLD) + "2\u26a1");
        }
        if (this.lavaSize < requiredLaved) {
            lore.add(String.valueOf(ChatColor.YELLOW) + " - Small lava source " + String.valueOf(ChatColor.BOLD) + "x" + TUMaths.roundDouble((double)this.lavaSize / ((double)requiredLaved * 1.0), 2) + "\u26a1");
        }
        if (this.missingLava) {
            lore.add(String.valueOf(ChatColor.YELLOW) + " - Missing lava on left or right side " + String.valueOf(ChatColor.BOLD) + "x" + this.lastEff + "\u26a1");
        }
        if (this.missingCopper) {
            lore.add(String.valueOf(ChatColor.YELLOW) + " - Needs cut copper slab above " + String.valueOf(ChatColor.BOLD) + "x0.5\u26a1");
        } else if (this.copperDebuff > 0.0) {
            lore.add(String.valueOf(ChatColor.YELLOW) + " - Cut copper slab is not pure " + String.valueOf(ChatColor.BOLD) + "x" + this.copperDebuff + "\u26a1");
        }
        if (this.getCrowdingEffeciency(0.25) != 1.0) {
            lore.add(String.valueOf(ChatColor.YELLOW) + " - Geothermal device crowding " + String.valueOf(ChatColor.BOLD) + "x" + TUMaths.roundDouble(this.getCrowdingEffeciency(0.25), 2) + "\u26a1");
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Power Generation", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            boolean isPlayerNear;
            Block block = this.getLocation().getBlock();
            this.setProducingPower(false);
            if (this.faceDir == null) {
                Smoker smoker2 = (Smoker)block.getState();
                Directional directionalData = (Directional)smoker2.getBlockData();
                this.faceDir = directionalData.getFacing();
            }
            if (isPlayerNear = TUMaths.isPlayerNearby(block.getLocation(), MineMain.distantDistance)) {
                --this.rescan;
                if (this.rescan <= 0) {
                    this.lavaSize = (int)this.calculateLavaScore(block.getLocation(), requiredLaved, 5);
                    this.rescan = 30;
                }
                Block leftBlock = block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 90));
                Block rightBlock = block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 270));
                Block upBlock = block.getRelative(BlockFace.UP);
                double eff = 0.34;
                if (leftBlock.getType().equals((Object)Material.LAVA)) {
                    eff += 0.33;
                } else {
                    this.missingLava = true;
                }
                if (rightBlock.getType().equals((Object)Material.LAVA)) {
                    eff += 0.33;
                } else {
                    this.missingLava = true;
                }
                if (upBlock.getType().toString().contains("CUT_COPPER_SLAB")) {
                    this.missingCopper = false;
                    if (upBlock.getType().toString().contains("EXPOSED")) {
                        eff *= 0.8;
                        this.copperDebuff = 0.8;
                    }
                    if (upBlock.getType().toString().contains("WEATHERED")) {
                        eff *= 0.6;
                        this.copperDebuff = 0.6;
                    }
                    if (upBlock.getType().toString().contains("OXIDIZED")) {
                        eff *= 0.4;
                        this.copperDebuff = 0.4;
                    }
                } else {
                    eff *= 0.5;
                    this.missingCopper = true;
                }
                this.lastEff = eff;
            }
            int powerGen = (int)((double)this.getPowerGen() * this.lastEff);
            powerGen = (int)((double)powerGen * ((double)this.lavaSize / ((double)requiredLaved * 1.0)));
            if (this.worldType == null) {
                this.worldType = this.getLocation().getWorld().getEnvironment().toString();
            }
            if (this.worldType.equals("NETHER")) {
                powerGen = (int)((double)powerGen * 1.4);
            }
            if (this.worldType.equals("NORMAL") && this.getLocationREADONLY().getBlockY() <= 0) {
                powerGen = (int)((double)powerGen * 1.4);
            }
            this.lastPower = powerGen = (int)((double)powerGen * this.getCrowdingEffeciency(0.25));
            if (powerGen > 7) {
                powerGen = 7;
            }
            this.getGrid().addPower(this, powerGen);
            this.setProducingPower(true);
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, GeothermalGenerator.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new GeothermalGenerator(null).getDeviceStack(), false);
        ItemStack stack = new GeothermalGenerator(null).getDeviceStack();
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.BLACKSTONE, 6));
        ings.add(MineItems.getIndustrialItem("Copper Cable", 2));
        RecipeUtils.addDefaultRecipe(stack, ings, MTRecipe.RecipeType.BASIC, true);
    }

    private double calculateLavaScore(Location start, int maxBlocks, int maxRange) {
        if (start == null || maxBlocks <= 0) {
            return 0.0;
        }
        World world = start.getWorld();
        if (world == null) {
            return 0.0;
        }
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        double liquidBlocks = 0.0;
        double score = 0.0;
        Block startBlock = start.getBlock();
        queue.offer(startBlock);
        while (!queue.isEmpty() && liquidBlocks < (double)maxBlocks) {
            Block currentBlock = (Block)queue.poll();
            visited.add(currentBlock);
            BlockFace[] blockFaceArray = BlockFace.values();
            int n = blockFaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                BlockFace face = blockFaceArray[n2];
                Block neighborBlock = currentBlock.getRelative(face);
                Location neighborLoc = neighborBlock.getLocation();
                if (!visited.contains(neighborBlock) && neighborBlock.getType().equals((Object)Material.LAVA) && TUMaths.getManhattanDistance(start, neighborLoc) <= maxRange) {
                    queue.offer(neighborBlock);
                    visited.add(neighborBlock);
                    BlockData blockData = neighborBlock.getBlockData();
                    if (blockData instanceof Levelled) {
                        Levelled levelled = (Levelled)blockData;
                        score = levelled.getLevel() == 0 ? (score += 1.0) : (score += 0.1);
                    }
                    liquidBlocks += 1.0;
                }
                ++n2;
            }
        }
        return score;
    }
}

