/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Liquids.LiquidUtil;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class HeatExchanger
extends Device {
    private static final long serialVersionUID = -39818092254951315L;
    private static String classSpacedNamed = "Heat Exchanger";
    private int heatLeft = 0;
    public static int producedSteam = 90;
    public static int neededWater = 60;
    public static int neededHeat = 1;

    public HeatExchanger(Location loc) {
        super(loc);
        this.setMaterial("REDSTONE_LAMP");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setStoreForm(false);
        this.setIdlePower(0);
        this.setActionPower(0);
        this.setUseUI(true);
        this.addLiquidType(Device.LiquidType.WATER, 100);
        this.addLiquidType(Device.LiquidType.STEAM, 100);
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Requires heat from adjacent nuclear reactor.");
        lore.add("- Produces steam from the heat using water.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon("Heat", "" + this.heatLeft));
        lore.add(MineUtil.colon("Stored Water", this.getStoredLiquid(Device.LiquidType.WATER) + "/100"));
        lore.add(MineUtil.colon("Stored Steam", this.getStoredLiquid(Device.LiquidType.STEAM) + "/100"));
        if (this.getFailReason() != null && !this.getFailReason().equals("None")) {
            lore.add(" ");
            lore.add(" " + String.valueOf(ChatColor.RED) + this.getFailReason());
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Heat Info", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            if (this.getStoredLiquid(Device.LiquidType.STEAM) > 0) {
                this.moveSteam();
            }
            if (this.getStoredLiquid(Device.LiquidType.WATER) < neededWater) {
                this.setFailReason("Need more water");
            } else if (this.heatLeft > 0) {
                this.removeLiquid(Device.LiquidType.WATER, neededWater);
                this.addLiquid(Device.LiquidType.STEAM, producedSteam);
            } else {
                this.setFailReason("Need more heat");
            }
            if (this.heatLeft > 0) {
                --this.heatLeft;
            }
        }
    }

    public void giveHeat(int amount) {
        this.heatLeft += amount;
        if (this.heatLeft > 25) {
            this.heatLeft = 25;
        }
    }

    private void moveSteam() {
        HashSet<Device> devices = LiquidUtil.getConnectedDevices(this.getLocation().getBlock(), Device.LiquidType.STEAM);
        if (devices.size() > 0) {
            int baseSteamEach = this.getStoredLiquid(Device.LiquidType.STEAM) / devices.size();
            for (Device device : devices) {
                if (device.getStoredLiquid(Device.LiquidType.STEAM) >= device.getMaxLiquid(Device.LiquidType.STEAM)) continue;
                int liquidNeeded = device.getMaxLiquid(Device.LiquidType.STEAM) - device.getStoredLiquid(Device.LiquidType.STEAM);
                if (liquidNeeded > baseSteamEach) {
                    device.addLiquid(Device.LiquidType.STEAM, baseSteamEach);
                    this.setStoredLiquid(Device.LiquidType.STEAM, this.getStoredLiquid(Device.LiquidType.STEAM) - baseSteamEach);
                    continue;
                }
                device.addLiquid(Device.LiquidType.STEAM, liquidNeeded);
                this.setStoredLiquid(Device.LiquidType.STEAM, this.getStoredLiquid(Device.LiquidType.STEAM) - liquidNeeded);
            }
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, HeatExchanger.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new HeatExchanger(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Advanced Circuit", 5));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 4));
        RecipeUtils.addDefaultRecipe(new HeatExchanger(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }
}

