/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Planets.PlanetHandler;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class LightningGenerator
extends Device {
    private static final long serialVersionUID = -2212409797254451315L;
    private boolean canRain = false;
    private int strikeChance = 0;
    private int timesStruck = 0;
    private int strikeBonus = 0;
    private int cooldown = 0;

    public LightningGenerator(Location loc) {
        super(loc);
        this.setMaterial("LIGHTNING_ROD");
        this.deviceName = "Lightning Generator";
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(5);
        this.setStoreForm(false);
        this.setPowerGen(500);
        this.setUseUI(true);
        this.setActionTimer(5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This needs clear sky access! Light level 15!");
        lore.add("- Has a chance to be struck by lightning!");
        lore.add("- This can only happen when its storming!");
        lore.add("- Does not need the chunk loaded to work.");
        lore.add("- Needs to be placed in biomes where it storms.");
        lore.add("- Higher placement increases strike chance.");
        return lore;
    }

    @Override
    public void postCreate(boolean isFirstTime) {
        Biome biome;
        if (isFirstTime && this.getLocation().getBlock().getHumidity() > 0.0 && this.getLocation().getBlock().getTemperature() >= 0.3 && !(biome = this.getLocation().getBlock().getBiome()).toString().contains("FROZEN") && !biome.toString().contains("SNOWY")) {
            this.canRain = true;
            this.strikeChance = 1;
            this.strikeBonus = (int)((this.getLocation().getY() - 62.0) / 10.0);
            if (this.strikeBonus > 0) {
                this.strikeChance += this.strikeBonus;
            }
        }
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Times Struck", "" + this.timesStruck));
        lore.add(MineUtil.colon(" Strike Chance", "" + this.strikeChance));
        lore.add(MineUtil.colon(" Height Bonus", "" + this.strikeBonus));
        ItemStack powerStack = TUItems.createItem(Material.REDSTONE_LAMP, String.valueOf(MineItems.goldBold()) + "Device Info", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void action() {
        if (this.getGrid() != null && this.getLocation().getBlock().getLightFromSky() == 15 && this.canRain) {
            Planet planet;
            this.setProducingPower(false);
            World world = this.getLocation().getBlock().getWorld();
            if (this.cooldown > 0) {
                --this.cooldown;
                return;
            }
            if (this.strikeChance != 0 && world.hasStorm() && TUMaths.rollRange(1, 100) <= this.strikeChance) {
                this.strike(world);
            }
            if ((planet = PlanetHandler.getPlanetByWorld(this.getLocationREADONLY().getWorld().getName())) != null && planet.getLightningIntensity() > 0.0 && TUMaths.rollRange(0, 10000) <= this.planetAdjustment(this.strikeChance)) {
                this.strike(world);
            }
        }
    }

    private void strike(World world) {
        ++this.timesStruck;
        if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.chunkViewDistance)) {
            world.strikeLightning(TUMaths.centerLocation(this.getLocation(), 0.0));
        }
        this.setProducingPower(true);
        this.cooldown += 60;
        this.getGrid().addPower(this, this.getPowerGen());
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                LightningGenerator.this.setProducingPower(false);
            }
        }, 20L);
    }

    public int planetAdjustment(int chance) {
        Planet planet = PlanetHandler.getPlanetByWorld(this.getLocationREADONLY().getWorld().getName());
        if (planet != null) {
            return (int)((double)chance * planet.getLightningIntensity());
        }
        return chance;
    }

    public static void addRecipe() {
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.LIGHTNING_ROD));
        ings.add(new ItemStack(Material.REDSTONE));
        RecipeUtils.addDefaultRecipe(new LightningGenerator(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, true);
    }
}

