/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Liquids;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Liquids.LiquidUtil;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pipe;
import com.MT.xxxtrigger50xxx.Devices.Liquids.PipeLine;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;

public class BarrelPump
extends Device {
    private static final long serialVersionUID = -3929401797254221315L;
    private Device.LiquidType targetLiquid = Device.LiquidType.WATER;
    private static int barrelLiquid = 500;

    public BarrelPump(Location loc) {
        super(loc);
        this.setMaterial("HOPPER");
        this.deviceName = "Barrel Pump";
        this.setActionTimer(1);
        this.setActionPower(1);
        this.setIdlePower(1);
        this.setOpenable(true);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setStoreForm(true);
        this.useAutoSlots();
        this.setUsingAutoUI(true);
        this.changeLiquid();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Input slots are used to barrel liquids.");
        lore.add("- Input slots also are used to empty barrels.");
        lore.add("- Output slots will provide the filled or emptied barrels.");
        lore.add("- Requires a connected liquid pipe to empty / fill barrels.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ItemStack stack = TUItems.setModelData(TUItems.createItem(Material.HOPPER, MineItems.whiteBold() + "Device Information"), 9527);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Target Liquid", String.valueOf((Object)this.targetLiquid)));
        lore.add(" ");
        lore.add(MineItems.whiteBold() + " Stored Liquids");
        boolean showingAny = false;
        Device.LiquidType[] liquidTypeArray = Device.LiquidType.values();
        int n = liquidTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Device.LiquidType type = liquidTypeArray[n2];
            if (this.getStoredLiquid(type) > 0) {
                showingAny = true;
                lore.add(String.valueOf(ChatColor.WHITE) + " - " + this.getStoredLiquid(type) + " " + type.toString());
            }
            ++n2;
        }
        if (showingAny) {
            lore.add(" ");
        }
        lore.add(String.valueOf(ChatColor.WHITE) + " - Input slots are used to empty or fill Liquid Barrels.");
        lore.add(String.valueOf(ChatColor.WHITE) + " - Output slots will provide empty or filled Liquid Barrels.");
        lore.add(String.valueOf(ChatColor.WHITE) + " - Requires a liquid connection to emport or fill Liquid Barrels.");
        if (!this.getFailReason().equals("None")) {
            lore.add(" ");
            lore.add(String.valueOf(ChatColor.RED) + " - " + this.getFailReason());
        }
        TUItems.addLore(stack, lore);
        if (!showingAny) {
            TUItems.removeLoreNoColor(stack, " Stored Liquids");
        }
        this.getInventory().setItem(13, stack);
    }

    public Device.LiquidType getTargetLiquidType() {
        return this.targetLiquid;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 13) {
            if (this.targetLiquid == null) {
                this.targetLiquid = Device.LiquidType.WATER;
                player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                return;
            }
            boolean next = false;
            Device.LiquidType[] liquidTypeArray = Device.LiquidType.values();
            int n = liquidTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Device.LiquidType type = liquidTypeArray[n2];
                if (next) {
                    this.targetLiquid = type;
                    next = false;
                    this.changeLiquid();
                    break;
                }
                if (type.equals((Object)this.targetLiquid)) {
                    next = true;
                }
                ++n2;
            }
            if (next) {
                this.targetLiquid = Device.LiquidType.values()[0];
            }
            this.changeLiquid();
            player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    private void changeLiquid() {
        this.updateUI();
        Device.LiquidType[] liquidTypeArray = Device.LiquidType.values();
        int n = liquidTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Device.LiquidType type = liquidTypeArray[n2];
            if (type.equals((Object)this.targetLiquid)) {
                this.addLiquidType(type, 1000);
            } else {
                this.removeLiquidType(type);
            }
            ++n2;
        }
    }

    @Override
    public void action() {
        for (Block block : TUMaths.getNearbyBlocks6Sided(this.getLocation().getBlock())) {
            PipeLine.pipeLineCheck(block);
        }
        if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            if (this.targetLiquid == null) {
                this.targetLiquid = Device.LiquidType.WATER;
                this.changeLiquid();
            }
            boolean didAnything = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), 8.0);
            for (Device.LiquidType type : this.getLiquidTypes()) {
                HashSet<Device> connectedDevice = LiquidUtil.getConnectedDevices(this.getLocation().getBlock(), type);
                this.moveLiquids(connectedDevice, type, playerNear);
            }
            for (ItemStack input : this.getInputItems()) {
                if (!input.getType().equals((Object)Material.BARREL) || !MineItems.isIndustrialItem(input, "Liquid Barrel")) continue;
                if (TUItems.hasLoreLineNoColor(input, "Stored: ")) {
                    Device.LiquidType storedLiquid = Device.LiquidType.valueOf(ChatColor.stripColor((String)TUItems.getLoreLineNoColor(input, "Stored: ").split(": ")[1]));
                    if (this.getMaxLiquid(storedLiquid) - this.getStoredLiquid(storedLiquid) >= barrelLiquid) {
                        input.setAmount(input.getAmount() - 1);
                        this.getInventory().setItem(this.getOutputSlot(), MineItems.getIndustrialItem("Liquid Barrel"));
                        this.addLiquid(storedLiquid, barrelLiquid);
                        didAnything = true;
                        if (!playerNear) break;
                        this.getLocation().getBlock().getWorld().playSound(this.getLocation(), Sound.ITEM_BUCKET_EMPTY, 0.5f, 0.8f);
                        break;
                    }
                    didAnything = true;
                    this.setFailReason("Waiting for " + barrelLiquid + " liquid space.");
                    continue;
                }
                if (this.getStoredLiquid(this.targetLiquid) >= barrelLiquid) {
                    ItemStack stack = input.clone();
                    stack.setAmount(1);
                    TUItems.addLore(stack, MineUtil.colon("Stored", this.targetLiquid.toString()));
                    input.setAmount(input.getAmount() - 1);
                    this.getInventory().setItem(this.getOutputSlot(), stack);
                    didAnything = true;
                    if (playerNear) {
                        this.getLocation().getBlock().getWorld().playSound(this.getLocation(), Sound.ITEM_BUCKET_FILL, 0.5f, 0.8f);
                    }
                    this.removeLiquid(this.targetLiquid, barrelLiquid);
                    break;
                }
                didAnything = true;
                this.setFailReason("Waiting for " + barrelLiquid + " liquid to fill barrel.");
            }
            if (!didAnything) {
                this.setFailReason("No barrels to fill or empty.");
            }
        }
    }

    private void moveLiquids(HashSet<Device> devices, Device.LiquidType liquidType, boolean playerNear) {
        if (devices.size() > 0) {
            boolean liquidGiven = false;
            int baseLiquidEach = this.getStoredLiquid(liquidType) / devices.size();
            if (baseLiquidEach == 0) {
                return;
            }
            for (Device device2 : devices) {
                if (device2.getStoredLiquid(liquidType) >= device2.getMaxLiquid(liquidType)) continue;
                liquidGiven = true;
                int liquidNeeded = device2.getMaxLiquid(liquidType) - device2.getStoredLiquid(liquidType);
                if (liquidNeeded > baseLiquidEach) {
                    device2.addLiquid(liquidType, baseLiquidEach);
                    this.removeLiquid(liquidType, baseLiquidEach);
                    continue;
                }
                device2.addLiquid(liquidType, liquidNeeded);
                this.removeLiquid(liquidType, liquidNeeded);
            }
            if (playerNear && liquidGiven) {
                this.getLocation().getBlock().getWorld().playSound(this.getLocation(), Sound.ITEM_BOTTLE_FILL, 0.5f, 0.8f);
            }
            if (liquidGiven && Pipe.isPipe(this.getLocation().getBlock().getRelative(BlockFace.UP))) {
                Pipe pipe = (Pipe)((MetadataValue)this.getLocation().getBlock().getRelative(BlockFace.UP).getMetadata("MT-Pipe").get(0)).value();
                pipe.getLine().addLiquidType(liquidType);
                pipe.getLine().decorTickPipeLine();
            }
        }
    }
}

