/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Manufactoring;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.MinetorioTables;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class Sifter
extends Device {
    private static final long serialVersionUID = 7571974070728037016L;
    private transient Item item = null;

    public Sifter(Location loc) {
        super(loc);
        this.setMaterial("SANDSTONE_SLAB");
        this.deviceName = "Sifter";
        this.setActionTimer(2);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(2);
        this.useAutoSlots();
        this.setPollutionGen(2);
        this.updateDeviceHeadItem();
        this.displayYScaleShift = -1.0f;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Sifts through sand and dirt to get trace materials.");
        lore.add("- Sand and dirt give different trace materials.");
        lore.add("- Both have a chance to be consumed if nothing is found.");
        lore.add("- Soul Sand and Soul Soil can be sifted as well.");
        lore.add("- Output slots are the bottom row of slots.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.BOWL, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            boolean playSound = false;
            Sound sound = Sound.BLOCK_SAND_BREAK;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance);
            if (this.getGrid().hasPower(this.getActionPower())) {
                boolean sifted = false;
                for (ItemStack stack : this.getInputItems()) {
                    ItemStack result;
                    if (!MinetorioTables.isSiftable(stack) || (result = MinetorioTables.siftStack(stack)) == null) continue;
                    boolean isAir = result.getType().equals((Object)Material.AIR);
                    if (!isAir) {
                        this.getInventory().setItem(this.getOutputSlot(), result);
                    }
                    playSound = true;
                    this.logItem(stack, -1);
                    if (!MinetorioTables.isSiftable(result) && !isAir) {
                        this.logItem(result, result.getAmount());
                    }
                    stack.setAmount(stack.getAmount() - 1);
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    sifted = true;
                    break;
                }
                if (!sifted) {
                    this.setFailReason("Nothing to sift through");
                }
            } else {
                this.setFailReason("Not Enough Power");
            }
            if (playSound && playerNear) {
                this.getLocation().getWorld().playSound(this.getLocation(), sound, 1.0f, 1.0f);
            }
        }
    }
}

