/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.Events.TUEvents;
import com.MT.triggersUtility.Saveable;
import com.MT.triggersUtility.SkullCreator;
import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterfaceScrolling;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Belt;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Lift;
import com.MT.xxxtrigger50xxx.Devices.MoverIOCenter;
import com.MT.xxxtrigger50xxx.Devices.MoverInput;
import com.MT.xxxtrigger50xxx.Devices.MoverOutput;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PlayerData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;

public class Mover
extends Saveable {
    private static final long serialVersionUID = 1048950112437837861L;
    private String location;
    public boolean beltToggle = false;
    private transient Location cacheLocation;
    private transient Location cachedInputLocation = null;
    private transient Location cachedOutputLocation = null;
    private transient Location cachedOutputLocationLeft;
    private transient Location cachedOutputLocationRight;
    private transient BlockFace cachedFacing = null;
    public transient ArrayList<ItemStack> cachedFilters;
    public transient HashMap<OutDirection, ArrayList<Belt>> fullBelts;
    public transient HashMap<OutDirection, HashMap<Belt, Belt>> beltChain;
    private int overDrive = 0;
    private static HashMap<Location, Mover> allMovers = new HashMap();
    private MotorType type = MotorType.BOTH;
    public MoverIOCenter.DeviceIOType inType;
    public MoverIOCenter.DeviceIOType outType;
    public MoverIOCenter.DeviceIOType outType2;
    public MoverIOCenter.DeviceIOType outType3;
    private boolean grabberOverride = false;
    public boolean stackLimitOverride = false;
    private boolean overFlow = false;
    private boolean dropInFront = false;
    private boolean fenceFacing = false;
    private boolean isSplitter = false;
    private boolean isForwardFilter = false;
    private String placerUUID = null;
    public boolean forcedCarpet = false;
    private transient HashSet<OutDirection> beltRebuilds = new HashSet();
    private ArrayList<OutDirection> outs = new ArrayList();
    private transient HashMap<OutDirection, Location> outDirections = new HashMap();
    private int gears = 0;
    private transient Location cachedDropLocation;
    private transient Location cachedGrabLocation;
    private int faceMod = 0;
    private static ArrayList<BlockFace> cardinalDirections = new ArrayList();
    public boolean filterDamaged = false;
    private boolean motor = false;
    private transient HashMap<OutDirection, ArrayList<Location>> stairs;
    public static HashMap<Location, Mover> linkedStairs;
    public static HashMap<Location, OutDirection> linkedStairsOutDirection;
    public static int maxUngroundBeltRange;
    private boolean isBlackList = false;
    private boolean removed = false;
    public static int duplicateMovers;
    private static long beltAttachDelay;
    private transient Chunk inChunk;
    private transient Chunk outChunk;
    private ArrayList<String> storedFilters = new ArrayList();
    private static ArrayList<ItemStack> vanillaItems;
    public static HashMap<String, ArrayList<ItemStack>> filterGroups;
    public transient ArrayList<Lift> lifts;
    public transient BlockFace liftDirection;
    public int liftLength = 0;
    public static int maxLift;
    private HashMap<String, String> storedLiftStacksLeft = new HashMap();
    private HashMap<String, String> storedLiftStacksRight = new HashMap();
    private HashMap<String, String> storedBeltStacksLeft = new HashMap();
    private HashMap<String, String> storedBeltStacksRight = new HashMap();
    private transient BlockData arrowColor;
    public int displayRotationOffset = 0;
    private String displayStackString = null;
    private transient ItemDisplay linkedDisplay;
    private transient ItemStack tempDisplayStack;

    static {
        cardinalDirections.add(BlockFace.NORTH);
        cardinalDirections.add(BlockFace.EAST);
        cardinalDirections.add(BlockFace.SOUTH);
        cardinalDirections.add(BlockFace.WEST);
        cardinalDirections.add(BlockFace.UP);
        cardinalDirections.add(BlockFace.DOWN);
        linkedStairs = new HashMap();
        linkedStairsOutDirection = new HashMap();
        maxUngroundBeltRange = 12;
        duplicateMovers = 0;
        beltAttachDelay = 10L;
        vanillaItems = new ArrayList();
        filterGroups = new HashMap();
        maxLift = 10;
    }

    public boolean isAuthorized(Player player) {
        if (player.isOp()) {
            return true;
        }
        if (this.getPlacerUUID() != null) {
            if (this.getPlacerUUID().equals(player.getUniqueId().toString())) {
                return true;
            }
            PlayerData pd = PlayerData.getPlayerData(this.getPlacerUUID());
            if (pd != null) {
                return pd.isShared(player.getUniqueId());
            }
        }
        return false;
    }

    public String getPlacerUUID() {
        return this.placerUUID;
    }

    public void setPlacerUUID(String placerUUID) {
        this.placerUUID = placerUUID;
    }

    public Mover(Location loc) {
        super("Server Data", TUMaths.locationString(loc).replace("/", "=="));
        this.fullBelts = new HashMap();
        this.location = TUMaths.locationString(loc);
        Mover.addMover(this);
        if (this.hasBeltMotor()) {
            this.buildFullBelt(OutDirection.FRONT);
        }
        this.type = MotorType.BOTH;
    }

    public void compute() {
        if (this.validCheck(true)) {
            this.save();
            this.buildMoverInfo();
            if (this.isLiftMover()) {
                this.rebuildLift();
            }
            if (this.isMotor()) {
                OutDirection[] outDirectionArray = OutDirection.values();
                int n = outDirectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OutDirection out = outDirectionArray[n2];
                    this.doRebuild(out);
                    ++n2;
                }
                this.loadBeltStacks();
            }
            new BukkitRunnable(){

                public void run() {
                    if (Mover.this.validCheck(false) && !Mover.this.isRemoved()) {
                        Mover.this.handleDisplay();
                        if (Mover.this.beltRebuilds.size() > 0) {
                            for (OutDirection out : new ArrayList<OutDirection>(Mover.this.beltRebuilds)) {
                                Mover.this.doRebuild(out);
                                Mover.this.beltRebuilds.remove((Object)out);
                            }
                            return;
                        }
                        if (MinetorioListener.isPlayerNearbyOPT(Mover.this.getLocation(), MineMain.nearDistance)) {
                            Mover.this.buildMoverInfo();
                        }
                        if (Mover.this.lifts != null) {
                            for (Lift lift : Mover.this.lifts) {
                                lift.tickLift();
                            }
                        }
                        if (Mover.this.outs.size() == 0) {
                            Mover.this.cycleOuts();
                        }
                        if (Mover.this.outs.size() == 0) {
                            return;
                        }
                        OutDirection nextOut = Mover.this.outs.get(0);
                        MoveResult result = Mover.this.move2(Mover.this.inType, Mover.this.getNextDeviceIOOut(nextOut), nextOut);
                        if (!result.equals((Object)MoveResult.INVALID)) {
                            Mover.this.cycleOuts();
                        } else {
                            Mover.this.validateOuts();
                        }
                        if (Mover.this.outs.size() == 0) {
                            return;
                        }
                        int drive = Mover.this.getEffectiveDrive();
                        if (drive > 0) {
                            int i = 0;
                            while (i < drive) {
                                long delay = 20 / (drive + 1);
                                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                                    @Override
                                    public void run() {
                                        if (Mover.this.isRemoved() || !Mover.this.validCheck(false)) {
                                            return;
                                        }
                                        OutDirection nextOut2 = (this).Mover.this.outs.get(0);
                                        if (Mover.this.validCheck(false) && !(this).Mover.this.beltRebuilds.contains((Object)nextOut2)) {
                                            MoveResult result2 = Mover.this.move2((this).Mover.this.inType, Mover.this.getNextDeviceIOOut(nextOut2), nextOut2);
                                            if (!result2.equals((Object)MoveResult.INVALID)) {
                                                Mover.this.cycleOuts();
                                            } else {
                                                Mover.this.validateOuts();
                                            }
                                        }
                                    }
                                }, delay * (long)(i + 1));
                                ++i;
                            }
                        }
                    } else {
                        this.cancel();
                    }
                }
            }.runTaskTimer(MineMain.getPlugin(), 0L, 20L);
        }
    }

    private MoverIOCenter.DeviceIOType getNextDeviceIOOut(OutDirection out) {
        if (out.equals((Object)OutDirection.LEFT)) {
            return this.outType2;
        }
        if (out.equals((Object)OutDirection.FRONT)) {
            return this.outType;
        }
        return this.outType3;
    }

    private ArrayList<OutDirection> getValidOutDirections() {
        ArrayList<OutDirection> outs = new ArrayList<OutDirection>();
        OutDirection[] outDirectionArray = OutDirection.values();
        int n = outDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OutDirection out = outDirectionArray[n2];
            MoverIOCenter.DeviceIOType ioType = this.getNextDeviceIOOut(out);
            if (ioType != null) {
                if (ioType.equals((Object)MoverIOCenter.DeviceIOType.AIR)) {
                    if (this.dropInFront) {
                        outs.add(out);
                    }
                } else {
                    outs.add(out);
                }
            }
            ++n2;
        }
        return outs;
    }

    private void cycleOuts() {
        if (this.outs.size() > 0) {
            this.outs.remove(0);
        }
        if (this.outs.size() == 0) {
            this.outs = this.getValidOutDirections();
        }
    }

    private void validateOuts() {
        ArrayList<OutDirection> validOuts = this.getValidOutDirections();
        for (OutDirection out : new ArrayList<OutDirection>(this.outs)) {
            if (validOuts.contains((Object)out)) continue;
            this.outs.remove((Object)out);
        }
    }

    public void buildMoverInfo() {
        this.inType = MoverIOCenter.determineIOType(this.getInputLocation());
        this.outDirections.clear();
        this.outType = MoverIOCenter.determineIOType(this.getOutputLocationFront());
        this.outDirections.put(OutDirection.FRONT, this.getOutputLocationFront());
        this.outType2 = null;
        this.outType3 = null;
        this.grabberOverride = false;
        this.stackLimitOverride = false;
        this.overFlow = false;
        this.dropInFront = false;
        this.fenceFacing = false;
        if (this.getLocation().getBlock().getRelative(BlockFace.UP).getType().equals((Object)Material.LEVER)) {
            this.grabberOverride = true;
        }
        if (Tag.BUTTONS.isTagged((Keyed)this.getLocation().getBlock().getRelative(BlockFace.UP).getType())) {
            this.stackLimitOverride = true;
        }
        if (this.getLocation().getBlock().getRelative(BlockFace.UP).getType().equals((Object)Material.COMPARATOR)) {
            this.overFlow = true;
        }
        if (this.getLocation().getBlock().getRelative(BlockFace.UP).getType().equals((Object)Material.HEAVY_WEIGHTED_PRESSURE_PLATE)) {
            this.dropInFront = true;
        }
        if (this.getLocation().getBlock().getRelative(this.getFacing()).getType().toString().contains("FENCE")) {
            this.fenceFacing = true;
        }
        if (this.isSplitter()) {
            this.outType2 = MoverIOCenter.determineIOType(this.getOutputLocationLeft());
            this.outDirections.put(OutDirection.LEFT, this.getOutputLocationLeft());
            this.outType3 = MoverIOCenter.determineIOType(this.getOutputLocationRight());
            this.outDirections.put(OutDirection.RIGHT, this.getOutputLocationRight());
        }
    }

    public boolean validCheck(boolean force) {
        if (!this.isValidMover(force)) {
            this.removeMover();
            return false;
        }
        return true;
    }

    public boolean isValidMover(boolean force) {
        if (this.getLocation() == null || this.getLocation() != null && this.getLocation().getWorld() == null) {
            return false;
        }
        if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), MineMain.distantDistance) || force) {
            return this.getLocation().getBlock().getType().equals((Object)Material.DROPPER);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public MoveResult move2(MoverIOCenter.DeviceIOType inType, MoverIOCenter.DeviceIOType outType, OutDirection outDirection) {
        OfflinePlayer player;
        if (inType == null || outType == null) {
            return MoveResult.INVALID;
        }
        MoverInput in = null;
        MoverOutput out = null;
        if (MineMain.devicesDisableOffline && TUMaths.isMultipleOf(TUEvents.serverTimeSeconds, 600) && MineMain.devicesDisableOffline && this.getPlacerUUID() != null && !(player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.getPlacerUUID()))).isOnline() && !player.isOp()) {
            return MoveResult.INVALID;
        }
        in = new MoverInput(this, inType, this.grabberOverride);
        out = new MoverOutput(this, outType, this.grabberOverride, outDirection);
        if (in.getType() != null && out.getType() != null) {
            Device device;
            if (in.getType().equals((Object)MoverIOCenter.DeviceIOType.AIR) && !this.dropInFront) {
                return MoveResult.INVALID;
            }
            if (out.getType().equals((Object)MoverIOCenter.DeviceIOType.AIR) && !this.dropInFront) {
                return MoveResult.INVALID;
            }
            boolean airIntake = inType.equals((Object)MoverIOCenter.DeviceIOType.AIR);
            if ((outType.equals((Object)MoverIOCenter.DeviceIOType.AIR) || airIntake) && !MinetorioListener.isPlayerNearby2DOPT(this.getLocation(), MineMain.distantDistance)) {
                return MoveResult.INVALID;
            }
            ArrayList<ItemStack> ins = in.getStacks();
            if (outType.equals((Object)MoverIOCenter.DeviceIOType.CHAIN) && (device = Device.getDevice(this.getOutputLocation(outDirection))) != null && device.useSpecificInputs && device.hasSpecificInputs()) {
                for (ItemStack itemStack : new ArrayList<ItemStack>(ins)) {
                    if (device.isSpecificInput(itemStack)) continue;
                    ins.remove(itemStack);
                }
            }
            if (this.filterDamaged) {
                for (ItemStack stack : new ArrayList<ItemStack>(ins)) {
                    if (!TUItems.isDamaged(stack)) {
                        if (this.isBlackList()) continue;
                        ins.remove(stack);
                        continue;
                    }
                    if (!this.isBlackList()) continue;
                    ins.remove(stack);
                }
            }
            if (this.isForwardFilter() && this.isSplitter()) {
                for (ItemStack stack : new ArrayList<ItemStack>(ins)) {
                    if ((!outDirection.equals((Object)OutDirection.FRONT) || this.isFilterItem(stack)) && (outDirection.equals((Object)OutDirection.FRONT) || !this.isFilterItem(stack))) continue;
                    ins.remove(stack);
                }
            }
            if (this.overFlow && !in.getType().equals((Object)MoverIOCenter.DeviceIOType.AIR)) {
                for (int slot : MoverIOCenter.getInSlots(in)) {
                    try {
                        if (TUItems.isValid(in.getInventory().getItem(slot))) continue;
                        return MoveResult.INVALID;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        TUMaths.dm("Type: " + String.valueOf((Object)in.getType()) + ": " + in.getInventorySize());
                        TUMaths.dm("CRITICAL ERROR, report the following stack trace to Trigger / Methedex", ChatColor.RED);
                        TUMaths.dm(String.valueOf(in.getMover().getLocation().getBlock().getType()) + " is involved in this error", ChatColor.RED);
                        TUMaths.dm("At Location: " + TUMaths.locationString(in.getMover().getLocation()), ChatColor.RED);
                        TUMaths.dm("===========================================================", ChatColor.RED);
                        e.printStackTrace();
                        TUMaths.dm("===========================================================", ChatColor.RED);
                        return MoveResult.INVALID;
                    }
                }
            }
            boolean soundPlayed = false;
            int n = 2 + this.getGears() * 2;
            if (this.isMotor() && !this.getMotorType().equals((Object)MotorType.BOTH)) {
                boolean bl = true;
            }
            if (in.getType().equals((Object)MoverIOCenter.DeviceIOType.LIFT) && (this.getFacing().equals((Object)BlockFace.UP) || this.getFacing().equals((Object)BlockFace.DOWN))) {
                int n2 = 2;
            }
            block6: for (ItemStack stack : ins) {
                void var9_24;
                if (var9_24 <= 0) break;
                int i = stack.getAmount();
                while (i > 0) {
                    if (var9_24 <= 0 || !out.hasSpace(stack, 1)) continue block6;
                    if (!airIntake) {
                        in.removeStack(stack, 1);
                    }
                    out.addStack(stack, this.beltToggle);
                    if (airIntake) {
                        in.removeStack(stack, 1);
                    }
                    this.beltToggle = !this.beltToggle;
                    --var9_24;
                    if (!soundPlayed) {
                        soundPlayed = true;
                        if (TUMaths.isPlayerNearby(this.getLocation(), 32.0)) {
                            this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_PISTON_EXTEND, 0.1f, 1.0f);
                        }
                    }
                    --i;
                }
            }
            if (soundPlayed) {
                return MoveResult.MOVED_ITEM;
            }
        }
        return MoveResult.NOTHING_MOVED;
    }

    public Location getLocation() {
        if (this.cacheLocation == null) {
            this.cacheLocation = TUMaths.getStringLocation(this.location);
        }
        return this.cacheLocation;
    }

    public Location getInputLocation() {
        if (this.cachedInputLocation != null) {
            return this.cachedInputLocation;
        }
        BlockFace backwardsFace = TUMaths.getOppostieFace(this.getFacing());
        if (this.getFaceMod() != 0) {
            backwardsFace = Mover.getOffsetBlockFace(this.getFacing(), this.getFaceMod());
        }
        this.cachedInputLocation = this.getLocation().getBlock().getRelative(backwardsFace).getLocation();
        return this.cachedInputLocation;
    }

    public Location getOutputLocation(OutDirection out) {
        return this.outDirections.get((Object)out);
    }

    public Location getOutputLocationFront() {
        if (this.cachedOutputLocation != null) {
            return this.cachedOutputLocation;
        }
        BlockFace forwardFace = this.getFacing();
        this.cachedOutputLocation = this.getLocation().getBlock().getRelative(forwardFace).getLocation();
        return this.cachedOutputLocation;
    }

    public Location getOutputLocationLeft() {
        if (this.cachedOutputLocationLeft != null) {
            return this.cachedOutputLocationLeft;
        }
        BlockFace leftFace = TUMaths.rotateBlockFace(this.getFacing(), 270);
        this.cachedOutputLocationLeft = this.getLocation().getBlock().getRelative(leftFace).getLocation();
        return this.cachedOutputLocationLeft;
    }

    public Location getOutputLocationRight() {
        if (this.cachedOutputLocationRight != null) {
            return this.cachedOutputLocationRight;
        }
        BlockFace face = TUMaths.rotateBlockFace(this.getFacing(), 90);
        this.cachedOutputLocationRight = this.getLocation().getBlock().getRelative(face).getLocation();
        return this.cachedOutputLocationRight;
    }

    public Location getOutputDropLocation() {
        if (this.cachedDropLocation != null) {
            return this.cachedDropLocation;
        }
        BlockFace forwardFace = this.getFacing();
        this.cachedDropLocation = this.getLocation().getBlock().getRelative(forwardFace).getLocation().add(0.5, 0.5, 0.5);
        return this.cachedDropLocation;
    }

    public Location getInputPickupLocation() {
        if (this.cachedGrabLocation != null) {
            return this.cachedGrabLocation;
        }
        BlockFace backwardsFace = TUMaths.getOppostieFace(this.getFacing());
        this.cachedGrabLocation = this.getLocation().getBlock().getRelative(backwardsFace).getLocation().add(0.5, 0.5, 0.5);
        return this.cachedGrabLocation;
    }

    public void clearCache() {
        this.cachedFacing = null;
        this.cachedOutputLocation = null;
        this.cachedInputLocation = null;
        this.inType = null;
        this.outType = null;
        this.outs.clear();
    }

    public int getFaceMod() {
        return this.faceMod;
    }

    public void changeFaceMod() {
        ++this.faceMod;
        if (this.faceMod > 5) {
            this.faceMod = 0;
        }
    }

    public static BlockFace getOffsetBlockFace(BlockFace currentFace, int offset) {
        if (offset == 0) {
            return currentFace;
        }
        if (offset < 1 || offset > 5) {
            throw new IllegalArgumentException("Offset must be between 1 and 5");
        }
        int currentIndex = -1;
        int i = 0;
        while (i < cardinalDirections.size()) {
            if (cardinalDirections.get(i) == currentFace) {
                currentIndex = i;
                break;
            }
            ++i;
        }
        if (currentIndex == -1) {
            throw new IllegalArgumentException("Invalid BlockFace provided");
        }
        int newIndex = (currentIndex + offset) % cardinalDirections.size();
        return cardinalDirections.get(newIndex);
    }

    public BlockFace getFacing() {
        BlockFace forwardFace;
        if (this.cachedFacing != null) {
            return this.cachedFacing;
        }
        BlockData blockData = this.getLocation().getBlock().getBlockData();
        if (!(blockData instanceof Directional)) {
            return BlockFace.NORTH;
        }
        Directional dir = (Directional)blockData;
        this.cachedFacing = forwardFace = dir.getFacing();
        return this.cachedFacing;
    }

    public ArrayList<ItemStack> getFilters() {
        if (this.cachedFilters != null) {
            return this.cachedFilters;
        }
        this.buildFilterCache();
        return this.cachedFilters;
    }

    private void buildFilterCache() {
        ArrayList<ItemStack> filters = new ArrayList<ItemStack>();
        this.filterDamaged = false;
        for (String str : this.storedFilters) {
            ItemStack filterStack = TUItems.createStackFromString(str);
            if (filterStack.getType().equals((Object)Material.PAPER) && filterStack.getItemMeta().hasDisplayName() && TUItems.hasLoreLine(filterStack, "Group Filter")) {
                String groupName = ChatColor.stripColor((String)filterStack.getItemMeta().getDisplayName());
                if (!filterGroups.containsKey(groupName)) continue;
                this.filterDamaged = groupName.equals("*Damaged*");
                for (ItemStack groupStack : filterGroups.get(groupName)) {
                    filters.add(groupStack.clone());
                }
                continue;
            }
            filters.add(filterStack);
        }
        this.cachedFilters = filters;
    }

    public boolean hasBeltMotor() {
        return this.motor;
    }

    public ArrayList<Belt> getFullBelt(OutDirection out) {
        if (this.fullBelts == null) {
            this.fullBelts = new HashMap();
        }
        if (!this.fullBelts.containsKey((Object)out)) {
            this.fullBelts.put(out, new ArrayList());
        }
        return new ArrayList<Belt>((Collection)this.fullBelts.get((Object)out));
    }

    public void wipeBelt(OutDirection out) {
        for (Belt belt : this.getFullBelt(out)) {
            belt.setMover(null);
            belt.releaseItems(false);
            belt.clearBelt();
            belt.remove();
        }
    }

    public void stageRebuild(OutDirection out) {
        this.beltRebuilds.add(out);
    }

    public void doRebuild(OutDirection out) {
        this.wipeBelt(out);
        this.fullBelts.get((Object)out).clear();
        this.beltChain.get((Object)out).clear();
        this.removeStairLinks(out);
        if (this.getValidOutDirections().contains((Object)out)) {
            this.buildFullBelt(out);
            this.reattachLooseItems(out);
        }
    }

    public void buildFullBelt(OutDirection out) {
        if (this.getOutputLocation(out) == null) {
            return;
        }
        if (!this.beltChain.containsKey((Object)out)) {
            this.beltChain.put(out, new HashMap());
        }
        this.stairs.put(out, new ArrayList());
        ArrayList<Belt> belts = new ArrayList<Belt>();
        ArrayList<Location> used = new ArrayList<Location>();
        Belt belt = null;
        if (Belt.isDetachedBelt(this.getOutputLocation(out))) {
            belt = Belt.getBelt(this.getOutputLocation(out));
            belt.setMover(this);
            belt.setDirection(this.getFacing());
        } else if (Belt.isCarpet(this.getOutputLocation(out))) {
            belt = Belt.isBelt(this.getOutputLocation(out)) ? Belt.getBelt(this.getOutputLocation(out)) : new Belt(this.getOutputLocation(out), this.getFacing(), this, out);
        }
        if (belt != null) {
            belts.add(belt);
            used.add(belt.getLoc());
            int beltLength = 1;
            Material color = belt.getColor();
            belt = this.getNextBelt(belt, used, color, out);
            while (belt != null) {
                belt.setMover(this);
                used.add(belt.getLoc());
                belts.add(belt);
                if (++beltLength > 100) break;
                belt = this.getNextBelt(belt, used, color, out);
            }
            Belt currentBelt = null;
            for (Belt belt1 : new ArrayList(belts)) {
                if (currentBelt == null) {
                    currentBelt = belt1;
                    continue;
                }
                this.beltChain.get((Object)out).put(currentBelt, belt1);
                belt1.fromBelt = currentBelt;
                currentBelt = belt1;
            }
            if (currentBelt != null) {
                this.beltChain.get((Object)out).put(currentBelt, null);
            }
            this.fullBelts.put(out, belts);
        }
    }

    private Belt getNextBelt(Belt currentBelt, ArrayList<Location> usedLocs, Material color, OutDirection out) {
        BlockFace facing = currentBelt.getDirection();
        BlockFace leftFacing = TUMaths.rotateBlockFace(facing, 90);
        BlockFace rightFacing = TUMaths.rotateBlockFace(facing, 270);
        Block beltBlock = currentBelt.getLoc().getBlock();
        Belt next = this.nextBeltDirection(beltBlock, facing, usedLocs, color, out);
        if (next == null && (next = this.nextBeltDirection(beltBlock, leftFacing, usedLocs, color, out)) == null) {
            next = this.nextBeltDirection(beltBlock, rightFacing, usedLocs, color, out);
        }
        return next;
    }

    public void removeStairLinks(OutDirection out) {
        if (this.stairs == null || this.stairs != null && !this.stairs.containsKey((Object)out)) {
            return;
        }
        for (Location stair : this.stairs.get((Object)out)) {
            linkedStairs.remove(stair);
            linkedStairsOutDirection.remove(stair);
        }
    }

    public ArrayList<Location> getUnderGroundBelts(OutDirection out) {
        if (this.stairs != null) {
            return new ArrayList<Location>((Collection)this.stairs.get((Object)out));
        }
        return new ArrayList<Location>();
    }

    private Belt nextBeltDirection(Block beltBlock, BlockFace facing, ArrayList<Location> usedLocs, Material color, OutDirection out) {
        Belt belt;
        Directional stair1;
        Block from = beltBlock;
        Material foundStair = beltBlock.getRelative(facing).getType();
        if (Tag.STAIRS.isTagged((Keyed)foundStair) && facing.equals((Object)(stair1 = (Directional)beltBlock.getRelative(facing).getBlockData()).getFacing().getOppositeFace())) {
            int i = 2;
            while (i <= maxUngroundBeltRange) {
                Block nextCarpet;
                Directional stair2;
                Block nextStair = beltBlock.getRelative(facing, i);
                if (Tag.STAIRS.isTagged((Keyed)nextStair.getType()) && foundStair.equals((Object)nextStair.getType()) && (stair2 = (Directional)nextStair.getBlockData()).getFacing().equals((Object)facing) && Belt.isCarpet((nextCarpet = beltBlock.getRelative(facing, i + 1)).getLocation()) && !usedLocs.contains(nextCarpet.getLocation()) && nextCarpet.getType().equals((Object)color)) {
                    linkedStairs.put(beltBlock.getRelative(facing).getLocation(), this);
                    linkedStairsOutDirection.put(beltBlock.getRelative(facing).getLocation(), out);
                    this.stairs.get((Object)out).add(beltBlock.getRelative(facing).getLocation());
                    linkedStairs.put(nextStair.getLocation(), this);
                    linkedStairsOutDirection.put(nextStair.getLocation(), out);
                    this.stairs.get((Object)out).add(nextStair.getLocation());
                    if (Belt.isDetachedBelt(nextCarpet.getLocation())) {
                        Belt belt2 = Belt.getBelt(nextCarpet.getLocation());
                        belt2.setDirection(facing);
                        return belt2;
                    }
                    if (Belt.isBelt(nextCarpet.getLocation())) {
                        return Belt.getBelt(nextCarpet.getLocation());
                    }
                    return new Belt(nextCarpet.getLocation(), facing, this, out);
                }
                ++i;
            }
        }
        if (Belt.isCarpet(beltBlock.getRelative(facing).getLocation()) && !usedLocs.contains(beltBlock.getRelative(facing).getLocation()) && beltBlock.getRelative(facing).getType().equals((Object)color)) {
            if (Belt.isDetachedBelt(beltBlock.getRelative(facing).getLocation())) {
                belt = Belt.getBelt(beltBlock.getRelative(facing).getLocation());
                belt.setDirection(facing);
                return belt;
            }
            if (Belt.isBelt(beltBlock.getRelative(facing).getLocation())) {
                return Belt.getBelt(beltBlock.getRelative(facing).getLocation());
            }
            return new Belt(beltBlock.getRelative(facing).getLocation(), facing, this, out);
        }
        if (Belt.isCarpet((beltBlock = beltBlock.getRelative(BlockFace.DOWN)).getRelative(facing).getLocation()) && beltBlock.getRelative(facing).getRelative(BlockFace.UP).getType().equals((Object)Material.AIR) && !usedLocs.contains(beltBlock.getRelative(facing).getLocation()) && beltBlock.getRelative(facing).getType().equals((Object)color)) {
            if (Belt.isDetachedBelt(beltBlock.getRelative(facing).getLocation())) {
                belt = Belt.getBelt(beltBlock.getRelative(facing).getLocation());
                belt.setDirection(facing);
                return belt;
            }
            if (Belt.isBelt(beltBlock.getRelative(facing).getLocation())) {
                return Belt.getBelt(beltBlock.getRelative(facing).getLocation());
            }
            return new Belt(beltBlock.getRelative(facing).getLocation(), facing, this, out);
        }
        if (!Belt.isCarpet((beltBlock = beltBlock.getRelative(BlockFace.UP).getRelative(BlockFace.UP)).getRelative(facing).getLocation()) || !from.getRelative(BlockFace.UP).getType().equals((Object)Material.AIR) || usedLocs.contains(beltBlock.getRelative(facing).getLocation()) || !beltBlock.getRelative(facing).getType().equals((Object)color)) {
            return null;
        }
        if (Belt.isDetachedBelt(beltBlock.getRelative(facing).getLocation())) {
            belt = Belt.getBelt(beltBlock.getRelative(facing).getLocation());
            belt.setDirection(facing);
            return belt;
        }
        if (Belt.isBelt(beltBlock.getRelative(facing).getLocation())) {
            return Belt.getBelt(beltBlock.getRelative(facing).getLocation());
        }
        return new Belt(beltBlock.getRelative(facing).getLocation(), facing, this, out);
    }

    public Belt getLastBelt(OutDirection out) {
        if (this.fullBelts.get((Object)out).size() > 0) {
            return this.fullBelts.get((Object)out).get(this.fullBelts.get((Object)out).size() - 1);
        }
        return null;
    }

    public Belt getFirstBelt(OutDirection out) {
        if (this.fullBelts.get((Object)out).size() > 0) {
            return this.fullBelts.get((Object)out).get(0);
        }
        return null;
    }

    public void addBelt(Belt belt, OutDirection out) {
        this.fullBelts.get((Object)out).add(belt);
    }

    public void moveFullBelt(OutDirection out) {
        Belt belt;
        int i = this.fullBelts.get((Object)out).size() - 1;
        while (i >= 0) {
            belt = this.fullBelts.get((Object)out).get(i);
            belt.attemptMove();
            --i;
        }
        if (this.getFirstBelt(out) != null && MineMain.allowBeltArrows && MinetorioListener.isPlayerNearbyOPT(this.getLocation(), MineMain.beltArrowDistance)) {
            long moveDelay = 20 / (this.getEffectiveDrive() + 1);
            long delay1 = moveDelay - 1L;
            int teleportDuration = (int)(delay1 - 1L);
            Belt.spawnArrow(this.getLocation().clone(), this.getFirstBelt(out).getLocREADONLY(), teleportDuration, this.getArrowColor(), this.getFirstBelt(out));
        }
        if (Lift.liftType.equals((Object)Lift.LiftEntityType.ITEM) || Lift.liftType.equals((Object)Lift.LiftEntityType.DISPLAY) && !Lift.animateLiftMovement) {
            i = this.fullBelts.get((Object)out).size() - 1;
            while (i >= 0) {
                belt = this.fullBelts.get((Object)out).get(i);
                belt.updateDisplay();
                --i;
            }
        }
    }

    public void clearBeltArrows(OutDirection out) {
        for (Belt belt : this.getFullBelt(out)) {
            belt.removeIncomingArrow();
        }
    }

    public int getEffectiveDrive() {
        int drive = this.getOverDrive();
        if (drive > 3) {
            drive = 3;
        }
        return drive;
    }

    public int getOverDrive() {
        return this.overDrive;
    }

    public void setOverDrive(int overDrive) {
        this.arrowColor = null;
        this.overDrive = overDrive;
    }

    public boolean isFilterItem(ItemStack stack) {
        ItemStack compareStack = stack.clone();
        compareStack.setAmount(1);
        TUItems.repairItem(compareStack);
        if (this.getFilters().size() > 0) {
            for (ItemStack item : this.getFilters()) {
                if (!compareStack.isSimilar(item)) continue;
                if (!this.isBlackList()) {
                    if (!this.filterDamaged) {
                        return true;
                    }
                    return TUItems.isDamaged(stack);
                }
                return false;
            }
            return this.isBlackList();
        }
        return !this.isBlackList();
    }

    public boolean hasFilters() {
        if (this.isForwardFilter() && this.isSplitter()) {
            return false;
        }
        return this.getFilters().size() > 0;
    }

    public void removeMover() {
        OutDirection[] outDirectionArray = OutDirection.values();
        int n = outDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OutDirection out = outDirectionArray[n2];
            this.wipeBelt(out);
            ++n2;
        }
        this.removeLinkedDisplay();
        allMovers.remove(this.getLocation());
        this.getFile().delete();
        this.remove();
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public static boolean isMover(ItemStack stack) {
        return stack.getType().equals((Object)Material.DROPPER) && MineItems.isIndustrialItem(stack, "Mover");
    }

    public static ArrayList<Mover> getMovers() {
        return new ArrayList<Mover>(allMovers.values());
    }

    public static ArrayList<Mover> getNearbyMovers(Location loc, int distance) {
        ArrayList<Mover> movers = new ArrayList<Mover>();
        for (Mover mover : Mover.getMovers()) {
            if (TUMaths.getManhattanDistance(loc, mover.getLocation()) > distance) continue;
            movers.add(mover);
        }
        return movers;
    }

    private static void addMover(Mover mover) {
        if (!allMovers.containsKey(mover.getLocation())) {
            allMovers.put(mover.getLocation(), mover);
        } else if (!allMovers.get(mover.getLocation()).equals(mover)) {
            mover.removeMover();
            ++duplicateMovers;
        }
    }

    public static boolean isMover(Location loc) {
        for (Mover mover : Mover.getMovers()) {
            if (!mover.getLocation().equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    public static Mover getMover(Block block) {
        return Mover.getMover(block.getLocation());
    }

    public static Mover getMover(Location loc) {
        for (Mover mover : Mover.getMovers()) {
            if (!mover.getLocation().equals((Object)loc)) continue;
            return mover;
        }
        return null;
    }

    public static boolean fullBeltValidationCheck(Mover mover, OutDirection out) {
        boolean valid = true;
        if (MineUtil.isActive(mover.getLocation())) {
            for (Belt belt : mover.getFullBelt(out)) {
                if (belt.getLoc().getBlock().getType().toString().contains("CARPET")) continue;
                belt.releaseItems(false);
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public void onCreate(boolean isFirstTime) {
        OutDirection out;
        if (this.getMotorType() == null) {
            this.setMotorType(MotorType.BOTH);
        }
        if (this.outs == null) {
            this.outs = new ArrayList();
        }
        this.stairs = new HashMap();
        this.beltChain = new HashMap();
        this.fullBelts = new HashMap();
        this.outDirections = new HashMap();
        OutDirection[] outDirectionArray = OutDirection.values();
        int n = outDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            out = outDirectionArray[n2];
            this.beltChain.put(out, new HashMap());
            ++n2;
        }
        this.beltRebuilds = new HashSet();
        this.outDirections = new HashMap();
        if (this.storedFilters == null) {
            this.storedFilters = new ArrayList();
        }
        if (this.storedLiftStacksLeft == null) {
            this.storedLiftStacksLeft = new HashMap();
        }
        if (this.storedLiftStacksRight == null) {
            this.storedLiftStacksRight = new HashMap();
        }
        if (this.storedBeltStacksLeft == null) {
            this.storedBeltStacksLeft = new HashMap();
        }
        if (this.storedBeltStacksRight == null) {
            this.storedBeltStacksRight = new HashMap();
        }
        if (!isFirstTime) {
            this.validCheck(true);
            if (this.isValidMover(true)) {
                this.buildMoverInfo();
                Mover.addMover(this);
                if (this.hasBeltMotor()) {
                    if (!this.isSplitter()) {
                        this.buildFullBelt(OutDirection.FRONT);
                    } else {
                        outDirectionArray = OutDirection.values();
                        n = outDirectionArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            out = outDirectionArray[n2];
                            this.buildFullBelt(out);
                            ++n2;
                        }
                    }
                }
                outDirectionArray = OutDirection.values();
                n = outDirectionArray.length;
                n2 = 0;
                while (n2 < n) {
                    out = outDirectionArray[n2];
                    this.reattachLooseItems(out);
                    ++n2;
                }
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        Mover.this.compute();
                    }
                }, beltAttachDelay + 1L);
            }
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                Mover.this.setDisplayStackString(SkullCreator.getHead(MineItems.devValueForDevices.get("Mover")));
                Mover.this.handleDisplay();
            }
        }, 1L);
    }

    private void reattachLooseItems(OutDirection out) {
        for (final Belt belt : this.getFullBelt(out)) {
            if (belt.getLeftDisplay() == null) {
                belt.getLeftLocation().getChunk().load();
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        ArrayList ents = (ArrayList)belt.getLeftLocation().getWorld().getNearbyEntities(belt.getLeftLocation(), 0.1, 0.1, 0.1);
                        if (ents.size() != 0 && ((Entity)ents.get(0)).getType().equals((Object)MineMain.version.getItemEntityType())) {
                            Item item = (Item)ents.get(0);
                            ItemStack stack = item.getItemStack().clone();
                            belt.setLeftDisplay(null);
                            belt.setLeftStack(stack);
                            item.remove();
                            belt.updateDisplay();
                        }
                    }
                }, 10L);
            }
            if (belt.getRightDisplay() != null) continue;
            belt.getRightLocation().getChunk().load();
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    ArrayList ents = (ArrayList)belt.getRightLocation().getWorld().getNearbyEntities(belt.getRightLocation(), 0.1, 0.1, 0.1);
                    if (ents.size() != 0 && ((Entity)ents.get(0)).getType().equals((Object)MineMain.version.getItemEntityType())) {
                        Item item = (Item)ents.get(0);
                        ItemStack stack = item.getItemStack().clone();
                        belt.setRightDisplay(null);
                        belt.setRightStack(stack);
                        item.remove();
                        belt.updateDisplay();
                    }
                }
            }, beltAttachDelay);
        }
    }

    public boolean isMotor() {
        return this.motor;
    }

    public void setMotor(boolean motor) {
        this.motor = motor;
        if (!motor) {
            OutDirection[] outDirectionArray = OutDirection.values();
            int n = outDirectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                OutDirection out = outDirectionArray[n2];
                this.wipeBelt(out);
                ++n2;
            }
        }
    }

    public MotorType getMotorType() {
        return this.type;
    }

    public void setMotorType(MotorType type) {
        this.type = type;
    }

    public boolean isBlackList() {
        return this.isBlackList;
    }

    public void setBlackList(boolean isBlackList) {
        this.isBlackList = isBlackList;
    }

    public int getGears() {
        return this.gears;
    }

    public void setGears(int gears) {
        this.gears = gears;
    }

    public Chunk getInChunk() {
        if (this.inChunk != null) {
            return this.inChunk;
        }
        this.inChunk = this.getInputLocation().getChunk();
        return this.inChunk;
    }

    public Chunk getOutChunk(OutDirection out) {
        if (this.outChunk != null) {
            return this.outChunk;
        }
        this.outChunk = this.getOutputLocation(out).getChunk();
        return this.outChunk;
    }

    public static void addGroupFilters(String contains, String name, ArrayList<ItemStack> customItems) {
        ArrayList<String> ores = new ArrayList<String>();
        ores.add(String.valueOf(ChatColor.GREEN) + "Group Filter");
        ores.add(" ");
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int more = 0;
        if (customItems.size() > 0) {
            for (ItemStack stack : customItems) {
                if (ores.size() <= 10) {
                    if (stack.getItemMeta().hasDisplayName()) {
                        ores.add(String.valueOf(ChatColor.WHITE) + "- " + stack.getItemMeta().getDisplayName());
                    } else {
                        ores.add(String.valueOf(ChatColor.WHITE) + "- " + stack.getType().toString());
                    }
                } else {
                    ++more;
                }
                stacks.add(stack);
            }
        }
        if (contains != null) {
            Material[] materialArray = Material.values();
            int n = materialArray.length;
            int n2 = 0;
            while (n2 < n) {
                Material material = materialArray[n2];
                if (material.isItem() && !material.isAir() && material.toString().contains(contains)) {
                    if (ores.size() <= 10) {
                        ores.add(String.valueOf(ChatColor.WHITE) + "- " + String.valueOf(material));
                    } else {
                        ++more;
                    }
                    stacks.add(new ItemStack(material));
                }
                ++n2;
            }
        }
        if (more > 0) {
            ores.add(" ");
            ores.add(String.valueOf(ChatColor.WHITE) + "+ " + more + " more...");
        }
        ItemStack groupStack = TUItems.createItem(Material.PAPER, MineItems.whiteBold() + name, ores);
        filterGroups.put(name, stacks);
        vanillaItems.add(groupStack);
        customItems.clear();
    }

    public static void populateFilterItems() {
        Material material;
        Material[] vanMaterials = Material.values();
        ArrayList<ItemStack> customItems = new ArrayList<ItemStack>();
        Mover.addGroupFilters("RAW_", "*Raw Ores*", customItems);
        customItems.add(new ItemStack(Material.COAL));
        customItems.add(new ItemStack(Material.REDSTONE));
        customItems.add(new ItemStack(Material.EMERALD));
        customItems.add(new ItemStack(Material.LAPIS_LAZULI));
        customItems.add(new ItemStack(Material.DIAMOND));
        Mover.addGroupFilters("RAW_", "*Ore Drops*", customItems);
        Mover.addGroupFilters("_ORE", "*Silktouch Ores*", customItems);
        Mover.addGroupFilters("INGOT", "*Ingots*", customItems);
        customItems.add(MineItems.getIndustrialItem("Copper Cable"));
        customItems.add(MineItems.getIndustrialItem("Copper Plate"));
        customItems.add(MineItems.getIndustrialItem("Iron Plate"));
        customItems.add(MineItems.getIndustrialItem("Electronic Circuit"));
        customItems.add(MineItems.getIndustrialItem("Advanced Circuit"));
        customItems.add(MineItems.getIndustrialItem("Processing Unit"));
        customItems.add(MineItems.getIndustrialItem("Steel Plate"));
        customItems.add(MineItems.getIndustrialItem("Iron Gear Wheel"));
        customItems.add(MineItems.getIndustrialItem("Plastic Bar"));
        customItems.add(MineItems.getIndustrialItem("Sulfur"));
        customItems.add(MineItems.getIndustrialItem("Engine Unit"));
        customItems.add(MineItems.getIndustrialItem("Electric Engine Unit"));
        customItems.add(MineItems.getIndustrialItem("Explosive"));
        customItems.add(MineItems.getIndustrialItem("Micro Battery"));
        customItems.add(MineItems.getIndustrialItem("Flying Robot Frame"));
        customItems.add(MineItems.getIndustrialItem("Low Density Structure"));
        customItems.add(MineItems.getIndustrialItem("Solid Fuel"));
        customItems.add(MineItems.getIndustrialItem("Rocket Parts"));
        customItems.add(MineItems.getIndustrialItem("Rocket Fuel"));
        Mover.addGroupFilters(null, "*Components*", customItems);
        for (ItemStack stack : ItemMenu.getAllItems()) {
            if (!MineItems.isDeviceItem(stack)) continue;
            customItems.add(stack);
        }
        Mover.addGroupFilters(null, "*Devices*", customItems);
        customItems.add(MineItems.getIndustrialItem("Automation Science Pack"));
        customItems.add(MineItems.getIndustrialItem("Logistic Science Pack"));
        customItems.add(MineItems.getIndustrialItem("Military Science Pack"));
        customItems.add(MineItems.getIndustrialItem("Chemical Science Pack"));
        customItems.add(MineItems.getIndustrialItem("Utility Science Pack"));
        customItems.add(MineItems.getIndustrialItem("Space Science Pack"));
        Mover.addGroupFilters(null, "*Science Packs*", customItems);
        Mover.addGroupFilters("_SEEDS", "*Seeds*", customItems);
        customItems.add(new ItemStack(Material.WHEAT));
        customItems.add(new ItemStack(Material.POTATO));
        customItems.add(new ItemStack(Material.CARROT));
        customItems.add(new ItemStack(Material.SWEET_BERRIES));
        customItems.add(new ItemStack(Material.MELON));
        customItems.add(new ItemStack(Material.BEETROOT));
        customItems.add(new ItemStack(Material.PUMPKIN));
        customItems.add(new ItemStack(Material.SUGAR_CANE));
        customItems.add(new ItemStack(Material.CACTUS));
        customItems.add(new ItemStack(Material.NETHER_WART));
        customItems.add(new ItemStack(Material.COCOA_BEANS));
        Mover.addGroupFilters(null, "*Crop Products*", customItems);
        customItems.add(new ItemStack(Material.ANDESITE));
        customItems.add(new ItemStack(Material.GRANITE));
        customItems.add(new ItemStack(Material.DIORITE));
        customItems.add(new ItemStack(Material.POLISHED_ANDESITE));
        customItems.add(new ItemStack(Material.POLISHED_GRANITE));
        customItems.add(new ItemStack(Material.POLISHED_DIORITE));
        customItems.add(new ItemStack(Material.ANDESITE_WALL));
        customItems.add(new ItemStack(Material.GRANITE_WALL));
        customItems.add(new ItemStack(Material.DIORITE_WALL));
        Mover.addGroupFilters(null, "*Pipe Material*", customItems);
        Material[] materialArray = vanMaterials;
        int n = vanMaterials.length;
        int n2 = 0;
        while (n2 < n) {
            material = materialArray[n2];
            if (Tag.WOOL.isTagged((Keyed)material)) {
                customItems.add(new ItemStack(material));
            }
            ++n2;
        }
        Mover.addGroupFilters("_CARPET", "*Conveyor Materials*", customItems);
        Mover.addGroupFilters("_LOG", "*Logs*", customItems);
        Mover.addGroupFilters("_PLANK", "*Planks*", customItems);
        Mover.addGroupFilters(null, "*Damaged*", customItems);
        Mover.addGroupFilters("_PICKAXE", "*Pickaxes*", customItems);
        Mover.addGroupFilters("_HOE", "*Hoes*", customItems);
        Mover.addGroupFilters("_AXE", "*Axes*", customItems);
        Mover.addGroupFilters("_SWORD", "*Swords*", customItems);
        materialArray = vanMaterials;
        n = vanMaterials.length;
        n2 = 0;
        while (n2 < n) {
            material = materialArray[n2];
            if (material.isItem() && !material.isAir() && (material.toString().contains("_SWORD") || material.toString().contains("_AXE") || material.toString().contains("_PICKAXE") || material.toString().contains("_HOE") || material.toString().contains("_SHOVEL") || material.equals((Object)Material.SHIELD) || material.equals((Object)Material.BOW) || material.equals((Object)Material.CROSSBOW))) {
                customItems.add(new ItemStack(material));
            }
            ++n2;
        }
        Mover.addGroupFilters(null, "*Tools*", customItems);
        materialArray = vanMaterials;
        n = vanMaterials.length;
        n2 = 0;
        while (n2 < n) {
            material = materialArray[n2];
            if (material.isItem() && !material.isAir() && (Tag.ITEMS_ARROWS.isTagged((Keyed)material) || material.equals((Object)Material.BOW) || material.equals((Object)Material.CROSSBOW))) {
                customItems.add(new ItemStack(material));
            }
            ++n2;
        }
        Mover.addGroupFilters(null, "*Bow & Arrows*", customItems);
        materialArray = vanMaterials;
        n = vanMaterials.length;
        n2 = 0;
        while (n2 < n) {
            material = materialArray[n2];
            if (material.isItem() && !material.isAir() && (Tag.ITEMS_HEAD_ARMOR.isTagged((Keyed)material) || Tag.ITEMS_CHEST_ARMOR.isTagged((Keyed)material) || Tag.ITEMS_FOOT_ARMOR.isTagged((Keyed)material) || Tag.ITEMS_LEG_ARMOR.isTagged((Keyed)material))) {
                customItems.add(new ItemStack(material));
            }
            ++n2;
        }
        Mover.addGroupFilters(null, "*Armor*", customItems);
        materialArray = vanMaterials;
        n = vanMaterials.length;
        n2 = 0;
        while (n2 < n) {
            material = materialArray[n2];
            if (TUItems.isRaw(material)) {
                customItems.add(new ItemStack(material));
            }
            ++n2;
        }
        Mover.addGroupFilters(null, "*Uncooked Food*", customItems);
        materialArray = vanMaterials;
        n = vanMaterials.length;
        n2 = 0;
        while (n2 < n) {
            material = materialArray[n2];
            if (TUItems.isRaw(material)) {
                customItems.add(new ItemStack(material));
            }
            ++n2;
        }
        Mover.addGroupFilters("COOKED_", "*Cooked Food*", customItems);
        materialArray = vanMaterials;
        n = vanMaterials.length;
        n2 = 0;
        while (n2 < n) {
            material = materialArray[n2];
            if (material.isEdible()) {
                customItems.add(new ItemStack(material));
            }
            ++n2;
        }
        Mover.addGroupFilters(null, "*Edibles*", customItems);
        materialArray = vanMaterials;
        n = vanMaterials.length;
        n2 = 0;
        while (n2 < n) {
            material = materialArray[n2];
            if (TUItems.isRaw(material)) {
                customItems.add(new ItemStack(material));
            }
            ++n2;
        }
        for (ItemStack mitem : ItemMenu.getAllItems()) {
            vanillaItems.add(mitem);
        }
        materialArray = vanMaterials;
        n = vanMaterials.length;
        int n3 = 0;
        while (n3 < n) {
            material = materialArray[n3];
            if (material.isItem() && !material.isAir()) {
                vanillaItems.add(new ItemStack(material));
            }
            ++n3;
        }
    }

    private ArrayList<ItemStack> getDeviceMods() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<String> modLore = new ArrayList<String>();
        for (String str : MineUtil.wrapText("A repeater above makes all carpet in front of the mover turn into a conveyor belt. Which it will dispense items from its input onto the first belt.", 45)) {
            modLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        stacks.add(TUItems.createItem(Material.REPEATER, MineItems.whiteBold() + "Motorized Mover", modLore));
        modLore.clear();
        for (String str : MineUtil.wrapText("A lever above makes the mover grab/dispense on both sides of a belt.", 45)) {
            modLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        stacks.add(TUItems.createItem(Material.LEVER, MineItems.whiteBold() + "Override Mover", modLore));
        modLore.clear();
        for (String str : MineUtil.wrapText("A comparator above will make the mover only take from its input if it is full.", 45)) {
            modLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        stacks.add(TUItems.createItem(Material.COMPARATOR, MineItems.whiteBold() + "Overflow Mover", modLore));
        modLore.clear();
        for (String str : MineUtil.wrapText("A heavy weighted pressure plate above will make the mover drop items in front of it if its air and it will pickup items behind it if there is air behind it.", 45)) {
            modLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        stacks.add(TUItems.createItem(Material.HEAVY_WEIGHTED_PRESSURE_PLATE, MineItems.whiteBold() + "Ground Mover", modLore));
        modLore.clear();
        for (String str : MineUtil.wrapText("Using any button above a mover will allow the mover to output beyond its normal stack limit.", 45)) {
            modLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        stacks.add(TUItems.createItem(Material.STONE_BUTTON, MineItems.whiteBold() + "Stack Override", modLore));
        modLore.clear();
        for (String str : MineUtil.wrapText("Unlike other modifiers, this one can only be done here. This will allow the mover to become a splitter. This will allow the mover to output in its normal direction but also left and right of it. In the event that this mover is a Motor, it can create three belts.", 45)) {
            modLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        if (this.isSplitter()) {
            modLore.add(" ");
            modLore.add(String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + " Mod Active");
        }
        stacks.add(TUItems.createItem(Material.GOLD_BLOCK, MineItems.whiteBold() + "Splitter Modification", modLore));
        modLore.clear();
        for (String str : MineUtil.wrapText("This will only work if the Splitter Modification is enabled. This will make the mover output items out the front only if they match the items in the filters. All other items will be output to the left and right sides. Movers will lose the ability to filter their inputs when using this. This can be inverted if using a blacklist.", 45)) {
            modLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        if (this.isForwardFilter()) {
            modLore.add(" ");
            modLore.add(String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + " Mod Active");
        }
        stacks.add(TUItems.createItem(Material.IRON_BLOCK, MineItems.whiteBold() + "Forward Modification", modLore));
        return stacks;
    }

    public void openMoverScreen(Player player) {
        ItemStack pane = MainMenu.createGoldPane();
        HashMap stacks = new HashMap();
        class LeaderScroller
        extends TUInterfaceScrolling {
            ArrayList<ItemStack> vanillaItems2;
            private ViewType viewType;
            public String lookup;
            private final /* synthetic */ HashMap val$stacks;
            private final /* synthetic */ ItemStack val$pane;

            public LeaderScroller(String name, int rows, HashMap hashMap, ItemStack itemStack) {
                this.val$stacks = hashMap;
                this.val$pane = itemStack;
                super(name, rows);
                this.vanillaItems2 = new ArrayList<ItemStack>(vanillaItems);
                this.viewType = ViewType.VIEW_FILTERS;
                this.lookup = null;
            }

            @Override
            public ItemStack defineScrolling(int i) {
                ItemStack stack;
                if (this.viewType.equals((Object)ViewType.VIEW_FILTERS) && Mover.this.storedFilters.size() > i) {
                    String filter = Mover.this.storedFilters.get(i);
                    ItemStack stack2 = TUItems.createStackFromString(filter);
                    this.val$stacks.put(stack2, filter);
                    return stack2;
                }
                if (this.viewType.equals((Object)ViewType.ADD_FILTERS) && this.vanillaItems2.size() > i && !Mover.this.storedFilters.contains(TUItems.createStackString(stack = this.vanillaItems2.get(i)))) {
                    return stack;
                }
                if (this.viewType.equals((Object)ViewType.MODS) && Mover.this.getDeviceMods().size() > i) {
                    return Mover.this.getDeviceMods().get(i);
                }
                return null;
            }

            @Override
            public void scrollingActionClick(Player player, ItemStack item, InventoryClickEvent event) {
                String filter;
                if (this.viewType.equals((Object)ViewType.VIEW_FILTERS) && (filter = (String)this.val$stacks.get(item)) != null) {
                    player.playSound(player.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 0.4f, 1.0f);
                    Mover.this.storedFilters.remove(filter);
                    this.updateDataSet();
                    this.updateScrolling();
                }
                if (this.viewType.equals((Object)ViewType.ADD_FILTERS)) {
                    ItemStack clicked = item.clone();
                    clicked.setAmount(1);
                    Mover.this.storedFilters.add(TUItems.createStackString(clicked));
                    player.playSound(player.getLocation(), Sound.ENTITY_CHICKEN_EGG, 0.4f, 1.0f);
                    this.updateDataSet();
                    this.updateScrolling();
                }
                if (this.viewType.equals((Object)ViewType.MODS)) {
                    Material upType = Mover.this.getLocation().getBlock().getRelative(BlockFace.UP).getType();
                    boolean isModType = false;
                    for (ItemStack stack : Mover.this.getDeviceMods()) {
                        if (!upType.equals((Object)stack.getType())) continue;
                        isModType = true;
                        break;
                    }
                    if (upType.isAir() || isModType) {
                        OutDirection out;
                        ItemStack vanillaType = new ItemStack(item.getType());
                        if (vanillaType.getType().equals((Object)Material.GOLD_BLOCK)) {
                            Mover.this.setSplitter(!Mover.this.isSplitter());
                            if (Mover.this.isSplitter()) {
                                MineUtil.sendWarning(player, "The mover is now a splitter.");
                            } else {
                                MineUtil.sendWarning(player, "The mover is no longer a splitter.");
                            }
                            OutDirection[] outDirectionArray = OutDirection.values();
                            int n = outDirectionArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                out = outDirectionArray[n2];
                                Mover.this.stageRebuild(out);
                                ++n2;
                            }
                            this.updateScrolling();
                            Mover.this.buildMoverInfo();
                            return;
                        }
                        if (vanillaType.getType().equals((Object)Material.IRON_BLOCK)) {
                            Mover.this.setForwardFilter(!Mover.this.isForwardFilter());
                            if (Mover.this.isForwardFilter()) {
                                MineUtil.sendWarning(player, "The mover is now using forward filters.");
                            } else {
                                MineUtil.sendWarning(player, "The mover is no longer using forward filters.");
                            }
                            OutDirection[] outDirectionArray = OutDirection.values();
                            int n = outDirectionArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                out = outDirectionArray[n3];
                                Mover.this.stageRebuild(out);
                                ++n3;
                            }
                            this.updateScrolling();
                            Mover.this.buildMoverInfo();
                            return;
                        }
                        if (TUMaths.hasStackAmount((Inventory)player.getInventory(), vanillaType, 1)) {
                            Block block;
                            BlockData blockData;
                            TUMaths.removeStackAmount((Inventory)player.getInventory(), vanillaType, 1);
                            if (isModType) {
                                Mover.this.getLocation().getBlock().getRelative(BlockFace.UP).breakNaturally();
                            }
                            Mover.this.getLocation().getBlock().getRelative(BlockFace.UP).setType(item.getType());
                            if ((item.getType().equals((Object)Material.LEVER) || Tag.BUTTONS.isTagged((Keyed)item.getType())) && (blockData = (block = Mover.this.getLocation().getBlock().getRelative(BlockFace.UP)).getBlockData()) instanceof FaceAttachable) {
                                FaceAttachable attach = (FaceAttachable)blockData;
                                attach.setAttachedFace(FaceAttachable.AttachedFace.FLOOR);
                                block.setBlockData((BlockData)attach);
                            }
                            Mover.this.buildMoverInfo();
                            player.playSound(player.getLocation(), Sound.ENTITY_CHICKEN_EGG, 0.4f, 1.0f);
                        } else {
                            MineUtil.sendWarning(player, "You need to have at a " + item.getType().toString() + " to do this.");
                        }
                    } else {
                        MineUtil.sendWarning(player, "The block above this mover needs to be air or a mover modifier type.");
                    }
                }
            }

            @Override
            public void playerInventoryClick(Player player, ItemStack item, InventoryClickEvent event) {
                if (this.viewType.equals((Object)ViewType.VIEW_FILTERS) || this.viewType.equals((Object)ViewType.ADD_FILTERS)) {
                    ItemStack clickedStack = item.clone();
                    clickedStack.setAmount(1);
                    String stackString = TUItems.createStackString(clickedStack);
                    if (!Mover.this.storedFilters.contains(stackString)) {
                        Mover.this.storedFilters.add(stackString);
                    }
                    this.updateDataSet();
                    this.updateScrolling();
                    event.setCancelled(true);
                    player.playSound(player.getLocation(), Sound.ENTITY_CHICKEN_EGG, 0.4f, 1.0f);
                }
            }

            @Override
            public void onClose(Player player, InventoryCloseEvent event) {
                Mover.this.buildFilterCache();
            }

            public void clearSelected() {
                int i = 0;
                while (i < 9) {
                    if (this.getComponent(i) != null) {
                        TUIComponent comp = this.getComponent(i);
                        ItemStack stack = comp.getLinkedStack();
                        stack.removeEnchantments();
                        comp.setLinkedStack(stack);
                        comp.createItemStack();
                    }
                    ++i;
                }
            }

            public void updateDataSet() {
                this.vanillaItems2 = new ArrayList<ItemStack>(vanillaItems);
                for (ItemStack stack : new ArrayList<ItemStack>(this.vanillaItems2)) {
                    String itemSTR = TUItems.createStackString(stack);
                    if (Mover.this.storedFilters.contains(itemSTR)) {
                        this.vanillaItems2.remove(stack);
                        continue;
                    }
                    if (this.lookup == null) continue;
                    String target = stack.getType().toString().toLowerCase();
                    if (stack.getItemMeta().hasDisplayName()) {
                        target = stack.getItemMeta().getDisplayName().toLowerCase();
                    }
                    if (target.contains(this.lookup)) continue;
                    this.vanillaItems2.remove(stack);
                }
            }

            public ItemStack createLookupIcon() {
                String looking = this.lookup;
                if (looking == null) {
                    looking = "None";
                }
                ArrayList<String> lookupLore = TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Set Lookup"), MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Clear Lookup"), " ");
                for (String str : MineUtil.wrapText("If you change this from none, items will require what you enter in its name. Searching dirt, will for example show dirt and coarse dirt. You can find any item quickly this way.", 45)) {
                    lookupLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
                }
                return TUItems.createItem(Material.SPYGLASS, MineItems.whiteBold() + "Lookup >> " + looking, lookupLore);
            }

            public ItemStack createListTypeIcon() {
                Material listType = Material.WHITE_CONCRETE;
                String type = "Whitelist";
                if (Mover.this.isBlackList()) {
                    type = "Blacklist";
                    listType = Material.BLACK_CONCRETE;
                }
                ArrayList<String> lookupLore = TUItems.basicLore(MineUtil.colon(" Filter Type", type), MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Toggle Type"), " ");
                for (String str : MineUtil.wrapText("You can change the filter type of the mover by clicking this, note that you need at least 1 filter in order for this either type to apply.", 45)) {
                    lookupLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
                }
                return TUItems.createItem(listType, MineItems.whiteBold() + "Filter Type", lookupLore);
            }

            public ItemStack createMoverGearsIcon() {
                ArrayList<String> lookupLore = TUItems.basicLore(MineUtil.colon(" Gears", Mover.this.getGears() + "/8"), " ");
                for (String str : MineUtil.wrapText("Mover gears allow movers to transfer items to their outputs much faster, however mover gears do not apply to belt outputs. A Mover that inputs from one chest to another with 8 mover gears, will move 18 items per second.", 45)) {
                    lookupLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
                }
                ItemStack stack = TUItems.createItem(Material.GOLD_NUGGET, MineItems.whiteBold() + "Mover Gears", lookupLore);
                if (Mover.this.getGears() - 1 > 0) {
                    stack.setAmount(Mover.this.getGears());
                }
                return stack;
            }

            public void updateLookupIcon() {
                TUIComponent comp = this.getComponent(49);
                if (this.viewType.equals((Object)ViewType.ADD_FILTERS)) {
                    comp.setLinkedStack(this.createLookupIcon());
                    comp.createItemStack();
                } else {
                    comp.setLinkedStack(this.val$pane);
                    comp.createItemStack();
                }
            }
        }
        LeaderScroller face = new LeaderScroller(ChatColor.GOLD + ChatColor.BOLD + "Mover Settings", 6, stacks, pane);
        face.updateDataSet();
        int i = 9;
        while (i < 18) {
            face.addComponent(new TUIComponent(i, pane));
            ++i;
        }
        i = 45;
        while (i <= 53) {
            if (i != 47 && i != 51 && i != 49) {
                face.addComponent(new TUIComponent(i, pane));
            }
            ++i;
        }
        ArrayList<Integer> scrollingSlots = new ArrayList<Integer>();
        int j = 18;
        while (j <= 44) {
            scrollingSlots.add(j);
            ++j;
        }
        face.setScrollingSlots(scrollingSlots);
        ArrayList<String> addLore = new ArrayList<String>();
        for (String str : MineUtil.wrapText("You can add filters from the list in here, you can also add items by clicking on them in your inventory. Minetorio items will always appear first in the list.", 45)) {
            addLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        ArrayList<String> viewLore = new ArrayList<String>();
        for (String str : MineUtil.wrapText("You can remove filters from the list in here.", 45)) {
            viewLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        ItemStack filterStack = TUItems.createItem(Material.HOPPER, MineItems.whiteBold() + "View/Remove Filters", viewLore);
        TUMaths.addGlow(filterStack);
        ArrayList<String> modLore = new ArrayList<String>();
        for (String str : MineUtil.wrapText("You can use this section to modifier the movers function, this can be done without this menu, but is handy for knowing what options are available.", 45)) {
            modLore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        ItemStack modStack = TUItems.createItem(Material.REPEATER, MineItems.whiteBold() + "Manage Modifier", modLore);
        ItemStack addFilterStack = TUItems.createItem(Material.GREEN_CONCRETE, MineItems.whiteBold() + "Add Filters", addLore);
        class FilterButton
        extends TUIComponent {
            private final /* synthetic */ LeaderScroller val$face;

            public FilterButton(int slot, ItemStack linkStack, LeaderScroller leaderScroller) {
                this.val$face = leaderScroller;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.val$face.viewType = ViewType.VIEW_FILTERS;
                this.val$face.setPage(0);
                this.val$face.updateScrolling();
                this.val$face.clearSelected();
                this.val$face.updateLookupIcon();
                this.setLinkedStack(TUMaths.addGlow(this.getLinkedStack()));
                this.createItemStack();
            }
        }
        FilterButton filterComp = new FilterButton(2, filterStack, face);
        class TypeButton
        extends TUIComponent {
            private final /* synthetic */ LeaderScroller val$face;

            public TypeButton(int slot, ItemStack linkStack, LeaderScroller leaderScroller) {
                this.val$face = leaderScroller;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.val$face.viewType = ViewType.MODS;
                this.val$face.setPage(0);
                this.val$face.updateScrolling();
                this.val$face.clearSelected();
                this.val$face.updateLookupIcon();
                this.setLinkedStack(TUMaths.addGlow(this.getLinkedStack()));
                this.createItemStack();
            }
        }
        TypeButton typeComp = new TypeButton(4, modStack, face);
        class AddButton
        extends TUIComponent {
            private final /* synthetic */ LeaderScroller val$face;

            public AddButton(int slot, ItemStack linkStack, LeaderScroller leaderScroller) {
                this.val$face = leaderScroller;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.val$face.viewType = ViewType.ADD_FILTERS;
                this.val$face.setPage(0);
                this.val$face.updateScrolling();
                this.val$face.clearSelected();
                this.val$face.updateLookupIcon();
                this.setLinkedStack(TUMaths.addGlow(this.getLinkedStack()));
                this.createItemStack();
            }
        }
        AddButton addFilterComp = new AddButton(0, addFilterStack, face);
        class AllowDenyButton
        extends TUIComponent {
            private final /* synthetic */ LeaderScroller val$face;

            public AllowDenyButton(int slot, ItemStack linkStack, LeaderScroller leaderScroller) {
                this.val$face = leaderScroller;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                Mover.this.setBlackList(!Mover.this.isBlackList());
                this.setLinkedStack(this.val$face.createListTypeIcon());
                this.createItemStack();
                player.playSound(player.getLocation(), Sound.BLOCK_CHISELED_BOOKSHELF_PLACE, 0.4f, 1.0f);
            }
        }
        AllowDenyButton filterTypeComp = new AllowDenyButton(6, face.createListTypeIcon(), face);
        class LookupButton
        extends TUIComponent {
            private final /* synthetic */ LeaderScroller val$face;

            public LookupButton(int slot, ItemStack linkStack, LeaderScroller leaderScroller) {
                this.val$face = leaderScroller;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                if (!this.val$face.viewType.equals((Object)ViewType.ADD_FILTERS)) {
                    return;
                }
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                player.closeInventory();
                class ChatInput
                extends com.MT.triggersUtility.ChatInput {
                    private final /* synthetic */ LeaderScroller val$face;
                    private final /* synthetic */ Player val$player;

                    public ChatInput(String startMessage, boolean numbersonly, LeaderScroller leaderScroller, Player player) {
                        this.val$face = leaderScroller;
                        this.val$player = player;
                        super(startMessage, numbersonly);
                    }

                    @Override
                    public void inputAction(String message) {
                        this.val$face.lookup = message.toLowerCase();
                        this.val$face.updateDataSet();
                        this.val$face.openInterface(this.val$player);
                        this.val$face.updateScrolling();
                        this.setLinkedStack(this.val$face.createLookupIcon());
                        this.createItemStack();
                    }
                }
                ChatInput input = new ChatInput("Enter what you want to lookup in chat now. EX DIRT, IRON", false, this.val$face, player);
                input.start(player);
            }

            @Override
            public void onRightClick(Player player) {
                if (!this.val$face.viewType.equals((Object)ViewType.ADD_FILTERS)) {
                    return;
                }
                this.val$face.lookup = null;
                this.val$face.updateDataSet();
                this.val$face.updateScrolling();
                this.setLinkedStack(this.val$face.createLookupIcon());
                this.createItemStack();
            }
        }
        LookupButton lookupComp = new LookupButton(49, face.createLookupIcon(), face);
        TUIComponent leftScroller = MineUtil.createLeftScroll(47);
        TUIComponent rightScroller = MineUtil.createRightScroll(51);
        face.addComponent(new TUIComponent(8, face.createMoverGearsIcon()));
        face.addComponent(filterTypeComp);
        face.addComponent(lookupComp);
        face.addComponent(addFilterComp);
        face.addComponent(filterComp);
        face.addComponent(typeComp);
        face.addComponent(leftScroller);
        face.addComponent(rightScroller);
        face.setLeftComp(leftScroller);
        face.setRightComp(rightScroller);
        face.updateScrolling();
        face.updateLookupIcon();
        face.openInterface(player);
    }

    public boolean isLiftMover() {
        return this.fenceFacing && (this.getFacing().equals((Object)BlockFace.UP) || this.getFacing().equals((Object)BlockFace.DOWN));
    }

    public void rebuildLift() {
        HashMap liftAttachStacks = new HashMap();
        if (this.lifts != null) {
            boolean releasing = false;
            for (Lift lift : this.lifts) {
                if (!lift.getLocation().getBlock().getType().toString().contains("FENCE")) {
                    releasing = true;
                }
                if (releasing) {
                    lift.releaseItems(false);
                } else {
                    ItemStack rightStack;
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    ItemStack leftStack = lift.getLeftStack();
                    if (leftStack == null && lift.leftTransit != null && !lift.leftTransit.isDead()) {
                        leftStack = lift.leftTransit.getItemStack();
                    }
                    if ((rightStack = lift.getRightStack()) == null && lift.rightTransit != null && !lift.rightTransit.isDead()) {
                        rightStack = lift.rightTransit.getItemStack();
                    }
                    stacks.add(leftStack);
                    stacks.add(rightStack);
                    liftAttachStacks.put(lift.getLocation(), stacks);
                }
                lift.removeLift();
            }
        }
        this.lifts = new ArrayList();
        this.liftLength = 0;
        Location nextLift = this.getLocation().clone();
        int i = 1;
        while (i < maxLift) {
            Location above = nextLift.clone();
            above = this.getFacing().equals((Object)BlockFace.UP) ? above.add(0.0, (double)i, 0.0) : above.add(0.0, (double)(i * -1), 0.0);
            if (!above.getBlock().getType().toString().contains("FENCE")) break;
            Lift lift = new Lift(this, above);
            if (liftAttachStacks.containsKey(lift.getLocation())) {
                ArrayList stacks = (ArrayList)liftAttachStacks.get(lift.getLocation());
                lift.setLeftStack((ItemStack)stacks.get(0));
                lift.setRightStack((ItemStack)stacks.get(1));
                lift.updateDisplay();
            }
            this.lifts.add(lift);
            ++i;
        }
        this.liftLength = this.lifts.size();
        Directional dir = (Directional)this.getLocation().getBlock().getBlockData();
        this.liftDirection = dir.getFacing();
        this.loadLiftStacks();
    }

    public void moveLift() {
        if (this.lifts == null) {
            return;
        }
        int size = this.lifts.size();
        if (size <= 1) {
            return;
        }
        ArrayList<Lift> lifts = new ArrayList<Lift>(this.lifts);
        int i = size - 1;
        while (i > 0) {
            Lift fromLift = lifts.get(i - 1);
            Lift toLift = lifts.get(i);
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.DISPLAY)) {
                if (Lift.animateLiftMovement) {
                    this.visuallyMoveLift(fromLift, toLift);
                } else {
                    this.physicalLiftMove(fromLift, toLift);
                }
            }
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.ITEM)) {
                this.physicalLiftMove(fromLift, toLift);
            }
            --i;
        }
    }

    private void visuallyMoveLift(final Lift fromLift, final Lift toLift) {
        if (Lift.liftType.equals((Object)Lift.LiftEntityType.DISPLAY)) {
            ItemStack rightStack;
            final ItemStack leftStack = fromLift.getLeftStack();
            boolean trySound = false;
            long moveDelay = 20 / (this.getEffectiveDrive() + 1);
            long delay1 = moveDelay - 1L;
            long delay2 = delay1 + 2L;
            int teleportDuration = (int)(delay1 - 1L);
            if (leftStack != null && toLift.getLeftStack() == null) {
                trySound = true;
                final ItemDisplay display = (ItemDisplay)fromLift.getLeftLocation().getWorld().spawn(fromLift.getLeftLocation(), ItemDisplay.class);
                MineUtil.setDisposableEntity((Entity)display);
                display.setItemStack(leftStack);
                display.setTransformation(Lift.getDisplayScale(display, leftStack));
                display.setTeleportDuration(teleportDuration);
                fromLift.setLeftStackNoRemoval(null);
                fromLift.updateDisplay();
                fromLift.leftTransit = display;
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        display.teleport(toLift.getLeftLocation());
                        fromLift.removeLeftItem();
                    }
                }, 1L);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        if (fromLift.leftTransit != null) {
                            toLift.setLeftStack(leftStack);
                        }
                        toLift.updateDisplay();
                        fromLift.leftTransit = null;
                    }
                }, delay1);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        display.remove();
                    }
                }, delay2);
            }
            if ((rightStack = fromLift.getRightStack()) != null && toLift.getRightStack() == null) {
                trySound = true;
                final ItemDisplay display = (ItemDisplay)fromLift.getRightLocation().getWorld().spawn(fromLift.getRightLocation(), ItemDisplay.class);
                MineUtil.setDisposableEntity((Entity)display);
                display.setItemStack(rightStack);
                display.setTransformation(Lift.getDisplayScale(display, rightStack));
                display.setTeleportDuration(teleportDuration);
                fromLift.setRightStackNoRemoval(null);
                fromLift.updateDisplay();
                fromLift.rightTransit = display;
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        display.teleport(toLift.getRightLocation());
                        fromLift.removeRightItem();
                    }
                }, 1L);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        if (fromLift.rightTransit != null) {
                            toLift.setRightStack(rightStack);
                        }
                        toLift.updateDisplay();
                        fromLift.rightTransit = null;
                    }
                }, delay1);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        display.remove();
                    }
                }, delay2);
            }
            if (trySound) {
                this.playLiftSound(fromLift.getLocation());
            }
        }
    }

    private void physicalLiftMove(Lift fromLift, Lift toLift) {
        boolean moved = false;
        if (fromLift.getLeftStack() != null && toLift.getLeftStack() == null) {
            toLift.setLeftStack(fromLift.getLeftStack());
            fromLift.setLeftStack(null);
            moved = true;
        }
        if (fromLift.getRightStack() != null && toLift.getRightStack() == null) {
            toLift.setRightStack(fromLift.getRightStack());
            fromLift.setRightStack(null);
            moved = true;
        }
        if (moved) {
            fromLift.updateDisplay();
            toLift.updateDisplay();
            this.playLiftSound(fromLift.getLocation());
        }
    }

    private void playLiftSound(Location loc) {
        if (!TUMaths.isPlayerNearby(loc, MineMain.farDistance)) {
            return;
        }
        loc.getWorld().playSound(loc, Sound.ENTITY_GUARDIAN_ATTACK, 0.03f, 2.0f);
    }

    private void saveLiftStacks() {
        for (Lift lift : this.lifts) {
            String locString = TUMaths.locationString(lift.getLocation());
            if (lift.getLeftStack() != null) {
                this.storedLiftStacksLeft.put(locString, TUItems.createStackString(lift.getLeftStack()));
            }
            if (lift.getRightStack() == null) continue;
            this.storedLiftStacksRight.put(locString, TUItems.createStackString(lift.getRightStack()));
        }
    }

    private void loadLiftStacks() {
        for (Lift lift : this.lifts) {
            for (Entity entity : lift.getLocation().getWorld().getNearbyEntities(lift.getLocation(), 2.0, 2.0, 2.0)) {
                if (!entity.getType().equals((Object)EntityType.ITEM) && !entity.getType().equals((Object)EntityType.ITEM_DISPLAY) || !entity.getPersistentDataContainer().has(Device.iconStackKey) || entity.hasMetadata("MT-LIFTDISPLAY")) continue;
                entity.remove();
            }
        }
        for (Lift lift : this.lifts) {
            String locString = TUMaths.locationString(lift.getLocation());
            if (locString != null && this.storedLiftStacksLeft.containsKey(locString)) {
                lift.setLeftStack(TUItems.createStackFromString(this.storedLiftStacksLeft.get(locString)));
            }
            if (locString != null && this.storedLiftStacksRight.containsKey(locString)) {
                lift.setRightStack(TUItems.createStackFromString(this.storedLiftStacksRight.get(locString)));
            }
            lift.updateDisplay();
        }
        this.storedLiftStacksLeft.clear();
        this.storedLiftStacksRight.clear();
    }

    public void saveBeltStacks() {
        OutDirection[] outDirectionArray = OutDirection.values();
        int n = outDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OutDirection out = outDirectionArray[n2];
            for (Belt belt : this.getFullBelt(out)) {
                String locString = TUMaths.locationString(belt.getLoc());
                if (belt.getLeftStack() != null) {
                    this.storedBeltStacksLeft.put(locString, TUItems.createStackString(belt.getLeftStack()));
                }
                if (belt.getRightStack() == null) continue;
                this.storedBeltStacksRight.put(locString, TUItems.createStackString(belt.getRightStack()));
            }
            ++n2;
        }
    }

    private void loadBeltStacks() {
        OutDirection[] outDirectionArray = OutDirection.values();
        int n = outDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OutDirection out = outDirectionArray[n2];
            for (Belt belt : this.getFullBelt(out)) {
                for (Entity entity : belt.getLoc().getWorld().getNearbyEntities(belt.getLoc(), 2.0, 2.0, 2.0)) {
                    if (!entity.getType().equals((Object)EntityType.ITEM) && !entity.getType().equals((Object)EntityType.ITEM_DISPLAY) || !entity.getPersistentDataContainer().has(Device.iconStackKey) || entity.hasMetadata("MT-BELTDISPLAY")) continue;
                    entity.remove();
                }
            }
            for (Belt belt : this.getFullBelt(out)) {
                String locString = TUMaths.locationString(belt.getLoc());
                if (locString != null && this.storedBeltStacksLeft.containsKey(locString)) {
                    belt.setLeftStack(TUItems.createStackFromString(this.storedBeltStacksLeft.get(locString)));
                }
                if (locString != null && this.storedBeltStacksRight.containsKey(locString)) {
                    belt.setRightStack(TUItems.createStackFromString(this.storedBeltStacksRight.get(locString)));
                }
                belt.updateDisplay();
            }
            this.storedBeltStacksLeft.clear();
            this.storedBeltStacksRight.clear();
            ++n2;
        }
    }

    @Override
    public void onSave() {
        if (this.lifts != null && this.lifts.size() > 0) {
            this.saveLiftStacks();
        }
        boolean saveBelts = false;
        OutDirection[] outDirectionArray = OutDirection.values();
        int n = outDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OutDirection out = outDirectionArray[n2];
            if (this.getFullBelt(out).size() > 0) {
                saveBelts = true;
                break;
            }
            ++n2;
        }
        if (saveBelts) {
            this.saveBeltStacks();
        }
    }

    public Lift getLift(Location loc) {
        if (this.lifts == null) {
            return null;
        }
        for (Lift lift : this.lifts) {
            if (!lift.getLocation().equals((Object)loc)) continue;
            return lift;
        }
        return null;
    }

    public static void updateLifts() {
        for (final Mover mover : allMovers.values()) {
            if (!mover.isLiftMover()) continue;
            mover.moveLift();
            long delay = 20 / (mover.getEffectiveDrive() + 1);
            int i = 0;
            while (i < mover.getEffectiveDrive()) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        mover.moveLift();
                    }
                }, delay * (long)(i + 1));
                ++i;
            }
        }
    }

    public static void updateMotors() {
        ArrayList<Mover> movers = Mover.getMovers();
        for (final Mover mover : movers) {
            if (!mover.hasBeltMotor()) continue;
            OutDirection[] outDirectionArray = OutDirection.values();
            int n = outDirectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                final OutDirection out = outDirectionArray[n2];
                if (mover.getFullBelt(out).size() == 0) {
                    if (mover.getOutputLocation(out) != null) {
                        if (Belt.isBelt(mover.getOutputLocation(out))) {
                            if (Belt.isDetachedBelt(mover.getOutputLocation(out))) {
                                mover.stageRebuild(out);
                            }
                        } else if (TUMaths.isPlayerNearby(mover.getOutputLocation(out), MineMain.distantDistance) || !mover.forcedCarpet) {
                            mover.forcedCarpet = true;
                            if (Belt.isCarpet(mover.getOutputLocation(out))) {
                                mover.stageRebuild(out);
                            }
                        }
                    }
                } else if (Mover.fullBeltValidationCheck(mover, out)) {
                    mover.moveFullBelt(out);
                    long delay = 20 / (mover.getEffectiveDrive() + 1);
                    int i = 0;
                    while (i < mover.getEffectiveDrive()) {
                        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                mover.moveFullBelt(out);
                            }
                        }, delay * (long)(i + 1));
                        ++i;
                    }
                } else {
                    mover.stageRebuild(out);
                }
                ++n2;
            }
        }
    }

    public BlockData getArrowColor() {
        if (this.arrowColor != null) {
            return this.arrowColor;
        }
        if (this.getEffectiveDrive() == 1) {
            this.arrowColor = Material.RED_CONCRETE.createBlockData();
            return this.arrowColor;
        }
        if (this.getEffectiveDrive() == 2) {
            this.arrowColor = Material.BLUE_CONCRETE.createBlockData();
            return this.arrowColor;
        }
        if (this.getEffectiveDrive() == 3) {
            this.arrowColor = Material.GREEN_CONCRETE.createBlockData();
            return this.arrowColor;
        }
        this.arrowColor = Material.YELLOW_CONCRETE.createBlockData();
        return this.arrowColor;
    }

    public boolean isSplitter() {
        return this.isSplitter;
    }

    public void setSplitter(boolean isSplitter) {
        this.isSplitter = isSplitter;
    }

    public Location getDisplayLocation() {
        return this.getLocation().clone().add(0.5, 1.002, 0.5);
    }

    public void handleDisplay() {
        if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.chunkViewDistance)) {
            this.spawnLinkedDisplay();
        } else {
            this.removeLinkedDisplay();
        }
    }

    public void spawnLinkedDisplay() {
        if (this.linkedDisplay == null && !this.isRemoved()) {
            ItemStack displayStack = this.getDisplayStack();
            if (displayStack == null) {
                return;
            }
            double rand = TUMaths.rollRange(0.001, 1.0E-5);
            Location loc = this.getDisplayLocation().add(0.0, -0.025 + rand, 0.0);
            this.rotateDisplay(loc);
            ItemDisplay display = (ItemDisplay)loc.getWorld().spawn(loc, ItemDisplay.class);
            MineUtil.setDisposableEntity((Entity)display);
            Transformation form = display.getTransformation();
            form.getScale().set(1.91 + rand, 1.91 + rand, 1.91 + rand);
            display.setTransformation(form);
            display.setBrightness(new Display.Brightness(15, 15));
            if (this.tempDisplayStack == null) {
                display.setItemStack(this.getDisplayStack());
            } else {
                display.setItemStack(this.tempDisplayStack);
            }
            this.linkedDisplay = display;
        }
    }

    public void rotateDisplay(Location loc) {
        if (this.getLocation().getBlock().getBlockData() instanceof Directional) {
            int rotateAmount = this.displayRotationOffset;
            if (this.getFacing().equals((Object)BlockFace.UP)) {
                loc.setPitch(90.0f);
                loc.add(0.0, -0.49, 0.48);
                return;
            }
            if (this.getFacing().equals((Object)BlockFace.DOWN)) {
                loc.setPitch(-90.0f);
                loc.add(0.0, -0.49, -0.48);
                return;
            }
            if (this.getFacing().equals((Object)BlockFace.EAST)) {
                rotateAmount += 90;
            }
            if (this.getFacing().equals((Object)BlockFace.SOUTH)) {
                rotateAmount += 180;
            }
            if (this.getFacing().equals((Object)BlockFace.WEST)) {
                rotateAmount += 270;
            }
            loc.setYaw((float)rotateAmount);
        }
    }

    public void removeLinkedDisplay() {
        if (this.linkedDisplay != null) {
            this.linkedDisplay.remove();
            this.linkedDisplay = null;
        }
    }

    public String getDisplayStackString() {
        return this.displayStackString;
    }

    public void setDisplayStackString(ItemStack stack) {
        this.displayStackString = TUItems.createStackString(stack);
    }

    public ItemStack getDisplayStack() {
        if (this.getDisplayStackString() != null) {
            return TUItems.createStackFromString(this.getDisplayStackString(), true);
        }
        return null;
    }

    public void updateDisplayStack(ItemStack stack) {
        this.tempDisplayStack = stack;
        if (this.linkedDisplay != null) {
            this.linkedDisplay.setItemStack(stack);
        }
    }

    public boolean isForwardFilter() {
        return this.isForwardFilter;
    }

    public void setForwardFilter(boolean isForwardFilter) {
        this.isForwardFilter = isForwardFilter;
    }

    public void setFilters(ArrayList<String> storedFilters) {
        this.storedFilters = storedFilters;
        this.clearCache();
        this.buildFilterCache();
    }

    public ArrayList<String> getFilterStrings() {
        return this.storedFilters;
    }

    public static enum MotorType {
        BOTH,
        LEFT,
        RIGHT,
        ALTERNATE;

    }

    public static enum MoveResult {
        MOVED_ITEM,
        INVALID,
        NOTHING_MOVED;

    }

    public static enum OutDirection {
        FRONT,
        LEFT,
        RIGHT;

    }

    private static enum ViewType {
        VIEW_FILTERS,
        ADD_FILTERS,
        MODS;

    }
}

