/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Directional;

public class OverDriver
extends Device {
    private static final long serialVersionUID = -3929401797254451315L;
    private transient Mover connectedMover = null;
    private transient Device connectedDevice;
    private transient Mover mover;
    private transient boolean firstMoverCheckDone = false;

    public OverDriver(Location loc) {
        super(loc);
        this.setMaterial("DISPENSER");
        this.deviceName = "Overdriver";
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(0);
        this.setIdlePower(1);
        this.setActionPower(1);
        this.setStoreForm(false);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int i = 0;
        while (i < 9) {
            slots.add(i);
            ++i;
        }
        this.setClickableSlots(slots);
        this.setPollutionGen(5);
    }

    private Mover getConnectedMover() {
        if (this.mover != null) {
            if (!this.mover.isRemoved()) {
                return this.mover;
            }
            this.mover = null;
        }
        if (!this.firstMoverCheckDone || MinetorioListener.isPlayerNearby2DOPT(this.getLocationREADONLY(), 32.0)) {
            Directional dis;
            Location moverLoc;
            Mover potMover;
            this.firstMoverCheckDone = true;
            Block block = this.getLocation().getBlock();
            if (block.getType().equals((Object)Material.DISPENSER) && block.getBlockData() instanceof Directional && (potMover = Mover.getMover(moverLoc = block.getRelative((dis = (Directional)block.getBlockData()).getFacing()).getLocation())) != null) {
                this.mover = potMover;
                return this.mover;
            }
        }
        return null;
    }

    private Device getConnectedDevice() {
        Directional dis;
        Block block = this.getLocation().getBlock();
        Location deviceLocation = block.getRelative((dis = (Directional)block.getBlockData()).getFacing()).getLocation();
        if (Device.isDevice(deviceLocation)) {
            Device device = Device.getDevice(deviceLocation);
            return device;
        }
        return null;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This should be placed facing into a mover with a motor.");
        lore.add("- Doing so will overdrive it. This will increase belt speed.");
        lore.add("- A mover can be overdriven by 3 overdrivers max.");
        lore.add("- Some devices can be overdriven too");
        return lore;
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void cleanup() {
        if (this.connectedMover != null) {
            this.connectedMover.setOverDrive(this.connectedMover.getOverDrive() - 1);
            this.connectedMover = null;
        }
        if (this.connectedDevice != null) {
            this.connectedDevice.setOverDrive(this.connectedDevice.getOverDrive() - 1);
            this.connectedDevice = null;
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getGrid().hasPower(this.getActionPower())) {
                this.getGrid().consumePower(this, this.getActionPower());
                this.setConsumingPower(true);
                this.overDriveMover();
                this.overDriveDevice();
            } else {
                if (this.connectedMover != null) {
                    this.connectedMover.setOverDrive(this.connectedMover.getOverDrive() - 1);
                    this.connectedMover = null;
                }
                if (this.connectedDevice != null) {
                    this.connectedDevice.setOverDrive(this.connectedDevice.getOverDrive() - 1);
                    this.connectedDevice = null;
                }
            }
        }
    }

    private void overDriveMover() {
        if (this.connectedMover == null) {
            Mover mover = this.getConnectedMover();
            if (mover != null) {
                this.connectedMover = mover;
                this.connectedMover.setOverDrive(mover.getOverDrive() + 1);
            }
        } else if (this.connectedMover.isRemoved()) {
            this.connectedMover = null;
        }
    }

    private void overDriveDevice() {
        Device device = this.getConnectedDevice();
        if (this.connectedDevice == null) {
            if (device != null) {
                this.connectedDevice = device;
                this.connectedDevice.setOverDrive(device.getOverDrive() + 1);
            }
        } else if (this.connectedDevice.isRemoved()) {
            this.connectedDevice = null;
        }
    }
}

