/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class AutoPlucker
extends Device {
    private static final long serialVersionUID = 2271974070728037017L;
    private transient Item item = null;

    public AutoPlucker(Location loc) {
        super(loc);
        this.setMaterial("POLISHED_DIORITE_SLAB");
        this.deviceName = "Auto Plucker";
        this.setActionTimer(2);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.useAutoSlots();
        this.setPollutionGen(5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will pluck feathers from nearby chickens.");
        lore.add("- Each chicken can be plucked every 30 seconds.");
        lore.add("- This only works while animals are loaded nearby.");
        lore.add("- Range is limited to a 10x10x10 area.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.FEATHER, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance);
            boolean playerVeryNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance);
            if (!playerNear) {
                return;
            }
            boolean hasAnimals = false;
            boolean plucked = false;
            for (final Entity entity : MineUtil.getEntitiesInCubeRange(this.getLocation(), 5.0)) {
                if (!entity.getType().equals((Object)EntityType.CHICKEN)) continue;
                hasAnimals = true;
                if (entity.hasMetadata("Plucked")) continue;
                entity.setMetadata("Plucked", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)true));
                plucked = true;
                playSound = true;
                this.getInventory().setItem(this.getOutputSlot(), new ItemStack(Material.FEATHER));
                this.logItem(new ItemStack(Material.FEATHER));
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        entity.removeMetadata("Plucked", MineMain.getPlugin());
                    }
                }, 600L);
                break;
            }
            if (playSound && playerVeryNear) {
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_CHICKEN_EGG, 0.5f, 1.2f);
            }
            if (!hasAnimals) {
                this.setFailReason("No chickens");
                this.spawnInactiveParticles();
            } else if (!plucked) {
                this.setFailReason("Chickens on cooldown");
                this.spawnInactiveParticles();
            }
        }
    }
}

