/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Spaceship;

import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class Thruster
extends Device {
    private static final long serialVersionUID = 3830649527439803504L;
    private static String classSpacedNamed = "Thruster";
    private int hydrogen = 0;

    public Thruster(Location loc) {
        super(loc);
        this.setMaterial("DISPENSER");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(2);
        this.setActionPower(2);
        this.setUseUI(true);
        this.useAutoSlots();
        this.useAutoUI();
        this.setDeviceCrowding(true);
        this.crowdingDistance = 3;
        if (loc != null) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Directional directional;
                    BlockData data = Thruster.this.getLocation().getBlock().getBlockData();
                    if (data instanceof Directional && (directional = (Directional)data).getFaces().contains(BlockFace.SOUTH)) {
                        directional.setFacing(BlockFace.SOUTH);
                        Thruster.this.getLocation().getBlock().setBlockData((BlockData)directional);
                    }
                }
            }, 1L);
        }
        this.updateDeviceHeadItem();
        this.displayLockedHorizontal = true;
        this.lockRotation = true;
        this.displayRotationOffset = 180;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Used to propel connected spaceships.");
        lore.add("- Will always face south when placed.");
        lore.add("- Will damage and break blocks in south direction.");
        lore.add("- In a 3x3x10 area!");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ItemStack stack = this.createInfoIcon();
        TUItems.addLore(stack, MineUtil.colon(" Hydrogen", "" + this.hydrogen));
        this.getInventory().setItem(13, stack);
    }

    @Override
    public void action() {
        ItemStack stack;
        if (this.getGrid() == null) {
            return;
        }
        if (this.getOutputSlot() == -1) {
            this.setFailReason("Missing output slot");
            return;
        }
        if (this.hydrogen <= 900 && (stack = this.getInputStack(MineItems.getGasCanister(Planet.Gas.HYDROGEN))) != null) {
            this.hydrogen += 100;
            stack.setAmount(stack.getAmount() - 1);
            this.getInventory().setItem(this.getOutputSlot(), MineItems.getIndustrialItem("Empty Gas Canister"));
            if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 6.0)) {
                this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.ENTITY_BREEZE_IDLE_AIR, 0.5f, 0.5f);
            }
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, Thruster.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new Thruster(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Low Density Structure", 5));
        ings.add(MineItems.getIndustrialItem("Electric Engine Unit", 3));
        ings.add(MineItems.getIndustrialItem("Processing Unit"));
        RecipeUtils.addDefaultRecipe(new Thruster(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 3;
    }

    public boolean provideThurst() {
        if (this.hydrogen > 10) {
            this.hydrogen -= 5;
            this.thrusterEffects();
            if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 10.0)) {
                this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.BLOCK_SMOKER_SMOKE, 2.0f, 0.5f);
            }
            return true;
        }
        return false;
    }

    private void thrusterEffects() {
        if (!MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 32.0)) {
            return;
        }
        for (Block block : this.getBlocksInFacingArea(this.getLocation().add(0.0, 0.0, 1.0), BlockFace.SOUTH)) {
            if (block.getType().isAir()) continue;
            block.breakNaturally();
            block.getWorld().playSound(block.getLocation(), Sound.ENTITY_GENERIC_EXTINGUISH_FIRE, 0.5f, 1.0f);
        }
        int z = 3;
        while (z < 10) {
            for (Entity entity : this.getLocationREADONLY().getWorld().getNearbyEntities(this.getLocation().add(0.5, 0.0, (double)z + 0.5), 2.0, 2.0, 2.0)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity lent = (LivingEntity)entity;
                lent.setFireTicks(80);
            }
            z += 3;
        }
        this.spawnHorizontalConeParticles(this.getLocation().add(0.5, 0.5, 11.5), 10, 1.5, 30, true);
    }

    private List<Block> getBlocksInFacingArea(Location origin, BlockFace facing) {
        ArrayList<Block> result = new ArrayList<Block>();
        World world = origin.getWorld();
        if (world == null) {
            return result;
        }
        Vector dir = facing.getDirection();
        Vector right = switch (facing) {
            case BlockFace.NORTH, BlockFace.SOUTH -> new Vector(1, 0, 0);
            case BlockFace.EAST, BlockFace.WEST -> new Vector(0, 0, 1);
            case BlockFace.UP, BlockFace.DOWN -> new Vector(1, 0, 0);
            default -> new Vector(1, 0, 0);
        };
        Vector up = new Vector(0, 1, 0);
        int forward = 0;
        while (forward < 10) {
            int x = -1;
            while (x <= 1) {
                int y = -1;
                while (y <= 1) {
                    Vector offset = dir.clone().multiply(forward).add(right.clone().multiply(x)).add(up.clone().multiply(y));
                    Location checkLoc = origin.clone().add(offset);
                    Block block = checkLoc.getBlock();
                    result.add(block);
                    ++y;
                }
                ++x;
            }
            ++forward;
        }
        return result;
    }

    public void spawnHorizontalConeParticles(final Location origin, int length, double maxRadius, int density, boolean isCircular) {
        final World world = origin.getWorld();
        if (world == null) {
            return;
        }
        Vector direction = new Vector(0, 0, -1);
        Vector perpendicular = new Vector(1, 0, 0);
        int total = 0;
        int i = 0;
        while (i <= length) {
            double progress = (double)i / (double)length;
            double radius = maxRadius * progress;
            ++total;
            int ringDensity = (int)((double)density * ((double)(i + 1) * 0.1));
            int j = 0;
            while (j < ringDensity) {
                double angle = Math.PI * 2 * (double)j / (double)ringDensity;
                double xOffset = radius * Math.cos(angle);
                double yOffset = radius * Math.sin(angle);
                if (!isCircular) {
                    yOffset *= 0.5;
                }
                final Vector offset = direction.clone().multiply(i).add(perpendicular.clone().multiply(xOffset)).add(new Vector(0.0, yOffset, 0.0));
                Particle particle = Particle.FLAME;
                if (i > 8) {
                    particle = Particle.SOUL_FIRE_FLAME;
                }
                final Particle fParticle = particle;
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        world.spawnParticle(fParticle, origin.clone().add(offset), 1, 0.0, 0.0, 0.1, 0.0);
                    }
                }, (long)(length - total) * 2L);
                ++j;
            }
            ++i;
        }
    }
}

