/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.API.RocketLaunchEvent;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.ShipCore;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PlayerData;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class RocketSilo
extends Device {
    private static final long serialVersionUID = -3929419111254171315L;
    private static String classSpacedNamed = "Rocket Silo";
    private String linkedShip = null;
    private boolean rocketSpawned = false;
    private int cooldown = 0;
    private static ArrayList<BlockDisplay> rocketRemovalEntities = new ArrayList();

    public RocketSilo(Location loc) {
        super(loc);
        this.setMaterial("SMITHING_TABLE");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(0);
        this.setActionPower(0);
        this.setUseUI(true);
        this.useAutoSlots();
        this.setDeviceCrowding(true);
    }

    @Override
    public int getGridScore() {
        return 10;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Sends rockets into space!");
        lore.add("- Requires a 5x5 launch pad of solid blocks.");
        lore.add("- Launch pad must be directly above the device.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ItemStack infoStack = TUItems.createItem(Material.REDSTONE_LAMP, MineItems.whiteBold() + "Device Information", new ArrayList<String>());
        ArrayList<String> lore = new ArrayList<String>();
        boolean solid = this.isReady("Solid");
        boolean clear = this.isReady("Clear");
        boolean parts = this.isReady("Parts");
        boolean fuel = this.isReady("Fuel");
        lore.add(" ");
        lore.add("  " + MineItems.whiteBold() + "Launch Checklist");
        lore.add("   " + this.getIcon(solid) + " Launch Pad Solid");
        lore.add("   " + this.getIcon(clear) + " Launch Pad Clear");
        lore.add("   " + this.getIcon(parts) + " Rocket Parts Ready");
        lore.add("   " + this.getIcon(fuel) + " Rocket Fuel Ready");
        lore.add("   " + this.getIcon(this.rocketSpawned) + " Rocket Spawned");
        lore.add(" ");
        lore.add("  " + MineItems.whiteBold() + "Launch Diagnostics");
        int rockets = this.getRocketParts();
        ChatColor color = ChatColor.YELLOW;
        if (rockets == 0) {
            color = ChatColor.RED;
        }
        if (rockets >= 100) {
            color = ChatColor.GREEN;
        }
        lore.add(MineUtil.colon(String.valueOf(ChatColor.WHITE) + "   Rocket Parts", String.valueOf(color) + rockets + "/100"));
        int fuelParts = this.getRocketFuel();
        color = ChatColor.YELLOW;
        if (fuelParts == 0) {
            color = ChatColor.RED;
        }
        if (fuelParts >= 100) {
            color = ChatColor.GREEN;
        }
        lore.add(MineUtil.colon(String.valueOf(ChatColor.WHITE) + "   Rocket Fuel", String.valueOf(color) + fuelParts + "/100"));
        if (this.getLastCrowding() > 0) {
            for (String str : MineUtil.wrapText("Rocket Silo has another Rocket Silo nearby, all other silos must be 10 blocks away!", 45, ChatColor.YELLOW)) {
                lore.add(String.valueOf(ChatColor.YELLOW) + "   " + str);
            }
            lore.add(" ");
        }
        if (!this.hasFoundation()) {
            for (String str : MineUtil.wrapText("A launch pad requires a 5x5 of solid blocks directly above this device.", 45, ChatColor.YELLOW)) {
                lore.add(String.valueOf(ChatColor.YELLOW) + "   " + str);
            }
            lore.add(" ");
        }
        if (this.cooldown > 0) {
            for (String str : MineUtil.wrapText("Must wait " + this.cooldown + "s to launch another rocket, launch pad needs to cool off!", 45, ChatColor.YELLOW)) {
                lore.add(String.valueOf(ChatColor.YELLOW) + "   " + str);
            }
            lore.add(" ");
        }
        lore.add(" ");
        lore.add("  " + MineItems.whiteBold() + "Launch Results");
        boolean canCreate = this.getCoreStack() != null && this.linkedShip == null;
        lore.add("   " + this.getIcon(canCreate) + " Create New Space Ship");
        lore.add("   " + this.getIcon(ShipCore.getCoreByName(this.linkedShip) != null || canCreate) + " Travel to Space Ship");
        boolean lastSpace = false;
        if (!this.hasClearence()) {
            for (String str : MineUtil.wrapText("A launch pad must have no blocks above any of its launch pad blocks! (5x5 Pad)", 45, ChatColor.YELLOW)) {
                lore.add(String.valueOf(ChatColor.YELLOW) + "   " + str);
            }
            lore.add(" ");
            lastSpace = true;
        }
        if (!this.rocketSpawned) {
            if (!lastSpace) {
                lore.add(" ");
            }
            if (!(solid && clear && parts && fuel)) {
                for (String str : MineUtil.wrapText("Once all other checklist items are complete a rocket can be spawned by left clicking this item.", 45, ChatColor.YELLOW)) {
                    lore.add(String.valueOf(ChatColor.YELLOW) + "   " + str);
                }
            } else {
                lore.add(String.valueOf(ChatColor.YELLOW) + "   -> Click to spawn rocket.");
            }
        }
        if (solid && clear && parts && fuel && this.rocketSpawned && this.cooldown <= 0) {
            lore.add(" ");
            lore.add(MineItems.yellowBold() + "  Awaiting redstone launch signal, power an adjacent redstone wire.");
            lore.add(MineItems.yellowBold() + "  Caution when launching rocket! It will damage nearby entities!");
            lore.add(MineItems.yellowBold() + "  Launch pad will damage entities near it for 30 seconds from the heat!");
        }
        TUItems.addLore(infoStack, lore);
        infoStack = TUItems.setModelData(infoStack, 9525);
        this.inv.setItem(12, infoStack);
        ArrayList<String> lLore = new ArrayList<String>();
        lLore.add(" ");
        lLore.add("  " + MineItems.whiteBold() + "Selectable Targets");
        if (this.linkedShip == null) {
            lLore.add(String.valueOf(ChatColor.WHITE) + "  >> None (Create New Ship)");
        } else {
            lLore.add(String.valueOf(ChatColor.WHITE) + "  None (Create New Ship)");
        }
        boolean foundLinkedShip = false;
        ArrayList<ShipCore> cores = ShipCore.getCores(this.getPlacerUUID(), this.getLocation());
        for (ShipCore sc : cores) {
            if (this.linkedShip == null) {
                lLore.add(String.valueOf(ChatColor.WHITE) + "  " + sc.getShipName());
                continue;
            }
            if (sc.getShipName().equals(this.linkedShip)) {
                foundLinkedShip = true;
                lLore.add(String.valueOf(ChatColor.WHITE) + "  >> " + sc.getShipName());
                continue;
            }
            lLore.add(String.valueOf(ChatColor.WHITE) + "  " + sc.getShipName());
        }
        if (this.linkedShip != null && !foundLinkedShip) {
            lLore.add(String.valueOf(ChatColor.RED) + "  >> " + this.linkedShip + " (Missing Ship)");
        }
        if (cores.size() > 0) {
            lLore.add(" ");
            lLore.add(String.valueOf(ChatColor.YELLOW) + "  -> Click to change target");
        }
        ItemStack lStack = TUItems.createItem(Material.TARGET, MineItems.whiteBold() + "Desired Target", lLore);
        this.inv.setItem(14, lStack);
        this.inv.setItem(13, this.inv.getItem(9));
    }

    private String getIcon(boolean bool) {
        if (!bool) {
            return MineItems.xMark;
        }
        return MineItems.checkMark;
    }

    private boolean isReady(String what) {
        if (what.equals("Solid")) {
            return this.hasFoundation();
        }
        if (what.equals("Clear")) {
            return this.hasClearence();
        }
        if (what.equals("Parts")) {
            return this.getRocketParts() >= 100;
        }
        if (what.equals("Fuel")) {
            return this.getRocketFuel() >= 100;
        }
        return false;
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
    }

    @Override
    public void action() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.rocketSpawned && TUMaths.isPlayerNearby(this.getLocation(), 32.0) && this.cooldown <= 0 && this.isNearbyRedstonePowered(this.getLocation()) && this.isReady("Solid") && this.isReady("Clear") && this.isReady("Parts") && this.isReady("Fuel")) {
            TUMaths.removeStackAmount(this.getInventory(), MineItems.getIndustrialItem("Rocket Parts"), 100);
            TUMaths.removeStackAmount(this.getInventory(), MineItems.getIndustrialItem("Rocket Fuel"), 100);
            this.createNewShip();
            this.launchRocket(this.getRocketEntities());
            this.travelToShip();
            this.rocketSpawned = false;
        }
    }

    public void createNewShip() {
        if (this.linkedShip != null) {
            return;
        }
        ItemStack stack = this.getCoreStack();
        if (stack != null) {
            stack.setAmount(stack.getAmount() - 1);
            Location spaceLoc = new Location(Bukkit.getWorld((String)"MT_world_space"), (double)(ShipCore.lastX += 600), 100.0, 0.0);
            ShipCore core = new ShipCore(spaceLoc, this.getLocation());
            this.linkedShip = core.getShipName();
            int x = -2;
            while (x <= 2) {
                int z = -2;
                while (z <= 2) {
                    Location loc = new Location(spaceLoc.getWorld(), spaceLoc.getX() + (double)x, 99.0, spaceLoc.getZ() - (double)z);
                    loc.getBlock().setType(Material.SMOOTH_STONE);
                    ++z;
                }
                ++x;
            }
            core.setPlacerUUID(this.getPlacerUUIDString());
            core.compute();
            return;
        }
    }

    public ItemStack getCoreStack() {
        for (ItemStack stack : this.getInputItems()) {
            if (!MineItems.isIndustrialItem(stack, "Ship Core")) continue;
            return stack;
        }
        return null;
    }

    public void travelToShip() {
        PlayerData pd = null;
        if (this.getPlacerUUID() != null) {
            pd = PlayerData.getPlayerData(this.getPlacerUUID().toString());
        }
        if (this.linkedShip == null) {
            return;
        }
        ShipCore core = ShipCore.getCoreByName(this.linkedShip);
        if (core != null) {
            for (Player player : this.getLocationREADONLY().getWorld().getPlayers()) {
                if (!(player.getLocation().distanceSquared(this.getLocationREADONLY()) <= 50.0)) continue;
                if (MineMain.sharedRocketLaunch) {
                    if (pd == null || !pd.isShared(player.getUniqueId()) && !this.getPlacerUUID().equals(player.getUniqueId())) continue;
                    player.teleport(core.getLocation().add(0.0, 1.0, 0.0));
                    continue;
                }
                player.teleport(core.getLocation().add(0.0, 1.0, 0.0));
            }
        }
    }

    @Override
    public void onDeviceRemove() {
        this.removeRocketEntity();
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.isLeftClick() && event.getSlot() == 12 && this.cooldown <= 0) {
            if (this.getLastCrowding() > 0) {
                MineUtil.sendWarning((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("Rocket_Silo_Close"));
                return;
            }
            boolean solid = this.isReady("Solid");
            boolean clear = this.isReady("Clear");
            boolean parts = this.isReady("Parts");
            boolean fuel = this.isReady("Fuel");
            if (!this.rocketSpawned) {
                if (solid && clear && parts && fuel) {
                    ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
                    int x = this.getLocation().getBlockX();
                    int y = this.getLocation().getBlockY() + 2;
                    int z = this.getLocation().getBlockZ();
                    String exePart = "execute in " + this.getLocationREADONLY().getWorld().getKey().toString() + " run ";
                    String summonCommand = "summon block_display " + x + " " + y + " " + z + " {Passengers:[{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:iron_block\",Properties:{}},transformation:[0.25f,0f,0f,-1f,0f,7.8406f,0f,0.875f,0f,0f,2f,-1f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:iron_block\",Properties:{}},transformation:[0.25f,0f,0f,0.75f,0f,7.8406f,0f,0.875f,0f,0f,2f,-1f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:iron_block\",Properties:{}},transformation:[0f,0f,-1.5f,0.75f,0f,7.8406f,0f,0.875f,0.25f,0f,0f,-1f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:iron_block\",Properties:{}},transformation:[0f,0f,-1.5f,0.75f,0f,7.8406f,0f,0.875f,0.25f,0f,0f,0.75f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:black_shulker_box\",Properties:{}},transformation:[1f,0f,0f,-2f,0f,1.7578f,0f,0.125f,0f,0f,1.7712f,-0.885f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:orange_concrete\",Properties:{}},transformation:[1.4142f,-0.7071f,0f,-0.9375f,1.4142f,0.7071f,0f,3.6875f,0f,0f,1.2f,-0.6f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:gray_concrete\",Properties:{}},transformation:[0f,-1f,0f,-0.64f,3f,0f,0f,1.375f,0f,0f,1.25f,-0.625f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:black_concrete\",Properties:{}},transformation:[1.125f,0f,0f,-2.0625f,0f,0.4395f,0f,0f,0f,0f,1.85f,-0.93f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:black_shulker_box\",Properties:{}},transformation:[1f,0f,0f,0.9767f,0f,1.7578f,0f,0.125f,0f,0f,1.7712f,-0.885f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:orange_concrete\",Properties:{}},transformation:[1.4142f,0.7071f,0f,-0.5f,-1.4142f,0.7071f,0f,5.1017f,0f,0f,1.2f,-0.6f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:gray_concrete\",Properties:{}},transformation:[0f,1f,0f,0.6167f,-3f,0f,0f,4.375f,0f,0f,1.25f,-0.625f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:black_concrete\",Properties:{}},transformation:[1.125f,0f,0f,0.9142f,0f,0.4395f,0f,0f,0f,0f,1.85f,-0.93f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:black_shulker_box\",Properties:{}},transformation:[0f,0f,-1.7712f,0.8925f,0f,1.7578f,0f,0.125f,1f,0f,0f,-2f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:orange_concrete\",Properties:{}},transformation:[0f,0f,-1.2f,0.6075f,1.4142f,0.7071f,0f,3.6875f,1.4142f,-0.7071f,0f,-0.9375f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:gray_concrete\",Properties:{}},transformation:[0f,0f,-1.25f,0.6325f,3f,0f,0f,1.375f,0f,-1f,0f,-0.64f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:black_concrete\",Properties:{}},transformation:[0f,0f,-1.85f,0.9375f,0f,0.4395f,0f,0f,1.125f,0f,0f,-2.0625f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:black_shulker_box\",Properties:{}},transformation:[0f,0f,1.7712f,-0.8925f,0f,1.7578f,0f,0.125f,-1f,0f,0f,1.9375f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:orange_concrete\",Properties:{}},transformation:[0f,0f,1.2f,-0.6075f,1.4142f,0.7071f,0f,3.6875f,-1.4142f,0.7071f,0f,0.875f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:gray_concrete\",Properties:{}},transformation:[0f,0f,1.25f,-0.6325f,3f,0f,0f,1.375f,0f,1f,0f,0.5775f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:black_concrete\",Properties:{}},transformation:[0f,0f,1.85f,-0.9375f,0f,0.4395f,0f,0f,-1.125f,0f,0f,2f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:orange_concrete\",Properties:{}},transformation:[2f,0f,0f,-1f,0f,0.42f,0f,8.71f,0f,0f,2f,-1f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:iron_block\",Properties:{}},transformation:[2.25f,0f,0f,-1.125f,0f,2.2969f,0f,9.125f,0f,0f,2.25f,-1.125f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:orange_concrete\",Properties:{}},transformation:[1.1313f,-1.1364f,0f,0f,1.1313f,1.1364f,0f,10.25f,0f,0f,2.0869f,-1.0625f,0f,0f,0f,1f]},{id:\"minecraft:block_display\",block_state:{Name:\"minecraft:iron_block\",Properties:{}},transformation:[2f,0f,0f,-1f,0f,0.1f,0f,0.8125f,0f,0f,2f,-1f,0f,0f,0f,1f]}],tag:MT-Rocket}";
                    Bukkit.dispatchCommand((CommandSender)console, (String)(exePart + summonCommand));
                    this.rocketSpawned = true;
                    this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_PISTON_EXTEND, 2.0f, 0.5f);
                    Bukkit.getScheduler().runTaskLater(MineMain.getPlugin(), () -> this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_COPPER_PLACE, 2.0f, 0.5f), 10L);
                } else {
                    MineUtil.sendWarning((CommandSender)event.getWhoClicked(), "Cannot spawn rocket yet, check diagnostics.");
                }
            } else if (solid && clear && parts && fuel && this.rocketSpawned) {
                MineUtil.sendMessage((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("Rocket_Silo_Redstone"));
            } else {
                MineUtil.sendWarning((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("Rocket_Silo_Not_Ready"));
            }
            this.updateUI();
        }
        if (event.isLeftClick() && event.getSlot() == 14) {
            ShipCore sc = RocketSilo.getNextEntry(ShipCore.getCores(this.getPlacerUUID(), this.getLocation()), ShipCore.getCoreByName(this.linkedShip));
            this.linkedShip = sc != null ? sc.getShipName() : null;
            this.getLocation().getWorld().playSound(this.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.updateUI();
        }
    }

    public static <T> T getNextEntry(List<T> list, T current) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (current == null) {
            return list.get(0);
        }
        int index = list.indexOf(current);
        if (index == -1) {
            return list.get(0);
        }
        if (list.size() - 1 == index) {
            return null;
        }
        int nextIndex = (index + 1) % list.size();
        return list.get(nextIndex);
    }

    public List<BlockDisplay> getRocketEntities() {
        ArrayList<BlockDisplay> ents = new ArrayList<BlockDisplay>();
        List nearbyEntities = (List)this.getLocation().getWorld().getNearbyEntities(this.getLocation(), 3.0, 3.0, 3.0);
        for (Entity entity : nearbyEntities) {
            if (!entity.getType().equals((Object)EntityType.BLOCK_DISPLAY)) continue;
            ents.add((BlockDisplay)entity);
        }
        return ents;
    }

    public void removeRocketEntity() {
        for (Entity entity : this.getRocketEntities()) {
            entity.remove();
        }
    }

    public int getRocketParts() {
        int amount = 0;
        for (ItemStack stack : this.getInputItems()) {
            if (!MineItems.isIndustrialItem(stack, "Rocket Parts")) continue;
            amount += stack.getAmount();
        }
        return amount;
    }

    public int getRocketFuel() {
        int amount = 0;
        for (ItemStack stack : this.getInputItems()) {
            if (!MineItems.isIndustrialItem(stack, "Rocket Fuel")) continue;
            amount += stack.getAmount();
        }
        return amount;
    }

    public static void removeAllTravelingRocketEntities() {
        for (BlockDisplay display : rocketRemovalEntities) {
            display.remove();
        }
    }

    public void launchRocket(final List<BlockDisplay> displays) {
        rocketRemovalEntities.addAll(displays);
        this.cooldown = 30;
        Bukkit.getServer().getPluginManager().callEvent((Event)new RocketLaunchEvent(this));
        this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_VAULT_REJECT_REWARDED_PLAYER, 2.0f, 0.25f);
        Bukkit.getScheduler().runTaskLater(MineMain.getPlugin(), () -> {
            this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_MINECART_RIDING, 5.0f, 0.5f);
            double initialYIncrement = 0.0;
            final double acceleration = 0.05;
            final double maxYIncrement = 100.0;
            final int removeAfter = 200;
            new BukkitRunnable(initialYIncrement){
                double currentYIncrement;
                double currentAceel;
                boolean isFirst;
                private int thurster;
                private int soundCounter;
                private Location smokeCenter;
                int ticks;
                BlockDisplay sound;
                {
                    this.currentYIncrement = d;
                    this.currentAceel = d2;
                    this.isFirst = true;
                    this.thurster = 0;
                    this.soundCounter = 5;
                    this.smokeCenter = RocketSilo.this.getLocation().add(0.5, 2.0, 0.5);
                    this.ticks = 0;
                    this.sound = null;
                }

                public void run() {
                    if (this.currentYIncrement >= maxYIncrement || this.ticks >= 100) {
                        RocketSilo.this.removeRocketEntity();
                        this.cancel();
                        return;
                    }
                    for (BlockDisplay display : displays) {
                        display.setTeleportDuration(10);
                        display.setViewRange((float)(MineMain.chunkViewDistance * 2));
                        if (this.isFirst && display.getBlock().equals(Bukkit.createBlockData((Material)Material.BLACK_SHULKER_BOX))) {
                            ++this.thurster;
                            RocketSilo.emitFireParticles(display, removeAfter, this.thurster);
                            this.sound = display;
                        }
                        Location loc = display.getLocation();
                        loc.add(0.0, this.currentYIncrement, 0.0);
                        display.teleport(loc);
                    }
                    this.currentYIncrement += this.currentAceel;
                    this.isFirst = false;
                    --this.soundCounter;
                    if (this.soundCounter <= 0) {
                        this.soundCounter = 5;
                        if (this.sound != null) {
                            RocketSilo.this.getLocation().getWorld().playSound(this.sound.getLocation(), Sound.ENTITY_GUARDIAN_ATTACK, 5.0f, 0.1f);
                            RocketSilo.this.getLocation().getWorld().playSound(this.sound.getLocation(), Sound.BLOCK_VAULT_AMBIENT, 5.0f, 0.5f);
                        }
                    }
                    ++this.ticks;
                    if (this.ticks <= 40) {
                        boolean quick = TUMaths.rollRange(0, 99) <= 66;
                        RocketSilo.spawnExpandingSmokeRing(this.smokeCenter.clone().add(0.0, TUMaths.rollRange(this.currentYIncrement / 2.0, this.currentYIncrement), 0.0), 3.0, 20, TUMaths.rollRange(0.02, 0.05), quick);
                        boolean bl = quick = TUMaths.rollRange(0, 99) <= 66;
                        if (TUMaths.isMultipleOf(this.ticks, 2)) {
                            RocketSilo.spawnExpandingSmokeRing(this.smokeCenter.clone().add(0.0, TUMaths.rollRange(this.currentYIncrement / 4.0, this.currentYIncrement / 2.0), 0.0), 2.0, 10, TUMaths.rollRange(0.02, 0.05), quick);
                        }
                        boolean bl2 = quick = TUMaths.rollRange(0, 99) <= 66;
                        if (TUMaths.isMultipleOf(this.ticks, 4)) {
                            RocketSilo.spawnExpandingSmokeRing(this.smokeCenter.clone().add(0.0, TUMaths.rollRange(this.currentYIncrement / 8.0, this.currentYIncrement / 4.0), 0.0), 1.0, 5, TUMaths.rollRange(0.02, 0.05), quick);
                        }
                        if (this.ticks == 40) {
                            Bukkit.getScheduler().runTaskLater(MineMain.getPlugin(), () -> {
                                int i = 0;
                                while (i < 40) {
                                    Bukkit.getScheduler().runTaskLater(MineMain.getPlugin(), () -> RocketSilo.spawnRisingAsh(this.smokeCenter, TUMaths.rollRange(1, 10), 10, acceleration), (long)(10 * i));
                                    ++i;
                                }
                                RocketSilo.this.cookBlocks();
                            }, 20L);
                        }
                    }
                }
            }.runTaskTimer(MineMain.getPlugin(), 0L, 2L);
            new BukkitRunnable(){
                private Location smokeCenter;
                int seconds;
                {
                    this.smokeCenter = RocketSilo.this.getLocation().add(0.5, 2.0, 0.5);
                    this.seconds = 0;
                }

                public void run() {
                    ++this.seconds;
                    if (this.seconds >= 30) {
                        this.cancel();
                        return;
                    }
                    double range = 0.0;
                    range = this.seconds <= 5 ? 3.0 + (double)this.seconds * 1.4 : 10.0 - (double)this.seconds * 0.4;
                    for (Entity entity : this.smokeCenter.getWorld().getNearbyEntities(this.smokeCenter, range, range, range)) {
                        Player player;
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity lent = (LivingEntity)entity;
                        lent.setFireTicks(60);
                        lent.damage(2.0);
                        if (!lent.getType().equals((Object)EntityType.PLAYER) || (player = (Player)lent).getGameMode().equals((Object)GameMode.CREATIVE)) continue;
                        MineUtil.sendWarning((CommandSender)lent, "This area is to hot! I need to wait for it to cool down!");
                    }
                }
            }.runTaskTimer(MineMain.getPlugin(), 0L, 20L);
            Bukkit.getScheduler().runTaskLater(MineMain.getPlugin(), () -> {
                for (BlockDisplay display : displays) {
                    display.remove();
                }
            }, (long)removeAfter);
        }, 20L);
    }

    public static void emitFireParticles(final BlockDisplay display, final int duration, int thrusterNumber) {
        new BukkitRunnable(thrusterNumber){
            int tick = 0;
            private boolean fireadjusted = false;
            private Location offset;
            {
                this.offset = blockDisplay.getLocation();
                if (n == 1) {
                    this.offset = new Location(blockDisplay.getWorld(), 1.5, -1.0, 0.0);
                }
                if (n == 2) {
                    this.offset = new Location(blockDisplay.getWorld(), -1.5, -1.0, 0.0);
                }
                if (n == 3) {
                    this.offset = new Location(blockDisplay.getWorld(), 0.0, -1.0, 1.5);
                }
                if (n == 4) {
                    this.offset = new Location(blockDisplay.getWorld(), 0.0, -1.0, -1.5);
                }
            }

            public void run() {
                if (this.tick > duration) {
                    this.cancel();
                    return;
                }
                int particleCount = Math.min(10, this.tick / 1);
                double speed = Math.min(1.0, (double)this.tick * 0.02);
                double yoffset = -0.08 * (double)this.tick;
                if (this.fireadjusted || this.tick > duration / 2) {
                    yoffset = -0.1 * (double)this.tick;
                    this.fireadjusted = true;
                }
                int i = 0;
                while (i < particleCount) {
                    Vector direction = new Vector(TUMaths.rollRange(-0.15, 0.15), -1.0, TUMaths.rollRange(-0.15, 0.15)).multiply(speed);
                    display.getWorld().spawnParticle(Particle.FLAME, display.getLocation().add(this.offset).add(0.0, yoffset, 0.0), 0, direction.getX() + TUMaths.rollRange(-0.1, 0.1), direction.getY() + TUMaths.rollRange(0.0, -1.0), direction.getZ() + TUMaths.rollRange(-0.1, 0.1), speed, null, true);
                    if (TUMaths.isMultipleOf(i, 2)) {
                        display.getWorld().spawnParticle(Particle.LARGE_SMOKE, display.getLocation().add(this.offset).add(0.0, yoffset, 0.0), 0, direction.getX() + TUMaths.rollRange(-0.1, 0.1), direction.getY() + TUMaths.rollRange(0.0, -1.0), direction.getZ() + TUMaths.rollRange(-0.1, 0.1), speed, null, true);
                        if (TUMaths.isMultipleOf(i, 4)) {
                            display.getWorld().spawnParticle(Particle.CAMPFIRE_COSY_SMOKE, display.getLocation().add(this.offset).add(0.0, yoffset, 0.0), 0, direction.getX() + (double)TUMaths.rollRange(-1, 1), direction.getY() + TUMaths.rollRange(0.0, -1.0), direction.getZ() + TUMaths.rollRange(-1.0, 1.0), speed * 0.05, null, true);
                        }
                    }
                    ++i;
                }
                ++this.tick;
            }
        }.runTaskTimer(MineMain.getPlugin(), 0L, 1L);
    }

    public static void spawnExpandingSmokeRing(Location center, double radius, int particleCount, double speed, boolean quick) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        int i = 0;
        while (i < particleCount) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = center.getX() + radius * Math.cos(angle += (double)TUMaths.rollRange(0, 90));
            double z = center.getZ() + radius * Math.sin(angle);
            Location particleLocation = new Location(world, x, center.getY(), z);
            Vector direction = particleLocation.toVector().subtract(center.toVector()).normalize();
            if (!quick) {
                world.spawnParticle(Particle.CAMPFIRE_SIGNAL_SMOKE, particleLocation, 0, direction.getX(), direction.getY(), direction.getZ(), speed);
            } else {
                world.spawnParticle(Particle.CAMPFIRE_COSY_SMOKE, particleLocation, 0, direction.getX(), direction.getY(), direction.getZ(), speed);
            }
            ++i;
        }
    }

    public static void spawnRisingAsh(Location center, double radius, int particleCount, double upwardSpeed) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        Random random = new Random();
        int i = 0;
        while (i < particleCount) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double distance = random.nextDouble() * radius;
            double xOffset = Math.cos(angle) * distance;
            double zOffset = Math.sin(angle) * distance;
            Location particleLocation = center.clone().add(xOffset, 0.0, zOffset);
            world.spawnParticle(Particle.LARGE_SMOKE, particleLocation, 0, 0.0, upwardSpeed, 0.0, 0.0);
            ++i;
        }
    }

    public boolean hasFoundation() {
        for (Block block : this.getBlocksInSquare(this.getLocation().add(0.0, 1.0, 0.0))) {
            if (block.getType().isSolid()) continue;
            return false;
        }
        return true;
    }

    public void cookBlocks() {
        long delay = 5L;
        for (Block block : this.getBlocksInSquare(this.getLocation().add(0.0, 1.0, 0.0))) {
            if (TUMaths.rollRange(0, 99) > 33 || !block.getType().isSolid() || block.getType().equals((Object)Material.BEDROCK)) continue;
            Material newType = Material.COBBLESTONE;
            if (block.getType().equals((Object)Material.GRASS_BLOCK)) {
                newType = Material.DIRT;
            }
            if (block.getType().equals((Object)Material.DIRT)) {
                newType = Material.GRAVEL;
            }
            if (block.getType().equals((Object)Material.GRAVEL)) {
                newType = Material.AIR;
            }
            if (block.getType().equals((Object)Material.SMOOTH_STONE)) {
                newType = Material.COBBLESTONE;
            }
            if (block.getType().equals((Object)Material.STONE)) {
                newType = Material.COBBLESTONE;
            }
            if (block.getType().equals((Object)Material.COBBLESTONE)) {
                newType = Material.AIR;
            }
            if (block.getType().equals((Object)Material.GLASS)) {
                newType = Material.AIR;
            }
            Material fType = newType;
            Bukkit.getScheduler().runTaskLater(MineMain.getPlugin(), () -> {
                block.setType(fType);
                if (!fType.equals((Object)Material.AIR) && TUMaths.rollRange(0, 99) <= 20) {
                    block.getRelative(BlockFace.UP).setType(Material.FIRE);
                }
            }, delay);
            delay += (long)TUMaths.rollRange(5, 10);
        }
    }

    public boolean hasClearence() {
        for (Block block : this.getBlocksInSquare(this.getLocation().add(0.0, 2.0, 0.0))) {
            if (block.getLightFromSky() == 15) continue;
            return false;
        }
        return true;
    }

    public List<Block> getBlocksInSquare(Location center) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int x = -2;
        while (x <= 2) {
            int z = -2;
            while (z <= 2) {
                Block block = center.getWorld().getBlockAt(center.clone().add((double)x, 0.0, (double)z));
                blocks.add(block);
                ++z;
            }
            ++x;
        }
        return blocks;
    }

    public boolean isNearbyRedstonePowered(Location location) {
        int[][] offsets;
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray[3] = nArray4;
        int[][] nArrayArray2 = offsets = nArrayArray;
        int n = offsets.length;
        int n2 = 0;
        while (n2 < n) {
            RedstoneWire wire;
            int[] offset = nArrayArray2[n2];
            Block block = location.clone().add((double)offset[0], 0.0, (double)offset[1]).getBlock();
            if (block.getType() == Material.REDSTONE_WIRE && (wire = (RedstoneWire)block.getBlockData()).getPower() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, RocketSilo.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.MANUFACTORING, new RocketSilo(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Low Density Structure", 3));
        ings.add(MineItems.getIndustrialItem("Electric Engine Unit", 3));
        ings.add(MineItems.getIndustrialItem("Processing Unit", 3));
        RecipeUtils.addDefaultRecipe(new RocketSilo(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }
}

