/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ChunkLoader
extends Device {
    private static final long serialVersionUID = -3929409111254171123L;
    private static String classSpacedNamed = "Chunk Loader";
    private int radius = 0;
    private transient HashSet<Chunk> chunks = new HashSet();
    private transient HashSet<Chunk> taggedChunks = new HashSet();

    public ChunkLoader(Location loc) {
        super(loc);
        this.setMaterial("WAXED_COPPER_BULB");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(false);
        this.setIdlePower(1);
        this.setActionPower(0);
        this.setUseUI(true);
    }

    @Override
    public int getGridScore() {
        return 3;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device can load chunks around it.");
        lore.add("- The radius of chunks is configurable.");
        lore.add("- A higher radius will use more power!");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = new ArrayList<String>();
        int range = (int)Math.sqrt(this.chunks.size());
        lore.add(MineUtil.colon(" Chunk Radius", range + "x" + range));
        lore.add(MineUtil.colon(" Power Needed", "" + this.powerNeeded()));
        lore.add(MineUtil.colon(" Total Chunks", "" + this.chunks.size()));
        lore.add(" ");
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Increase Radius"));
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Decrease Radius"));
        if (this.getFailReason() != null && !this.getFailReason().equals("None")) {
            lore.add(" ");
            lore.add(" " + String.valueOf(ChatColor.RED) + this.getFailReason());
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Power Usage", lore);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    private int powerNeeded() {
        return this.chunks.size() * 5;
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GRASS_BLOCK, 1.0);
    }

    @Override
    public void action() {
        if (this.chunks == null) {
            this.rebuildChunks();
        }
        if (this.getGrid() != null) {
            int powerNeeded = this.powerNeeded();
            if (this.getGrid().hasPower(powerNeeded)) {
                for (Chunk chunk : this.chunks) {
                    if (!chunk.addPluginChunkTicket(MineMain.getPlugin())) continue;
                    this.taggedChunks.add(chunk);
                }
                this.setActionPower(powerNeeded);
                this.getGrid().consumePower(this, powerNeeded);
                this.setConsumingPower(true);
            } else {
                for (Chunk chunk : this.taggedChunks) {
                    chunk.removePluginChunkTicket(MineMain.getPlugin());
                }
            }
        }
    }

    private void rebuildChunks() {
        if (this.chunks == null) {
            this.chunks = new HashSet();
        }
        if (this.taggedChunks == null) {
            this.taggedChunks = new HashSet();
        }
        if (this.taggedChunks.size() > 0) {
            for (Chunk chunk : this.taggedChunks) {
                chunk.removePluginChunkTicket(MineMain.getPlugin());
            }
        }
        this.chunks.clear();
        this.taggedChunks.clear();
        int r = this.radius - 1;
        if (r != -1) {
            Chunk chunk = this.getLocation().getChunk();
            World world = chunk.getWorld();
            if (r == 0) {
                this.chunks.add(world.getChunkAt(chunk.getX(), chunk.getZ()));
            } else {
                int x = chunk.getX() - r;
                while (x <= chunk.getX() + r) {
                    int z = chunk.getZ() - r;
                    while (z <= chunk.getZ() + r) {
                        this.chunks.add(world.getChunkAt(x, z));
                        ++z;
                    }
                    ++x;
                }
            }
        }
    }

    @Override
    public void onDeviceRemove() {
        if (this.taggedChunks != null) {
            for (Chunk chunk : this.taggedChunks) {
                chunk.removePluginChunkTicket(MineMain.getPlugin());
            }
        }
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 13) {
            if (event.isLeftClick()) {
                ++this.radius;
                if (this.radius > 10) {
                    this.radius = 10;
                }
                if (!event.getWhoClicked().isOp() && this.radius > MineMain.maxChunkLoaderRadius) {
                    this.radius = MineMain.maxChunkLoaderRadius;
                }
            }
            if (event.isRightClick()) {
                --this.radius;
                if (this.radius < 0) {
                    this.radius = 0;
                }
            }
            this.rebuildChunks();
            this.updateUI();
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, ChunkLoader.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.AUTOMATION, new ChunkLoader(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.BLACKSTONE, 3));
        ings.add(new ItemStack(Material.QUARTZ_BLOCK, 4));
        ings.add(new ItemStack(Material.OBSIDIAN, 2));
        RecipeUtils.addDefaultRecipe(new ChunkLoader(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, true);
    }
}

