/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.RightClickBlockInput;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Powerable;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class PowerBreaker
extends Device {
    private static final long serialVersionUID = -3839101797254229915L;
    private static String classSpacedNamed = "Power Breaker";
    private HashSet<String> connected = new HashSet();
    private int breakThreshhold = 0;

    public PowerBreaker(Location loc) {
        super(loc);
        this.setMaterial("WAXED_COPPER_BULB");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setActionPower(0);
        this.setIdlePower(0);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setOpenable(true);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Connects to multiple devices.");
        lore.add("- Mirrors on / off state to connected devices.");
        lore.add("- Can turn off when exceeding a power level.");
        return lore;
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.OBSERVER, 1.0);
    }

    @Override
    public void updateUI() {
        ArrayList<String> gridInfo = new ArrayList<String>();
        gridInfo.add(MineUtil.colon(" Connections", "" + this.connected.size()));
        gridInfo.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Clear Connections"));
        gridInfo.add(" ");
        for (String connection : this.connected) {
            Location location = TUMaths.getStringLocation(connection);
            Device device = Device.getDevice(location);
            if (device == null) continue;
            gridInfo.add(String.valueOf(ChatColor.GRAY) + " " + device.getName() + " > Connected @ " + TUMaths.locationStringBasic(TUMaths.getStringLocation(connection)));
        }
        ItemStack connectionStack = TUItems.createItem(Material.OBSERVER, MineItems.whiteBold() + "Connections", gridInfo);
        this.inv.setItem(13, connectionStack);
        ArrayList<String> breakerLore = new ArrayList<String>();
        breakerLore.addAll(MineUtil.wrapText("You can set the breaker threshold here, when the power grid uses this power amount, then this device will turn off. Which it will mirror its off state to all connected devices. Once this is turned back on, it will then turn all connected devices one. Attach a lever to this to turn the state on or off manually.", 45, ChatColor.WHITE, 1));
        breakerLore.add(" ");
        breakerLore.add(MineUtil.colon(" Threshold", "" + this.breakThreshhold));
        int draw = 0;
        if (this.getGrid() != null) {
            draw = this.getGrid().getLastConsume();
        }
        breakerLore.add(MineUtil.colon(" Grid Draw", "" + draw));
        ChatColor color = ChatColor.RED;
        if (this.getPoweredState().equals((Object)Device.PoweredState.ON)) {
            color = ChatColor.GREEN;
        }
        breakerLore.add(String.valueOf(color) + " " + this.getPoweredStateString());
        this.inv.setItem(11, TUItems.createItem(Material.GRAY_CONCRETE, MineItems.whiteBold() + "Breaker Settings", breakerLore));
        this.inv.setItem(15, TUItems.createItem(Material.GREEN_CONCRETE, MineItems.whiteBold() + "Add Connection(s)", MineUtil.wrapText("Click this, then you will select the device you want to link. If you want to link more then one device, just crouch when linking a device.", 45, ChatColor.WHITE, 1)));
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13 && i != 11 && i != 15) {
                this.inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 15) {
            this.startSelection(player);
            player.closeInventory();
        }
        if (event.getSlot() == 11) {
            player.closeInventory();
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ Player val$player;

                public ChatInput(String startMessage, boolean numbersonly, Player player) {
                    this.val$player = player;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    PowerBreaker.this.breakThreshhold = Integer.valueOf(message);
                    MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("PB_Threshhold_Updated"));
                    PowerBreaker.this.updateUI();
                    this.val$player.openInventory(PowerBreaker.this.getInventory());
                }
            }
            ChatInput input = new ChatInput(LocaleUtil.messageText("PB_Threshhold_Input"), true, player);
            input.start(player);
        }
        if (event.getSlot() == 13) {
            for (String str : this.connected) {
                Location location = TUMaths.getStringLocation(str);
                Device device = Device.getDevice(location);
                if (device == null) continue;
                device.setPoweredState(Device.PoweredState.ON);
            }
            this.connected.clear();
            this.updateUI();
        }
    }

    private void startSelection(Player player) {
        class BlockInput
        extends RightClickBlockInput {
            private final /* synthetic */ Player val$player;

            public BlockInput(String startMessage, Player player) {
                this.val$player = player;
                super(startMessage);
            }

            @Override
            public void inputAction(Block block) {
                String strLoc = TUMaths.locationString(block);
                if (!PowerBreaker.this.connected.contains(strLoc)) {
                    PowerBreaker.this.connected.add(strLoc);
                    MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("PB_Threshhold_Connected"));
                } else {
                    Device device = Device.getDevice(block);
                    if (device == null) {
                        MineUtil.sendWarning(this.val$player, LocaleUtil.messageText("PB_Threshhold_Aborted"));
                    } else {
                        MineUtil.sendWarning(this.val$player, LocaleUtil.messageText("PB_Threshhold_Removed"));
                        PowerBreaker.this.connected.remove(strLoc);
                    }
                }
                if (this.val$player.isSneaking()) {
                    PowerBreaker.this.startSelection(this.val$player);
                }
            }
        }
        BlockInput input = new BlockInput(String.valueOf(ChatColor.GREEN) + LocaleUtil.messageText("PB_Right_Input"), player);
        input.start(player);
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = new ArrayList<String>();
        return lore;
    }

    @Override
    public void action() {
        this.tickBreaker();
        if (this.getGrid() != null && this.breakThreshhold != 0 && this.breakThreshhold <= this.getGrid().getLastConsume()) {
            this.setPoweredState(Device.PoweredState.OFF_BREAKER);
            if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 16.0)) {
                this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.BLOCK_TRIPWIRE_CLICK_ON, 1.0f, 0.6f);
            }
        }
    }

    @Override
    public void actionNotPowered() {
        this.tickBreaker();
    }

    @Override
    public void onStateChange() {
        BlockData data = this.getLocation().getBlock().getBlockData();
        if (data instanceof Powerable) {
            Powerable powerable = (Powerable)data;
            powerable.setPowered(true);
            if (powerable instanceof Lightable) {
                Lightable light = (Lightable)powerable;
                light.setLit(!this.getPoweredState().equals((Object)Device.PoweredState.ON));
                this.getLocation().getBlock().setBlockData((BlockData)powerable);
            }
        }
    }

    private void tickBreaker() {
        if (this.connected.size() > 0) {
            for (String str : new ArrayList<String>(this.connected)) {
                Location location = TUMaths.getStringLocation(str);
                Device device = Device.getDevice(location);
                if (device != null) {
                    if (!this.getPoweredState().equals((Object)Device.PoweredState.ON)) {
                        device.setPoweredState(Device.PoweredState.OFF_BREAKER);
                        continue;
                    }
                    device.setPoweredState(Device.PoweredState.ON);
                    continue;
                }
                this.connected.remove(str);
            }
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, PowerBreaker.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new PowerBreaker(null).getDeviceStack(), true);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Copper Cable"));
        ings.add(new ItemStack(Material.IRON_INGOT, 2));
        RecipeUtils.addDefaultRecipe(new PowerBreaker(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }
}

