/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.RightClickBlockInput;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Utility.PowerReceiver;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PowerTransmitter
extends Device {
    private static final long serialVersionUID = -1111109111254171315L;
    private int powerDraw = 0;
    private int transmissionCost = 0;
    private static String classSpacedNamed = "Power Transmitter";
    private String reciever = null;

    public PowerTransmitter(Location loc) {
        super(loc);
        this.setMaterial("NOTE_BLOCK");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(false);
        this.setIdlePower(0);
        this.setActionPower(0);
        this.setUseUI(true);
        this.updateDeviceHeadItem();
        this.displayLockedHorizontal = true;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device is linked to a power receiver.");
        lore.add("- It sends a configured amount of power to the reciever.");
        lore.add("- The further the distance the more power that is needed.");
        lore.add("- Batteries always discharge first on the power grid.");
        lore.add("- So this will only use its power if its needed.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Power Set", "" + this.powerDraw));
        if (this.getFailReason() != null && !this.getFailReason().equals("None")) {
            lore.add(" ");
            lore.add(" " + String.valueOf(ChatColor.RED) + this.getFailReason());
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Power Usage", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        lore.clear();
        if (this.reciever == null) {
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Create Connection"));
        } else {
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Change Connection"));
            lore.add(" ");
            lore.add(String.valueOf(ChatColor.GRAY) + "  > Connected @ " + TUMaths.locationStringBasic(TUMaths.getStringLocation(this.reciever)));
        }
        ItemStack connectionStack = TUItems.createItem(Material.GRAY_CONCRETE, String.valueOf(MineItems.goldBold()) + "Reciever Connection", lore);
        inv.setItem(11, connectionStack);
        lore.clear();
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Change Transmission"));
        lore.add(" ");
        lore.add(MineUtil.colon(" Current Configuration", this.powerDraw + " "));
        lore.add(MineUtil.colon(" Transmission Cost", this.transmissionCost + " "));
        ItemStack transmissionStack = TUItems.createItem(Material.GREEN_CONCRETE, String.valueOf(MineItems.goldBold()) + "Transmission Configuration", lore);
        inv.setItem(15, transmissionStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13 && i != 11 && i != 15) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    private Location getRecieverLocation() {
        return TUMaths.getStringLocation(this.reciever);
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.REDSTONE_BLOCK, 1.0);
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            if (this.reciever != null) {
                this.transmissionCost = TUMaths.get2DManhattanDistance(this.getRecieverLocation(), this.getLocation()) / 30;
            }
            if (this.powerDraw != 0 && this.reciever != null) {
                this.setConsumingPower(false);
                int amountToConsume = 0;
                Device device = Device.getDevice(TUMaths.getStringLocation(this.reciever));
                if (device != null && device instanceof PowerReceiver) {
                    PowerReceiver pr = (PowerReceiver)device;
                    int needed = pr.getNeededPower();
                    amountToConsume = this.powerDraw >= needed ? needed : this.powerDraw;
                    if (this.getGrid().hasPower(amountToConsume)) {
                        pr.addPower(amountToConsume);
                        this.getGrid().consumePower(this, amountToConsume + this.transmissionCost);
                        this.setConsumingPower(true);
                        this.setActionPower(amountToConsume + this.transmissionCost);
                    }
                } else {
                    this.reciever = null;
                }
            }
        }
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Object input;
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 11) {
            player.closeInventory();
            class BlockInput
            extends RightClickBlockInput {
                private final /* synthetic */ Player val$player;

                public BlockInput(String startMessage, Player player) {
                    this.val$player = player;
                    super(startMessage);
                }

                @Override
                public void inputAction(Block block) {
                    String strLoc = TUMaths.locationString(block);
                    Device device = Device.getDevice(block);
                    if (device != null && device instanceof PowerReceiver) {
                        PowerTransmitter.this.reciever = strLoc;
                        MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("PT_Connected"));
                    } else if (PowerTransmitter.this.reciever == null) {
                        MineUtil.sendWarning(this.val$player, LocaleUtil.messageText("PT_Aborted"));
                    } else {
                        MineUtil.sendWarning(this.val$player, LocaleUtil.messageText("PT_Removed"));
                        PowerTransmitter.this.reciever = null;
                    }
                }
            }
            input = new BlockInput(String.valueOf(ChatColor.GREEN) + LocaleUtil.messageText("PT_Right_Input"), player);
            ((RightClickBlockInput)input).start(player);
        }
        if (event.getSlot() == 15) {
            player.closeInventory();
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ Player val$player;

                public ChatInput(String startMessage, boolean numbersonly, Player player) {
                    this.val$player = player;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    PowerTransmitter.this.powerDraw = Integer.valueOf(message);
                    MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("PT_Configured"));
                    PowerTransmitter.this.updateUI();
                    this.val$player.openInventory(PowerTransmitter.this.getInventory());
                }
            }
            input = new ChatInput(LocaleUtil.messageText("PT_Chat_Input"), true, player);
            ((com.MT.triggersUtility.ChatInput)input).start(player);
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, PowerTransmitter.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new PowerTransmitter(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Iron Plate", 7));
        ings.add(new ItemStack(Material.ENDER_PEARL, 1));
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        RecipeUtils.addDefaultRecipe(new PowerTransmitter(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }
}

