/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx;

import com.MT.triggersUtility.SkullCreator;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.PhaseRelay;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Technology.TechTree;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MineItems {
    public static NamespacedKey debugItemKey = new NamespacedKey(MineMain.getPlugin(), "DebugItem");
    public static ChatColor industrialColor;
    public static ChatColor descColor;
    public static String checkMark;
    public static String xMark;
    public static NamespacedKey isMinetorioItemKey;
    private static ItemFlag hideFlag;
    private static HashMap<String, ItemStack> compCache;
    public static HashMap<String, String> itemNames;
    public static HashMap<String, String> itemDescs;
    public static HashMap<String, String> itemModelData;
    public static HashMap<String, NamespacedKey> pdcKey;
    public static HashMap<String, Material> itemMaterial;
    public static HashMap<String, String> devValueForItems;
    public static HashMap<String, String> devValueForDevices;

    static {
        checkMark = MineItems.greenBold() + "\u2714";
        xMark = MineItems.redBold() + "\u274c";
        industrialColor = ChatColor.GOLD;
        descColor = ChatColor.DARK_GRAY;
        isMinetorioItemKey = new NamespacedKey(MineMain.getPlugin(), "MT_IS_MINETORIO_ITEM");
        hideFlag = MineMain.version.getHideItemFlag();
        compCache = new HashMap();
        itemNames = new HashMap();
        itemDescs = new HashMap();
        itemModelData = new HashMap();
        pdcKey = new HashMap();
        itemMaterial = new HashMap();
        devValueForItems = new HashMap();
        devValueForDevices = new HashMap();
    }

    public static String getEnergyIcon() {
        return "\u26a1";
    }

    public static String getUpArrow() {
        return "\u2191";
    }

    public static String getDownArrow() {
        return "\u2193";
    }

    public static void addDesc(ItemStack stack, Device device) {
        TUItems.addLore(stack, String.valueOf(ChatColor.GOLD) + "Industrial Device");
        TUItems.addLore(stack, "" + ChatColor.GOLD);
        if (device != null && MineMain.usingPowerSystem()) {
            if (device.getActionPower() != 0) {
                TUItems.addLore(stack, String.valueOf(MineItems.redBold()) + "- " + device.getActionPower() + "\u26a1");
            } else if (device.getIdlePower() != 0) {
                TUItems.addLore(stack, String.valueOf(MineItems.redBold()) + "- " + device.getIdlePower() + "\u26a1");
            }
            if (device.getPowerGen() != 0) {
                TUItems.addLore(stack, String.valueOf(MineItems.yellowBold()) + "+ " + device.getPowerGen() + "\u26a1");
            }
            if (device.getGridRange() != 0) {
                TUItems.addLore(stack, String.valueOf(MineItems.whiteBold()) + "- " + device.getGridRange() + "\ud83d\udcd0");
            }
        }
    }

    public static String redBold() {
        return "" + ChatColor.RED + ChatColor.BOLD;
    }

    public static String yellowBold() {
        return "" + ChatColor.YELLOW + ChatColor.BOLD;
    }

    public static String whiteBold() {
        return "" + ChatColor.WHITE + ChatColor.BOLD;
    }

    public static String goldBold() {
        return "" + ChatColor.GOLD + ChatColor.BOLD;
    }

    public static String grayBold() {
        return "" + ChatColor.GRAY + ChatColor.BOLD;
    }

    public static String greenBold() {
        return "" + ChatColor.GREEN + ChatColor.BOLD;
    }

    public static String uiTitle() {
        return "" + ChatColor.WHITE + ChatColor.BOLD;
    }

    public static String buttonTitle() {
        return "" + ChatColor.GOLD + ChatColor.BOLD;
    }

    public static String itemColor() {
        return "" + ChatColor.GOLD + ChatColor.BOLD;
    }

    public static ChatColor descColor() {
        return ChatColor.WHITE;
    }

    public static String getTechCardTech(ItemStack stack) {
        if (MineItems.isTechCard(stack)) {
            return ChatColor.stripColor((String)stack.getItemMeta().getDisplayName());
        }
        return null;
    }

    public static boolean isTechCard(ItemStack stack) {
        if (!stack.getType().equals((Object)Material.PAPER)) {
            return false;
        }
        return TUItems.hasLoreLineNoColor(stack, "Industrial Tech Card");
    }

    public static ItemStack getTechCard(String tech) {
        String desc = "Right click while holding in your hand to unlock! This will unlock " + tech + " if you have not unlocked it yet!";
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.WHITE) + " Industrial Tech Card");
        lore.add(String.valueOf(ChatColor.WHITE) + " -----------------------------------------");
        lore.addAll(MineUtil.wrapText(desc, 45, MineItems.descColor(), 1));
        lore.add(String.valueOf(ChatColor.WHITE) + " -----------------------------------------");
        ItemStack stack = TUItems.createItem(Material.PAPER, MineItems.itemColor() + tech, lore);
        return stack;
    }

    public static ArrayList<ItemStack> getAllTechCards() {
        ArrayList<ItemStack> cards = new ArrayList<ItemStack>();
        for (String tech : TechTree.getAllTechs()) {
            cards.add(MineItems.getTechCard(tech));
        }
        return cards;
    }

    public static ItemStack getIndustrialItem(String name, int amount) {
        ItemStack stack = MineItems.getIndustrialItem(name);
        if (stack != null) {
            stack.setAmount(amount);
        }
        return stack;
    }

    public static ItemStack getIndustrialItem(String name) {
        block29: {
            ItemStack stack;
            block30: {
                String dev;
                if (compCache.containsKey(name)) {
                    return compCache.get(name).clone();
                }
                if (!itemNames.containsKey(name)) break block29;
                String localeName = itemNames.get(name);
                String desc = itemDescs.get(name);
                String modelData = itemModelData.get(name);
                String device = name;
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(String.valueOf(ChatColor.WHITE) + " Industrial Item");
                lore.add(String.valueOf(ChatColor.WHITE) + " -----------------------------------------");
                lore.addAll(MineUtil.wrapText(desc, 45, MineItems.descColor(), 1));
                lore.add(String.valueOf(ChatColor.WHITE) + " -----------------------------------------");
                if (itemMaterial.get(device) == null) break block29;
                stack = TUItems.createItem(itemMaterial.get(device), MineItems.itemColor() + localeName, lore);
                if (itemMaterial.get(device).equals((Object)Material.PLAYER_HEAD) && (dev = devValueForItems.get(device)) != null && !dev.equals("none")) {
                    stack = SkullCreator.getHead(dev);
                    ItemMeta im = stack.getItemMeta();
                    im.setItemName(MineItems.goldBold() + localeName);
                    im.setDisplayName(MineItems.goldBold() + localeName);
                    im.setLore(lore);
                    stack.setItemMeta(im);
                }
                ItemMeta meta = stack.getItemMeta();
                meta.getPersistentDataContainer().set(pdcKey.get(device), PersistentDataType.STRING, (Object)MineItems.getPDCString(device));
                meta.getPersistentDataContainer().set(isMinetorioItemKey, PersistentDataType.STRING, (Object)"MT_IS_MINETORIO_ITEM");
                if (device.equals("Mover")) {
                    NamespacedKey key = new NamespacedKey(MineMain.getPlugin(), "MT_" + device.replace(" ", "_"));
                    meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)("MT_" + device.replace(" ", "_")));
                    meta.getPersistentDataContainer().set(Device.isDeviceItemKey, PersistentDataType.STRING, (Object)"MT_IS_DEVICE");
                }
                if (!modelData.equals("none")) {
                    meta.setItemModel(NamespacedKey.fromString((String)modelData));
                }
                stack.setItemMeta(meta);
                if (!name.contains("Science Pack")) break block30;
                PotionMeta pm = (PotionMeta)stack.getItemMeta();
                pm.addItemFlags(new ItemFlag[]{hideFlag});
                switch (name) {
                    case "Automation Science Pack": {
                        pm.setColor(Color.fromRGB((int)255, (int)0, (int)0));
                        break;
                    }
                    case "Logistic Science Pack": {
                        pm.setColor(Color.fromRGB((int)0, (int)255, (int)0));
                        break;
                    }
                    case "Military Science Pack": {
                        pm.setColor(Color.fromRGB((int)0, (int)0, (int)0));
                        break;
                    }
                    case "Chemical Science Pack": {
                        pm.setColor(Color.fromRGB((int)0, (int)255, (int)255));
                        break;
                    }
                    case "Production Science Pack": {
                        pm.setColor(Color.fromRGB((int)128, (int)0, (int)128));
                        break;
                    }
                    case "Utility Science Pack": {
                        pm.setColor(Color.fromRGB((int)255, (int)250, (int)205));
                        break;
                    }
                    case "Space Science Pack": {
                        pm.setColor(Color.fromRGB((int)255, (int)255, (int)255));
                        break;
                    }
                    default: {
                        pm.setColor(Color.fromRGB((int)128, (int)128, (int)128));
                    }
                }
                pm.addCustomEffect(new PotionEffect(PotionEffectType.LUCK, 1, 1), false);
                stack.setAmount(1);
                stack.setItemMeta((ItemMeta)pm);
            }
            compCache.put(name, stack);
            return stack.clone();
        }
        return null;
    }

    public static ItemStack getIndustrialItemByPDC(String internalName) {
        for (ItemStack stack : ItemMenu.getAllItems()) {
            if (!MineItems.isIndustrialItem(stack, internalName)) continue;
            return stack.clone();
        }
        return null;
    }

    public static boolean isDeviceItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.hasItemMeta()) {
            return stack.getItemMeta().getPersistentDataContainer().has(Device.isDeviceItemKey);
        }
        return false;
    }

    public static boolean isMinetorioItem(ItemStack stack) {
        return MineItems.isIndustrialItem(stack) || MineItems.isDeviceItem(stack);
    }

    public static ItemStack getModularPowerArmor(Material baseType) {
        if (baseType.equals((Object)Material.DIAMOND_CHESTPLATE)) {
            return MineItems.getIndustrialItem("Modular Power Armor");
        }
        return MineItems.getIndustrialItem("Modular Power Armor Mk2");
    }

    public static boolean isModularPowerArmor(ItemStack stack) {
        return MineItems.isIndustrialItem(stack, "Modular Power Armor") || MineItems.isIndustrialItem(stack, "Modular Power Armor Mk2");
    }

    public static ItemStack getModularChip(MChip chip) {
        if (chip.equals((Object)MChip.Personal_Shield_Generator)) {
            return MineItems.getIndustrialItem("Personal Shield Generator");
        }
        if (chip.equals((Object)MChip.Personal_Laser_Turret)) {
            return MineItems.getIndustrialItem("Personal Laser Turret");
        }
        if (chip.equals((Object)MChip.Mobile_Battery)) {
            return MineItems.getIndustrialItem("Mobile Battery");
        }
        if (chip.equals((Object)MChip.Mobile_Solar_Panel)) {
            return MineItems.getIndustrialItem("Mobile Solar Panel");
        }
        if (chip.equals((Object)MChip.Integrated_Exoskeleton)) {
            return MineItems.getIndustrialItem("Integrated Exoskeleton");
        }
        return MineItems.getIndustrialItem("EVA Module");
    }

    public static MChip getModularChipType(ItemStack stack) {
        if (TUItems.isValid(stack)) {
            if (MineItems.isIndustrialItem(stack, "Personal Shield Generator")) {
                return MChip.Personal_Shield_Generator;
            }
            if (MineItems.isIndustrialItem(stack, "Personal Laser Turret")) {
                return MChip.Personal_Laser_Turret;
            }
            if (MineItems.isIndustrialItem(stack, "Mobile Battery")) {
                return MChip.Mobile_Battery;
            }
            if (MineItems.isIndustrialItem(stack, "Mobile Solar Panel")) {
                return MChip.Mobile_Solar_Panel;
            }
            if (MineItems.isIndustrialItem(stack, "Integrated Exoskeleton")) {
                return MChip.Integrated_Exoskeleton;
            }
            if (MineItems.isIndustrialItem(stack, "EVA Module")) {
                return MChip.EVA_Module;
            }
        }
        return null;
    }

    public static ItemStack getOxygenTank(int amount) {
        ItemStack stack = MineItems.getIndustrialItem("Oxygen Tank");
        TUItems.addLore(stack, MineUtil.colon(" Oxygen", amount + "/100"));
        return stack;
    }

    public static int getOxygenInTank(ItemStack stack) {
        if (TUItems.hasLoreLineNoColor(stack, "Oxygen")) {
            return Integer.valueOf(ChatColor.stripColor((String)TUItems.getLoreLineNoColor(stack, " Oxygen").split(": ")[1].split("/")[0]));
        }
        return 0;
    }

    public static ItemStack getOxygenMask() {
        ItemStack stack = MineItems.getIndustrialItem("Oxygen Mask");
        LeatherArmorMeta lam = (LeatherArmorMeta)stack.getItemMeta();
        lam.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
        lam.setColor(Color.fromRGB((int)255, (int)255, (int)240));
        stack.setItemMeta((ItemMeta)lam);
        return stack;
    }

    public static ItemStack getGasCanister(Planet.Gas gas) {
        ItemStack stack = MineItems.getIndustrialItem("Gas Canister");
        TUItems.addLore(stack, String.valueOf(ChatColor.GREEN) + " Contains 100 " + gas.toString());
        PotionMeta pm = (PotionMeta)stack.getItemMeta();
        pm.addItemFlags(new ItemFlag[]{hideFlag});
        if (gas.equals((Object)Planet.Gas.OXYGEN)) {
            pm.setColor(Color.fromRGB((int)255, (int)165, (int)120));
        }
        if (gas.equals((Object)Planet.Gas.HYDROGEN)) {
            pm.setColor(Color.fromRGB((int)255, (int)165, (int)200));
        }
        pm.addCustomEffect(new PotionEffect(PotionEffectType.LUCK, 1, 1), false);
        stack.setAmount(1);
        stack.setItemMeta((ItemMeta)pm);
        return stack;
    }

    public static ItemStack getSpaceSuit() {
        ItemStack stack = MineItems.getIndustrialItem("Space Suit");
        LeatherArmorMeta lam = (LeatherArmorMeta)stack.getItemMeta();
        lam.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
        lam.setColor(Color.fromRGB((int)255, (int)255, (int)240));
        stack.setItemMeta((ItemMeta)lam);
        return stack;
    }

    public static ItemStack getPhaseBeacon() {
        ItemStack stack = MineItems.getIndustrialItem("Phase Beacon");
        TUItems.addLore(stack, MineItems.redBold() + " Unlinked");
        return stack;
    }

    public static ItemStack getLinkedPhaseBeacon(PhaseRelay relay) {
        ItemStack stack = MineItems.getIndustrialItem("Phase Beacon");
        TUItems.addLore(stack, MineItems.greenBold() + " Linked @ " + TUMaths.locationString(relay.getLocation()));
        return stack;
    }

    public static boolean isPhaseBeacon(ItemStack stack) {
        return stack != null && stack.getType().equals((Object)Material.BLAZE_ROD) && TUItems.hasName(stack, "Phase Beacon", false, false);
    }

    public static PhaseRelay getPhaseRelay(ItemStack stack) {
        Location loc;
        Device device;
        if (MineItems.isIndustrialItem(stack, "Phase Beacon") && TUItems.hasLoreLine(stack, "Linked @ ") && (device = Device.getDevice((loc = TUMaths.getStringLocation(TUItems.getLoreLineNoColor(stack, "Linked @").split("@ ")[1])).getBlock())) != null && device instanceof PhaseRelay) {
            PhaseRelay relay = (PhaseRelay)device;
            return relay;
        }
        return null;
    }

    public static String formatMaterialName(String materialName) {
        String[] parts = materialName.split("_");
        StringBuilder formatted = new StringBuilder();
        int i = 0;
        while (i < parts.length) {
            String part = parts[i];
            if (!part.isEmpty()) {
                formatted.append(part.substring(0, 1).toUpperCase());
                formatted.append(part.substring(1).toLowerCase());
                if (i < parts.length - 1) {
                    formatted.append(" ");
                }
            }
            ++i;
        }
        return formatted.toString();
    }

    public static String getPDCString(String internalName) {
        return "MT_" + internalName.replace(" ", "_");
    }

    public static void loadItems() {
        Material mat;
        String modelData;
        String desc;
        String localeName;
        File file = new File(MineMain.getPlugin().getDataFolder(), "items.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection section = config.getConfigurationSection("Devices");
        if (section != null) {
            for (String internalDeviceName : section.getKeys(false)) {
                String deviceHeadValue;
                localeName = config.getString("Devices." + internalDeviceName + ".Name");
                desc = config.getString("Devices." + internalDeviceName + ".Description");
                modelData = config.getString("Devices." + internalDeviceName + ".Model Data").replace(" ", "_");
                itemNames.put(internalDeviceName, localeName);
                itemDescs.put(internalDeviceName, desc);
                itemModelData.put(internalDeviceName, modelData);
                if (config.isSet("Devices." + internalDeviceName + ".Material") && (mat = Material.matchMaterial((String)config.getString("Devices." + internalDeviceName + ".Material"))) != null) {
                    itemMaterial.put(internalDeviceName, mat);
                }
                if ((deviceHeadValue = config.getString("Devices." + internalDeviceName + ".Device Head Value")) != null) {
                    devValueForDevices.put(internalDeviceName, deviceHeadValue);
                }
                devValueForItems.put(internalDeviceName, config.getString("Items." + internalDeviceName + ".Dev Value"));
                pdcKey.put(internalDeviceName, new NamespacedKey(MineMain.getPlugin(), MineItems.getPDCString(internalDeviceName)));
            }
        }
        itemMaterial.put("Mover", Material.DROPPER);
        section = config.getConfigurationSection("Items");
        if (section != null) {
            for (String device : section.getKeys(false)) {
                localeName = config.getString("Items." + device + ".Name");
                desc = config.getString("Items." + device + ".Description");
                modelData = config.getString("Items." + device + ".Model Data").replace(" ", "_");
                itemNames.put(device, localeName);
                itemDescs.put(device, desc);
                itemModelData.put(device, modelData);
                pdcKey.put(device, new NamespacedKey(MineMain.getPlugin(), MineItems.getPDCString(device)));
                mat = Material.matchMaterial((String)config.getString("Items." + device + ".Material"));
                if (mat != null) {
                    itemMaterial.put(device, mat);
                    if (mat.equals((Object)Material.PLAYER_HEAD)) {
                        devValueForItems.put(device, config.getString("Items." + device + ".Dev Value"));
                        continue;
                    }
                    devValueForItems.put(device, "none");
                    continue;
                }
                itemMaterial.put(device, Material.STICK);
            }
        }
    }

    public static boolean isIndustrialItem(ItemStack stack, String internalName) {
        if (stack == null) {
            return false;
        }
        NamespacedKey key = pdcKey.getOrDefault(internalName, null);
        if (key != null && stack.hasItemMeta()) {
            return stack.getItemMeta().getPersistentDataContainer().has(key);
        }
        return false;
    }

    public static boolean isIndustrialItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.hasItemMeta()) {
            return stack.getItemMeta().getPersistentDataContainer().has(isMinetorioItemKey);
        }
        return false;
    }

    public static String getMTItemKey(ItemStack stack) {
        for (NamespacedKey key : stack.getItemMeta().getPersistentDataContainer().getKeys()) {
            String stringKey;
            if (isMinetorioItemKey.equals((Object)key) || Device.isDeviceItemKey.equals((Object)key) || !(stringKey = key.getKey()).contains("mt_")) continue;
            String pdcValue = stringKey.replace("mt_", "").replace("_", " ");
            for (String internalName : new ArrayList<String>(itemNames.keySet())) {
                TUMaths.dm(internalName.toLowerCase() + " VS " + pdcValue);
                if (!internalName.toLowerCase().equals(pdcValue)) continue;
                return internalName;
            }
        }
        return null;
    }

    public static enum MChip {
        Personal_Shield_Generator,
        Personal_Laser_Turret,
        Mobile_Battery,
        Mobile_Solar_Panel,
        Integrated_Exoskeleton,
        EVA_Module;

    }
}

