/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Pollution;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.Pollution.BiterAttack;
import com.MT.xxxtrigger50xxx.Pollution.SuperChunk;
import com.MT.xxxtrigger50xxx.PowerGrid;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class BiterWaves {
    private static final Random random = new Random();

    public static boolean canBeAttacked(PowerGrid gridToAttack) {
        if (gridToAttack.getGridScore() >= 25) {
            ArrayList<Device> devices = new ArrayList<Device>(gridToAttack.getConnectedDevices().keySet());
            Device device = devices.get(0);
            Player player = Bukkit.getPlayer((UUID)device.getPlacerUUID());
            if (MineMain.attackOnlyOnline) {
                if (player != null && player.isOnline()) {
                    return BiterWaves.beingPolluted(device.getLocation());
                }
            } else {
                return BiterWaves.beingPolluted(device.getLocation());
            }
        }
        return false;
    }

    public static void createWaveAttack(PowerGrid gridToAttack) {
        ArrayList<Device> devices = new ArrayList<Device>(gridToAttack.getConnectedDevices().keySet());
        if (devices.size() == 0) {
            TUMaths.dm("Grid has no devices to attack");
            return;
        }
        Location target = devices.get(0).getLocation();
        Location gatherLocation = BiterWaves.getAttackGatherLocation(target);
        if (gatherLocation == null) {
            TUMaths.dm("Biter Attack could not find eligible spawn location.");
            return;
        }
        int localEvo = (int)((double)BiterWaves.getLocalEvolution(gatherLocation) * 0.8);
        int min = (int)Math.floor(Math.min((double)gridToAttack.getGridScore() / 200.0, 1.0) * 100.0);
        int gridEvo = (int)((double)min * 0.2);
        int totalEvo = localEvo + gridEvo;
        int biterCount = gridToAttack.getGridScore() / 5;
        if (biterCount >= MineMain.attackBitersMax) {
            biterCount = MineMain.attackBitersMax;
        }
        BiterAttack ba = new BiterAttack(gatherLocation);
        ba.setGatherTime(5);
        ba.setAttackLocation(target);
        ba.onlyTargetsPolluting = false;
        int i = 0;
        while (i < biterCount) {
            ba.addBiter(BiterWaves.getBiterSpawnType(totalEvo));
            ++i;
        }
    }

    public static Location getAttackGatherLocation(Location target) {
        int i = 0;
        while (i <= 10) {
            Location potentialLocation = BiterWaves.getRandomEdgeLocation(target, 128.0);
            if (potentialLocation.getChunk().getInhabitedTime() >= 36000L) {
                return potentialLocation;
            }
            ++i;
        }
        return null;
    }

    public static Location getRandomEdgeLocation(Location center, double radius) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be greater than 0");
        }
        World world = center.getWorld();
        double angle = random.nextDouble() * 2.0 * Math.PI;
        double x = center.getX() + radius * Math.cos(angle);
        double z = center.getZ() + radius * Math.sin(angle);
        int y = world.getHighestBlockYAt((int)x, (int)z);
        return new Location(world, x, (double)y, z);
    }

    public static String getBiterSpawnType(int evoPercent) {
        String type = null;
        String baseType = "Biter";
        if (evoPercent >= 15 && TUMaths.rollRange(0, 99) <= evoPercent / 2) {
            baseType = "Spitter";
        }
        if (baseType.equals("Spitter")) {
            type = "Small Spitter";
            if (evoPercent >= 20 && TUMaths.rollRange(0, 99) <= evoPercent) {
                type = "Medium Spitter";
            }
            if (evoPercent >= 40 && TUMaths.rollRange(0, 99) <= evoPercent) {
                type = "Big Spitter";
            }
            if (evoPercent >= 70 && TUMaths.rollRange(0, 99) <= evoPercent) {
                type = "Behemoth Spitter";
            }
        } else {
            type = "Small Biter";
            if (evoPercent >= 10 && TUMaths.rollRange(0, 99) <= evoPercent) {
                type = "Medium Biter";
            }
            if (evoPercent >= 30 && TUMaths.rollRange(0, 99) <= evoPercent) {
                type = "Big Biter";
            }
            if (evoPercent >= 60 && TUMaths.rollRange(0, 99) <= evoPercent) {
                type = "Behemoth Biter";
            }
        }
        return type;
    }

    public static int getLocalEvolution(Location loc) {
        int evo = 0;
        SuperChunk sc = SuperChunk.getSuperChunk(loc);
        ArrayList<SuperChunk> scs = new ArrayList<SuperChunk>(sc.getNeibors(true));
        scs.add(sc);
        for (SuperChunk near : scs) {
            int evoPCT = near.getEvolutionPercent();
            if (evoPCT > 100) {
                evoPCT = 100;
            }
            evo += evoPCT;
        }
        return evo / 9;
    }

    public static boolean beingPolluted(Location loc) {
        SuperChunk sc = SuperChunk.getSuperChunk(loc);
        if (sc.getPollution() > 0) {
            return true;
        }
        for (SuperChunk near : sc.getNeibors(true)) {
            if (near.getPollution() <= 0) continue;
            return true;
        }
        return false;
    }
}

