/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BatteryMonitor
extends Device {
    private static final long serialVersionUID = -4449401797254451315L;
    private int onPercent = 60;
    private int offPercent = 30;
    private boolean onState = true;
    private boolean inverted = false;
    private HashSet<String> attachedLocations = new HashSet();
    private transient int delay = 0;

    public BatteryMonitor(Location loc) {
        super(loc);
        this.setMaterial("OBSERVER");
        this.deviceName = "Battery Monitor";
        this.setActionTimer(1);
        this.setActionPower(0);
        this.setIdlePower(0);
        this.setOpenable(true);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setStoreForm(false);
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device can be linked to other devices.");
        lore.add("- Right click with a wire tool to do so.");
        lore.add("- Can set a battery level to turn on & off at.");
        lore.add("- Connected devices will turn on/off based on battery level.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> gridInfo = new ArrayList<String>();
        int maxCap = 0;
        int bat = 0;
        int percent = 0;
        if (this.getGrid() != null) {
            maxCap = this.getGrid().batteryMaxCapacity();
            bat = this.getGrid().batteryPower();
            percent = (int)((double)this.getGrid().batteryPower() / ((double)this.getGrid().batteryMaxCapacity() * 1.0) * 100.0);
        }
        Object capStr = "" + maxCap;
        Object batStr = "" + bat;
        if (maxCap > 1000) {
            capStr = TUMaths.simplifyNumber(maxCap);
            batStr = TUMaths.simplifyNumber(bat);
        }
        gridInfo.add(MineUtil.colon(" Stored Power", (String)batStr + "/" + (String)capStr + " - " + percent + "%"));
        gridInfo.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Invert Power Signal"));
        gridInfo.add(MineUtil.colon(" Inverting Signal", "" + this.inverted));
        gridInfo.add(MineUtil.colon(" Connections", "" + this.attachedLocations.size()));
        gridInfo.add(" ");
        if (this.onState) {
            gridInfo.add(MineItems.whiteBold() + " Devices On!");
        } else {
            gridInfo.add(MineItems.whiteBold() + " Devices Off!");
        }
        Object infoString = "";
        infoString = !this.inverted ? " Turning off below " + this.offPercent + "%, turning on above " + this.onPercent + "%" : " Turning off above " + this.offPercent + "%, turning on below " + this.onPercent + "%";
        gridInfo.add(String.valueOf(ChatColor.WHITE) + (String)infoString);
        if (!this.getFailReason().equals("None")) {
            gridInfo.add(String.valueOf(ChatColor.RED) + this.getFailReason());
        }
        ItemStack powerStack = TUItems.setModelData(TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.whiteBold()) + "Grid Information", gridInfo), 9524);
        Inventory inv = this.getInventory();
        inv.setItem(13, TUItems.setModelData(powerStack, 9533));
        inv.setItem(11, TUItems.setModelData(TUItems.createItem(Material.LIGHTNING_ROD, MineItems.whiteBold() + "Target Off %", TUItems.basicLore(MineUtil.colon(" Current", this.offPercent + "%"), MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Decrease By 10%"), MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Increase By 10%"))), 9532));
        inv.setItem(15, TUItems.setModelData(TUItems.createItem(Material.REDSTONE_TORCH, MineItems.whiteBold() + "Target On %", TUItems.basicLore(MineUtil.colon(" Current", this.onPercent + "%"), MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Decrease By 10%"), MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Increase By 10%"))), 9534));
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13 && i != 11 && i != 15) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 13) {
            boolean bl = this.inverted = !this.inverted;
            if (this.inverted) {
                this.onPercent = 30;
                this.offPercent = 60;
            } else {
                this.onPercent = 60;
                this.offPercent = 30;
            }
            this.toggleAttached();
        }
        if (event.getSlot() == 11) {
            if (event.isLeftClick()) {
                this.setOffPercent(this.getOffPercent() - 10);
            }
            if (event.isRightClick()) {
                this.setOffPercent(this.getOffPercent() + 10);
            }
        }
        if (event.getSlot() == 15) {
            if (event.isLeftClick()) {
                this.setOnPercent(this.getOnPercent() - 10);
            }
            if (event.isRightClick()) {
                this.setOnPercent(this.getOnPercent() + 10);
            }
        }
        if (this.getOnPercent() > 100) {
            this.setOnPercent(100);
        }
        if (this.getOnPercent() < 0) {
            this.setOnPercent(0);
        }
        Player player = (Player)event.getWhoClicked();
        this.updateUI();
        player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
    }

    @Override
    public void action() {
        if (this.delay < 2) {
            ++this.delay;
            return;
        }
        if (!this.inverted) {
            if (this.getOffPercent() >= this.getOnPercent()) {
                this.setFailReason("Off percent must be lower then on percent.");
                return;
            }
        } else if (this.getOnPercent() >= this.getOffPercent()) {
            this.setFailReason("On percent must be higher then off percent.");
            return;
        }
        if (this.getGrid() != null) {
            int currentGridPercent = (int)((double)this.getGrid().batteryPower() / ((double)this.getGrid().batteryMaxCapacity() * 1.0) * 100.0);
            if (!this.inverted) {
                if (currentGridPercent >= this.getOnPercent() && !this.onState) {
                    this.onState = true;
                    this.tripSound();
                }
                if (currentGridPercent <= this.getOffPercent() && this.onState) {
                    this.onState = false;
                    this.tripSound();
                }
            } else {
                if (currentGridPercent >= this.getOffPercent() && this.onState) {
                    this.onState = false;
                    this.tripSound();
                }
                if (currentGridPercent <= this.getOnPercent() && !this.onState) {
                    this.onState = true;
                    this.tripSound();
                }
            }
            this.toggleAttached();
        }
    }

    private void toggleAttached() {
        for (String strLoc : new ArrayList<String>(this.attachedLocations)) {
            Location loc = TUMaths.getStringLocation(strLoc);
            Device device = Device.getDevice(loc);
            if (device != null) {
                if (this.onState) {
                    device.setPoweredState(Device.PoweredState.ON);
                    continue;
                }
                device.setPoweredState(Device.PoweredState.OFF_BATTERY_MONITOR);
                continue;
            }
            this.removeLocation(loc);
        }
    }

    private void tripSound() {
        if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
            this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_LEVER_CLICK, 0.5f, 1.0f);
        }
    }

    @Override
    public void cleanup() {
        for (String strLoc : new ArrayList<String>(this.attachedLocations)) {
            Location loc = TUMaths.getStringLocation(strLoc);
            Device device = Device.getDevice(loc);
            if (device == null) continue;
            device.setPoweredState(Device.PoweredState.ON);
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.COMPASS, 1.0);
    }

    public int getOnPercent() {
        return this.onPercent;
    }

    public void setOnPercent(int onPercent) {
        this.onPercent = onPercent;
    }

    public void addLocation(Location loc) {
        String strLoc = TUMaths.locationString(loc);
        if (!this.attachedLocations.contains(strLoc)) {
            this.attachedLocations.add(strLoc);
        }
    }

    public void removeLocation(Location loc) {
        this.attachedLocations.remove(TUMaths.locationString(loc));
    }

    public boolean hasLocation(Location loc) {
        return this.attachedLocations.contains(TUMaths.locationString(loc));
    }

    public int getOffPercent() {
        return this.offPercent;
    }

    public void setOffPercent(int offPercent) {
        this.offPercent = offPercent;
    }
}

