/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Planets.PlanetHandler;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import com.MT.xxxtrigger50xxx.StoryTeller;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

public class MoonlightPanel
extends Device {
    private static final long serialVersionUID = -3912409797254451315L;
    private StoryTeller.CloudEnviroment cEnv;

    public MoonlightPanel(Location loc) {
        super(loc);
        this.setMaterial("DAYLIGHT_DETECTOR");
        this.deviceName = "Moonlight Panel";
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(5);
        this.setStoreForm(false);
        this.setPowerGen(4);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This needs clear sky access! Light level 15!");
        lore.add("- Creates max power output during midnight.");
        lore.add("- Power generation can shift up and down.");
        lore.add("- This is due to cloud coverage.");
        lore.add("- This can be avoided by going above the clouds!");
        lore.add("- This device can still be used as a night detector!");
        lore.add("- This device is effected by the moon cycle greatly.");
        return lore;
    }

    @Override
    public void postCreate(boolean isFirstTime) {
        if (this.cEnv == null) {
            double temp = this.getLocation().getBlock().getTemperature();
            this.cEnv = StoryTeller.CloudEnviroment.TEMPERATE;
            if (temp <= 0.3) {
                this.cEnv = StoryTeller.CloudEnviroment.COLD;
            }
            if (temp >= 1.0) {
                this.cEnv = StoryTeller.CloudEnviroment.HOT;
            }
        }
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void action() {
        if (this.getGrid() != null && this.getLocation().getBlock().getLightFromSky() == 15 && this.cEnv != null) {
            this.setProducingPower(false);
            int power = 0;
            World world = this.getLocation().getBlock().getWorld();
            if (world.getTime() >= 0L) {
                ++power;
            }
            if (world.getTime() >= 12000L) {
                ++power;
            }
            if (world.getTime() >= 14000L) {
                ++power;
            }
            if (world.getTime() >= 20000L) {
                --power;
            }
            if (world.getTime() >= 22000L) {
                --power;
            }
            if (world.getTime() >= 0L && world.getTime() <= 12000L) {
                power = 0;
            }
            if (power > 0 && world.hasStorm()) {
                power /= 2;
            }
            int clouds = MineMain.storyteller.getCurrentCloudLevel(this.getCloudEnviroment());
            if ((double)MineMain.cloudYLevel < this.getLocation().getY()) {
                power -= clouds;
            }
            if (power > 0) {
                int phase = MoonlightPanel.getMoonPhase(world);
                if (phase != 0) {
                    if (phase != 4) {
                        if (phase == 2 || phase == 6) {
                            --power;
                        }
                        if (phase == 3 || phase == 5) {
                            --power;
                        }
                    } else {
                        power = 0;
                    }
                } else if (clouds <= 1) {
                    ++power;
                }
            }
            if ((power = this.planetAdjustment(power)) > 0) {
                this.getGrid().addPower(this, power);
                if (power > 0) {
                    this.setProducingPower(true);
                }
            }
        }
    }

    public int planetAdjustment(int power) {
        Planet planet = PlanetHandler.getPlanetByWorld(this.getLocationREADONLY().getWorld().getName());
        if (planet != null) {
            return (int)((double)power * planet.getMoonDistance());
        }
        return power;
    }

    public StoryTeller.CloudEnviroment getCloudEnviroment() {
        return this.cEnv;
    }

    public static int getMoonPhase(World world) {
        long day = world.getFullTime() / 24000L;
        return (int)(day % 8L);
    }

    public static void addRecipe() {
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Copper Cable", 2));
        ings.add(new ItemStack(Material.AMETHYST_SHARD, 3));
        ings.add(new ItemStack(Material.QUARTZ, 2));
        ings.add(new ItemStack(Material.REDSTONE, 2));
        RecipeUtils.addDefaultRecipe(new MoonlightPanel(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, true);
    }
}

