/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Liquids;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Liquids.LiquidUtil;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pipe;
import com.MT.xxxtrigger50xxx.Devices.Liquids.PipeLine;
import com.MT.xxxtrigger50xxx.Devices.Manufactoring.OilRefinery;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.ResourceZone;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;

public class Pump
extends Device {
    private static final long serialVersionUID = -3929401797254451315L;
    int waterAmount = 0;
    int waterPerTick = 0;
    public static int maxWater = 100;
    private transient HashSet<Device> lastDevices = new HashSet();
    private transient boolean scannedPipes = false;
    private transient Device.LiquidType extractionType;
    private transient HashSet<Device> cachedDevices = null;
    private transient boolean waterBelow = false;

    public Pump(Location loc) {
        super(loc);
        this.setMaterial("HOPPER");
        this.deviceName = "Pump";
        this.setActionTimer(3);
        this.setActionPower(3);
        this.setIdlePower(1);
        this.setOpenable(true);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setStoreForm(false);
        if (loc != null) {
            this.updateWaterPerTick();
        }
        this.displayYawOffset = 90;
        this.updateDeviceHeadItem();
    }

    private void updateWaterPerTick() {
        this.waterAmount = Pump.calculateLiquidBlocks(this.getLocation(), 25, Material.WATER, 50);
        this.waterPerTick = this.waterAmount / 25 * maxWater;
    }

    private int getWaterPerTick() {
        return this.waterPerTick * (1 + this.getEffectiveDrive());
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.GREEN) + "+ " + maxWater + "\ud83d\udca7");
        lore.add("- This pulls liquids & gases from under it.");
        lore.add("- It then outputs it into any connected pipes.");
        lore.add("- If placed in an oil zone, it will extract oil.");
        lore.add("- So long as it has a solid block under it.");
        lore.add("- Requires 25 water blocks for full " + maxWater + " output.");
        lore.add("- Overdriving also increases liquid per action.");
        return lore;
    }

    @Override
    public void updateUI() {
        ResourceZone rz;
        Object str = "Water";
        if (this.extractionType != null) {
            str = this.extractionType.toString().toLowerCase().substring(0, 1).toUpperCase() + this.extractionType.toString().toLowerCase().substring(1);
        }
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" " + (String)str + " Per Action", this.getWaterPerTick() + " " + String.valueOf(ChatColor.GRAY) + "(" + TUMaths.roundDouble((double)this.getWaterPerTick() / 3.0, 2) + "s)"));
        lore.add(MineUtil.colon(" Action Time", this.getActionTimer() + "s"));
        lore.add(MineUtil.colon(" Current Timer", this.getCurrentTimer() + "s"));
        int size = 0;
        if (this.getGrid() != null) {
            size = this.getGrid().gridSize();
        }
        lore.add(MineUtil.colon(" Connected Grid Size", "" + size));
        if (this.extractionType != null && this.extractionType.equals((Object)Device.LiquidType.OIL) && (rz = this.getOilZone()) != null) {
            lore.add(" ");
            lore.add(MineUtil.colon(" Remaining Oil", "" + rz.getStoredResource()));
        }
        if (!this.getFailReason().equals("None")) {
            lore.add(String.valueOf(ChatColor.RED) + " - " + this.getFailReason());
        }
        if (this.getWaterPerTick() == 0 && this.extractionType != null && this.extractionType.equals((Object)Device.LiquidType.WATER)) {
            lore.add(String.valueOf(ChatColor.RED) + " - No water beneath device.");
        }
        ItemStack waterStack = TUItems.createItem(Material.HOPPER, MineItems.whiteBold() + "Device Information", lore);
        waterStack = TUItems.setModelData(waterStack, 9256);
        Inventory inv = this.getInventory();
        inv.setItem(13, waterStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void action() {
        if (this.extractionType == null) {
            this.updateExtractionType(TUMaths.isPlayerNearby(this.getLocation(), 8.0));
        }
        PipeLine.pipeLineCheck(this.getLocation().getBlock().getRelative(BlockFace.UP));
        if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
            boolean nearby = TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance);
            this.updateExtractionType(TUMaths.isPlayerNearby(this.getLocation(), 8.0));
            if (this.extractionType != null) {
                if (this.extractionType.equals((Object)Device.LiquidType.WATER) && !this.waterBelow) {
                    return;
                }
                this.setFailReason("None");
                if (!this.scannedPipes || nearby) {
                    this.scannedPipes = true;
                    if (LiquidUtil.isPipeBlock(this.getLocation().getBlock().getRelative(BlockFace.UP))) {
                        this.getGrid().consumePower(this, this.getActionPower());
                        if (TUMaths.isPlayerNearby(this.getLocation(), 64.0) || this.cachedDevices == null) {
                            this.cachedDevices = LiquidUtil.getConnectedDevices(this.getLocation().getBlock(), this.extractionType);
                        }
                        for (Device device : new HashSet<Device>(this.cachedDevices)) {
                            if (!device.isRemoved()) continue;
                            this.cachedDevices.remove(device);
                        }
                        this.lastDevices = new HashSet<Device>(this.cachedDevices);
                        if (this.extractionType.equals((Object)Device.LiquidType.OIL)) {
                            for (Device device : new ArrayList<Device>(this.cachedDevices)) {
                                if (!(device instanceof OilRefinery)) continue;
                                OilRefinery or = (OilRefinery)device;
                                Device.LiquidType liquid = or.getInputLiquid();
                                if (liquid == null) {
                                    if (this.extractionType.equals((Object)Device.LiquidType.OIL)) continue;
                                    this.cachedDevices.remove(device);
                                    continue;
                                }
                                if (liquid.equals((Object)this.extractionType)) continue;
                                this.cachedDevices.remove(device);
                            }
                        }
                        this.moveLiquids(this.cachedDevices, this.extractionType, TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance));
                    } else {
                        this.setFailReason("No connected pipe (Diorite Wall) above");
                    }
                } else if (this.lastDevices != null && this.lastDevices.size() > 0) {
                    this.moveLiquids(this.lastDevices, this.extractionType, TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance));
                }
            }
        }
    }

    public Device.LiquidType getExtractionType() {
        return this.extractionType;
    }

    private void updateExtractionType(boolean playerNear) {
        if (playerNear || this.extractionType == null) {
            ResourceZone rz = this.getOilZone();
            this.waterBelow = this.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.WATER);
            if (rz != null && !this.waterBelow) {
                this.extractionType = Device.LiquidType.OIL;
                this.waterPerTick = maxWater;
                return;
            }
            this.extractionType = Device.LiquidType.WATER;
        }
    }

    private void moveLiquids(HashSet<Device> devices, Device.LiquidType liquidType, boolean playerNear) {
        ResourceZone rz = this.getOilZone();
        if (devices.size() > 0) {
            boolean waterGiven = false;
            int baseWaterEach = this.getWaterPerTick() / devices.size();
            for (Device device2 : devices) {
                if (device2.getStoredLiquid(liquidType) >= device2.getMaxLiquid(liquidType)) continue;
                waterGiven = true;
                int liquidNeeded = device2.getMaxLiquid(liquidType) - device2.getStoredLiquid(liquidType);
                if (liquidNeeded > baseWaterEach) {
                    device2.addLiquid(liquidType, baseWaterEach);
                    this.getGrid().logLiquid(liquidType, baseWaterEach);
                    if (!liquidType.equals((Object)Device.LiquidType.OIL) || rz == null) continue;
                    rz.extractResource(baseWaterEach);
                    continue;
                }
                device2.addLiquid(liquidType, liquidNeeded);
                this.getGrid().logLiquid(liquidType, liquidNeeded);
                if (!liquidType.equals((Object)Device.LiquidType.OIL) || rz == null) continue;
                rz.extractResource(liquidNeeded);
            }
            if (playerNear && waterGiven) {
                this.getLocation().getBlock().getWorld().playSound(this.getLocation(), Sound.ITEM_BOTTLE_FILL, 0.5f, 0.8f);
            }
            if (waterGiven && Pipe.isPipe(this.getLocation().getBlock().getRelative(BlockFace.UP))) {
                Pipe pipe = (Pipe)((MetadataValue)this.getLocation().getBlock().getRelative(BlockFace.UP).getMetadata("MT-Pipe").get(0)).value();
                pipe.getLine().addLiquidType(liquidType);
                pipe.getLine().decorTickPipeLine();
            }
        }
    }

    private ResourceZone getOilZone() {
        for (ResourceZone rz : ResourceZone.getNearResourceZones(this.getLocation())) {
            if (rz == null || rz.getResourceType() == null || !rz.getResourceType().equals("OIL") || rz.getStoredResource() <= 0) continue;
            return rz;
        }
        return null;
    }

    public static int calculateLiquidBlocks(Location start, int maxBlocks, Material liquidType, int maxRange) {
        if (start == null || maxBlocks <= 0) {
            return 0;
        }
        World world = start.getWorld();
        if (world == null) {
            return 0;
        }
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        int liquidBlocks = 0;
        Block startBlock = start.getBlock();
        queue.offer(startBlock);
        while (!queue.isEmpty() && liquidBlocks < maxBlocks) {
            Block currentBlock = (Block)queue.poll();
            visited.add(currentBlock);
            BlockFace[] blockFaceArray = BlockFace.values();
            int n = blockFaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                BlockFace face = blockFaceArray[n2];
                Block neighborBlock = currentBlock.getRelative(face);
                Location neighborLoc = neighborBlock.getLocation();
                if (!visited.contains(neighborBlock) && neighborBlock.getType().equals((Object)liquidType) && TUMaths.getManhattanDistance(start, neighborLoc) <= maxRange) {
                    queue.offer(neighborBlock);
                    visited.add(neighborBlock);
                    ++liquidBlocks;
                }
                ++n2;
            }
        }
        return liquidBlocks;
    }
}

