/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Sheep;
import org.bukkit.inventory.ItemStack;

public class AutoShearer
extends Device {
    private static final long serialVersionUID = 7571974070728037025L;
    private transient Item item = null;

    public AutoShearer(Location loc) {
        super(loc);
        this.setMaterial("SMOOTH_STONE_SLAB");
        this.deviceName = "Auto Shearer";
        this.setActionTimer(5);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(3);
        this.useAutoSlots();
        this.setPollutionGen(5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will shear any nearby sheep!");
        lore.add("- This requires a set of shears to be in the input slots to operate.");
        lore.add("- Input slots are the top row of slots.");
        lore.add("- Each wool collected is placed into its own output slot.");
        lore.add("- A mover will only extract items from the output slots.");
        lore.add("- Output slots are the bottom row of slots.");
        lore.add("- Range is limited to a 10x10x10 area.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.SHEARS, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance);
            boolean hasShears = false;
            boolean sheared = false;
            for (Entity entity : MineUtil.getEntitiesInCubeRange(this.getLocation(), 5.0)) {
                if (!this.getGrid().hasPower(this.getActionPower()) || this.getOutputSlot() == -1) break;
                for (ItemStack stack : this.getInventory()) {
                    Sheep sheep;
                    if (stack == null || !stack.getType().equals((Object)Material.SHEARS) || stack.getItemMeta().hasDisplayName()) continue;
                    hasShears = true;
                    if (!entity.getType().equals((Object)EntityType.SHEEP) || (sheep = (Sheep)entity).isSheared()) break;
                    if (playerNear) {
                        MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), sheep.getEyeLocation(), MineMain.version.getDrippingLavaParticle(), 1, 0.5);
                    }
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    Material mat = Material.matchMaterial((String)(String.valueOf(sheep.getColor().toString()) + "_WOOL"));
                    ItemStack wool = new ItemStack(mat, TUMaths.rollRange(1, 3));
                    this.getInventory().setItem(this.getOutputSlot(), wool);
                    this.logItem(wool);
                    MineUtil.damageItemStack(stack, this.getLocation(), this.getInventory());
                    playSound = true;
                    sheep.setSheared(true);
                    sheared = true;
                    break;
                }
                if (sheared) break;
            }
            if (playSound) {
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_SHEEP_SHEAR, 1.0f, 1.0f);
            } else if (!hasShears) {
                this.spawnInactiveParticles();
                this.setFailReason("Missing Shears");
            }
        }
    }
}

