/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.ShipCore;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.PlanetHandler;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class HumanTeleporter
extends Device {
    private static final long serialVersionUID = 7111971120728037017L;
    private transient Item item;
    public int lastTPPrice = 0;
    private static HashMap<UUID, HumanTeleporter> selecting = new HashMap();
    String worldType = null;
    private transient Location attachedLoc = null;
    private String attached = null;

    public HumanTeleporter(Location loc) {
        super(loc);
        this.setMaterial("CHISELED_STONE_BRICKS");
        this.deviceName = "Human Teleporter";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(3);
        this.setActionPower(1);
        this.useAutoSlots();
        this.updateDeviceHeadItem();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.ENDER_PEARL, 1.0);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Teleports players to another Human Teleporter.");
        lore.add("- You can attach them using a wire tool!");
        lore.add("- Power usage changes based on distance.");
        if (MineMain.humanTeleportRange != -1) {
            lore.add("- Has a max range of " + MineMain.humanTeleportRange + " blocks.");
        }
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Teleport Power", "" + this.lastTPPrice));
        return lore;
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public boolean onWireRightClick(PlayerInteractEvent event) {
        if (!selecting.containsKey(event.getPlayer().getUniqueId())) {
            selecting.put(event.getPlayer().getUniqueId(), this);
            MineUtil.sendMessage(event.getPlayer(), LocaleUtil.messageText("Human_Teleporter_Select"));
            event.setCancelled(true);
            MinetorioListener.delayRightClick(event.getPlayer(), 20L);
            return true;
        }
        if (!this.equals(selecting.get(event.getPlayer().getUniqueId()))) {
            boolean otherWorld;
            int distance = TUMaths.getManhattanDistance(selecting.get(event.getPlayer().getUniqueId()).getLocation(), event.getClickedBlock().getLocation());
            boolean bl = otherWorld = !selecting.get(event.getPlayer().getUniqueId()).getLocation().getWorld().equals(event.getClickedBlock().getLocation().getWorld());
            if (distance <= MineMain.humanTeleportRange || MineMain.humanTeleportRange == -1 || otherWorld) {
                Device device = Device.getDevice(event.getClickedBlock().getLocation());
                if (device != null && device instanceof HumanTeleporter) {
                    selecting.get(event.getPlayer().getUniqueId()).setAttached(TUMaths.locationString(event.getClickedBlock().getLocation()));
                    if (otherWorld) {
                        MineUtil.sendMessage(event.getPlayer(), LocaleUtil.messageText("Human_Teleporter_World_Linked"));
                    } else {
                        MineUtil.sendMessage(event.getPlayer(), LocaleUtil.messageText("Human_Teleporter_Linked"));
                    }
                } else {
                    MineUtil.sendWarning(event.getPlayer(), LocaleUtil.messageText("Human_Teleporter_Aborted"));
                }
            } else {
                MineUtil.sendWarning(event.getPlayer(), LocaleUtil.messageText("Human_Teleporter_Aborted_Distance").replace("%distance%", "" + distance).replace("%range%", "" + MineMain.humanTeleportRange));
            }
            selecting.remove(event.getPlayer().getUniqueId());
            event.setCancelled(true);
            MinetorioListener.delayRightClick(event.getPlayer(), 20L);
            return true;
        }
        return false;
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            Location attached = this.getAttachedLocation();
            if (attached != null) {
                Device device = Device.getDevice(attached);
                if (device == null) {
                    this.setAttached(null);
                    this.setFailReason("No attached teleporter");
                } else {
                    if (this.worldType == null) {
                        this.worldType = this.getLocation().getWorld().getEnvironment().toString();
                    }
                    if (!this.getLocation().getWorld().equals(this.getAttachedLocation().getWorld())) {
                        int power;
                        String planetName;
                        String otherWorld;
                        ArrayList<ShipCore> nearby;
                        ShipCore core;
                        this.lastTPPrice = 1000;
                        if (this.getLocation().getWorld().getName().equals("MT_world_space")) {
                            core = null;
                            nearby = ShipCore.getCores(this.getPlacerUUID(), this.getLocation());
                            if (nearby.size() > 0) {
                                core = nearby.get(0);
                            }
                            if (core != null) {
                                otherWorld = this.getAttachedLocation().getWorld().getName();
                                planetName = PlanetHandler.getPlanetByWorld(otherWorld).getPlanetName();
                                power = (int)(core.getDistanceToTargetPlanet(planetName) / 2.0);
                                if (power < 50) {
                                    power = 50;
                                }
                                this.lastTPPrice = power;
                            }
                        }
                        if (this.getAttachedLocation().getWorld().getName().equals("MT_world_space")) {
                            core = null;
                            nearby = ShipCore.getCores(this.getPlacerUUID(), this.getAttachedLocation());
                            if (nearby.size() > 0) {
                                core = nearby.get(0);
                            }
                            if (core != null) {
                                otherWorld = this.getLocation().getWorld().getName();
                                planetName = PlanetHandler.getPlanetByWorld(otherWorld).getPlanetName();
                                power = (int)(core.getDistanceToTargetPlanet(planetName) / 2.0);
                                if (power < 50) {
                                    power = 50;
                                }
                                this.lastTPPrice = power;
                            }
                        }
                    } else {
                        this.lastTPPrice = TUMaths.getManhattanDistance(this.getLocation(), this.getAttachedLocation()) / 2;
                    }
                    if (this.worldType.equals("NETHER") && this.lastTPPrice != 0) {
                        this.lastTPPrice /= 2;
                    }
                }
            } else {
                this.setFailReason("No attached teleporter");
            }
        }
    }

    public Location getAttachedLocation() {
        if (this.attachedLoc != null) {
            return this.attachedLoc;
        }
        if (this.attached != null) {
            this.attachedLoc = TUMaths.getStringLocation(this.attached);
            return this.attachedLoc;
        }
        return null;
    }

    public String getAttached() {
        return this.attached;
    }

    public void setAttached(String attached) {
        this.attachedLoc = null;
        this.attached = attached;
    }

    public boolean isAttached() {
        Device device;
        Location attached = this.getAttachedLocation();
        return attached != null && (device = Device.getDevice(attached)) instanceof HumanTeleporter;
    }

    public boolean canTeleport() {
        Device device;
        if (this.isAttached() && (device = Device.getDevice(this.getAttachedLocation())) instanceof HumanTeleporter) {
            HumanTeleporter ht = (HumanTeleporter)device;
            return ht.isPowered();
        }
        return false;
    }

    public void teleport(Player who) {
        if (this.getAttachedLocation() != null) {
            Location tpLoc = this.getAttachedLocation().clone().add(0.5, 1.0, 0.5);
            tpLoc.setYaw(who.getEyeLocation().getYaw());
            tpLoc.setPitch(who.getEyeLocation().getPitch());
            who.teleport(tpLoc);
            who.getWorld().playSound(who.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        }
    }

    public static void addRecipe() {
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Advanced Circuit"));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 7));
        ings.add(new ItemStack(Material.ENDER_PEARL));
        RecipeUtils.addDefaultRecipe(new HumanTeleporter(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, false);
    }
}

