/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class ItemTeleporter
extends Device {
    private static final long serialVersionUID = 7111973330728037017L;
    private transient Item item;
    private int lastTPPrice = 0;
    String worldType = null;
    private transient Location attachedLoc = null;
    private String attached = null;

    public ItemTeleporter(Location loc) {
        super(loc);
        this.setMaterial("END_STONE_BRICK_SLAB");
        this.deviceName = "Item Teleporter";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(3);
        this.setActionPower(1);
        this.useAutoSlots();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.ENDER_PEARL, 0.5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Teleports input items to another item teleporter.");
        lore.add("- The items teleported go into the output slots of the target.");
        lore.add("- You can attach them using a wire tool!");
        lore.add("- Power usage changes based on distance.");
        lore.add("- Has a max range of 32 blocks.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Teleport Power", "" + this.lastTPPrice));
        return lore;
    }

    @Override
    public void cleanup() {
        this.setActionPower(1);
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            Location loc = this.getAttachedLocation();
            if (loc != null) {
                Device device = Device.getDevice(loc);
                if (device != null) {
                    if (device instanceof ItemTeleporter) {
                        ItemTeleporter it = (ItemTeleporter)device;
                        if (it.getOutputSlot() != -1) {
                            if (this.worldType == null) {
                                this.worldType = this.getLocation().getWorld().getEnvironment().toString();
                            }
                            int powerCost = TUMaths.getManhattanDistance(this.getLocation(), this.getAttachedLocation()) / 2;
                            if (this.worldType.equals("NETHER") && powerCost != 0) {
                                powerCost /= 2;
                            }
                            this.setActionPower(powerCost);
                            this.lastTPPrice = powerCost;
                            if (this.getGrid().hasPower(powerCost)) {
                                if (it.isPowered()) {
                                    boolean teled = false;
                                    Iterator<ItemStack> iterator = this.getInputItems().iterator();
                                    if (iterator.hasNext()) {
                                        ItemStack stack = iterator.next();
                                        ItemStack teleStack = stack.clone();
                                        teleStack.setAmount(1);
                                        stack.setAmount(stack.getAmount() - 1);
                                        it.getInventory().setItem(it.getOutputSlot(), teleStack);
                                        teled = true;
                                        this.getGrid().consumePower(this, powerCost);
                                        this.setConsumingPower(true);
                                        if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
                                            this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.5f, 0.9f);
                                        }
                                        if (TUMaths.isPlayerNearby(this.getAttachedLocation(), MineMain.closeDistance)) {
                                            this.getLocation().getWorld().playSound(this.getAttachedLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.5f, 0.9f);
                                        }
                                    }
                                    if (!teled) {
                                        this.setFailReason("Nothing to teleport");
                                    }
                                } else {
                                    this.setFailReason("Linked isn't powered");
                                }
                            } else {
                                this.setFailReason("Need " + powerCost + " power");
                            }
                        } else {
                            this.setFailReason("No output space");
                        }
                    } else {
                        this.setFailReason("No set teleporter");
                    }
                } else {
                    this.setFailReason("No set teleporter");
                }
            } else {
                this.setFailReason("No set teleporter");
            }
        }
    }

    public Location getAttachedLocation() {
        if (this.attachedLoc != null) {
            return this.attachedLoc;
        }
        if (this.attached != null) {
            this.attachedLoc = TUMaths.getStringLocation(this.attached);
            return this.attachedLoc;
        }
        return null;
    }

    public String getAttached() {
        return this.attached;
    }

    public void setAttached(String attached) {
        this.attachedLoc = null;
        this.attached = attached;
    }
}

