/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterfaceScrolling;
import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Transport.Locomotive;
import com.MT.xxxtrigger50xxx.Devices.Transport.StationFinder;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class TrainStation
extends Device {
    public static boolean allowVirtualConnections = true;
    private static final long serialVersionUID = 7571974070728037026L;
    private static HashMap<String, TrainStation> stations = new HashMap();
    public HashMap<String, Integer> incomingLocomotives = new HashMap();
    public ArrayList<String> parkedLocomotives = new ArrayList();
    public ArrayList<String> connectedStations = new ArrayList();
    public ArrayList<String> virtuallyConnectedStations = new ArrayList();
    private String stationName;
    private int rails = 0;
    private int gravel = 0;
    private int sortCooldown = 0;
    private int rebuildConnectedTimer = 0;
    private int storedFuel = 0;

    public static ArrayList<TrainStation> getAllStations() {
        return new ArrayList<TrainStation>(stations.values());
    }

    public static TrainStation getStation(String id) {
        if (stations.containsKey(id)) {
            return stations.get(id);
        }
        return null;
    }

    public static ArrayList<TrainStation> getAuthedStations(UUID playerUUID) {
        ArrayList<TrainStation> stations = new ArrayList<TrainStation>();
        for (TrainStation station : TrainStation.getAllStations()) {
            if (!station.isAuthorized(playerUUID)) continue;
            stations.add(station);
        }
        return stations;
    }

    public TrainStation(Location loc) {
        super(loc);
        this.setStationName("Unnamed Station");
        this.setMaterial("CARTOGRAPHY_TABLE");
        this.deviceName = "Train Station";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(2);
        this.setActionPower(5);
        ArrayList<Integer> outputs = new ArrayList<Integer>();
        int j = 18;
        while (j <= 53) {
            outputs.add(j);
            ++j;
        }
        this.setOutputSlots(outputs);
        this.setInputSlots(outputs);
        this.setClickableSlots(outputs);
    }

    @Override
    public int getGridScore() {
        return 2;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Locomotives can be placed in input slots.");
        lore.add("- Once placed here you can manage them.");
        lore.add("- This uses a barrel below it for fueling.");
        lore.add("- Locomotives attempt to load / unload entire stacks.");
        return lore;
    }

    @Override
    public void recreateInv() {
        this.inv = TUInventory.createInventory(ChatColor.GOLD + ChatColor.BOLD + this.deviceName, 6, this.deviceName);
    }

    @Override
    public void updateUI() {
        int i = 9;
        while (i <= 17) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            ++i;
        }
        ItemStack stack = this.createInfoIcon();
        TUItems.addLore(stack, MineUtil.colon(" Stored Fuel", this.getStoredFuel() + "/1000"));
        TUItems.addLore(stack, MineUtil.colon(" Merge Timer", "" + this.sortCooldown));
        TUItems.addLore(stack, " ");
        TUItems.addLore(stack, MineUtil.wrapText(" Merge timer only goes down when there is no open slots in the train station. A sort can also trigger if there is an item over their total limit. Most items have a total limit of 256 or 4 stacks.", 45, ChatColor.WHITE, 1));
        if (!allowVirtualConnections) {
            this.getInventory().setItem(13, stack);
        } else {
            this.getInventory().setItem(12, stack);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Manage Connections"));
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Add Rails / Gravel"));
            lore.add(MineUtil.colon(" Rails", "" + this.rails));
            lore.add(MineUtil.colon(" Gravel", "" + this.gravel));
            lore.add(" ");
            String desc = "Connect stations without physically building rail lines between them here. This proccess still takes rails and some gravel to establish the connection. You can still physically connect stations, doing so will usually use a lot less rails and materials. But takes more time to setup.";
            for (String str : MineUtil.wrapText(desc, 45)) {
                lore.add(String.valueOf(ChatColor.WHITE) + " " + str);
            }
            ItemStack virtualStations = TUItems.createItem(Material.CARTOGRAPHY_TABLE, MineItems.goldBold() + "Virtual Stations", lore);
            this.getInventory().setItem(14, virtualStations);
        }
        int i2 = 0;
        for (Locomotive loco : this.getParkedLocomotives()) {
            this.getInventory().setItem(i2, TUItems.setModelData(this.createLocostack(loco, false), 9543));
            ++i2;
        }
        for (Locomotive loco : this.getIncomingLocomotives()) {
            this.getInventory().setItem(i2, TUItems.setModelData(this.createLocostack(loco, true), 9544));
            ++i2;
        }
        int i22 = i2;
        while (i22 < 9) {
            ArrayList<String> lore = TUItems.basicLore(String.valueOf(ChatColor.GRAY) + " An open port for a locomotive.");
            lore.add(String.valueOf(ChatColor.GRAY) + " Drop click a locomotive item here.");
            lore.add(String.valueOf(ChatColor.GRAY) + " This will park it here.");
            lore.add(String.valueOf(ChatColor.GRAY) + " Once parked you can modify it.");
            ItemStack rail = TUItems.setModelData(TUItems.createItem(Material.RAIL, MineItems.goldBold() + "Open Rail", lore), 9542);
            this.getInventory().setItem(i22, rail);
            ++i22;
        }
        if (this.getInventory().getViewers().size() > 0) {
            this.rebuildConnectedStations(true);
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        Material mat = Material.CHEST_MINECART;
        if (nearbyPlayer && (this.parkedLocomotives.size() > 0 || this.incomingLocomotives.size() > 0)) {
            mat = this.parkedLocomotives.size() == 0 && this.incomingLocomotives.size() > 0 ? Material.CLOCK : Material.CHEST_MINECART;
        }
        this.visualIconUpdate(nearbyPlayer, mat, 1.0);
    }

    private ItemStack createLocostack(Locomotive loco, boolean incoming) {
        ArrayList<String> lore = new ArrayList<String>();
        String pickupName = "Not set";
        String dropName = "Not set";
        if (loco.getPickupStation() != null) {
            pickupName = loco.getPickupStation().getStationName();
        }
        if (loco.getDropOffStation() != null) {
            dropName = loco.getDropOffStation().getStationName();
        }
        lore.add(MineUtil.colon(" Pickup Station", pickupName));
        lore.add(MineUtil.colon(" Dropoff Station", dropName));
        lore.add(MineUtil.colon(" Fuel", loco.getFuel() + "/100"));
        if (loco.getDropOffStation() != null && loco.getPickupStation() != null) {
            int cost = loco.tripFuel(loco.getDropOffStation().getLocation(), loco.getPickupStation().getLocation());
            String strCost = "" + cost;
            if (cost > 100) {
                strCost = String.valueOf(ChatColor.RED) + strCost;
            }
            lore.add(MineUtil.colon(" Roundtrip Fuel", strCost));
            if (cost > loco.getFuel()) {
                lore.add(String.valueOf(ChatColor.RED) + " Waiting on fuel, need charcoal or coal");
                lore.add(String.valueOf(ChatColor.RED) + " Add either to a barrel below station.");
            }
        }
        lore.add(" ");
        if (!incoming) {
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Manage Locomotive"));
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Remove Locomotive"));
            if (MineMain.allowTrainTeleports) {
                lore.add(MineUtil.colon(" Shift Left", "Take Train"));
            }
            Object dep = "None";
            if (loco.getDropOffStation() != null && loco.getDropOffStation().equals(this)) {
                dep = loco.getDropOffTime() == -1 ? "Once empty" : loco.getTimer() + "s";
            }
            if (loco.getPickupStation() != null && loco.getPickupStation().equals(this)) {
                dep = loco.getPickupTime() == -1 ? "Once full" : loco.getTimer() + "s";
            }
            lore.add(MineUtil.colon(" Departure Time", (String)dep));
            lore.add(" ");
            lore.addAll(MineUtil.wrapText("If you take the train you have to stay within 3 blocks of the train station to actually get teleported to the destination. Once the train arrives at the destination you will teleport with it. It can take sometime if its a far distance.", 45, ChatColor.GRAY, 1));
        } else {
            lore.add(String.valueOf(ChatColor.WHITE) + "Arriving in " + String.valueOf(this.incomingLocomotives.get(loco.getID())) + "s");
        }
        ItemStack stack = TUItems.createItem(Material.CHEST_MINECART, MineItems.goldBold() + loco.getLocomativeName(), lore);
        return stack;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        int slot = event.getSlot();
        Player player = (Player)event.getWhoClicked();
        if (slot <= 9 && event.getCurrentItem() != null) {
            if (event.getCurrentItem().getType().equals((Object)Material.CHEST_MINECART)) {
                Locomotive loco = null;
                if (this.parkedLocomotives.size() > slot) {
                    loco = Locomotive.getLocomotive(this.parkedLocomotives.get(slot));
                }
                if (loco != null) {
                    if (event.isLeftClick()) {
                        if (!event.isShiftClick()) {
                            loco.openEditor((Player)event.getWhoClicked(), this);
                            player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                        } else if (MineMain.allowTrainTeleports) {
                            for (Locomotive park : this.getParkedLocomotives()) {
                                park.disembarkFrom(player.getUniqueId().toString(), null, null);
                            }
                            loco.boardTrain(player);
                        }
                    } else {
                        for (ItemStack stack : loco.getInv()) {
                            HashMap notAdded;
                            if (stack == null || stack.getType().equals((Object)Material.AIR) || (notAdded = player.getInventory().addItem(new ItemStack[]{stack})).size() <= 0) continue;
                            player.getWorld().dropItemNaturally(player.getLocation(), MineItems.getIndustrialItem("Locomotive"));
                        }
                        Locomotive.removeLocomotive(loco);
                        loco.remove();
                        loco.getFile().delete();
                        this.parkedLocomotives.remove(loco.getID());
                        this.incomingLocomotives.remove(loco.getID());
                        HashMap notAdded = player.getInventory().addItem(new ItemStack[]{MineItems.getIndustrialItem("Locomotive")});
                        if (notAdded.size() > 0) {
                            player.getWorld().dropItemNaturally(player.getLocation(), MineItems.getIndustrialItem("Locomotive"));
                        }
                        this.updateUI();
                        player.playSound((Entity)player, Sound.BLOCK_FIRE_EXTINGUISH, 1.0f, 1.0f);
                    }
                }
            }
            if (event.getCurrentItem().getType().equals((Object)Material.RAIL) && event.getCursor() != null && MineItems.isIndustrialItem(event.getCursor(), "Locomotive")) {
                ItemStack stack = event.getCursor();
                stack.setAmount(stack.getAmount() - 1);
                event.setCursor(stack);
                Locomotive loco = new Locomotive();
                this.parkedLocomotives.add(loco.getID());
                this.updateUI();
                player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        }
        if (!allowVirtualConnections && event.getSlot() == 13 || event.getSlot() == 12 && allowVirtualConnections) {
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ InventoryClickEvent val$event;

                public ChatInput(String startMessage, boolean numbersonly, InventoryClickEvent inventoryClickEvent) {
                    this.val$event = inventoryClickEvent;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    TrainStation.this.setStationName(message);
                    ((Player)this.val$event.getWhoClicked()).openInventory(TrainStation.this.getInventory());
                }
            }
            ChatInput input = new ChatInput(String.valueOf(ChatColor.YELLOW) + "Enter the new station name in chat now!", false, event);
            player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            input.start((Player)event.getWhoClicked());
        }
        if (event.getSlot() == 14 && allowVirtualConnections) {
            player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            if (event.isLeftClick()) {
                this.virtualTrainStationViewer(player);
            }
            if (event.isRightClick()) {
                ItemStack gravel = new ItemStack(Material.GRAVEL);
                ItemStack rail = new ItemStack(Material.RAIL);
                for (ItemStack stack : player.getInventory()) {
                    if (stack == null) continue;
                    if (stack.isSimilar(gravel)) {
                        this.gravel += stack.getAmount();
                        stack.setAmount(0);
                    }
                    if (!stack.isSimilar(rail)) continue;
                    this.rails += stack.getAmount();
                    stack.setAmount(0);
                }
                MineUtil.sendMessage(player, LocaleUtil.messageText("Train_Adding_Rails"));
            }
        }
    }

    @Override
    public void dropInventory() {
        Location dropLoc = this.getLocation();
        World world = dropLoc.getWorld();
        for (ItemStack stack : this.getOutputItems()) {
            world.dropItemNaturally(dropLoc, stack);
        }
        ArrayList<Locomotive> locos = this.getParkedLocomotives();
        locos.addAll(this.getIncomingLocomotives());
        int dropAmount = locos.size();
        for (Locomotive loco : locos) {
            for (ItemStack stack : loco.getInv()) {
                if (stack == null || stack.getType().equals((Object)Material.AIR)) continue;
                world.dropItemNaturally(dropLoc, stack);
            }
            Locomotive.removeLocomotive(loco);
            loco.remove();
            loco.getFile().delete();
        }
        ItemStack dropss = MineItems.getIndustrialItem("Locomotive");
        dropss.setAmount(dropAmount);
        world.dropItemNaturally(dropLoc, dropss);
        stations.remove(this.getID());
    }

    @Override
    public void postCreate(boolean isFirstTime) {
        stations.put(this.getID(), this);
        if (this.virtuallyConnectedStations == null) {
            this.virtuallyConnectedStations = new ArrayList();
        }
    }

    private void rebuildConnectedStations(boolean force) {
        --this.rebuildConnectedTimer;
        if (this.rebuildConnectedTimer <= 0 || force) {
            this.connectedStations.clear();
            StationFinder sf = new StationFinder();
            for (TrainStation ts : sf.findConnectedCartographyTables(this.getLocation())) {
                this.connectedStations.add(ts.getID());
            }
            this.rebuildConnectedTimer = 30;
        }
    }

    @Override
    public void action() {
        if (this.getOutputSlot() == -1) {
            --this.sortCooldown;
            if (this.sortCooldown <= 0) {
                this.sortCooldown = 60;
                MineUtil.mergeItemStacks(this.getInventory(), this.getOutSlots());
            }
        }
        this.rebuildConnectedStations(false);
        for (String strLoco : new ArrayList<String>(this.incomingLocomotives.keySet())) {
            int timeLeft;
            Locomotive loco = Locomotive.getLocomotive(strLoco);
            if (loco.getAllBoarded().size() > 0) {
                for (String who : loco.getAllBoarded()) {
                    Player player = Bukkit.getPlayer((UUID)UUID.fromString(who));
                    if (player != null && player.isOnline()) {
                        Location fromStation = this.getLocation();
                        if (loco.getDropOffStation() != null && loco.getDropOffStation().equals(this)) {
                            fromStation = loco.getPickupStation().getLocation();
                        }
                        if (loco.getPickupStation() != null && loco.getPickupStation().equals(this)) {
                            fromStation = loco.getDropOffStation().getLocation();
                        }
                        if (TUMaths.getManhattanDistance(player.getLocation(), fromStation) <= 3) continue;
                        loco.disembarkFrom(who, "To Far", null);
                        continue;
                    }
                    loco.disembarkFrom(who, null, null);
                }
            }
            if ((timeLeft = this.incomingLocomotives.get(strLoco) - 1) > 0) {
                this.incomingLocomotives.put(strLoco, timeLeft);
                continue;
            }
            this.parkIncomingLocomotive(loco);
        }
        if (this.getStoredFuel() < 900 && this.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.BARREL)) {
            BlockInventoryHolder bih = (BlockInventoryHolder)this.getLocation().getBlock().getRelative(BlockFace.DOWN).getState();
            for (ItemStack stack : bih.getInventory()) {
                if (!TUItems.isValid(stack)) continue;
                if (MineItems.isIndustrialItem(stack, "Solid Fuel")) {
                    stack.setAmount(stack.getAmount() - 1);
                    this.setStoredFuel(this.getStoredFuel() + 60);
                    break;
                }
                if (!stack.getType().equals((Object)Material.COAL) && !stack.getType().equals((Object)Material.CHARCOAL)) continue;
                stack.setAmount(stack.getAmount() - 1);
                this.setStoredFuel(this.getStoredFuel() + 20);
                break;
            }
        }
        for (Locomotive loco : this.getParkedLocomotives()) {
            if (loco.getFuel() >= 100) continue;
            int needed = 100 - loco.getFuel();
            if (this.getStoredFuel() >= needed) {
                loco.setFuel(loco.getFuel() + needed);
                this.setStoredFuel(this.getStoredFuel() - needed);
                continue;
            }
            loco.setFuel(loco.getFuel() + this.getStoredFuel());
            this.setStoredFuel(0);
            break;
        }
        for (Locomotive loco : this.getParkedLocomotives()) {
            boolean tryDispatch = false;
            boolean hasFuel = false;
            if (loco.getDropOffStation() != null && loco.getDropOffStation().equals(this)) {
                if (loco.getPickupStation() != null) {
                    if (loco.getTimer() > 0) {
                        loco.setTimer(loco.getTimer() - 1);
                    }
                    if (loco.hasFuel(this.getLocation(), loco.getPickupStation().getLocation())) {
                        hasFuel = true;
                    }
                }
                if (loco.getDropOffTime() != -1) {
                    if (loco.getTimer() <= 0) {
                        tryDispatch = true;
                    }
                } else if (loco.getFirstStoredStack() == -1) {
                    tryDispatch = true;
                }
            }
            if (loco.getPickupStation() != null && loco.getPickupStation().equals(this)) {
                if (loco.getDropOffStation() != null) {
                    if (loco.getTimer() > 0) {
                        loco.setTimer(loco.getTimer() - 1);
                    }
                    if (loco.hasFuel(this.getLocation(), loco.getDropOffStation().getLocation())) {
                        hasFuel = true;
                    }
                }
                if (loco.getPickupTime() != -1) {
                    if (loco.getTimer() <= 0) {
                        tryDispatch = true;
                    }
                } else if (loco.firstEmpty() == -1) {
                    tryDispatch = true;
                }
            }
            if (!tryDispatch || !hasFuel) continue;
            this.attemptDispatch(loco);
        }
        if (this.isPowered()) {
            boolean playSound = false;
            Sound sound = Sound.BLOCK_FIRE_AMBIENT;
            if (this.getGrid().hasPower(this.getActionPower())) {
                block5: for (Locomotive loco : this.getParkedLocomotives()) {
                    if (loco.getDropOffStation() != null && loco.getDropOffStation().equals(this) && this.getOutputSlot() == -1) {
                        this.setFailReason("No output space");
                        return;
                    }
                    if (loco.getDropOffStation() != null && loco.getDropOffStation().equals(this) && !loco.getInv().isEmpty()) {
                        Inventory inv = loco.getInv();
                        int slot = 9;
                        while (slot < 54) {
                            ItemStack item = inv.getItem(slot);
                            if (TUItems.isValid(item) && this.getOutputSlot() != -1) {
                                this.getInventory().setItem(this.getOutputSlot(), item.clone());
                                item.setAmount(0);
                            }
                            ++slot;
                        }
                    }
                    if (loco.getPickupStation() == null || !loco.getPickupStation().equals(this)) continue;
                    for (ItemStack stack : this.getOutputItems()) {
                        int possibleSlot = loco.getSlotForItem(stack);
                        if (possibleSlot == -1) continue block5;
                        boolean hasDesiredamount = false;
                        int maxAmount = stack.getType().getMaxStackSize();
                        if (stack.getType().equals((Object)Material.BARREL)) {
                            maxAmount = 8;
                        }
                        if (stack.getAmount() >= maxAmount) {
                            hasDesiredamount = true;
                        }
                        if (!hasDesiredamount) continue;
                        ItemStack split = stack.clone();
                        split.setAmount(maxAmount);
                        loco.getInv().setItem(possibleSlot, split);
                        stack.setAmount(stack.getAmount() - maxAmount);
                    }
                }
            } else {
                this.setFailReason("Not Enough Power");
            }
            if (playSound && TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance)) {
                this.getLocation().getWorld().playSound(this.getLocation(), sound, 1.0f, 1.0f);
            }
        }
    }

    public int amountStored(Locomotive loco, ItemStack whatStack) {
        int amountStored = 0;
        for (ItemStack stack : loco.getInv()) {
            ItemMeta itemMeta;
            if (stack != null && (itemMeta = stack.getItemMeta()) instanceof Damageable) {
                Damageable dmg = (Damageable)itemMeta;
                if (MineUtil.isTool(stack.getType())) {
                    stack = stack.clone();
                    dmg.setDamage(0);
                    stack.setItemMeta((ItemMeta)dmg);
                }
            }
            if (!TUItems.isValid(stack) || !stack.isSimilar(whatStack)) continue;
            amountStored += stack.getAmount();
        }
        return amountStored;
    }

    public int amountStationStored(ItemStack whatStack) {
        int amountStored = 0;
        for (ItemStack stack : this.getInputItems()) {
            ItemMeta itemMeta;
            if (stack != null && (itemMeta = stack.getItemMeta()) instanceof Damageable) {
                Damageable dmg = (Damageable)itemMeta;
                stack = stack.clone();
                dmg.setDamage(0);
                stack.setItemMeta((ItemMeta)dmg);
            }
            if (!TUItems.isValid(stack) || !stack.isSimilar(whatStack)) continue;
            amountStored += stack.getAmount();
        }
        return amountStored;
    }

    public ArrayList<Locomotive> getIncomingLocomotives() {
        ArrayList<Locomotive> locos = new ArrayList<Locomotive>();
        for (String str : this.incomingLocomotives.keySet()) {
            if (Locomotive.getLocomotive(str) == null) continue;
            locos.add(Locomotive.getLocomotive(str));
        }
        return locos;
    }

    public ArrayList<Locomotive> getParkedLocomotives() {
        ArrayList<Locomotive> locos = new ArrayList<Locomotive>();
        for (String str : this.parkedLocomotives) {
            if (Locomotive.getLocomotive(str) == null) continue;
            locos.add(Locomotive.getLocomotive(str));
        }
        return locos;
    }

    public int netTrains() {
        return this.incomingLocomotives.size() + this.parkedLocomotives.size();
    }

    public boolean canAcceptLocomotive() {
        return this.netTrains() < 9;
    }

    public int addIncomingLocomotive(Locomotive loco, TrainStation fromStation) {
        int time = TUMaths.getManhattanDistance(fromStation.getLocation(), this.getLocation()) / 10;
        if (time < 5) {
            time = 5;
        }
        this.incomingLocomotives.put(loco.getID(), time);
        return time;
    }

    public void parkIncomingLocomotive(Locomotive loco) {
        this.incomingLocomotives.remove(loco.getID());
        this.parkedLocomotives.add(loco.getID());
        if (loco.getPickupStation() != null && loco.getPickupStation().equals(this) && loco.getPickupTime() > -1) {
            loco.setTimer(loco.getPickupTime());
        }
        if (loco.getDropOffStation() != null && loco.getDropOffStation().equals(this) && loco.getDropOffTime() > -1) {
            loco.setTimer(loco.getDropOffTime());
        }
        loco.disembarkAll(this.getLocation());
        if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance)) {
            this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_MINECART_RIDING, 0.1f, 0.6f);
        }
    }

    public void attemptDispatch(Locomotive loco) {
        if (loco.getPickupStation() != null && loco.getDropOffStation() != null) {
            if (loco.getPickupStation().equals(this) && loco.getDropOffStation().canAcceptLocomotive()) {
                this.parkedLocomotives.remove(loco.getID());
                int seconds = loco.getDropOffStation().addIncomingLocomotive(loco, this);
                loco.useFuel(this.getLocation(), loco.getDropOffStation().getLocation());
                if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance)) {
                    this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_MINECART_RIDING, 0.1f, 0.6f);
                }
                String timeString = seconds + " seconds!";
                if (seconds >= 60) {
                    timeString = TUMaths.roundDouble((double)seconds / 60.0, 1) + " minutes!";
                }
                loco.sendPassengersMessage("Your train has left the station! You will be teleported in " + timeString);
                return;
            }
            if (loco.getDropOffStation().equals(this) && loco.getPickupStation().canAcceptLocomotive()) {
                this.parkedLocomotives.remove(loco.getID());
                int seconds = loco.getPickupStation().addIncomingLocomotive(loco, this);
                loco.useFuel(this.getLocation(), loco.getPickupStation().getLocation());
                if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance)) {
                    this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_MINECART_RIDING, 0.1f, 0.6f);
                }
                String timeString = seconds + " seconds!";
                if (seconds >= 60) {
                    timeString = TUMaths.roundDouble((double)seconds / 60.0, 1) + " minutes!";
                }
                loco.sendPassengersMessage("Your train has left the station! You will be teleported in " + timeString);
            }
        }
    }

    public String getStationName() {
        return this.stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(" ");
        lore.add(MineUtil.colon(" Station Name", this.getStationName()));
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Set name"));
        return lore;
    }

    public String getID() {
        return this.getFileName();
    }

    public void virtualTrainStationViewer(Player player) {
        ItemStack pane = MainMenu.createGoldPane();
        ArrayList<TrainStation> stations = TrainStation.getAuthedStations(player.getUniqueId());
        stations.remove(this);
        HashMap stacks = new HashMap();
        class LeaderScroller
        extends TUInterfaceScrolling {
            private final /* synthetic */ ArrayList val$stations;
            private final /* synthetic */ HashMap val$stacks;

            public LeaderScroller(String name, int rows, ArrayList arrayList, HashMap hashMap) {
                this.val$stations = arrayList;
                this.val$stacks = hashMap;
                super(name, rows);
            }

            @Override
            public ItemStack defineScrolling(int i) {
                if (this.val$stations.size() > i) {
                    TrainStation ts = (TrainStation)this.val$stations.get(i);
                    ItemStack stack = TUItems.createItem(Material.CARTOGRAPHY_TABLE, MineItems.goldBold() + ts.getStationName());
                    ArrayList<String> lore = new ArrayList<String>();
                    int distance = TUMaths.get2DManhattanDistance(ts.getLocationREADONLY(), TrainStation.this.getLocationREADONLY());
                    int railCost = TrainStation.this.getRailCost(distance);
                    int gravelCost = TrainStation.this.getGravelCost(distance);
                    lore.add(MineUtil.colon(" Distance", "" + distance));
                    lore.add(MineUtil.colon(" Rails", railCost + " " + String.valueOf(ChatColor.GRAY) + "(" + TUMaths.roundDouble((double)railCost / 64.0, 2)) + " stacks)");
                    lore.add(MineUtil.colon(" Gravel", gravelCost + " " + String.valueOf(ChatColor.GRAY) + "(" + TUMaths.roundDouble((double)gravelCost / 64.0, 2)) + " stacks)");
                    if (TrainStation.this.virtuallyConnectedStations.contains(ts.getID())) {
                        stack = TUMaths.addGlow(stack);
                        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Disconnect, rails and gravel are given."));
                        lore.add(" ");
                        lore.add(String.valueOf(ChatColor.GREEN) + " Connected");
                    } else {
                        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Connect, using rails and gravel."));
                        lore.add(" ");
                        lore.add(String.valueOf(ChatColor.RED) + " Not Connected");
                    }
                    TUItems.addLore(stack, lore);
                    this.val$stacks.put(stack, ts);
                    return stack;
                }
                return null;
            }

            @Override
            public void scrollingActionClick(Player player, ItemStack item, InventoryClickEvent event) {
                TrainStation ts = (TrainStation)this.val$stacks.get(item);
                int distance = TUMaths.get2DManhattanDistance(ts.getLocationREADONLY(), TrainStation.this.getLocationREADONLY());
                int railCost = TrainStation.this.getRailCost(distance);
                int gravelCost = TrainStation.this.getGravelCost(distance);
                if (!TrainStation.this.virtuallyConnectedStations.contains(ts.getID())) {
                    if (TrainStation.this.rails >= railCost && TrainStation.this.gravel >= gravelCost) {
                        TrainStation.this.rails -= railCost;
                        TrainStation.this.gravel -= gravelCost;
                        TrainStation.this.virtuallyConnectedStations.add(ts.getID());
                        ts.virtuallyConnectedStations.add(TrainStation.this.getID());
                        MineUtil.sendMessage(player, LocaleUtil.messageText("Train_Station_Connected").replace("%station_name%", ts.stationName));
                        TrainStation.this.updateUI();
                    } else {
                        MineUtil.sendWarning(player, LocaleUtil.messageText("Train_Station_Connected").replace("%railcost%", "" + railCost).replace("%gravelcost%", "" + gravelCost));
                    }
                } else {
                    ItemStack railStack = new ItemStack(Material.RAIL, railCost);
                    HashMap notGiven = player.getInventory().addItem(new ItemStack[]{railStack});
                    for (ItemStack stack : notGiven.values()) {
                        player.getWorld().dropItem(player.getLocation(), stack);
                    }
                    ItemStack gravelStack = new ItemStack(Material.GRAVEL, railCost);
                    notGiven = player.getInventory().addItem(new ItemStack[]{gravelStack});
                    for (ItemStack stack : notGiven.values()) {
                        player.getWorld().dropItem(player.getLocation(), stack);
                    }
                    TrainStation.this.virtuallyConnectedStations.remove(ts.getID());
                    ts.virtuallyConnectedStations.remove(TrainStation.this.getID());
                    MineUtil.sendMessage(player, LocaleUtil.messageText("Train_Station_Disconnected").replace("%station_name%", ts.stationName));
                }
                this.updateScrolling();
            }
        }
        LeaderScroller face = new LeaderScroller(ChatColor.DARK_GRAY + ChatColor.BOLD + "Virtual Connections", 6, stations, stacks);
        int i = 45;
        while (i <= 53) {
            if (i != 47 && i != 51 && i != 49) {
                face.addComponent(new TUIComponent(i, pane));
            }
            ++i;
        }
        ArrayList<Integer> scrollingSlots = new ArrayList<Integer>();
        int j = 0;
        while (j <= 44) {
            scrollingSlots.add(j);
            ++j;
        }
        face.setScrollingSlots(scrollingSlots);
        class ReturnComp
        extends TUIComponent {
            public ReturnComp(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                player.openInventory(TrainStation.this.getInventory());
            }
        }
        face.addComponent(new ReturnComp(49, MainMenu.createReturnArrow()));
        class Scroll
        extends TUIComponent {
            public Scroll(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        }
        Scroll leftScroller = new Scroll(47, MineUtil.getLeftScollingStack());
        Scroll rightScroller = new Scroll(51, MineUtil.getRightScrollingStack());
        face.addComponent(leftScroller);
        face.addComponent(rightScroller);
        face.setLeftComp(leftScroller);
        face.setRightComp(rightScroller);
        face.updateScrolling();
        face.openInterface(player);
    }

    public int getRailCost(int distance) {
        int cost = distance;
        double mod = 1.0;
        if (distance >= 16) {
            mod += 0.1;
        }
        if (distance >= 64) {
            mod += 0.1;
        }
        if (distance >= 256) {
            mod += 0.1;
        }
        if (distance >= 1024) {
            mod += 0.1;
        }
        return (int)((double)cost * mod);
    }

    public int getGravelCost(int distance) {
        int cost = distance;
        double mod = 0.1;
        if (distance >= 64) {
            mod += 0.05;
        }
        if (distance >= 256) {
            mod += 0.05;
        }
        if (distance >= 512) {
            mod += 0.05;
        }
        return (int)((double)cost * mod);
    }

    public int getStoredFuel() {
        return this.storedFuel;
    }

    public void setStoredFuel(int storedFuel) {
        this.storedFuel = storedFuel;
    }
}

