/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Utility.Importer;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class Exporter
extends Device {
    private static final long serialVersionUID = -5803502768826302817L;
    private static String classSpacedNamed = "Exporter";
    private double funds;
    private double price;
    public static HashSet<Exporter> exporters = new HashSet();

    public Exporter(Location loc) {
        super(loc);
        this.setMaterial("FLETCHING_TABLE");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        ArrayList<Integer> inputs = new ArrayList<Integer>();
        int i = 9;
        while (i <= 53) {
            inputs.add(i);
            ++i;
        }
        this.setClickableSlots(inputs);
        this.setInputSlots(inputs);
        this.setStoreForm(true);
        this.updateDeviceHeadItem();
    }

    @Override
    public void postCreate(boolean first) {
        exporters.add(this);
    }

    @Override
    public void cleanup() {
        exporters.remove(this);
    }

    @Override
    public ArrayList<String> stackDescription() {
        return new ArrayList<String>();
    }

    @Override
    public void updateUI() {
        int i = 0;
        while (i <= 8) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            ++i;
        }
        ItemStack stack = TUItems.createItem(Material.REDSTONE_LAMP, MineItems.whiteBold() + "Export Information");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Funds", "" + this.funds));
        lore.add(MineUtil.colon(" Price", "" + this.price));
        lore.add(" ");
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Collect Funds"));
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Set Price"));
        ItemStack target = null;
        if (this.getInputItems().size() > 0) {
            target = this.getInputItems().get(0);
        }
        if (target != null) {
            double highest = -1.0;
            double average = 0.0;
            double taxAverage = 0.0;
            int total = 0;
            for (Importer importer : Importer.importers) {
                if (importer.getTargetItem() == null || !importer.getTargetItem().isSimilar(target)) continue;
                if (highest == -1.0) {
                    highest = importer.getBuyPrice() - Importer.getTax(importer, this);
                } else if (highest < importer.getBuyPrice() - Importer.getTax(importer, this)) {
                    highest = importer.getBuyPrice() - Importer.getTax(importer, this);
                }
                average += importer.getBuyPrice() - Importer.getTax(importer, this);
                ++total;
                taxAverage += TUMaths.roundDouble(Importer.getTax(importer, this), 2);
            }
            highest = TUMaths.roundDouble(highest / (double)total, 2);
            average = TUMaths.roundDouble(average / (double)total, 2);
            taxAverage = TUMaths.roundDouble(taxAverage / (double)total, 2);
            if (highest == -1.0) {
                highest = 0.0;
            }
            lore.add(" ");
            lore.add(" " + MineItems.whiteBold() + "Market Information");
            lore.add(MineUtil.colon("  Highest Offer", "$" + highest));
            lore.add(MineUtil.colon("  Average Offer", "$" + average));
            lore.add(MineUtil.colon("  Average Tax", "$" + taxAverage));
            lore.add(MineUtil.colon("  Importers", "" + total));
        } else {
            lore.add(" ");
            lore.add(MineItems.yellowBold() + " Nothing For Sale");
        }
        if (!this.getFailReason().equals("None")) {
            lore.add(" ");
            lore.add(" " + String.valueOf(ChatColor.RED) + this.getFailReason());
        }
        TUItems.addLore(stack, lore);
        this.getInventory().setItem(4, stack);
    }

    @Override
    public void action() {
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.DROPPER, 1.0);
    }

    @Override
    public void recreateInv() {
        this.inv = TUInventory.createInventory(MineItems.uiTitle() + this.deviceName, 6, this.deviceName);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 4) {
            if (event.isLeftClick()) {
                if (this.funds > 0.0) {
                    MineMain.getEconomy().depositPlayer((OfflinePlayer)player, this.funds);
                    MineUtil.sendMessage(player, LocaleUtil.messageText("Exporter_Collect").replace("%funds%", "" + this.funds));
                    this.funds = 0.0;
                }
                return;
            }
            if (event.isRightClick()) {
                class ChatInput
                extends com.MT.triggersUtility.ChatInput {
                    private final /* synthetic */ Player val$player;

                    public ChatInput(String startMessage, boolean numbersonly, Player player) {
                        this.val$player = player;
                        super(startMessage, numbersonly);
                        this.setIgnorePeriod(true);
                    }

                    @Override
                    public void inputAction(String message) {
                        TUMaths.dm(message);
                        Exporter.this.price = Double.valueOf(message);
                        Exporter.this.price = TUMaths.roundDouble(Exporter.this.price, 2);
                        MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("Exporter_Price").replace("%price%", "" + Exporter.this.price));
                        Exporter.this.updateUI();
                        this.val$player.openInventory(Exporter.this.getInventory());
                    }
                }
                ChatInput input = new ChatInput("Enter the new price in chat now!", false, player);
                input.start(player);
            }
            player.closeInventory();
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, Exporter.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new Exporter(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Iron Plate", 3));
        ings.add(MineItems.getIndustrialItem("Electronic Circuit", 3));
        RecipeUtils.addDefaultRecipe(new Exporter(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }

    public double getFunds() {
        return this.funds;
    }

    public void setFunds(double funds) {
        this.funds = funds;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }
}

