/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Pollution;

import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterface;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Guide.GuideMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.Pollution.SuperChunk;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PollutionMap {
    public static void openPollutionMap(Player player) {
        TUInterface face = new TUInterface(MineItems.goldBold() + "Pollution Map", 6);
        int i = 45;
        while (i <= 53) {
            face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, i));
            ++i;
        }
        SuperChunk sc = SuperChunk.getSuperChunk(player.getLocation());
        String worldName = player.getLocation().getWorld().getName();
        int slot = 0;
        int z = sc.z - 2;
        while (z <= sc.z + 2) {
            int x = sc.x - 4;
            while (x <= sc.x + 4) {
                TUIComponent comp = PollutionMap.createPollutionIcon(face, x, z, worldName, slot, player);
                if (x == sc.x && z == sc.z) {
                    ItemStack stack = comp.getLinkedStack();
                    comp.setLinkedStack(TUMaths.addGlow(stack));
                    comp.createItemStack();
                    comp.setTag("Glow");
                }
                face.addComponent(comp);
                ++slot;
                ++x;
            }
            ++z;
        }
        face.addComponent(PollutionMap.createDissButton());
        face.addComponent(PollutionMap.createReturnArrow());
        face.addComponent(MineUtil.createInfoComponent(53, "The center icon is your current location! The top of chest UI is north, and the bottom of the UI is south! Each icon is a 3 chunks by 3 chunks, this is called a super chunk!"));
        face.openInterface(player);
    }

    private static TUIComponent createReturnArrow() {
        ItemStack itemStack = MainMenu.createReturnArrow();
        return new TUIComponent(50, itemStack){

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                MainMenu.openGuideMenu(player, null);
            }
        };
    }

    private static TUIComponent createDissButton() {
        ItemStack itemStack = TUItems.createItem(Material.BIRCH_LOG, MineItems.goldBold() + "Toggle Dissapation", MineUtil.wrapText("When toggled item amounts represent dissapation of the super chunk. The higher the number the better the enviroment can remove pollution.", 45, ChatColor.WHITE, 1));
        itemStack = TUItems.setModelData(itemStack, 9522);
        return new TUIComponent(48, itemStack){

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (this.getTuface().hasTag("Show Diss")) {
                    this.getTuface().removeTag("Show Diss");
                } else {
                    this.getTuface().addTag("Show Diss");
                }
                for (TUIComponent comp : this.getTuface().getComponents()) {
                    comp.onUpdate();
                }
            }
        };
    }

    private static TUIComponent createPollutionIcon(final TUInterface face, final int scX, final int scZ, final String worldName, int slot, Player opener) {
        return new TUIComponent(slot, PollutionMap.createStack(face, scX, scZ, worldName)){

            @Override
            public void onUpdate() {
                ItemStack stack = PollutionMap.createStack(face, scX, scZ, worldName);
                if (this.getTag() != null && this.getTag().equals("Glow")) {
                    stack = TUMaths.addGlow(stack);
                }
                this.setLinkedStack(stack);
                this.createItemStack();
            }
        };
    }

    private static ItemStack createStack(TUInterface face, int scX, int scZ, String worldName) {
        Material mat = Material.GREEN_CONCRETE;
        int modelID = 9553;
        int pollution = 0;
        int dissapation = 0;
        int nests = 0;
        int evoPCT = 0;
        int ecoDMG = 0;
        String pollLevel = String.valueOf(ChatColor.DARK_GREEN) + String.valueOf(ChatColor.BOLD) + "No Pollution";
        ArrayList<Object> biomes = new ArrayList();
        SuperChunk sc = null;
        if (SuperChunk.superChunkExists(scX, scZ)) {
            sc = SuperChunk.getSuperChunk(scX, scZ, worldName);
            pollution = sc.getPollution();
            dissapation = sc.getDissapation();
            biomes = sc.getBiomes();
            nests = sc.getNestCount();
            evoPCT = sc.getEvolutionPercent();
            ecoDMG = sc.getEcoDamagePCT();
            if (pollution > 0) {
                mat = Material.LIME_CONCRETE;
                pollLevel = String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "Low Pollution";
                modelID = 9554;
            }
            if (pollution >= 100) {
                mat = Material.YELLOW_CONCRETE;
                pollLevel = String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + "Moderate Pollution";
                modelID = 9555;
            }
            if (pollution >= 500) {
                mat = Material.ORANGE_CONCRETE;
                pollLevel = String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "High Pollution";
                modelID = 9556;
            }
            if (pollution >= 1000) {
                mat = Material.RED_CONCRETE;
                pollLevel = String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Very High Pollution";
                modelID = 9557;
            }
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Pollution", "" + pollution));
        Object dispStr = "Unknown";
        if (dissapation > 0) {
            dispStr = "" + dissapation;
        }
        lore.add(MineUtil.colon(" Dissapation", (String)dispStr));
        if (evoPCT > 100) {
            evoPCT = 100;
        }
        String ecologicalState = "Healthy";
        if (sc != null) {
            if (sc.getEcoDamagePCT() >= 15) {
                ecologicalState = "Minor Damage";
            }
            if (sc.getEcoDamagePCT() >= 50) {
                ecologicalState = "Major Damage";
            }
            if (sc.getEcoDamagePCT() >= 75) {
                ecologicalState = "Devastated";
            }
        }
        lore.add(MineUtil.colon(" Ecological Damage", ecoDMG + "% (" + ecologicalState + ")"));
        if (MineMain.useBiters) {
            lore.add(MineUtil.colon(" Biter Evolution", evoPCT + "%"));
        }
        if (nests > 0) {
            lore.add(" ");
            lore.add(String.valueOf(ChatColor.RED) + " " + nests + " nests detected!");
        }
        if (sc != null) {
            String ecoWarning = null;
            if (sc.getPollution() <= 50 && sc.getEcoDamagePCT() > 0) {
                ecoWarning = String.valueOf(ChatColor.GREEN) + " Ecosystem Is Healing";
            }
            if (sc.getPollution() > 50 && sc.getPollution() < 200) {
                ecoWarning = String.valueOf(ChatColor.YELLOW) + " Ecosystem In Stasis";
            }
            if (sc.getPollution() > 200) {
                ecoWarning = String.valueOf(ChatColor.RED) + " Ecosystem Taking Damage";
            }
            if (ecoWarning != null) {
                lore.add(" ");
                lore.add(ecoWarning);
            }
        }
        if (biomes.size() > 0) {
            HashMap<String, Integer> count = new HashMap<String, Integer>();
            for (String string : biomes) {
                if (!count.containsKey(string)) {
                    count.put(string, 1);
                    continue;
                }
                count.put(string, (Integer)count.get(string) + 1);
            }
            lore.add(" ");
            lore.add(MineItems.whiteBold() + " Notable Biomes");
            for (String string : count.keySet()) {
                lore.add(String.valueOf(ChatColor.WHITE) + " - " + string + " x" + String.valueOf(count.get(string)));
            }
        }
        if (nests > 0) {
            mat = Material.NETHER_WART_BLOCK;
        }
        ItemStack itemStack = TUItems.createItem(mat, pollLevel, lore);
        if (dissapation > 1 && face.hasTag("Show Diss")) {
            itemStack.setAmount(dissapation);
        }
        if (nests > 1) {
            itemStack.setAmount(nests);
        }
        return TUItems.setModelData(itemStack, modelID);
    }
}

