/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.MineMain;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.Dropper;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.enginehub.linbus.stream.token.LinToken;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;

public class Schematic {
    private static HashMap<Location, String> devicePastes = new HashMap();
    private static final Map<BlockFace, BlockFace> ROTATE_90 = new HashMap<BlockFace, BlockFace>();

    static {
        ROTATE_90.put(BlockFace.NORTH, BlockFace.EAST);
        ROTATE_90.put(BlockFace.EAST, BlockFace.SOUTH);
        ROTATE_90.put(BlockFace.SOUTH, BlockFace.WEST);
        ROTATE_90.put(BlockFace.WEST, BlockFace.NORTH);
    }

    public static void paste(String schematicName, Location pasteLocation, boolean ignoreAir, double rotation) {
        Schematic.pasteBlocks(Schematic.getPasteLocations(schematicName, pasteLocation, ignoreAir, rotation));
    }

    public static HashMap<Location, BlockData> getPasteLocations(String schematicName, Location pasteLocation, boolean ignoreAir, double rotation) {
        File myfile = new File(MineMain.getPlugin().getDataFolder().getAbsolutePath() + "/schematics/" + schematicName + ".schem");
        ClipboardFormat format = ClipboardFormats.findByFile((File)myfile);
        if (format != null) {
            try {
                ClipboardReader reader = format.getReader((InputStream)new FileInputStream(myfile));
                Clipboard clipboard = reader.read();
                HashMap<Location, BlockData> locs = new HashMap<Location, BlockData>();
                EditSession editSession = WorldEdit.getInstance().newEditSession((World)new BukkitWorld(pasteLocation.getWorld()));
                BlockVector3 minimumPoint = clipboard.getMinimumPoint();
                BlockVector3 maximumPoint = clipboard.getMaximumPoint();
                int minX = minimumPoint.x();
                int maxX = maximumPoint.x();
                int minY = minimumPoint.y();
                int maxY = maximumPoint.y();
                int minZ = minimumPoint.z();
                int maxZ = maximumPoint.z();
                int x = minX;
                while (x <= maxX) {
                    int y = minY;
                    while (y <= maxY) {
                        int z = minZ;
                        while (z <= maxZ) {
                            BlockVector3 at = BlockVector3.at((int)x, (int)y, (int)z);
                            BaseBlock block = clipboard.getFullBlock(at);
                            if (!block.getBlockType().getMaterial().isAir() || !ignoreAir) {
                                double offsetX = Math.abs(maxX - x);
                                double offsetY = Math.abs(maxY - y);
                                double offsetZ = Math.abs(maxZ - z);
                                int width = clipboard.getRegion().getWidth();
                                int height = clipboard.getRegion().getHeight();
                                int length = clipboard.getRegion().getLength();
                                int widthCentre = width / 2;
                                int heightCentre = height;
                                int lengthCentre = length / 2;
                                Location offsetLoc = pasteLocation.clone().subtract(offsetX - (double)widthCentre, offsetY - (double)heightCentre, offsetZ - (double)lengthCentre);
                                locs.put(offsetLoc, BukkitAdapter.adapt((BlockStateHolder)block));
                                Schematic.checkDeviceLocation(block, at, offsetLoc);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                editSession.close();
                if (rotation != 0.0) {
                    return Schematic.rotateBlockDataLocations(locs, pasteLocation, rotation);
                }
                return locs;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new HashMap<Location, BlockData>();
    }

    public static String getPasteDevice(Location pasteLocation) {
        if (devicePastes.containsKey(pasteLocation)) {
            return devicePastes.get(pasteLocation);
        }
        return null;
    }

    private static void checkDeviceLocation(BaseBlock block, BlockVector3 at, Location pasteLocation) {
        LinCompoundTag nbtData = block.getNbt();
        if (nbtData == null) {
            return;
        }
        LinListTag itemsTag = nbtData.findListTag("Items", LinTagType.compoundTag());
        if (itemsTag != null) {
            for (LinTag lTag : itemsTag.value()) {
                Iterator iterator = lTag.linStream().asIterator();
                while (iterator.hasNext()) {
                    LinToken lt = (LinToken)iterator.next();
                    String data = lt.toString();
                    if (!data.contains("MTDEVICE:")) continue;
                    devicePastes.put(pasteLocation, data.split("::")[1]);
                }
            }
        }
    }

    private static HashMap<Location, BlockData> rotateBlockDataLocations(HashMap<Location, BlockData> blockDataMap, Location center, double degrees) {
        HashMap<Location, BlockData> rotatedBlockDataMap = new HashMap<Location, BlockData>();
        double radians = Math.toRadians(degrees);
        for (Map.Entry<Location, BlockData> entry : blockDataMap.entrySet()) {
            Location loc = entry.getKey();
            BlockData blockData = entry.getValue();
            double x = loc.getX() - center.getX();
            double z = loc.getZ() - center.getZ();
            double newX = x * Math.cos(radians) - z * Math.sin(radians);
            double newZ = x * Math.sin(radians) + z * Math.cos(radians);
            Location newLoc = new Location(loc.getWorld(), center.getX() + newX, loc.getY(), center.getZ() + newZ, loc.getYaw(), loc.getPitch());
            BlockData bd = Schematic.rotateDirectional(Schematic.rotateBlock(blockData, (int)degrees), (int)degrees);
            rotatedBlockDataMap.put(newLoc, bd);
        }
        return rotatedBlockDataMap;
    }

    public static ArrayList<BlockState> pasteBlocks(HashMap<Location, BlockData> blocks) {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        for (Location loc : new ArrayList<Location>(blocks.keySet())) {
            Block newBlock = loc.getBlock();
            states.add(newBlock.getState());
            newBlock.setBlockData(blocks.get(loc));
        }
        return states;
    }

    public static ArrayList<Block> getReplaceBlocks(HashMap<Location, BlockData> blocks) {
        ArrayList<Block> rBlocks = new ArrayList<Block>();
        for (Location loc : new ArrayList<Location>(blocks.keySet())) {
            Block newBlock = loc.getBlock();
            rBlocks.add(newBlock);
        }
        return rBlocks;
    }

    public static void saveSchematic(org.bukkit.World bukkitWorld, BlockVector3 minPoint, BlockVector3 maxPoint, String schematicName, BlockVector3 pasteOrigin) {
        try {
            Object editSession;
            World world = BukkitAdapter.adapt((org.bukkit.World)bukkitWorld);
            CuboidRegion region = new CuboidRegion(world, minPoint, maxPoint);
            ArrayList<BlockState> originalItems = new ArrayList<BlockState>();
            int x = minPoint.getX();
            while (x <= maxPoint.getX()) {
                int y = minPoint.getY();
                while (y <= maxPoint.getY()) {
                    int z22 = minPoint.getZ();
                    while (z22 <= maxPoint.getZ()) {
                        Block block = bukkitWorld.getBlockAt(x, y, z22);
                        if (Mover.isMover(block.getLocation())) {
                            originalItems.add(block.getState());
                            Dropper barrel = (Dropper)block.getState();
                            barrel.getInventory().setItem(0, TUItems.createItem(Material.PAPER, "MTDEVICE::Mover::"));
                        } else {
                            Device device = Device.getDevice(block);
                            if (device != null) {
                                boolean isContainer = block.getState() instanceof Container;
                                if (!isContainer) {
                                    originalItems.add(block.getState());
                                    block.setType(Material.BARREL);
                                }
                                Container cont = (Container)block.getState();
                                cont.getInventory().setItem(0, TUItems.createItem(Material.PAPER, "MTDEVICE::" + device.getName() + "::"));
                            }
                        }
                        ++z22;
                    }
                    ++y;
                }
                ++x;
            }
            BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region);
            clipboard.setOrigin(pasteOrigin);
            Throwable y = null;
            Object z22 = null;
            try {
                editSession = WorldEdit.getInstance().newEditSession(world);
                try {
                    ForwardExtentCopy copy = new ForwardExtentCopy((Extent)editSession, (Region)region, (Extent)clipboard, region.getMinimumPoint());
                    copy.setCopyingEntities(true);
                    Operations.complete((Operation)copy);
                }
                finally {
                    if (editSession != null) {
                        editSession.close();
                    }
                }
            }
            catch (Throwable z22) {
                if (y == null) {
                    y = z22;
                } else if (y != z22) {
                    y.addSuppressed(z22);
                }
                throw y;
            }
            File schematicFile = new File(MineMain.getPlugin().getDataFolder().getAbsolutePath() + "/schematics/" + schematicName + ".schem");
            ClipboardFormat format = ClipboardFormats.findByAlias((String)"schem");
            if (format == null) {
                TUMaths.dm("Could not find the .schem format.");
                return;
            }
            editSession = null;
            Iterator iterator = null;
            try (ClipboardWriter writer = format.getWriter(Files.newOutputStream(schematicFile.toPath(), new OpenOption[0]));){
                writer.write((Clipboard)clipboard);
                TUMaths.dm("Schematic saved successfully as " + schematicName + ".schem");
            }
            catch (Throwable throwable) {
                if (editSession == null) {
                    editSession = throwable;
                } else if (editSession != throwable) {
                    ((Throwable)editSession).addSuppressed(throwable);
                }
                throw editSession;
            }
            for (BlockState state : originalItems) {
                state.update(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean doesSchematicExist(String schematicName) {
        File worldEditFolder = MineMain.getPlugin().getDataFolder();
        if (worldEditFolder == null) {
            return false;
        }
        File schematicFile = new File(MineMain.getPlugin().getDataFolder().getPath() + File.separator + "schematics" + File.separator + schematicName + ".schem");
        boolean exists = schematicFile.exists();
        schematicFile.canRead();
        return exists;
    }

    public static BlockVector3 getSchematicDimensions(String schematicName) {
        File myfile = new File(MineMain.getPlugin().getDataFolder().getAbsolutePath() + "/schematics/" + schematicName + ".schem");
        ClipboardFormat format = ClipboardFormats.findByFile((File)myfile);
        if (format != null) {
            try {
                ClipboardReader reader = format.getReader((InputStream)new FileInputStream(myfile));
                Clipboard clipboard = reader.read();
                return clipboard.getDimensions();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static BlockData rotateBlock(BlockData blockData, int degrees) {
        if (!(blockData instanceof MultipleFacing)) {
            return blockData;
        }
        MultipleFacing facing = (MultipleFacing)blockData;
        MultipleFacing newFacing = (MultipleFacing)blockData.clone();
        for (BlockFace face : facing.getAllowedFaces()) {
            if (!facing.hasFace(face)) continue;
            BlockFace rotatedFace = Schematic.rotateFace(face, degrees);
            newFacing.setFace(face, false);
            newFacing.setFace(rotatedFace, true);
        }
        return newFacing;
    }

    private static BlockFace rotateFace(BlockFace face, int degrees) {
        if (degrees % 90 != 0) {
            return face;
        }
        int steps = degrees / 90 % 4;
        BlockFace rotatedFace = face;
        int i = 0;
        while (i < steps) {
            rotatedFace = ROTATE_90.getOrDefault(rotatedFace, rotatedFace);
            ++i;
        }
        return rotatedFace;
    }

    public static BlockData rotateDirectional(BlockData blockData, int degrees) {
        if (!(blockData instanceof Directional)) {
            return blockData;
        }
        Directional directional = (Directional)blockData;
        BlockFace currentFace = directional.getFacing();
        BlockFace newFace = Schematic.rotateFace(currentFace, degrees);
        directional.setFacing(newFace);
        return directional;
    }
}

