/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility.TUInterface;

import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInventory;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TUInterface {
    private Inventory inv;
    private boolean cancelClick = true;
    public HashMap<Integer, TUIComponent> components = new HashMap();
    private String name;
    private Location linkedLocation = null;
    public ArrayList<String> tags = new ArrayList();
    private ArrayList<Integer> exempCancelSlots = new ArrayList();

    public Location getLinkedLocation() {
        return this.linkedLocation;
    }

    public void setLinkedLocation(Location linkedLocation) {
        this.linkedLocation = linkedLocation;
    }

    public TUInterface(String name, int rows) {
        this.setInv(TUInventory.createInventory(name, rows, "Interface:" + ChatColor.stripColor((String)name)));
        TUInventory.storedInterfaces.put(this.inv, this);
        this.name = ChatColor.stripColor((String)name);
    }

    public String getInterfaceName() {
        return this.name;
    }

    public Inventory getInv() {
        return this.inv;
    }

    public void setInv(Inventory inv) {
        this.inv = inv;
    }

    public void playerInventoryClick(Player player, ItemStack item, InventoryClickEvent event) {
    }

    public void onClose(Player player, InventoryCloseEvent event) {
    }

    public ArrayList<TUIComponent> getComponents() {
        return new ArrayList<TUIComponent>(this.components.values());
    }

    public TUIComponent getComponent(int slot) {
        for (TUIComponent comp : this.getComponents()) {
            if (comp.getSlot() != slot) continue;
            return comp;
        }
        return null;
    }

    public TUIComponent getComponent(ItemStack stack) {
        for (TUIComponent comp : this.getComponents()) {
            if (!comp.getLinkedStack().equals((Object)stack)) continue;
            return comp;
        }
        return null;
    }

    public void addComponent(TUIComponent comp) {
        comp.setTuface(this);
        this.components.put(comp.getSlot(), comp);
    }

    public void removeComponent(TUIComponent comp) {
        this.inv.setItem(comp.getSlot(), new ItemStack(Material.AIR));
        this.components.remove(comp.getSlot());
        comp.setTuface(null);
    }

    public void removeComponent(int slot) {
        TUIComponent comp = this.getComponent(slot);
        if (comp != null) {
            this.removeComponent(comp);
        }
    }

    public void openInterface(Player player) {
        this.openInterface(player, true);
    }

    public void openInterface(Player player, boolean openSound) {
        player.openInventory(this.inv);
        TUInventory.storedInterfaces.put(this.inv, this);
    }

    public boolean isCancelClick() {
        return this.cancelClick;
    }

    public void setCancelClick(boolean cancelClick) {
        this.cancelClick = cancelClick;
    }

    public String toString() {
        return "TUInterface [inv=" + String.valueOf(this.inv) + ", cancelClick=" + this.cancelClick + ", components=" + String.valueOf(this.components) + ", name=" + this.name + "]";
    }

    public void addTag(String tag) {
        if (!this.hasTag(tag)) {
            this.tags.add(tag);
        }
    }

    public void removeTag(String tag) {
        for (String tag2 : new ArrayList<String>(this.tags)) {
            if (!tag2.contains(tag)) continue;
            this.tags.remove(tag2);
        }
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public String getTag(String tagContains) {
        for (String tag : new ArrayList<String>(this.tags)) {
            if (!tag.contains(tagContains)) continue;
            return tag;
        }
        return null;
    }

    public ArrayList<Integer> getExempCancelSlots() {
        return this.exempCancelSlots;
    }

    public void setExempCancelSlots(ArrayList<Integer> exempCancelSlots) {
        this.exempCancelSlots = exempCancelSlots;
    }

    public boolean isExemptFromCancelClick(int slot) {
        return this.exempCancelSlots.contains(slot);
    }
}

