/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility.TUInterface;

import com.MT.triggersUtility.Events.ServerTimeUpdate;
import com.MT.triggersUtility.Events.TUClickEvent;
import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterface;
import com.MT.triggersUtility.TUInterface.TUInterfaceScrolling;
import com.MT.triggersUtility.TUMaths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TUInventory
implements Listener {
    private static HashMap<Inventory, String> storedInventory = new HashMap();
    public static HashMap<Inventory, TUInterface> storedInterfaces = new HashMap();

    public static Inventory createInventory(InventoryType type, String name, String data) {
        Inventory inv = Bukkit.createInventory(null, (InventoryType)type, (String)name);
        storedInventory.put(inv, data);
        return inv;
    }

    public static Inventory createInventory(String name, int rows, String data) {
        Inventory inv = Bukkit.createInventory(null, (int)(9 * rows), (String)name);
        storedInventory.put(inv, data);
        return inv;
    }

    @EventHandler
    public void onSecond(ServerTimeUpdate event) {
        if (TUMaths.isMultipleOf(event.getTime(), 3)) {
            for (Inventory inv : new ArrayList<Inventory>(storedInterfaces.keySet())) {
                TUInterface face = storedInterfaces.get(inv);
                if (face.getInv().getViewers().size() <= 0) {
                    storedInterfaces.remove(face.getInv());
                    continue;
                }
                for (TUIComponent comp : face.getComponents()) {
                    comp.onUpdate();
                }
            }
        }
    }

    public static ArrayList<TUInterface> getInterfaces() {
        return new ArrayList<TUInterface>(storedInterfaces.values());
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        if (storedInventory.containsKey(event.getInventory()) && storedInventory.get(event.getView().getTopInventory()).contains("Interface")) {
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int rawSlot = (Integer)iterator.next();
                if (rawSlot > event.getView().getTopInventory().getSize() - 1) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (storedInterfaces.containsKey(event.getInventory())) {
            storedInterfaces.get(event.getInventory()).onClose((Player)event.getPlayer(), event);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        ItemStack targetItem;
        if (event.getClick().equals((Object)ClickType.NUMBER_KEY) && storedInterfaces.containsKey(event.getInventory())) {
            event.setCancelled(true);
            return;
        }
        if (event.getClickedInventory() != null && event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER) && event.getView().getTopInventory() != null && storedInventory.containsKey(event.getView().getTopInventory()) && storedInventory.get(event.getView().getTopInventory()).contains("Interface")) {
            TUInterface face = storedInterfaces.get(event.getView().getTopInventory());
            Player player = (Player)event.getWhoClicked();
            face.playerInventoryClick(player, event.getCurrentItem(), event);
            if (event.getClick().toString().contains("SHIFT") || event.getClick().equals((Object)ClickType.DOUBLE_CLICK)) {
                event.setCancelled(true);
                return;
            }
        }
        if ((targetItem = event.getCurrentItem()) == null || targetItem != null && targetItem.getType().equals((Object)Material.AIR)) {
            targetItem = event.getCursor();
        }
        if (targetItem != null && !targetItem.getType().equals((Object)Material.AIR) && storedInventory.containsKey(event.getClickedInventory())) {
            if (!storedInventory.get(event.getClickedInventory()).contains("Interface")) {
                Bukkit.getPluginManager().callEvent((Event)new TUClickEvent(event.getClickedInventory(), storedInventory.get(event.getClickedInventory()), event));
            } else {
                TUInterface face = storedInterfaces.get(event.getClickedInventory());
                if (!face.isExemptFromCancelClick(event.getSlot())) {
                    event.setCancelled(face.isCancelClick());
                }
                Player player = (Player)event.getWhoClicked();
                for (TUIComponent comp : face.getComponents()) {
                    if (comp.getSlot() != event.getSlot()) continue;
                    if (comp.isForceCancel()) {
                        event.setCancelled(true);
                    }
                    if (event.isLeftClick()) {
                        if (!event.isShiftClick()) {
                            comp.onLeftClick(player);
                            comp.onLeftClickFull(player, event);
                            break;
                        }
                        comp.onShiftLeftClick(player);
                        break;
                    }
                    if (event.isRightClick()) {
                        if (!event.isShiftClick()) {
                            comp.onRightClick(player);
                            break;
                        }
                        comp.onShiftRightClick(player);
                        break;
                    }
                    if (!event.getClick().equals((Object)ClickType.MIDDLE)) continue;
                    comp.onMiddleClick(player);
                    break;
                }
                if (event.getSlot() != -1 && targetItem != null && !targetItem.getType().equals((Object)Material.AIR) && face instanceof TUInterfaceScrolling) {
                    TUInterfaceScrolling scrolling = (TUInterfaceScrolling)face;
                    if (scrolling.getScrollingSlots().contains(event.getSlot())) {
                        scrolling.scrollingActionClick(player, targetItem, event);
                    } else {
                        if (scrolling.getLeftComp() != null && scrolling.getLeftComp().getLinkedStack().equals((Object)targetItem)) {
                            scrolling.scrollLeft();
                        }
                        if (scrolling.getRightComp() != null && scrolling.getRightComp().getLinkedStack().equals((Object)targetItem)) {
                            scrolling.scrollRight();
                        }
                        if (scrolling.getLeftRightComp() != null && scrolling.getRightComp().getLinkedStack().equals((Object)targetItem)) {
                            if (event.isLeftClick()) {
                                scrolling.scrollLeft();
                            }
                            if (event.isRightClick()) {
                                scrolling.scrollRight();
                            }
                        }
                        scrolling.scrollingMenuClick(player, targetItem, event);
                    }
                }
            }
        }
    }

    public static boolean isTUInv(Inventory inv) {
        return storedInventory.containsKey(inv);
    }

    public static String getTUInvData(Inventory inv) {
        return storedInventory.get(inv);
    }

    public static boolean isInterface(Inventory inv) {
        return storedInterfaces.keySet().contains(inv);
    }

    public static TUInterface getInterface(Inventory inv) {
        return storedInterfaces.get(inv);
    }
}

