/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility;

import com.MT.VersionControl.MTVersion;
import com.MT.VersionControl.MTVersion121;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.MineMain;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class TUItems {
    public static boolean migrationOccured = false;
    private static final Map<String, ItemStack> cachedStackStrings = new HashMap<String, ItemStack>();

    public static void addLore(ItemStack item, String loreLine) {
        if (!TUItems.isValid(item)) {
            return;
        }
        ArrayList itemLore = new ArrayList();
        ItemMeta meta = item.getItemMeta();
        if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
            itemLore = (ArrayList)item.getItemMeta().getLore();
        }
        itemLore.add(loreLine);
        meta.setLore(itemLore);
        item.setItemMeta(meta);
    }

    public static void addLore(ItemStack item, ArrayList<String> loreLines) {
        ArrayList itemLore = new ArrayList();
        ItemMeta meta = item.getItemMeta();
        if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
            itemLore = (ArrayList)item.getItemMeta().getLore();
        }
        itemLore.addAll(loreLines);
        meta.setLore(itemLore);
        item.setItemMeta(meta);
    }

    public static void addLoreIndex(ItemStack item, String loreLine, int index) {
        ArrayList itemLore = new ArrayList();
        ItemMeta meta = item.getItemMeta();
        if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
            itemLore = (ArrayList)item.getItemMeta().getLore();
        }
        if (itemLore.size() <= index) {
            index = itemLore.size();
        }
        if (itemLore.size() > 0) {
            itemLore.add(index, loreLine);
        } else {
            itemLore.add(loreLine);
        }
        meta.setLore((List)itemLore);
        item.setItemMeta(meta);
    }

    public static void removeLore(ItemStack item, String loreLine) {
        ArrayList itemLore = new ArrayList();
        ItemMeta meta = item.getItemMeta();
        if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
            itemLore = (ArrayList)item.getItemMeta().getLore();
            for (String loreLine2 : new ArrayList(itemLore)) {
                if (!loreLine2.contains(loreLine)) continue;
                itemLore.remove(loreLine2);
                break;
            }
        }
        meta.setLore(itemLore);
        item.setItemMeta(meta);
    }

    public static void removeLoreNoColor(ItemStack item, String loreLine) {
        if (item == null) {
            return;
        }
        ArrayList itemLore = new ArrayList();
        ItemMeta meta = item.getItemMeta();
        if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
            itemLore = (ArrayList)item.getItemMeta().getLore();
            for (String loreLine2 : new ArrayList(itemLore)) {
                if (!ChatColor.stripColor((String)loreLine2).contains(ChatColor.stripColor((String)loreLine))) continue;
                itemLore.remove(loreLine2);
                break;
            }
        }
        meta.setLore(itemLore);
        item.setItemMeta(meta);
    }

    public static boolean hasLoreLine(ItemStack item, String stringcheck) {
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasLore()) {
            for (String loreLine : item.getItemMeta().getLore()) {
                if (!loreLine.contains(stringcheck)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasLoreLineNoColor(ItemStack item, String stringcheck) {
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasLore()) {
            for (String loreLine : item.getItemMeta().getLore()) {
                if (!ChatColor.stripColor((String)loreLine).contains(ChatColor.stripColor((String)stringcheck))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasLore(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasLore();
    }

    public static String getLoreLine(ItemStack item, String stringcheck) {
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasLore()) {
            for (String loreLine : item.getItemMeta().getLore()) {
                if (!loreLine.contains(stringcheck)) continue;
                return loreLine;
            }
        }
        return null;
    }

    public static String getLoreLineNoColor(ItemStack item, String stringcheck) {
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasLore()) {
            for (String loreLine : item.getItemMeta().getLore()) {
                if (!ChatColor.stripColor((String)loreLine).contains(ChatColor.stripColor((String)stringcheck))) continue;
                return loreLine;
            }
        }
        return null;
    }

    public static int getListIndex(List<String> listValue, String targetString) {
        int targetIndex = -1;
        int i = 0;
        while (i < listValue.size()) {
            if (listValue.get(i).contains(targetString)) {
                targetIndex = i;
            }
            ++i;
        }
        return targetIndex;
    }

    public static int getFeedAmount(Material material) {
        if (material.equals((Object)Material.CAKE)) {
            return 2;
        }
        if (material.equals((Object)Material.COOKIE)) {
            return 2;
        }
        if (material.equals((Object)Material.MELON)) {
            return 2;
        }
        if (material.equals((Object)Material.MUTTON)) {
            return 2;
        }
        if (material.equals((Object)Material.SPIDER_EYE)) {
            return 3;
        }
        if (material.equals((Object)Material.RABBIT)) {
            return 3;
        }
        if (material.equals((Object)Material.APPLE)) {
            return 4;
        }
        if (material.equals((Object)Material.ROTTEN_FLESH)) {
            return 4;
        }
        if (material.equals((Object)Material.GOLDEN_APPLE)) {
            return 4;
        }
        if (material.equals((Object)Material.BAKED_POTATO)) {
            return 5;
        }
        if (material.equals((Object)Material.BREAD)) {
            return 5;
        }
        if (material.equals((Object)Material.COOKED_RABBIT)) {
            return 4;
        }
        if (material.equals((Object)Material.COOKED_CHICKEN)) {
            return 6;
        }
        if (material.equals((Object)Material.COOKED_MUTTON)) {
            return 6;
        }
        if (material.equals((Object)Material.GOLDEN_CARROT)) {
            return 4;
        }
        if (material.equals((Object)Material.RABBIT_STEW)) {
            return 6;
        }
        if (material.equals((Object)Material.PUMPKIN_PIE)) {
            return 8;
        }
        if (material.equals((Object)Material.COOKED_BEEF)) {
            return 8;
        }
        if (material.equals((Object)Material.RABBIT_STEW)) {
            return 10;
        }
        return 0;
    }

    public static boolean isFuelSource(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.getType().equals((Object)Material.DRIED_KELP_BLOCK)) {
            return true;
        }
        if (item.getType().equals((Object)Material.COAL)) {
            return true;
        }
        if (item.getType().equals((Object)Material.COAL_BLOCK)) {
            return true;
        }
        if (item.getType().equals((Object)Material.CHARCOAL)) {
            return true;
        }
        if (item.getType().equals((Object)Material.STICK)) {
            return true;
        }
        if (item.getType().equals((Object)Material.BAMBOO)) {
            return true;
        }
        if (item.getType().equals((Object)Material.BAMBOO_BLOCK)) {
            return true;
        }
        if (item.getType().equals((Object)Material.LAVA_BUCKET)) {
            return true;
        }
        String type = item.getType().toString();
        return type.contains("PLANK");
    }

    public static boolean isFurnaceSpecific(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.getType().equals((Object)Material.CACTUS)) {
            return true;
        }
        MTVersion mTVersion = MineMain.version;
        if (mTVersion instanceof MTVersion121) {
            MTVersion121 mt21 = (MTVersion121)mTVersion;
            if (mt21.resinClump && item.getType().equals((Object)Material.RESIN_CLUMP)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isCookable(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (TUItems.isSmeltable(item)) {
            return true;
        }
        return TUItems.isRaw(item.getType());
    }

    public static boolean isSmeltable(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.getType().equals((Object)Material.RAW_IRON)) {
            return true;
        }
        if (item.getType().equals((Object)Material.RAW_GOLD)) {
            return true;
        }
        if (item.getType().equals((Object)Material.RAW_COPPER)) {
            return true;
        }
        if (item.getType().equals((Object)Material.COBBLESTONE)) {
            return true;
        }
        if (item.getType().equals((Object)Material.STONE)) {
            return true;
        }
        if (item.getType().equals((Object)Material.CLAY_BALL)) {
            return true;
        }
        if (item.getType().equals((Object)Material.SAND)) {
            return true;
        }
        if (item.getType().equals((Object)Material.BASALT)) {
            return true;
        }
        String type = item.getType().toString();
        if (type.contains("IRON_ORE")) {
            return true;
        }
        if (type.contains("GOLD_ORE")) {
            return true;
        }
        if (type.contains("COPPER_ORE")) {
            return true;
        }
        if (type.contains("DIAMOND_ORE")) {
            return true;
        }
        if (type.contains("REDSTONE_ORE")) {
            return true;
        }
        if (type.contains("EMERALD_ORE")) {
            return true;
        }
        if (type.contains("LAPIS_ORE")) {
            return true;
        }
        if (type.contains("COAL_ORE")) {
            return true;
        }
        if (type.contains("LOG")) {
            return true;
        }
        return type.contains("_WOOD");
    }

    public static boolean isRaw(Material material) {
        if (material == null) {
            return false;
        }
        if (material.equals((Object)Material.MUTTON)) {
            return true;
        }
        if (material.equals((Object)Material.RABBIT)) {
            return true;
        }
        if (material.equals((Object)Material.BEEF)) {
            return true;
        }
        if (material.equals((Object)Material.CHICKEN)) {
            return true;
        }
        if (material.equals((Object)Material.RABBIT)) {
            return true;
        }
        if (material.equals((Object)Material.COD)) {
            return true;
        }
        if (material.equals((Object)Material.SALMON)) {
            return true;
        }
        if (material.equals((Object)Material.POTATO)) {
            return true;
        }
        if (material.equals((Object)Material.PORKCHOP)) {
            return true;
        }
        return material.equals((Object)Material.KELP);
    }

    public static boolean hasName(ItemStack item, String name, boolean strict, boolean colors) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && (strict ? (colors ? item.getItemMeta().getDisplayName().equals(name) : ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).equals(ChatColor.stripColor((String)name))) : (colors ? item.getItemMeta().getDisplayName().contains(name) : ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).contains(ChatColor.stripColor((String)name))));
    }

    public static ItemStack setAmount(ItemStack stack, int amount) {
        stack.setAmount(amount);
        return stack;
    }

    public static ArrayList<String> basicLore(String lore) {
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(lore);
        return lores;
    }

    public static ArrayList<String> basicLore(String lore, String lore2) {
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(lore);
        lores.add(lore2);
        return lores;
    }

    public static ArrayList<String> basicLore(String lore, String lore2, String lore3) {
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(lore);
        lores.add(lore2);
        lores.add(lore3);
        return lores;
    }

    public static ArrayList<String> basicLore(String lore, String lore2, String lore3, String lore4) {
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(lore);
        lores.add(lore2);
        lores.add(lore3);
        lores.add(lore4);
        return lores;
    }

    public static ArrayList<String> basicLore(String lore, String lore2, String lore3, String lore4, String lore5) {
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(lore);
        lores.add(lore2);
        lores.add(lore3);
        lores.add(lore4);
        lores.add(lore5);
        return lores;
    }

    public static ItemStack setModelData(ItemStack stack, int data) {
        ItemMeta meta = stack.getItemMeta();
        CustomModelDataComponent cmdc = meta.getCustomModelDataComponent();
        ArrayList<Float> list = new ArrayList<Float>();
        list.add(Float.valueOf(data));
        meta.setCustomModelDataComponent(cmdc);
        stack.setItemMeta(meta);
        return stack;
    }

    public static ItemStack createItem(Material itemMaterial, String itemName) {
        return TUItems.createItem(itemMaterial, itemName, null);
    }

    public static ItemStack createItem(Material itemMaterial, String itemName, List<String> itemLore) {
        ItemStack generatedItem = new ItemStack(itemMaterial);
        if (itemMaterial != Material.AIR) {
            ItemMeta meta = generatedItem.getItemMeta();
            if (itemName != null) {
                meta.setDisplayName(itemName);
            }
            if (itemLore != null) {
                meta.setLore(itemLore);
            }
            generatedItem.setItemMeta(meta);
        }
        return generatedItem;
    }

    public static ItemStack createItem(Material itemMaterial, String itemName, List<String> itemLore, int amount) {
        ItemStack generatedItem = TUItems.createItem(itemMaterial, itemName, itemLore);
        generatedItem.setAmount(amount);
        return generatedItem;
    }

    public static ItemStack getHead(String uuid, String name) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skull = (SkullMeta)item.getItemMeta();
        skull.setDisplayName(name);
        skull.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid)));
        item.setItemMeta((ItemMeta)skull);
        return item;
    }

    public static boolean isBase64Format(String str) {
        return str.length() > 100 && !str.contains(":") && str.matches("^[A-Za-z0-9+/=\\r\\n]+$");
    }

    /*
     * Loose catch block
     */
    public static String createStackString(ItemStack item) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                String string;
                BukkitObjectOutputStream out;
                ByteArrayOutputStream byteOut;
                block18: {
                    block17: {
                        byteOut = new ByteArrayOutputStream();
                        out = new BukkitObjectOutputStream((OutputStream)byteOut);
                        out.writeObject((Object)item);
                        string = Base64.getEncoder().encodeToString(byteOut.toByteArray());
                        if (out == null) break block17;
                        out.close();
                    }
                    if (byteOut == null) break block18;
                    byteOut.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (out != null) {
                                out.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (byteOut != null) {
                                byteOut.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static ItemStack createStackFromString(String base64) {
        if (!TUItems.isBase64Format(base64)) {
            ItemStack stack2222 = TUItems.migrateStackString(base64);
            if (stack2222 == null) {
                TUMaths.dm("Failed item Migration.");
            }
            migrationOccured = true;
            return stack2222;
        }
        try {
            Throwable stack2222 = null;
            Object var2_5 = null;
            try {
                ItemStack itemStack;
                BukkitObjectInputStream in;
                ByteArrayInputStream byteIn;
                block20: {
                    block19: {
                        byteIn = new ByteArrayInputStream(Base64.getDecoder().decode(base64));
                        in = new BukkitObjectInputStream((InputStream)byteIn);
                        itemStack = (ItemStack)in.readObject();
                        if (in == null) break block19;
                        in.close();
                    }
                    if (byteIn == null) break block20;
                    byteIn.close();
                }
                return itemStack;
                {
                    catch (Throwable stack2222) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw stack2222;
                        }
                        catch (Throwable throwable) {
                            if (stack2222 == null) {
                                stack2222 = throwable;
                            } else if (stack2222 != throwable) {
                                stack2222.addSuppressed(throwable);
                            }
                            if (byteIn != null) {
                                byteIn.close();
                            }
                            throw stack2222;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (stack2222 == null) {
                    stack2222 = throwable;
                } else if (stack2222 != throwable) {
                    stack2222.addSuppressed(throwable);
                }
                throw stack2222;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return new ItemStack(Material.AIR);
        }
    }

    public static ItemStack createStackFromString(String stackString, boolean useCache) {
        if (useCache && cachedStackStrings.containsKey(stackString)) {
            return cachedStackStrings.get(stackString);
        }
        ItemStack item = TUItems.createStackFromString(stackString);
        if (useCache) {
            cachedStackStrings.put(stackString, item);
        }
        return item;
    }

    public static ItemStack migrateStackString(String stackString) {
        YamlConfiguration cnfItem = new YamlConfiguration();
        try {
            cnfItem.loadFromString(stackString);
        }
        catch (InvalidConfigurationException e) {
            ItemStack oldStack = TUItems.createStackFromStringOLD(stackString);
            if (oldStack != null) {
                return oldStack;
            }
            return new ItemStack(Material.AIR);
        }
        if (cnfItem.getConfigurationSection("item") != null) {
            ItemStack stack = ItemStack.deserialize((Map)cnfItem.getConfigurationSection("item").getValues(true));
            return stack;
        }
        ItemStack oldStack = TUItems.createStackFromStringOLD(stackString);
        if (oldStack != null) {
            return oldStack;
        }
        return null;
    }

    public static ItemStack createStackFromStringOLD(String stackString) {
        PotionMeta pot;
        HashMap<Enchantment, Integer> enchs = new HashMap<Enchantment, Integer>();
        ArrayList<ItemFlag> flags = new ArrayList<ItemFlag>();
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        Material mat = null;
        String name = null;
        int amount = 1;
        int damage = -1;
        int modelData = -1;
        ArrayList<String> lore = new ArrayList<String>();
        Color potionColor = null;
        String[] pieces = stackString.split(":::");
        int i = 0;
        while (i < pieces.length) {
            String loreLine;
            int n;
            int n2;
            String[] stringArray;
            boolean skipped;
            String currentPiece = pieces[i];
            if (currentPiece.equals("TYPE")) {
                mat = Material.valueOf((String)pieces[i + 1]);
            }
            if (currentPiece.equals("NAME")) {
                name = pieces[i + 1];
            }
            if (currentPiece.equals("AMOUNT")) {
                amount = Integer.valueOf(pieces[i + 1]);
            }
            if (currentPiece.equals("DAMAGE")) {
                damage = Integer.valueOf(pieces[i + 1]);
            }
            if (currentPiece.equals("LORE")) {
                skipped = false;
                stringArray = pieces[i + 1].split("%%");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    loreLine = stringArray[n];
                    if (skipped) {
                        lore.add(loreLine);
                    } else {
                        skipped = true;
                    }
                    ++n;
                }
            }
            if (currentPiece.equals("ENCHANTS")) {
                skipped = false;
                stringArray = pieces[i + 1].split("%%");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    loreLine = stringArray[n];
                    if (skipped) {
                        String key = loreLine.split(":")[0];
                        int level = Integer.valueOf(loreLine.split(":")[1]);
                        enchs.put(Enchantment.getByKey((NamespacedKey)NamespacedKey.fromString((String)key)), level);
                    } else {
                        skipped = true;
                    }
                    ++n;
                }
            }
            if (currentPiece.equals("POTIONCOLOR")) {
                String[] rgb = pieces[i + 1].split("-");
                int red = Integer.parseInt(rgb[0]);
                int green = Integer.parseInt(rgb[1]);
                int blue = Integer.parseInt(rgb[2]);
                potionColor = Color.fromRGB((int)red, (int)green, (int)blue);
            }
            if (currentPiece.equals("POTIONFLAGS")) {
                String[] stringArray2 = pieces[i + 1].split("-");
                n = stringArray2.length;
                int n3 = 0;
                while (n3 < n) {
                    String strFlag = stringArray2[n3];
                    if (strFlag.length() > 0) {
                        flags.add(ItemFlag.valueOf((String)strFlag));
                    }
                    ++n3;
                }
            }
            if (currentPiece.equals("POTIONEFFECTS")) {
                String[] stringArray3 = pieces[i + 1].split("##");
                n = stringArray3.length;
                int n4 = 0;
                while (n4 < n) {
                    String strEffect = stringArray3[n4];
                    if (strEffect.length() > 0) {
                        String[] pePieces = strEffect.split("%%");
                        String peName = pePieces[0].split("t:")[1].replace("]", "");
                        PotionEffectType type = PotionEffectType.getByName((String)peName);
                        int duration = Integer.valueOf(pePieces[1]);
                        int amp = Integer.valueOf(pePieces[2]);
                        boolean amb = Boolean.valueOf(pePieces[3]);
                        boolean particles = Boolean.valueOf(pePieces[4]);
                        boolean icon = Boolean.valueOf(pePieces[5]);
                        potionEffects.add(new PotionEffect(type, duration, amp, amb, particles, icon));
                    }
                    ++n4;
                }
            }
            if (currentPiece.equals("MODEL")) {
                modelData = Integer.valueOf(pieces[i + 1]);
            }
            ++i;
        }
        if (mat == null) {
            mat = Material.AIR;
        }
        ItemStack stack = TUItems.createItem(mat, name, lore);
        stack.setAmount(amount);
        for (Enchantment ench : enchs.keySet()) {
            stack.addEnchantment(ench, ((Integer)enchs.get(ench)).intValue());
        }
        if (damage != -1) {
            Damageable dmg = (Damageable)stack.getItemMeta();
            dmg.setDamage(damage);
            stack.setItemMeta((ItemMeta)dmg);
        }
        if (potionColor != null) {
            pot = (PotionMeta)stack.getItemMeta();
            pot.setColor(potionColor);
            for (PotionEffect pe : potionEffects) {
                pot.addCustomEffect(pe, true);
            }
            stack.setItemMeta((ItemMeta)pot);
        }
        if (flags.size() > 0) {
            pot = (PotionMeta)stack.getItemMeta();
            for (ItemFlag iFlag : flags) {
                pot.addItemFlags(new ItemFlag[]{iFlag});
            }
            stack.setItemMeta((ItemMeta)pot);
        }
        if (modelData != -1) {
            ItemMeta im = stack.getItemMeta();
            im.setCustomModelData(Integer.valueOf(modelData));
            stack.setItemMeta(im);
        }
        return stack;
    }

    public static boolean isValid(ItemStack stack) {
        return stack != null && !stack.getType().equals((Object)Material.AIR);
    }

    public static void damageItem(ItemStack stack, Player player, int damage) {
        Damageable dmg = (Damageable)stack.getItemMeta();
        dmg.setDamage(dmg.getDamage() + damage);
        if (dmg.getDamage() >= stack.getType().getMaxDurability()) {
            stack.setAmount(stack.getAmount() - 1);
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        } else {
            stack.setItemMeta((ItemMeta)dmg);
        }
    }

    public static void setName(ItemStack stack, String name) {
        ItemMeta im = stack.getItemMeta();
        im.setDisplayName(name);
        stack.setItemMeta(im);
    }

    public static void repairItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (item.getType().getMaxDurability() == 0) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(0);
            item.setItemMeta(meta);
        }
    }

    public static boolean isDamaged(ItemStack item) {
        Damageable dmg;
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        if (item.getType().getMaxDurability() == 0) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        return itemMeta instanceof Damageable && (dmg = (Damageable)itemMeta).getDamage() > 0;
    }
}

