/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Lift;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.Vector3fc;

public class Belt {
    private Entity leftDisplay;
    private Entity rightDisplay;
    private ItemStack leftStack;
    private ItemStack rightStack;
    private Location loc;
    private BlockFace direction;
    private Mover mover;
    private Belt lastBelt;
    public static ArrayList<Item> noPickups = new ArrayList();
    private static HashMap<Location, Belt> belts = new HashMap();
    private Mover.OutDirection out;
    private Location leftCache = null;
    private Location rightCache = null;
    public BlockDisplay incoming1;
    public BlockDisplay incoming2;
    private boolean isRemoved = false;
    public ItemDisplay leftIncoming;
    public ItemDisplay rightIncoming;
    public boolean isLastBelt = false;
    public long lastMoveDelay = 0L;
    private boolean addedTicket = false;
    public Belt fromBelt;
    private ArrayList<Display> railing = new ArrayList();
    private static ArrayList<BlockFace> blankList = new ArrayList();

    public Belt(Location loc, BlockFace direction, Mover mover, Mover.OutDirection out) {
        this.loc = loc;
        this.direction = direction;
        this.mover = mover;
        belts.put(loc, this);
        this.out = out;
    }

    public ItemStack getLeftStack() {
        if (this.leftStack != null) {
            return this.leftStack.clone();
        }
        return null;
    }

    public ItemStack getLeftStackREADONLY() {
        if (this.leftStack != null) {
            return this.leftStack;
        }
        return null;
    }

    public void setLeftStackNoRemoval(ItemStack leftStack) {
        this.leftStack = leftStack;
    }

    public void setRightStackNoRemoval(ItemStack leftStack) {
        this.leftStack = leftStack;
    }

    public void setLeftStack(ItemStack leftItem) {
        this.leftStack = leftItem;
        if (this.leftStack == null) {
            this.setLeftDisplay(null);
        }
    }

    public ItemStack getRightStack() {
        if (this.rightStack != null) {
            return this.rightStack.clone();
        }
        return null;
    }

    public ItemStack getRightStackREADONLY() {
        if (this.rightStack != null) {
            return this.rightStack;
        }
        return null;
    }

    public void setRightStack(ItemStack rightItem) {
        this.rightStack = rightItem;
        if (this.rightStack == null) {
            this.setRightDisplay(null);
        }
    }

    public Location getLoc() {
        return this.loc.clone();
    }

    public Location getLocREADONLY() {
        return this.loc;
    }

    public BlockFace getDirection() {
        return this.direction;
    }

    public void setDirection(BlockFace direction) {
        this.direction = direction;
    }

    public boolean updateBelt() {
        boolean changed = false;
        this.updateDisplay();
        return changed;
    }

    public Location getLeftLocation() {
        if (this.leftCache != null) {
            return this.leftCache;
        }
        Location loc = TUMaths.centerLocation(this.getLoc().clone(), 0.3);
        if (this.getDirection().equals((Object)BlockFace.NORTH)) {
            loc.setX(loc.getX() - 0.25);
        }
        if (this.getDirection().equals((Object)BlockFace.EAST)) {
            loc.setZ(loc.getZ() - 0.25);
        }
        if (this.getDirection().equals((Object)BlockFace.SOUTH)) {
            loc.setX(loc.getX() + 0.25);
        }
        if (this.getDirection().equals((Object)BlockFace.WEST)) {
            loc.setZ(loc.getZ() + 0.25);
        }
        this.leftCache = loc;
        return this.leftCache;
    }

    public Location getRightLocation() {
        if (this.rightCache != null) {
            return this.rightCache;
        }
        Location loc = TUMaths.centerLocation(this.getLoc().clone(), 0.3);
        if (this.getDirection().equals((Object)BlockFace.NORTH)) {
            loc.setX(loc.getX() + 0.25);
        }
        if (this.getDirection().equals((Object)BlockFace.EAST)) {
            loc.setZ(loc.getZ() + 0.25);
        }
        if (this.getDirection().equals((Object)BlockFace.SOUTH)) {
            loc.setX(loc.getX() - 0.25);
        }
        if (this.getDirection().equals((Object)BlockFace.WEST)) {
            loc.setZ(loc.getZ() - 0.25);
        }
        this.rightCache = loc;
        return this.rightCache;
    }

    public void attemptMove() {
        if (!this.isValid()) {
            return;
        }
        if (this.getMover() != null) {
            Belt nextBelt = this.getMover().beltChain.get((Object)this.out).get(this);
            if (MineMain.allowBeltArrows) {
                if (MinetorioListener.isPlayerNearbyOPT(this.getLocREADONLY(), MineMain.beltArrowDistance)) {
                    long moveDelay = 20 / (this.mover.getEffectiveDrive() + 1);
                    long delay1 = moveDelay - 1L;
                    int teleportDuration = (int)(delay1 - 1L);
                    if (nextBelt != null) {
                        if (TUMaths.get2DManhattanDistance(this.getLoc(), nextBelt.getLoc()) < 2) {
                            if (this.incoming1 == null || this.incoming1 != null && this.incoming1.isDead()) {
                                Belt.spawnArrow(this.getLoc(), nextBelt.getLoc(), teleportDuration, this.mover.getArrowColor(), nextBelt);
                            } else {
                                Belt.spawnArrow(this.getLoc(), nextBelt.getLoc(), teleportDuration, this, nextBelt);
                            }
                        } else {
                            this.removeIncomingArrow();
                        }
                    } else {
                        this.removeIncomingArrow();
                    }
                } else {
                    this.removeIncomingArrow();
                }
            }
            if (nextBelt != null) {
                if (this.moveItems(nextBelt)) {
                    if (!TUMaths.isPlayerNearby(this.getLocREADONLY(), MineMain.farDistance)) {
                        return;
                    }
                    this.getLocREADONLY().getWorld().playSound(this.getLocREADONLY(), Sound.ENTITY_GUARDIAN_ATTACK, 0.03f, 1.0f);
                }
            } else if (Lift.liftType.equals((Object)Lift.LiftEntityType.DISPLAY) && Lift.animateLiftMovement && this.leftIncoming == null && this.rightIncoming == null) {
                this.updateDisplay();
            }
        }
    }

    public void removeIncomingArrow() {
        if (this.incoming1 != null) {
            this.incoming1.remove();
        }
        this.incoming1 = null;
        if (this.incoming2 != null) {
            this.incoming2.remove();
        }
        this.incoming2 = null;
    }

    public static void spawnArrow(Location fromLoc, Location toLoc, int teleportDuration, BlockData color, Belt toBelt) {
        fromLoc = fromLoc.clone().add(0.5, 0.0, 0.5);
        toLoc = toLoc.clone().add(0.5, 0.0, 0.5);
        BlockFace direction = TUMaths.getCardinalDirection(fromLoc, toLoc);
        float yaw = 90.0f;
        if (direction.equals((Object)BlockFace.EAST)) {
            yaw = 180.0f;
        }
        if (direction.equals((Object)BlockFace.SOUTH)) {
            yaw = 270.0f;
        }
        if (direction.equals((Object)BlockFace.WEST)) {
            yaw = 0.0f;
        }
        fromLoc.setYaw(yaw);
        World world = fromLoc.getWorld();
        float radYaw = (float)Math.toRadians(0.0);
        float scaleX = 0.5f;
        BlockDisplay part1 = (BlockDisplay)world.spawn(fromLoc, BlockDisplay.class);
        MineUtil.setDisposableEntity((Entity)part1);
        part1.setBlock(color);
        Transformation transform1 = part1.getTransformation();
        transform1.getScale().set(scaleX, 0.07f, 0.1f);
        transform1.getTranslation().set(-0.07f, 0.0f, -0.07f);
        transform1.getLeftRotation().rotateLocalY(radYaw + (float)Math.toRadians(45.0));
        part1.setTransformation(transform1);
        BlockDisplay part2 = (BlockDisplay)world.spawn(fromLoc, BlockDisplay.class);
        MineUtil.setDisposableEntity((Entity)part2);
        part2.setBlock(color);
        part2.setPersistent(false);
        Transformation transform2 = part1.getTransformation();
        transform2.getTranslation().reflect((Vector3fc)transform2.getTranslation());
        transform2.getScale().x = scaleX + 0.1f;
        transform2.getLeftRotation().invert();
        part2.setTransformation(transform2);
        part1.setTeleportDuration(teleportDuration);
        part2.setTeleportDuration(teleportDuration);
        Location fromLoc2 = fromLoc;
        Location toLoc2 = toLoc;
        float yaw2 = yaw;
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), () -> {
            Location part1Offset = part1.getLocation().subtract(fromLoc2);
            Location part2Offset = part2.getLocation().subtract(fromLoc2);
            Location tpLoc1 = toLoc2.clone().add(part1Offset);
            tpLoc1.setYaw(yaw2);
            Location tpLoc2 = toLoc2.clone().add(part2Offset);
            tpLoc2.setYaw(yaw2);
            part1.teleport(tpLoc1);
            part2.teleport(tpLoc2);
        }, 2L);
        if (toBelt == null) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), () -> {
                part1.remove();
                part2.remove();
            }, (long)teleportDuration + 3L);
        } else {
            toBelt.incoming1 = part1;
            toBelt.incoming2 = part2;
        }
    }

    public static void spawnArrow(Location fromLoc, Location toLoc, int teleportDuration, Belt fromBelt, Belt toBelt) {
        BlockDisplay part1 = fromBelt.incoming1;
        BlockDisplay part2 = fromBelt.incoming2;
        part1.setTeleportDuration(teleportDuration);
        part2.setTeleportDuration(teleportDuration);
        part1.setBlock(fromBelt.getMover().getArrowColor());
        part2.setBlock(fromBelt.getMover().getArrowColor());
        fromLoc = fromLoc.clone().add(0.5, 0.0, 0.5);
        toLoc = toLoc.clone().add(0.5, 0.0, 0.5);
        BlockFace direction = TUMaths.getCardinalDirection(fromLoc, toLoc);
        float yaw = 90.0f;
        if (direction.equals((Object)BlockFace.EAST)) {
            yaw = 180.0f;
        }
        if (direction.equals((Object)BlockFace.SOUTH)) {
            yaw = 270.0f;
        }
        if (direction.equals((Object)BlockFace.WEST)) {
            yaw = 0.0f;
        }
        fromLoc.setYaw(yaw);
        Location fromLoc2 = fromLoc;
        Location toLoc2 = toLoc;
        float yaw2 = yaw;
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), () -> {
            Location part1Offset = part1.getLocation().subtract(fromLoc2);
            Location part2Offset = part2.getLocation().subtract(fromLoc2);
            Location tpLoc1 = toLoc2.clone().add(part1Offset);
            tpLoc1.setYaw(yaw2);
            Location tpLoc2 = toLoc2.clone().add(part2Offset);
            tpLoc2.setYaw(yaw2);
            part1.teleport(tpLoc1);
            part2.teleport(tpLoc2);
        }, 2L);
        if (toBelt == null) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), () -> {
                part1.remove();
                part2.remove();
            }, (long)teleportDuration + 3L);
        } else {
            toBelt.incoming1 = part1;
            toBelt.incoming2 = part2;
            fromBelt.incoming1 = null;
            fromBelt.incoming2 = null;
        }
    }

    public void remove() {
        belts.remove(this.getLoc());
        this.isRemoved = true;
    }

    private boolean moveItems(Belt belt) {
        boolean moved = false;
        if (this.getMover() == null || belt.getMover() == null) {
            return false;
        }
        if (this.getMover().equals(belt.getMover())) {
            this.setLastBelt(belt);
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.ITEM) || Lift.liftType.equals((Object)Lift.LiftEntityType.DISPLAY) && !Lift.animateLiftMovement) {
                moved = this.moveItemsAsItems(belt);
            }
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.DISPLAY) && Lift.animateLiftMovement && !(moved = MinetorioListener.isPlayerNearbyOPT(this.getLocREADONLY(), MineMain.beltDistance) ? this.moveItemsSmoothly2(belt) : this.moveItemsAsItems(belt))) {
                this.updateDisplay();
            }
        }
        return moved;
    }

    public void removeLeftItem() {
        if (this.leftDisplay != null) {
            this.leftDisplay.remove();
            this.leftDisplay = null;
        }
    }

    public void removeRightItem() {
        if (this.rightDisplay != null) {
            this.rightDisplay.remove();
            this.rightDisplay = null;
        }
    }

    private boolean moveItemsSmoothly2(Belt toBelt) {
        boolean isLastBelt;
        boolean moved = false;
        toBelt.isLastBelt = isLastBelt = this.getMover().getLastBelt(this.out).equals(toBelt);
        if (this.getLeftStackREADONLY() != null && toBelt.getLeftStackREADONLY() == null) {
            toBelt.leftIncoming = this.moveVisualItem(this.getLeftStack(), this.getLeftLocation(), toBelt.getLeftLocation(), toBelt, this.leftIncoming, isLastBelt);
            toBelt.setLeftStack(this.getLeftStack());
            this.setLeftStack(null);
            this.setLeftDisplay(null);
            this.updateDisplay();
            moved = true;
        } else if (this.getLeftStackREADONLY() == null && toBelt.getLeftStackREADONLY() == null) {
            toBelt.leftIncoming = null;
        }
        if (this.getRightStackREADONLY() != null && toBelt.getRightStackREADONLY() == null) {
            toBelt.rightIncoming = this.moveVisualItem(this.getRightStack(), this.getRightLocation(), toBelt.getRightLocation(), toBelt, this.rightIncoming, isLastBelt);
            toBelt.setRightStack(this.getRightStack());
            this.setRightStack(null);
            this.setRightDisplay(null);
            this.updateDisplay();
            moved = true;
        } else if (this.getRightStackREADONLY() == null && toBelt.getRightStackREADONLY() == null) {
            toBelt.rightIncoming = null;
        }
        return moved;
    }

    private ItemDisplay moveVisualItem(ItemStack stack, Location startLocation, final Location endLocation, final Belt toBelt, ItemDisplay incoming, final boolean isLastBelt) {
        long moveDelay = 20 / (this.mover.getEffectiveDrive() + 1);
        long delay1 = moveDelay - 1L;
        int teleportDuration = (int)(delay1 - 1L);
        this.lastMoveDelay = teleportDuration;
        ItemDisplay display = incoming;
        if (incoming != null && incoming.isDead()) {
            display = null;
        }
        if (display == null) {
            display = (ItemDisplay)startLocation.getWorld().spawn(startLocation, ItemDisplay.class);
            MineUtil.setDisposableEntity((Entity)display);
            display.getPersistentDataContainer().set(Device.iconStackKey, PersistentDataType.BOOLEAN, (Object)true);
            display.setMetadata("MT-BELTDISPLAY", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)true));
        }
        display.setItemStack(stack);
        display.setTransformation(Lift.getDisplayScale(display, stack));
        display.setTeleportDuration(teleportDuration - 1);
        if (TUMaths.get2DManhattanDistance(startLocation, endLocation) > 2) {
            display.setTeleportDuration(0);
        }
        final ItemDisplay display2 = display;
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                display2.teleport(endLocation);
            }
        }, 1L);
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                toBelt.updateDisplay();
            }
        }, (long)teleportDuration);
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (isLastBelt || display2.hasMetadata("MT-REMOVE")) {
                    display2.remove();
                }
            }
        }, (long)teleportDuration + 1L);
        return display;
    }

    private boolean moveItemsAsItems(Belt toBelt) {
        boolean moved = false;
        if (this.getLeftStackREADONLY() != null && toBelt.getLeftStackREADONLY() == null) {
            toBelt.setLeftStack(this.getLeftStack());
            this.setLeftStack(null);
            this.setLeftDisplay(null);
            moved = true;
        }
        if (this.getRightStackREADONLY() != null && toBelt.getRightStackREADONLY() == null) {
            toBelt.setRightStack(this.getRightStack());
            this.setRightStack(null);
            this.setRightDisplay(null);
            moved = true;
        }
        return moved;
    }

    public static ArrayList<Belt> getBelts() {
        return new ArrayList<Belt>(belts.values());
    }

    public static ArrayList<Belt> getBeltsREADONLY() {
        return Belt.getBelts();
    }

    public static boolean isBelt(Location loc) {
        for (Belt belt : Belt.getBelts()) {
            if (!belt.getLoc().equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    public static Belt getBelt(Location loc) {
        return belts.getOrDefault(loc, null);
    }

    public static BlockFace createDirection(Location from, Location soonToBeBelt) {
        Block block = from.getBlock();
        if (block.getRelative(BlockFace.NORTH).getLocation().equals((Object)soonToBeBelt)) {
            return BlockFace.NORTH;
        }
        if (block.getRelative(BlockFace.SOUTH).getLocation().equals((Object)soonToBeBelt)) {
            return BlockFace.SOUTH;
        }
        if (block.getRelative(BlockFace.WEST).getLocation().equals((Object)soonToBeBelt)) {
            return BlockFace.WEST;
        }
        if (block.getRelative(BlockFace.EAST).getLocation().equals((Object)soonToBeBelt)) {
            return BlockFace.EAST;
        }
        return null;
    }

    public static boolean isDetachedBelt(Location loc) {
        Belt belt;
        return Belt.isBelt(loc) && (belt = Belt.getBelt(loc)).getMover() == null;
    }

    public Material getColor() {
        return this.getLoc().getBlock().getType();
    }

    public void applyPower() {
        Block block = this.getLoc().getBlock();
        BlockData data = block.getBlockData();
        if (!(data instanceof AnaloguePowerable)) {
            return;
        }
        AnaloguePowerable powerable = (AnaloguePowerable)data;
        powerable.setPower(15);
        block.setBlockData((BlockData)powerable);
    }

    public Mover getMover() {
        return this.mover;
    }

    public void setMover(Mover mover) {
        this.mover = mover;
    }

    public static boolean isCarpet(Location loc) {
        return loc.getBlock().getType().toString().contains("CARPET");
    }

    public static boolean isCarpet(Block block) {
        return block.getType().toString().contains("CARPET");
    }

    public Belt getLastBelt() {
        return this.lastBelt;
    }

    public void setLastBelt(Belt lastBelt) {
        this.lastBelt = lastBelt;
    }

    public boolean isValid() {
        return belts.containsKey(this.getLocREADONLY());
    }

    public void clearBelt() {
        this.setLeftStack(null);
        this.setRightStack(null);
        this.clearRails();
        this.removeIncomingArrow();
        if (this.leftIncoming != null) {
            this.leftIncoming.remove();
        }
        if (this.rightIncoming != null) {
            this.rightIncoming.remove();
        }
    }

    public void releaseItems(boolean popEffect) {
        Item item;
        Item item2;
        ItemStack stack;
        if (this.leftIncoming != null) {
            this.leftIncoming.remove();
        }
        if (this.rightIncoming != null) {
            this.rightIncoming.remove();
        }
        if (this.getLeftDisplay() != null) {
            this.getLeftDisplay().removeMetadata(MineMain.noPickupMetaValue, MineMain.getPlugin());
            stack = null;
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.ITEM)) {
                stack = ((Item)this.getLeftDisplay()).getItemStack();
            }
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.DISPLAY)) {
                stack = ((ItemDisplay)this.getLeftDisplay()).getItemStack();
            }
            item2 = this.loc.getWorld().dropItem(this.getLeftDisplay().getLocation(), stack);
            if (!popEffect) {
                item2.setVelocity(new Vector());
            }
            this.setLeftStack(null);
            this.setLeftDisplay(null);
        } else if (this.getLeftStack() != null) {
            item = this.loc.getWorld().dropItem(this.getLeftLocation(), this.getLeftStack());
            item.setVelocity(new Vector());
        }
        if (this.getRightDisplay() != null) {
            this.getRightDisplay().removeMetadata(MineMain.noPickupMetaValue, MineMain.getPlugin());
            stack = null;
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.ITEM)) {
                stack = ((Item)this.getRightDisplay()).getItemStack();
            }
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.DISPLAY)) {
                stack = ((ItemDisplay)this.getRightDisplay()).getItemStack();
            }
            item2 = this.loc.getWorld().dropItem(this.getRightDisplay().getLocation(), stack);
            if (!popEffect) {
                item2.setVelocity(new Vector());
            }
            this.setRightStack(null);
            this.setRightDisplay(null);
        } else if (this.getRightStack() != null) {
            item = this.loc.getWorld().dropItem(this.getRightLocation(), this.getRightStack());
            item.setVelocity(new Vector());
        }
    }

    public Entity getLeftDisplay() {
        return this.leftDisplay;
    }

    public void setLeftDisplay(Entity leftDisplay) {
        if (leftDisplay == null && this.leftDisplay != null) {
            this.leftDisplay.remove();
        }
        this.leftDisplay = leftDisplay;
    }

    public Entity getRightDisplay() {
        return this.rightDisplay;
    }

    public void setRightDisplay(Entity rightDisplay) {
        if (rightDisplay == null && this.rightDisplay != null) {
            this.rightDisplay.remove();
        }
        this.rightDisplay = rightDisplay;
    }

    public void spawnLeftItem() {
        if (this.getLeftStack() != null && this.getLeftDisplay() == null) {
            Location loc = this.getLeftLocation();
            ItemStack convStack = this.getLeftStack();
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.ITEM)) {
                Item item = loc.getWorld().dropItem(loc, convStack);
                item.setMetadata(MineMain.noPickupMetaValue, (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)MineMain.noPickupMetaValue));
                item.getPersistentDataContainer().set(Device.iconStackKey, PersistentDataType.BOOLEAN, (Object)true);
                item.setVelocity(new Vector());
                item.setGravity(false);
                this.setLeftDisplay((Entity)item);
                noPickups.add(item);
            }
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.DISPLAY)) {
                ItemDisplay display = (ItemDisplay)loc.getWorld().spawn(loc, ItemDisplay.class);
                MineUtil.setDisposableEntity((Entity)display);
                display.setTransformation(Lift.getDisplayScale(display, convStack));
                display.setItemStack(convStack);
                display.setMetadata("MT-BELTDISPLAY", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)true));
                display.getPersistentDataContainer().set(Device.iconStackKey, PersistentDataType.BOOLEAN, (Object)true);
                this.leftDisplay = display;
            }
        }
    }

    public void spawnRightItem() {
        if (this.getRightStack() != null && this.getRightDisplay() == null) {
            Location loc = this.getRightLocation();
            ItemStack convStack = this.getRightStack();
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.ITEM)) {
                Item item = loc.getWorld().dropItem(loc, convStack);
                item.setMetadata(MineMain.noPickupMetaValue, (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)MineMain.noPickupMetaValue));
                item.getPersistentDataContainer().set(Device.iconStackKey, PersistentDataType.BOOLEAN, (Object)true);
                item.setVelocity(new Vector());
                item.setGravity(false);
                this.setRightDisplay((Entity)item);
                noPickups.add(item);
            }
            if (Lift.liftType.equals((Object)Lift.LiftEntityType.DISPLAY)) {
                ItemDisplay display = (ItemDisplay)loc.getWorld().spawn(loc, ItemDisplay.class);
                MineUtil.setDisposableEntity((Entity)display);
                display.setTransformation(Lift.getDisplayScale(display, convStack));
                display.setItemStack(convStack);
                display.setMetadata("MT-BELTDISPLAY", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)true));
                display.getPersistentDataContainer().set(Device.iconStackKey, PersistentDataType.BOOLEAN, (Object)true);
                this.rightDisplay = display;
            }
        }
    }

    public void updateDisplay() {
        boolean inFarRange = MinetorioListener.isPlayerNearbyOPT(this.getLocREADONLY(), MineMain.beltDistance);
        if (inFarRange) {
            if (!this.addedTicket) {
                this.addedTicket = this.getLocREADONLY().getChunk().addPluginChunkTicket(MineMain.getPlugin());
            }
            if (!this.isRemoved) {
                this.spawnLeftItem();
                this.spawnRightItem();
            }
        } else {
            this.setLeftDisplay(null);
            this.setRightDisplay(null);
            if (this.leftIncoming != null) {
                this.leftIncoming.remove();
            }
            if (this.rightIncoming != null) {
                this.rightIncoming.remove();
            }
            if (this.addedTicket) {
                this.getLocREADONLY().getChunk().removePluginChunkTicket(MineMain.getPlugin());
                this.addedTicket = false;
            }
        }
        if (MineMain.allowBeltRails) {
            if (inFarRange && MinetorioListener.isPlayerNearbyOPT(this.getLocREADONLY(), MineMain.beltRailDistance)) {
                if (!this.isRemoved && this.railing.size() == 0) {
                    Belt nextBelt;
                    ArrayList<BlockFace> skipFaces = new ArrayList<BlockFace>();
                    if (this.fromBelt != null) {
                        skipFaces.add(TUMaths.getCardinalDirection(this.getLoc(), this.fromBelt.getLoc()));
                    }
                    if ((nextBelt = this.getMover().beltChain.get((Object)this.out).get(this)) != null) {
                        skipFaces.add(TUMaths.getCardinalDirection(this.getLoc(), nextBelt.getLoc()));
                    }
                    this.setRailing(Belt.spawnCarpetBorder(this.getLoc(), Material.LIGHT_GRAY_CONCRETE, skipFaces));
                }
            } else {
                this.clearRails();
            }
        }
    }

    private void railingOclussion() {
        if (this.railing.isEmpty()) {
            return;
        }
        Player[] players2 = MinetorioListener.currentPlayersByWorld.get(this.getLocREADONLY().getWorld());
        if (players2 == null) {
            return;
        }
        Player[] playerArray = players2;
        int n = players2.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            for (Display linkedDisplay : this.railing) {
                if (MinetorioListener.getManhattanDistance(player.getLocation(), this.getLocREADONLY()) > MineMain.beltRailDistance / 2) {
                    if (player.hasLineOfSight((Entity)linkedDisplay)) {
                        player.showEntity(MineMain.getPlugin(), (Entity)linkedDisplay);
                        continue;
                    }
                    player.hideEntity(MineMain.getPlugin(), (Entity)linkedDisplay);
                    continue;
                }
                player.showEntity(MineMain.getPlugin(), (Entity)linkedDisplay);
            }
            ++n2;
        }
    }

    public void setRailing(ArrayList<Display> rails) {
        this.clearRails();
        this.railing = rails;
    }

    public void clearRails() {
        for (Display display : this.railing) {
            display.remove();
        }
        this.railing.clear();
    }

    public static ArrayList<Display> spawnCarpetBorder(Location loc, Material woolColor) {
        return Belt.spawnCarpetBorder(loc, woolColor, blankList);
    }

    public static ArrayList<Display> spawnCarpetBorder(Location loc, Material woolColor, ArrayList<BlockFace> ignoreDirections) {
        ArrayList<Display> railing = new ArrayList<Display>();
        World world = loc.getWorld();
        loc = loc.clone().add(0.5, 0.0, 0.5);
        float thickness = 0.07f;
        float scaleY = 0.09375f;
        float scaleX = 1.0f;
        float scaleZ = thickness;
        if (!ignoreDirections.contains(BlockFace.NORTH) && loc.getBlock().getRelative(BlockFace.NORTH).getType().isAir()) {
            BlockDisplay northSide = Belt.createBorderDisplay(world, loc.clone().add(-0.5125, 0.0, -0.5125), woolColor, scaleX + 0.025f, scaleY, scaleZ);
            railing.add((Display)northSide);
        }
        if (!ignoreDirections.contains(BlockFace.SOUTH) && loc.getBlock().getRelative(BlockFace.SOUTH).getType().isAir()) {
            BlockDisplay southSide = Belt.createBorderDisplay(world, loc.clone().add(-0.5125, 0.0, 0.4375), woolColor, scaleX + 0.025f, scaleY, scaleZ);
            railing.add((Display)southSide);
        }
        if (!ignoreDirections.contains(BlockFace.EAST) && loc.getBlock().getRelative(BlockFace.EAST).getType().isAir()) {
            BlockDisplay eastSide = Belt.createBorderDisplay(world, loc.clone().add(0.4375, 0.0, -0.5125), woolColor, scaleZ, scaleY, scaleX + 0.025f);
            railing.add((Display)eastSide);
        }
        if (!ignoreDirections.contains(BlockFace.WEST) && loc.getBlock().getRelative(BlockFace.WEST).getType().isAir()) {
            BlockDisplay westSide = Belt.createBorderDisplay(world, loc.clone().add(-0.5125, 0.0, -0.5125), woolColor, scaleZ, scaleY, scaleX + 0.025f);
            railing.add((Display)westSide);
        }
        return railing;
    }

    private static BlockDisplay createBorderDisplay(World world, Location loc, Material woolColor, float scaleX, float scaleY, float scaleZ) {
        BlockDisplay display = (BlockDisplay)world.spawn(loc, BlockDisplay.class);
        MineUtil.setDisposableEntity((Entity)display);
        display.setPersistent(false);
        display.setBlock(Bukkit.createBlockData((Material)woolColor));
        display.setBrightness(new Display.Brightness(15, 15));
        Transformation transformation = display.getTransformation();
        transformation.getScale().set(scaleX, scaleY, scaleZ);
        display.setTransformation(transformation);
        return display;
    }
}

