/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Defense;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.ShipCore;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.SpaceObjects.ResourceAsteroid;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class RailGun
extends Device {
    private static final long serialVersionUID = -5711957959587600700L;
    private static String classSpacedNamed = "Rail Gun";
    private transient HashSet<UUID> lockedOn = new HashSet();
    private transient HashSet<ResourceAsteroid> lockedOnRoid = new HashSet();

    public RailGun(Location loc) {
        super(loc);
        this.setMaterial("DEEPSLATE_BRICK_SLAB");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(1);
        this.setActionPower(2);
        this.setUseUI(true);
        this.useAutoSlots();
        this.useAutoUI();
        this.updateDeviceHeadItem();
        this.displayLockedHorizontal = true;
        this.lockRotation = true;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Can destroy incoming asteroids in one hit.");
        lore.add("- Limited firing arc of 10 blocks in front of it.");
        lore.add("- Targets must be atleast 10 blocks in front of it.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ItemStack stack = this.createInfoIcon();
        this.getInventory().setItem(13, stack);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 13) {
            ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.updateUI();
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.LIGHT_GRAY_CANDLE, 0.5);
    }

    @Override
    public void action() {
        if (this.getGrid() == null) {
            return;
        }
        if (this.lockedOn == null) {
            this.lockedOn = new HashSet();
        }
        if (this.lockedOnRoid == null) {
            this.lockedOnRoid = new HashSet();
        }
        if (!MinetorioListener.isPlayerNearby2DOPT(this.getLocationREADONLY(), MineMain.chunkViewDistance)) {
            return;
        }
        if (!this.getGrid().hasPower(this.getActionPower())) {
            this.setFailReason("Need " + this.getActionPower() + " power");
            return;
        }
        ItemStack missile = null;
        for (ItemStack stack : this.getInputItems()) {
            if (!MineItems.isIndustrialItem(stack, "Railgun Round")) continue;
            missile = stack;
            break;
        }
        if (missile == null) {
            this.setFailReason("Need Railgun Round");
            return;
        }
        ResourceAsteroid targetAsteroid = null;
        if (this.getLocationREADONLY().getWorld().getName().equals("MT_world_space") && this.getCore() != null) {
            if (this.getCore().incomingRoids == null) {
                this.getCore().incomingRoids = new HashSet();
            }
            for (ResourceAsteroid roid : this.getCore().incomingRoids) {
                if (this.lockedOnRoid.contains(roid) || roid.removed || roid.getAsteroidSize().equals((Object)ResourceAsteroid.Size.CHUNK) || TUMaths.get2DManhattanDistance(roid.getLocation(), this.getLocation()) > 128 || !(roid.getLocation().getZ() + 10.0 < this.getLocation().getZ()) || !(Math.abs(roid.getLocation().getX() - this.getLocation().getX()) <= 15.0)) continue;
                targetAsteroid = roid;
            }
        }
        if (targetAsteroid == null) {
            this.setFailReason("Waiting for target");
            return;
        }
        if (targetAsteroid != null) {
            this.lockedOnRoid.add(targetAsteroid);
        }
        missile.setAmount(missile.getAmount() - 1);
        this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.BLOCK_VAULT_EJECT_ITEM, 1.0f, 0.5f);
        this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.ENTITY_FIREWORK_ROCKET_LAUNCH, 0.5f, 0.5f);
        if (targetAsteroid != null) {
            this.spawnHomingMissile(targetAsteroid, 5.0, 5.0);
        }
    }

    private ShipCore getCore() {
        ShipCore core = null;
        ArrayList<Device> cores = Device.getNearbyDevicesByType(this.getLocation(), 100, "Ship Core");
        if (cores.size() > 0) {
            core = (ShipCore)Device.getNearbyDevicesByType(this.getLocation(), 100, "Ship Core").get(0);
        }
        return core;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, RailGun.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.DEFENSE, new RailGun(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        ings.add(MineItems.getIndustrialItem("Copper Cable", 2));
        ings.add(MineItems.getIndustrialItem("Iron Plate", 5));
        RecipeUtils.addDefaultRecipe(new RailGun(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 1;
    }

    public void spawnHomingMissile(final ResourceAsteroid roidTarget, final double speed, final double stopDistance) {
        new BukkitRunnable(){
            Location current;
            World world;
            {
                this.current = RailGun.this.getLocation();
                this.world = resourceAsteroid.getLocation().getWorld();
            }

            public void run() {
                if (roidTarget.removed) {
                    this.cancel();
                    RailGun.this.lockedOnRoid.remove(roidTarget);
                    return;
                }
                Location targetLoc = roidTarget.getLocation();
                Vector toTarget = targetLoc.toVector().subtract(this.current.toVector());
                double distance = TUMaths.get2DManhattanDistance(this.current, targetLoc);
                if (distance > (double)MineMain.chunkViewDistance) {
                    RailGun.this.lockedOnRoid.remove(roidTarget);
                    this.cancel();
                    return;
                }
                if (distance < stopDistance) {
                    RailGun.spawnParticleBurst(targetLoc, Particle.CAMPFIRE_COSY_SMOKE, 20, 2.0);
                    RailGun.spawnParticleBurst(targetLoc, Particle.FLAME, 20, 2.0);
                    RailGun.spawnParticleBurst(targetLoc, Particle.SMOKE, 20, 3.0);
                    targetLoc.getWorld().playSound(targetLoc, Sound.ENTITY_FIREWORK_ROCKET_LARGE_BLAST_FAR, 10.0f, 0.5f);
                    roidTarget.damage(100);
                    RailGun.this.lockedOnRoid.remove(roidTarget);
                    this.cancel();
                    return;
                }
                Vector motion = toTarget.normalize().multiply(speed);
                this.current.add(motion);
                this.world.spawnParticle(Particle.SMOKE, this.current, 1, 0.0, 0.0, 0.0, 0.0, null, true);
            }
        }.runTaskTimer(MineMain.getPlugin(), 0L, 1L);
    }

    public static void spawnParticleBurst(Location center, Particle particle, int count, double radius) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        Random random = new Random();
        int i = 0;
        while (i < count) {
            double theta = Math.PI * 2 * random.nextDouble();
            double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
            double r = radius * Math.cbrt(random.nextDouble());
            double x = r * Math.sin(phi) * Math.cos(theta);
            double y = r * Math.sin(phi) * Math.sin(theta);
            double z = r * Math.cos(phi);
            Location particleLoc = center.clone().add(x, y, z);
            world.spawnParticle(particle, particleLoc, 3, 1.0, 1.0, 1.0, 0.0, null, true);
            ++i;
        }
    }
}

