/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PlayerData;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Centrifuge
extends Device {
    private static final long serialVersionUID = -39814092254499315L;
    private static String classSpacedNamed = "Centrifuge";

    public Centrifuge(Location loc) {
        super(loc);
        this.setMaterial("DARK_PRISMARINE_SLAB");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setIdlePower(3);
        this.setActionPower(20);
        this.setUseUI(true);
        this.useAutoSlots();
        this.useAutoUI();
        this.setUseUI(true);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Extracts uranium 235 & 238 from uranium ore.");
        lore.add("- With Uranium Reprocessing you may also do the following.");
        lore.add("- Refuel Uranium Fuel Cells using 8 uranium 238.");
        lore.add("- Can enrich uranium by using one u235 and eight u238.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ArrayList<String> lore = new ArrayList<String>();
        if (this.getFailReason() != null && !this.getFailReason().equals("None")) {
            lore.add(String.valueOf(ChatColor.RED) + " " + this.getFailReason());
            lore.add(" ");
        }
        for (String str : MineUtil.wrapText("This will extract u238 or u235 from uranium ore. The chance is 1 in 500 to get u235.", 45)) {
            lore.add(" " + String.valueOf(ChatColor.GRAY) + str);
        }
        lore.add(" ");
        lore.add(MineItems.whiteBold() + " " + String.valueOf(ChatColor.UNDERLINE) + "With Uranium Reprocessing Unlocked");
        lore.add(" ");
        for (String str : MineUtil.wrapText("You can input 1 u235 and 8 u238 to make 2 u235 or use 8 u238 and 1 used Uranium Fuel Cell to make a Uranium Fuel Cell.", 45)) {
            lore.add(" " + String.valueOf(ChatColor.GRAY) + str);
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Centrifuge Info", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output slot");
                return;
            }
            if (this.getGrid().hasPower(this.getActionPower())) {
                PlayerData pd;
                ItemStack uraniumOre = null;
                ItemStack u235 = null;
                ItemStack emptyCell = null;
                int u238amount = 0;
                ArrayList<ItemStack> u238Stacks = new ArrayList<ItemStack>();
                for (ItemStack stack : this.getInputItems()) {
                    if (!TUItems.isValid(stack)) continue;
                    if (MineItems.isIndustrialItem(stack, "Uranium Ore")) {
                        uraniumOre = stack;
                    }
                    if (MineItems.isIndustrialItem(stack, "Uranium 238")) {
                        u238amount += stack.getAmount();
                        u238Stacks.add(stack);
                    }
                    if (MineItems.isIndustrialItem(stack, "Uranium 235")) {
                        u235 = stack;
                    }
                    if (!MineItems.isIndustrialItem(stack, "Used Uranium Fuel Cell")) continue;
                    emptyCell = stack;
                }
                boolean usePower = false;
                if (uraniumOre != null) {
                    uraniumOre.setAmount(uraniumOre.getAmount() - 1);
                    ItemStack uranium = MineItems.getIndustrialItem("Uranium 238");
                    if (TUMaths.rollRange(0, 499) <= 0) {
                        uranium = MineItems.getIndustrialItem("Uranium 235");
                    }
                    this.getInventory().setItem(this.getOutputSlot(), uranium);
                    usePower = true;
                }
                boolean use238 = false;
                if (!usePower && (pd = PlayerData.getPlayerData(this.getPlacerUUIDString())).hasTech("Uranium Reprocessing")) {
                    if (!usePower && emptyCell != null && u238amount >= 8) {
                        use238 = true;
                        emptyCell.setAmount(emptyCell.getAmount() - 1);
                        this.getInventory().setItem(this.getOutputSlot(), MineItems.getIndustrialItem("Uranium Fuel Cell"));
                        usePower = true;
                    }
                    if (!usePower && u235 != null && u238amount >= 8) {
                        use238 = true;
                        u235.setAmount(u235.getAmount() - 1);
                        ItemStack stack = MineItems.getIndustrialItem("Uranium 235");
                        stack.setAmount(2);
                        this.getInventory().setItem(this.getOutputSlot(), stack);
                        usePower = true;
                    }
                }
                if (usePower) {
                    if (use238) {
                        int removeAmount = 8;
                        for (ItemStack stack : u238Stacks) {
                            if (stack.getAmount() >= removeAmount) {
                                stack.setAmount(stack.getAmount() - removeAmount);
                                removeAmount = 0;
                            } else {
                                removeAmount -= stack.getAmount();
                                stack.setAmount(0);
                            }
                            if (removeAmount <= 0) break;
                        }
                    }
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance)) {
                        this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_FIRE_AMBIENT, 1.0f, 1.0f);
                    }
                } else {
                    this.setFailReason("No refining possible");
                }
            }
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.LIME_CANDLE, 0.5);
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, Centrifuge.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new Centrifuge(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Processing Unit", 3));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 5));
        RecipeUtils.addDefaultRecipe(new Centrifuge(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 4;
    }
}

