/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Planets.PlanetHandler;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class WindTurbine
extends Device {
    private static final long serialVersionUID = -3929409111254451315L;
    private int airSize = 0;
    private int lastPower = 0;
    private static String classSpacedNamed = "Wind Turbine";
    private boolean hasClearence = true;
    private static int neededAirBlocks = 1000;
    private double clearenceMin = 0.75;
    private int rescan = 0;
    private double lastHeightMod = 0.0;
    private int gustBonus = 0;
    private static ArrayList<BlockFace> faces = new ArrayList();

    static {
        faces.add(BlockFace.UP);
        faces.add(BlockFace.DOWN);
        faces.add(BlockFace.NORTH);
        faces.add(BlockFace.SOUTH);
        faces.add(BlockFace.WEST);
        faces.add(BlockFace.EAST);
    }

    public WindTurbine(Location loc) {
        super(loc);
        this.setMaterial("SMOKER");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setStoreForm(false);
        this.setPowerGen(10);
        this.setUseUI(true);
        this.setDeviceCrowding(true);
        this.crowdingDistance = 15;
        this.determineVolume(loc);
    }

    private void determineVolume(Location loc) {
        if (loc == null) {
            return;
        }
        Location corner1 = loc.clone().add(-5.0, -3.0, -5.0);
        Location corner2 = loc.clone().add(5.0, 7.0, 5.0);
        this.airSize = WindTurbine.getAirBlocks(Material.AIR, loc, corner1, corner2);
        this.hasClearence = (double)this.airSize >= (double)neededAirBlocks * this.clearenceMin;
    }

    private double volumeMod() {
        if (this.airSize >= neededAirBlocks) {
            return 1.0;
        }
        double base = (double)this.airSize / ((double)neededAirBlocks * 1.0);
        double missing = 1.0 - base;
        return 1.0 - (missing *= 4.0);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Needs to be in a open area to work best.");
        lore.add("- Place higher for optimal power.");
        lore.add("- Requires space from other wind turbines.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = TUItems.basicLore(String.valueOf(ChatColor.GOLD) + " Production:" + String.valueOf(ChatColor.WHITE) + " " + this.lastPower + MineItems.getEnergyIcon() + "/" + this.getPowerGen() + MineItems.getEnergyIcon());
        int speed = (int)(MineMain.storyteller.getWindLevel() * 100.0);
        ChatColor color = ChatColor.WHITE;
        if (speed >= 80) {
            color = ChatColor.GREEN;
        }
        if (speed <= 50) {
            color = ChatColor.YELLOW;
        }
        if (speed <= 30) {
            color = ChatColor.RED;
        }
        lore.add(MineUtil.colon(" Wind Speed", String.valueOf(color) + speed + "%"));
        if (!this.hasClearence) {
            lore.add(String.valueOf(ChatColor.RED) + "  - Too obstructed " + String.valueOf(ChatColor.BOLD) + "x0.0\u26a1");
        } else if (this.airSize < neededAirBlocks) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "  - Obscured area " + String.valueOf(ChatColor.BOLD) + "x" + TUMaths.roundDouble(this.volumeMod(), 2) + "\u26a1");
        }
        if (this.getCrowdingEffeciency(0.1) != 1.0) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "  - Wind turbine crowding " + String.valueOf(ChatColor.BOLD) + "x" + TUMaths.roundDouble(this.getCrowdingEffeciency(0.1), 2) + "\u26a1");
        }
        if (this.lastHeightMod != 1.0) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "  - Low placement " + String.valueOf(ChatColor.BOLD) + "x" + TUMaths.roundDouble(this.lastHeightMod, 2) + "\u26a1");
        }
        if (this.gustBonus != 0) {
            lore.add(String.valueOf(ChatColor.GREEN) + "  + Local Wind Gust " + MineItems.greenBold() + "x1.25\u26a1");
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Power Generation", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void action() {
        if (this.gustBonus > 0) {
            --this.gustBonus;
        }
        if (this.getGrid() != null) {
            this.setProducingPower(false);
            boolean isPlayerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance);
            if (isPlayerNear) {
                --this.rescan;
                if (this.rescan <= 0) {
                    this.determineVolume(this.getLocation());
                    this.rescan = 600;
                }
            }
            int powerGen = this.getPowerGen();
            powerGen = (int)((double)powerGen * this.volumeMod());
            powerGen = (int)((double)powerGen * this.getCrowdingEffeciency(0.1));
            this.lastHeightMod = 0.5 + (this.getLocation().getY() - 62.0) / 10.0 * 0.1;
            if (this.lastHeightMod < 0.0) {
                this.lastHeightMod = 0.0;
            }
            if (this.lastHeightMod > 1.0) {
                this.lastHeightMod = 1.0;
            }
            powerGen = (int)((double)powerGen * this.lastHeightMod);
            double windLevel = MineMain.storyteller.getWindMod();
            if (isPlayerNear && this.getLocation().getWorld().hasStorm()) {
                windLevel = 1.0;
            }
            if (this.gustBonus == 0 && TUMaths.rollRange(0, 240) <= 0) {
                this.gustBonus = 60;
            }
            if (this.gustBonus > 0 && (windLevel += 0.25) > 1.0) {
                windLevel = 1.0;
            }
            if ((powerGen = (int)((double)powerGen * this.planetAdjustment(windLevel))) < 0) {
                powerGen = 0;
            }
            this.lastPower = powerGen;
            this.getGrid().addPower(this, powerGen);
            this.setProducingPower(true);
        }
    }

    public double planetAdjustment(double windLevel) {
        Planet planet = PlanetHandler.getPlanetByWorld(this.getLocationREADONLY().getWorld().getName());
        if (planet != null) {
            return windLevel * planet.getWindLevels();
        }
        return windLevel;
    }

    public static int getAirBlocks(Material targetMaterial, Location start, Location corner1, Location corner2) {
        int air = 0;
        World world = start.getWorld();
        if (world == null) {
            return 0;
        }
        int minX = Math.min(corner1.getBlockX(), corner2.getBlockX());
        int maxX = Math.max(corner1.getBlockX(), corner2.getBlockX());
        int minY = Math.min(corner1.getBlockY(), corner2.getBlockY());
        int maxY = Math.max(corner1.getBlockY(), corner2.getBlockY());
        int minZ = Math.min(corner1.getBlockZ(), corner2.getBlockZ());
        int maxZ = Math.max(corner1.getBlockZ(), corner2.getBlockZ());
        HashSet<Block> connectedBlocks = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        HashSet<Block> visited = new HashSet<Block>();
        Block startBlock = start.getBlock();
        queue.add(startBlock);
        visited.add(startBlock);
        while (!queue.isEmpty()) {
            Block currentBlock = (Block)queue.poll();
            connectedBlocks.add(currentBlock);
            for (BlockFace face : faces) {
                Block neighborBlock = currentBlock.getRelative(face);
                Location neighborLoc = neighborBlock.getLocation();
                if (!neighborBlock.getType().equals((Object)targetMaterial) || visited.contains(neighborBlock) || neighborLoc.getBlockX() < minX || neighborLoc.getBlockX() > maxX || neighborLoc.getBlockY() < minY || neighborLoc.getBlockY() > maxY || neighborLoc.getBlockZ() < minZ || neighborLoc.getBlockZ() > maxZ) continue;
                ++air;
                queue.add(neighborBlock);
                visited.add(neighborBlock);
            }
        }
        return air;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, WindTurbine.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new WindTurbine(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.SMOOTH_STONE, 3));
        ings.add(new ItemStack(Material.IRON_BARS, 4));
        ings.add(MineItems.getIndustrialItem("Copper Cable", 2));
        RecipeUtils.addDefaultRecipe(new WindTurbine(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, true);
    }
}

