/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Liquids;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Liquids.LiquidUtil;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pipe;
import com.MT.xxxtrigger50xxx.Devices.Liquids.PipeLine;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;

public class Boiler
extends Device {
    private static final long serialVersionUID = -3929309797254251315L;
    private int generatedSteam = producedSteam;
    public int steam = 0;
    public static int neededWater = 30;
    public static int producedSteam = 18;
    private transient Furnace furnace;
    private String fuelString;
    private short lastFuel = 0;
    private transient Furnace visualFurnace;
    private short arrow = 0;
    private transient HashSet<Device> cachedDevices = null;

    public Boiler(Location loc) {
        super(loc);
        this.setMaterial("BLAST_FURNACE");
        this.deviceName = "Boiler";
        this.setActionTimer(1);
        this.setOpenable(false);
        this.setGridRange(5);
        this.setStoreForm(false);
        this.addLiquidType(Device.LiquidType.WATER, 100);
        this.setUseUI(true);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        slots.add(0);
        slots.add(1);
        this.setClickableSlots(slots);
        this.setNeedsPower(false);
        slots.clear();
        slots.add(1);
        this.setInputSlots(slots);
        this.setAllowPowerIndicator(false);
        this.setPollutionGen(35);
        this.chainingMoverBehavior = true;
    }

    public void createFurnace() {
        this.furnace = (Furnace)Bukkit.createBlockData((Material)Material.FURNACE).createBlockState();
        this.furnace.setCustomName(MineItems.goldBold() + "Boiler");
        this.furnace.setCookTimeTotal(5);
        this.furnace.setBurnTime(this.lastFuel);
        this.updateArrow();
        if (this.fuelString != null) {
            this.furnace.getInventory().setFuel(TUItems.createStackFromString(this.fuelString));
        }
        this.fuelString = null;
        this.updateInventoryView();
    }

    public Furnace getFurnace() {
        return this.furnace;
    }

    @Override
    public void cleanup() {
        if (this.getFurnace() != null && this.getFurnace().getInventory().getFuel() != null) {
            this.fuelString = TUItems.createStackString(this.getFurnace().getInventory().getFuel());
            this.lastFuel = this.getFurnace().getBurnTime();
        }
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.RED) + "- " + neededWater + "\ud83d\udca7");
        lore.add(String.valueOf(ChatColor.GREEN) + "+ " + this.generatedSteam + "\ud83d\udca8");
        lore.add("- Burns fuel to create steam.");
        lore.add("- Burns fuel twice as long.");
        lore.add("- Requires water piping connection.");
        return lore;
    }

    @Override
    public Inventory getInventory() {
        if (this.furnace == null) {
            this.createFurnace();
        }
        return this.getFurnace().getInventory();
    }

    @Override
    public void visualUpdate(boolean nearby) {
        if (nearby) {
            if (this.furnace == null) {
                return;
            }
            if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 32.0)) {
                if (this.visualFurnace == null) {
                    this.visualFurnace = (Furnace)this.getLocation().getBlock().getState();
                }
                this.visualFurnace.setBurnTime(this.furnace.getBurnTime());
                this.visualFurnace.update();
            } else {
                this.visualFurnace = null;
            }
            if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 8.0)) {
                this.updateInventoryView();
            }
        }
    }

    private void updateArrow() {
        this.arrow = (short)(this.arrow + 1);
        if (this.arrow > 5 || this.furnace.getBurnTime() == 0) {
            this.arrow = 0;
        }
        this.furnace.setCookTimeTotal(5);
        this.furnace.setCookTime(this.arrow);
    }

    @Override
    public void action() {
        if (this.furnace == null) {
            this.createFurnace();
        }
        for (Block block : TUMaths.getNearbyBlocks6Sided(this.getLocation().getBlock())) {
            PipeLine.pipeLineCheck(block);
        }
        if (this.getGrid() != null) {
            ItemStack fuelStack;
            if (this.steam > 0) {
                this.moveSteam();
            }
            if (this.furnace.getBurnTime() > 0) {
                this.createPollution(true);
                if (this.hasLiquid(Device.LiquidType.WATER, neededWater)) {
                    this.removeLiquid(Device.LiquidType.WATER, neededWater);
                    this.getGrid().logLiquid(Device.LiquidType.WATER, -neededWater);
                    this.getGrid().logLiquid(Device.LiquidType.STEAM, this.generatedSteam);
                    this.steam += this.generatedSteam;
                    if (this.steam > 100) {
                        this.steam = 100;
                    }
                }
            }
            if (this.furnace.getBurnTime() > 0) {
                this.furnace.setBurnTime((short)(this.furnace.getBurnTime() - 1));
                this.updateArrow();
                this.lastFuel = this.getFurnace().getBurnTime();
            }
            if (this.furnace.getBurnTime() == 0 && this.hasLiquid(Device.LiquidType.WATER, neededWater) && (fuelStack = this.furnace.getInventory().getFuel()) != null && !fuelStack.getType().equals((Object)Material.BUCKET)) {
                int amount = fuelStack.getAmount();
                this.furnace.setBurnTime((short)(MineUtil.burnSeconds(fuelStack.getType()) * 2));
                this.updateArrow();
                this.logItem(fuelStack, -1);
                if (amount - 1 > 0) {
                    fuelStack.setAmount(amount - 1);
                    this.furnace.getInventory().setFuel(fuelStack);
                } else if (!fuelStack.getType().equals((Object)Material.LAVA_BUCKET)) {
                    this.furnace.getInventory().setFuel(new ItemStack(Material.AIR));
                } else {
                    this.furnace.getInventory().setFuel(new ItemStack(Material.BUCKET));
                }
                this.visualUpdate(TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance));
            }
        }
    }

    public void updateInventoryView() {
        if (this.furnace == null) {
            return;
        }
        FurnaceInventory finv = this.furnace.getInventory();
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Stored Water", String.valueOf(this.getStoredLiquid(Device.LiquidType.WATER)) + "/" + this.getMaxLiquid(Device.LiquidType.WATER)));
        lore.add(MineUtil.colon(" Burn Time", this.furnace.getBurnTime() + "s"));
        if (!this.hasLiquid(Device.LiquidType.WATER, 30)) {
            lore.add(String.valueOf(ChatColor.RED) + " - Need more water!");
        }
        if (!this.getPoweredState().equals((Object)Device.PoweredState.ON)) {
            lore.add(String.valueOf(ChatColor.RED) + " - " + this.getPoweredStateString());
        }
        finv.setSmelting(TUItems.setModelData(TUItems.createItem(Material.WATER_BUCKET, MineItems.goldBold() + "Stored Water", lore), 9530));
        ArrayList<String> steamLore = TUItems.basicLore(MineUtil.colon(" Stored Steam", this.steam + "/100"));
        steamLore.add(MineUtil.colon(" Burn Time", this.furnace.getBurnTime() + "s"));
        finv.setResult(TUItems.setModelData(TUItems.createItem(Material.GLASS, MineItems.goldBold() + "Stored Steam", steamLore), 9528));
    }

    private void moveSteam() {
        if (TUMaths.isPlayerNearby(this.getLocation(), 64.0) || this.cachedDevices == null) {
            this.cachedDevices = LiquidUtil.getConnectedDevices(this.getLocation().getBlock(), Device.LiquidType.STEAM);
        }
        for (Device device : new HashSet<Device>(this.cachedDevices)) {
            if (!device.isRemoved()) continue;
            this.cachedDevices.remove(device);
        }
        if (this.cachedDevices.size() > 0) {
            int baseSteamEach = this.steam / this.cachedDevices.size();
            boolean steamGiven = false;
            for (Device device : this.cachedDevices) {
                if (device.getStoredLiquid(Device.LiquidType.STEAM) >= device.getMaxLiquid(Device.LiquidType.STEAM)) continue;
                int liquidNeeded = device.getMaxLiquid(Device.LiquidType.STEAM) - device.getStoredLiquid(Device.LiquidType.STEAM);
                if (liquidNeeded > baseSteamEach) {
                    device.addLiquid(Device.LiquidType.STEAM, baseSteamEach);
                    this.steam -= baseSteamEach;
                } else {
                    device.addLiquid(Device.LiquidType.STEAM, liquidNeeded);
                    this.steam -= liquidNeeded;
                }
                steamGiven = true;
            }
            if (steamGiven) {
                for (Block block : TUMaths.getNearbyBlocks6Sided(this.getLocation().getBlock())) {
                    if (!Pipe.isPipe(block)) continue;
                    Pipe pipe = (Pipe)((MetadataValue)block.getMetadata("MT-Pipe").get(0)).value();
                    pipe.getLine().addLiquidType(Device.LiquidType.STEAM);
                    pipe.getLine().decorTickPipeLine();
                }
            }
        }
    }

    @Override
    public void updateUI() {
    }
}

